/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.options.CodeStyle;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ReflowParagraphAction
extends BaseAction {
    public ReflowParagraphAction() {
        super("ruby-reflow-paragraph", 0);
    }

    public Class getShortDescriptionBundleClass() {
        return ReflowParagraphAction.class;
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        if (jTextComponent.getCaret() == null) {
            return;
        }
        FileObject fileObject = GsfUtilities.findFileObject((JTextComponent)jTextComponent);
        if (fileObject != null) {
            int n = jTextComponent.getCaret().getDot();
            new ParagraphFormatter(false, jTextComponent, null, -1).reflowParagraph(n);
        }
    }

    public static void reflowEditedComment(JTextComponent jTextComponent) {
        if (jTextComponent.getCaret() == null) {
            return;
        }
        int n = jTextComponent.getCaret().getDot();
        new ParagraphFormatter(true, jTextComponent, null, -1).reflowParagraph(n);
    }

    public static void reflowComments(BaseDocument baseDocument, int n, int n2, int n3) {
        ParagraphFormatter paragraphFormatter = new ParagraphFormatter(false, null, baseDocument, n3);
        paragraphFormatter.reflow(n, n2);
    }

    private static class ParagraphFormatter {
        private JTextComponent target;
        private BaseDocument doc;
        private int oldCaretPosition = -1;
        private boolean inVerbatim;
        private boolean indentedList;
        private boolean inList;
        private int listIndentation;
        private boolean documentation;
        private final StringBuilder sb = new StringBuilder(500);
        private StringBuilder buffer = new StringBuilder();
        private int indent = 4;
        private int rightMargin;
        private boolean currentSectionOnly;
        private final char CARET_MARKER = (char)19914;

        ParagraphFormatter(boolean bl, JTextComponent jTextComponent, BaseDocument baseDocument, int n) {
            this.currentSectionOnly = bl;
            this.target = jTextComponent;
            if (jTextComponent != null) {
                this.doc = (BaseDocument)jTextComponent.getDocument();
                this.oldCaretPosition = jTextComponent.getCaret() != null ? Integer.valueOf(jTextComponent.getCaret().getDot()) : null;
            } else {
                this.doc = baseDocument;
            }
            this.rightMargin = n != -1 ? n : CodeStyle.get((Document)this.doc).getRightMargin();
        }

        private void reflow(int n, int n2) {
            try {
                block2: while (n2 >= n) {
                    TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(this.doc, n2);
                    if (tokenSequence == null) {
                        return;
                    }
                    tokenSequence.move(n2);
                    int n3 = n2;
                    while (tokenSequence.movePrevious() && tokenSequence.offset() >= n) {
                        OffsetRange offsetRange;
                        n3 = tokenSequence.offset();
                        Token token = tokenSequence.token();
                        if (token.id() != RubyTokenId.DOCUMENTATION && token.id() != RubyTokenId.LINE_COMMENT || (offsetRange = this.findParagraph(n3)) == OffsetRange.NONE) continue;
                        n2 = Utilities.getRowStart((BaseDocument)this.doc, (int)offsetRange.getStart()) - 1;
                        this.reflowParagraph(n3);
                        continue block2;
                    }
                    n2 = Utilities.getRowStart((BaseDocument)this.doc, (int)n3) - 1;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }

        private void reflowParagraph(int n) {
            try {
                n = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)n);
                if (n == -1) {
                    return;
                }
                Token<? extends RubyTokenId> token = LexUtilities.getToken(this.doc, n);
                if (token == null) {
                    return;
                }
                if (token.id() == RubyTokenId.DOCUMENTATION) {
                    this.documentation = true;
                } else if (token.id() != RubyTokenId.LINE_COMMENT) {
                    return;
                }
                OffsetRange offsetRange = this.findParagraph(n);
                if (offsetRange != OffsetRange.NONE) {
                    this.reflow(offsetRange);
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }

        private OffsetRange findParagraph(int n) {
            try {
                int n2;
                int n3 = Utilities.getRowStart((BaseDocument)this.doc, (int)n);
                int n4 = Utilities.getRowEnd((BaseDocument)this.doc, (int)n);
                while (n >= 0) {
                    String string;
                    if (Utilities.isRowEmpty((BaseDocument)this.doc, (int)n) || Utilities.isRowWhite((BaseDocument)this.doc, (int)n)) {
                        if (this.currentSectionOnly || !this.documentation) break;
                        n = Utilities.getRowStart((BaseDocument)this.doc, (int)n) - 1;
                        continue;
                    }
                    n2 = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)(n = Utilities.getRowStart((BaseDocument)this.doc, (int)n)));
                    Token<? extends RubyTokenId> token = LexUtilities.getToken(this.doc, n2);
                    if (token == null) break;
                    if (token.id() == RubyTokenId.DOCUMENTATION) {
                        string = this.doc.getText(n, Utilities.getRowEnd((BaseDocument)this.doc, (int)n) - n);
                        if (string.startsWith("=begin")) break;
                        n3 = n;
                    } else {
                        if (token.id() != RubyTokenId.LINE_COMMENT) break;
                        n3 = n;
                    }
                    if (this.currentSectionOnly && !this.documentation && ((string = this.doc.getText(n2, Utilities.getRowEnd((BaseDocument)this.doc, (int)n2) - n2)).startsWith("#") && string.length() == 1 || string.equals("# ") || string.startsWith("# *") || string.startsWith("# - "))) break;
                    --n;
                }
                n2 = this.doc.getLength();
                n = n4;
                while (n < n2) {
                    String string;
                    if (Utilities.isRowEmpty((BaseDocument)this.doc, (int)n) || Utilities.isRowWhite((BaseDocument)this.doc, (int)n)) {
                        if (this.currentSectionOnly || !this.documentation) break;
                        n = Utilities.getRowEnd((BaseDocument)this.doc, (int)n) + 1;
                        continue;
                    }
                    n = Utilities.getRowStart((BaseDocument)this.doc, (int)n);
                    int n5 = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)n);
                    int n6 = Utilities.getRowEnd((BaseDocument)this.doc, (int)n);
                    Token<? extends RubyTokenId> token = LexUtilities.getToken(this.doc, n5);
                    if (token == null) break;
                    if (token.id() == RubyTokenId.DOCUMENTATION) {
                        string = this.doc.getText(n, n6 - n);
                        if (string.startsWith("=end")) break;
                        n4 = n6;
                    } else {
                        if (token.id() != RubyTokenId.LINE_COMMENT) break;
                        n4 = n6;
                    }
                    if (this.currentSectionOnly && !this.documentation && ((string = this.doc.getText(n5, n6 - n5)).startsWith("#") && string.length() == 1 || string.equals("# ") || string.startsWith("# *") || string.startsWith("# - "))) break;
                    n = n6 + 1;
                }
                return new OffsetRange(n3, n4);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                return OffsetRange.NONE;
            }
        }

        private int findWordEnd(StringBuilder stringBuilder, int n) {
            int n2 = stringBuilder.length();
            for (int i = n; i < n2; ++i) {
                char c = stringBuilder.charAt(i);
                if (!Character.isWhitespace(c)) continue;
                return i;
            }
            return stringBuilder.length();
        }

        private void reflow(OffsetRange offsetRange) throws BadLocationException {
            this.sb.setLength(0);
            final int n = offsetRange.getStart();
            final int n2 = offsetRange.getEnd();
            this.indent = GsfUtilities.getLineIndent((BaseDocument)this.doc, (int)n);
            int n3 = n;
            boolean bl = false;
            while (n3 < n2) {
                int n4;
                int n5 = this.documentation ? Utilities.getRowStart((BaseDocument)this.doc, (int)n3) : Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)n3);
                int n6 = Utilities.getRowLastNonWhite((BaseDocument)this.doc, (int)n3) + 1;
                int n7 = Utilities.getRowEnd((BaseDocument)this.doc, (int)n3);
                if (this.documentation) {
                    if (n6 < n5) {
                        n6 = n7;
                    }
                    if (n5 == -1 || n6 == -1) {
                        int n8;
                        assert (this.documentation);
                        n5 = n8 = Utilities.getRowStart((BaseDocument)this.doc, (int)n3);
                        n6 = n7;
                    }
                }
                String string = this.doc.getText(n5, n6 - n5);
                if (!bl && this.oldCaretPosition >= (n4 = Utilities.getRowStart((BaseDocument)this.doc, (int)n3)) && this.oldCaretPosition <= n7) {
                    bl = true;
                    if (this.oldCaretPosition > n6) {
                        string = this.doc.getText(n5, this.oldCaretPosition - n5);
                    }
                    if (this.oldCaretPosition < n5) {
                        string = string.startsWith("#") ? "#\u4dca" + string.substring(1) : '\u4dca' + string;
                    } else if (this.oldCaretPosition > n6) {
                        string = string + '\u4dca';
                    } else {
                        int n9 = this.oldCaretPosition - n5;
                        if (n9 < string.length()) {
                            String string2 = string.substring(0, n9);
                            String string3 = string.substring(n9);
                            string = string3.startsWith("#") && string2.trim().length() == 0 ? string2 + string3.charAt(0) + '\u4dca' + string3.substring(1) : string2 + '\u4dca' + string3;
                        } else {
                            string = string + '\u4dca';
                        }
                    }
                }
                this.appendLine(string);
                n3 = n7 + 1;
            }
            this.flush();
            this.doc.runAtomic(new Runnable(){

                public void run() {
                    try {
                        int n3;
                        String string = ParagraphFormatter.this.sb.toString();
                        if (string.endsWith("\n")) {
                            string = string.substring(0, string.length() - 1);
                        }
                        if ((n3 = string.indexOf(19914)) != -1) {
                            string = string.substring(0, n3) + string.substring(n3 + 1);
                        }
                        ParagraphFormatter.this.doc.replace(n, n2 - n, string, null);
                        if (n3 != -1 && ParagraphFormatter.this.target != null) {
                            ParagraphFormatter.this.target.getCaret().setDot(n + n3);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }

        public void appendLine(String string) {
            if (!this.documentation) {
                if (string.startsWith("# ")) {
                    string = string.substring(2);
                } else if (string.startsWith("#\u4dca ")) {
                    string = '\u4dca' + string.substring(3);
                } else if (string.equals("#")) {
                    string = "";
                } else if (string.length() == 2 && string.equals("#\u4dca")) {
                    string = "\u4dca";
                }
            }
            boolean bl = string.length() == 0;
            int n = string.indexOf(19914);
            if (n != -1 && string.substring(0, n).trim().length() == 0 && string.substring(n + 1).trim().length() == 0) {
                bl = true;
            }
            if (bl) {
                this.flush();
                this.finishSection();
                this.startComment();
                if (n != -1) {
                    this.sb.append('\u4dca');
                }
                this.sb.append("\n");
                return;
            }
            if (string.startsWith("* ") || string.startsWith("- ") || string.matches("^[0-9]+\\.\\s*( .*)?")) {
                this.flush();
                if (!this.inList) {
                    this.finishSection();
                    this.inList = true;
                }
                this.indentedList = false;
                this.appendFlowed(string.trim());
                this.appendFlowed(" ");
                this.listIndentation = 2;
                if (string.startsWith("* ") || string.startsWith("- ")) {
                    this.listIndentation = 1;
                    int n2 = 1;
                    while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
                        ++n2;
                        ++this.listIndentation;
                    }
                }
                return;
            }
            if (string.matches("^[\\S]+::\\s*( .*)?") || string.matches("^\\[[\\S]+\\]\\s*( .+)?")) {
                this.flush();
                if (!this.inList) {
                    this.finishSection();
                    this.inList = true;
                }
                this.indentedList = false;
                this.appendFlowed(string.trim());
                this.appendFlowed(" ");
                this.listIndentation = 2;
                if (!string.matches("^\\[[\\S]+\\] .+") && !string.matches("^[\\S]+:: .+")) {
                    this.flush();
                    this.indentedList = true;
                }
                return;
            }
            if (string.startsWith("Copyright")) {
                this.flush();
                this.startComment();
                this.finishSection();
                this.sb.append(string);
                this.sb.append("\n");
                return;
            }
            if (!this.inList && string.length() > 0 && Character.isWhitespace(string.charAt(0))) {
                this.flush();
                this.startComment();
                if (!this.inVerbatim) {
                    this.finishSection();
                    this.inVerbatim = true;
                }
                this.sb.append(string);
                this.sb.append("\n");
                return;
            }
            if (string.startsWith("=") || string.startsWith("#---") || string.startsWith("---")) {
                this.flush();
                this.finishSection();
                this.startComment();
                this.sb.append(string);
                this.sb.append("\n");
                return;
            }
            if (this.inVerbatim) {
                this.finishSection();
            }
            this.appendFlowed(string.trim());
            this.appendFlowed(" ");
        }

        private void startComment() {
            if (!this.documentation) {
                this.sb.append(IndentUtils.createIndentString((Document)this.doc, (int)this.indent));
                this.sb.append("# ");
            }
        }

        private void finishSection() {
            this.flush();
            if (this.inVerbatim) {
                this.flush();
                this.inVerbatim = false;
            }
            if (this.inList) {
                this.flush();
                this.indentedList = false;
                this.inList = false;
            }
        }

        private void appendFlowed(String string) {
            int n = string.indexOf(60);
            if (n != -1) {
                int n2 = string.indexOf("<br>", n);
                if (n2 == -1 && (n2 = string.indexOf("<br/>", n)) == -1) {
                    n2 = string.indexOf("<br />", n);
                }
                if (n2 != -1) {
                    int n3 = string.indexOf(62, n2) + 1;
                    String string2 = string.substring(0, n3);
                    String string3 = null;
                    if (n3 < string.length() && (string3 = string.substring(n3).trim()).length() == 1 && string3.charAt(0) == '\u4dca') {
                        string2 = string2 + '\u4dca';
                        string3 = null;
                    }
                    this.buffer.append(string2);
                    this.flush();
                    if (string3 != null) {
                        this.appendFlowed(string3);
                    }
                    return;
                }
            }
            this.buffer.append(string);
        }

        private void chompSpaces() {
            for (int i = this.sb.length() - 1; i >= 0; --i) {
                char c = this.sb.charAt(i);
                if (c == ' ') continue;
                this.sb.setLength(i + 1);
                break;
            }
        }

        private void flush() {
            char c;
            if (this.buffer.length() == 0) {
                return;
            }
            if (this.buffer.length() == 1 && this.buffer.charAt(0) == ' ') {
                return;
            }
            int n = 0;
            char c2 = '\u0000';
            int n2 = this.sb.length();
            this.startComment();
            if (this.inList && this.indentedList) {
                this.sb.append(IndentUtils.createIndentString((Document)this.doc, (int)this.listIndentation));
            }
            n += this.sb.length() - n2;
            int n3 = this.rightMargin;
            while (c2 < this.buffer.length() && Character.isWhitespace(c = this.buffer.charAt(c2))) {
                ++c2;
            }
            while (c2 < this.buffer.length()) {
                char c3;
                c = c2;
                char c4 = this.findWordEnd(this.buffer, c);
                int n4 = c4 - c;
                if (n + n4 > n3 && n4 < n3 - this.indent) {
                    this.chompSpaces();
                    this.sb.append("\n");
                    n2 = this.sb.length();
                    this.startComment();
                    if (this.inList) {
                        this.sb.append(IndentUtils.createIndentString((Document)this.doc, (int)this.listIndentation));
                    }
                    n = this.sb.length() - n2;
                }
                for (c3 = c; c3 < c4; ++c3) {
                    char c5 = this.buffer.charAt(c3);
                    if (c5 == '\u4dca') {
                        n3 = this.rightMargin + 1;
                    }
                    this.sb.append(c5);
                    ++n;
                }
                c2 = c4;
                this.sb.append(" ");
                ++n;
                ++c2;
                while (c2 < this.buffer.length() && Character.isWhitespace(c3 = (char)this.buffer.charAt(c2))) {
                    if (n < this.rightMargin) {
                        this.sb.append(c3);
                        ++n;
                    }
                    ++c2;
                }
            }
            this.chompSpaces();
            this.sb.append("\n");
            this.buffer.setLength(0);
        }
    }
}

