/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerUpdateCache;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteUserInfo;
import org.netbeans.modules.cnd.remote.ui.AddServerDialog;
import org.netbeans.modules.cnd.remote.ui.EditPathMapDialog;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditServerListDialog
extends JPanel
implements ActionListener,
PropertyChangeListener,
ListSelectionListener {
    private DefaultListModel model;
    private DialogDescriptor desc;
    private int defaultIndex;
    private JButton ok;
    private ProgressHandle phandle;
    private PropertyChangeSupport pcs;
    private boolean buttonsEnabled;
    private static Logger log = Logger.getLogger("cnd.remote.logger");
    private JButton btAddServer;
    private JButton btPathMapper;
    private JButton btRemoveServer;
    private JButton btRetry;
    private JButton btSetAsDefault;
    private JScrollPane jScrollPane1;
    private JLabel lbDevHosts;
    private JLabel lbReason;
    private JLabel lbStatus;
    private JList lstDevHosts;
    private JPanel pbarStatusPanel;
    private JTextField tfReason;
    private JTextField tfStatus;

    public EditServerListDialog(ServerUpdateCache serverUpdateCache) {
        this.initComponents();
        this.initServerList(serverUpdateCache);
        this.desc = null;
        this.lbReason.setText(" ");
        this.tfReason.setVisible(false);
        this.pbarStatusPanel.setVisible(false);
        this.initListeners();
    }

    private void initListeners() {
        this.lstDevHosts.addListSelectionListener(this);
        this.btAddServer.addActionListener(this);
        this.btRemoveServer.addActionListener(this);
        this.btSetAsDefault.addActionListener(this);
        this.btPathMapper.addActionListener(this);
        this.pcs = new PropertyChangeSupport(this);
        this.pcs.addPropertyChangeListener(this);
        this.setButtons(true);
        this.valueChanged(null);
    }

    private void initServerList(ServerUpdateCache serverUpdateCache) {
        this.model = new DefaultListModel();
        if (serverUpdateCache == null) {
            ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
            for (String string : serverList.getServerNames()) {
                this.model.addElement(string);
            }
            this.defaultIndex = serverList.getDefaultIndex();
        } else {
            for (String string : serverUpdateCache.getHostKeyList()) {
                this.model.addElement(string);
            }
            this.defaultIndex = serverUpdateCache.getDefaultIndex();
        }
        this.lstDevHosts.setModel(this.model);
        this.lstDevHosts.setSelectedIndex(this.defaultIndex);
        this.lstDevHosts.setCellRenderer(new MyCellRenderer());
    }

    private boolean isEmptyToolchains(String string) {
        if ("localhost".equals(string)) {
            return false;
        }
        CompilerSetManager compilerSetManager = ToolsPanel.getToolsPanel().getCompilerSetManagerCopy(string);
        return compilerSetManager.isEmpty();
    }

    private void revalidateRecord(final String string, String string2, boolean bl) {
        final RemoteServerRecord remoteServerRecord = (RemoteServerRecord)RemoteServerList.getInstance().get(string);
        if (!remoteServerRecord.isOnline()) {
            remoteServerRecord.resetOfflineState();
            this.setButtons(false);
            this.hideReason();
            RemoteUserInfo remoteUserInfo = RemoteUserInfo.getUserInfo(string, true);
            remoteUserInfo.setPassword(string2, bl);
            this.phandle = ProgressHandleFactory.createHandle((String)"");
            this.pbarStatusPanel.removeAll();
            this.pbarStatusPanel.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)this.phandle), "Center");
            this.pbarStatusPanel.setVisible(true);
            this.phandle.start();
            this.tfStatus.setText(NbBundle.getMessage(RemoteServerRecord.class, (String)"STATE_INITIALIZING"));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    remoteServerRecord.init(EditServerListDialog.this.pcs);
                    if (remoteServerRecord.isOnline()) {
                        CompilerSetManager compilerSetManager = ToolsPanel.getToolsPanel().getCompilerSetManagerCopy(string);
                        compilerSetManager.initialize(false);
                    }
                    EditServerListDialog.this.phandle.finish();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            EditServerListDialog.this.pbarStatusPanel.setVisible(false);
                            EditServerListDialog.this.setButtons(true);
                            EditServerListDialog.this.valueChanged(null);
                        }
                    });
                }
            });
        }
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.desc = dialogDescriptor;
    }

    public String[] getHostKeyList() {
        String[] stringArray = new String[this.model.getSize()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.model.get(i);
        }
        return stringArray;
    }

    public int getDefaultIndex() {
        return this.defaultIndex;
    }

    private void showAddServerDialog() {
        assert (this.desc != null) : "Internal Error: Set DialogDescriptor before calling AddServer";
        int n = this.lstDevHosts.getSelectedIndex();
        AddServerDialog addServerDialog = new AddServerDialog();
        if (addServerDialog.createNewRecord()) {
            String string;
            String string2 = addServerDialog.getServerName();
            int n2 = string2.indexOf(64);
            if (n2 == -1) {
                string = addServerDialog.getLoginName() + '@' + string2;
            } else if (string2.startsWith(addServerDialog.getLoginName() + '@')) {
                string = string2;
            } else {
                return;
            }
            if (!this.model.contains(string)) {
                this.model.addElement(string);
                this.lstDevHosts.setSelectedValue(string, true);
                this.revalidateRecord(string, addServerDialog.getPassword(), addServerDialog.isRememberPassword());
            }
        }
    }

    private void showPathMapper() {
        EditPathMapDialog.showMe((String)this.lstDevHosts.getSelectedValue(), this.getHostKeyList());
    }

    private void setButtons(boolean bl) {
        this.buttonsEnabled = bl;
        if (this.desc != null) {
            this.desc.setValid(bl);
        }
        this.btAddServer.setEnabled(bl);
        this.btAddServer.setEnabled(bl);
        this.btRemoveServer.setEnabled(bl);
        this.btPathMapper.setEnabled(bl);
        this.btSetAsDefault.setEnabled(bl);
        this.btRetry.setEnabled(bl);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (object instanceof AddServerDialog && string.equals("valid")) {
            AddServerDialog addServerDialog = (AddServerDialog)propertyChangeEvent.getSource();
            this.ok.setEnabled(addServerDialog.isOkValid());
        } else if (object instanceof DialogDescriptor && string.equals("valid")) {
            ((DialogDescriptor)object).setValid(false);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.lstDevHosts.getSelectedIndex();
        if (n >= 0) {
            String string = (String)this.lstDevHosts.getSelectedValue();
            RemoteServerRecord remoteServerRecord = (RemoteServerRecord)RemoteServerList.getInstance().get(string);
            this.tfStatus.setText(remoteServerRecord.getStateAsText());
            this.btRemoveServer.setEnabled(n > 0 && this.buttonsEnabled);
            this.btSetAsDefault.setEnabled(n != this.defaultIndex && this.buttonsEnabled && !this.isEmptyToolchains(string));
            this.btPathMapper.setEnabled(this.buttonsEnabled && !RemoteUtils.isLocalhost((String)string) && remoteServerRecord.isOnline());
            if (!remoteServerRecord.isOnline()) {
                this.showReason(remoteServerRecord.getReason());
                this.btRetry.setEnabled(true);
            } else {
                this.hideReason();
                this.btRetry.setEnabled(false);
            }
        } else {
            log.warning("ESLD.valueChanged: No selection in Dev Hosts list");
        }
    }

    private void showReason(String string) {
        this.lbReason.setText(NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_Reason"));
        this.tfReason.setText(string);
        this.tfReason.setVisible(true);
    }

    private void hideReason() {
        this.lbReason.setText(" ");
        this.tfReason.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            JButton jButton = (JButton)object;
            if (jButton.getActionCommand().equals("Add")) {
                this.showAddServerDialog();
            } else if (jButton.getActionCommand().equals("Remove")) {
                int n = this.lstDevHosts.getSelectedIndex();
                if (n > 0) {
                    this.model.remove(n);
                    this.lstDevHosts.setSelectedIndex(this.model.size() > n ? n : n - 1);
                    if (this.defaultIndex >= n) {
                        --this.defaultIndex;
                    }
                }
                this.lstDevHosts.repaint();
            } else if (jButton.getActionCommand().equals("SetAsDefault")) {
                this.defaultIndex = this.lstDevHosts.getSelectedIndex();
                jButton.setEnabled(false);
                this.lstDevHosts.repaint();
            } else if (jButton.getActionCommand().equals("PathMapper")) {
                this.showPathMapper();
            }
        }
    }

    private void initComponents() {
        this.lbDevHosts = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstDevHosts = new JList();
        this.btAddServer = new JButton();
        this.btRemoveServer = new JButton();
        this.btSetAsDefault = new JButton();
        this.btPathMapper = new JButton();
        this.lbStatus = new JLabel();
        this.tfStatus = new JTextField();
        this.btRetry = new JButton();
        this.lbReason = new JLabel();
        this.tfReason = new JTextField();
        this.pbarStatusPanel = new JPanel();
        this.setMinimumSize(new Dimension(258, 315));
        this.setLayout(new GridBagLayout());
        this.lbDevHosts.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("MNEM_ServerList").charAt(0));
        this.lbDevHosts.setLabelFor(this.lstDevHosts);
        this.lbDevHosts.setText(NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_ServerList"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lbDevHosts, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(200, 200));
        this.lstDevHosts.setSelectionMode(0);
        this.lstDevHosts.setMinimumSize(new Dimension(200, 200));
        this.lstDevHosts.setSelectedIndex(0);
        this.jScrollPane1.setViewportView(this.lstDevHosts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1000.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btAddServer.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("MNEM_AddServer").charAt(0));
        this.btAddServer.setText(NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_AddServer"));
        this.btAddServer.setActionCommand("Add");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btAddServer, gridBagConstraints);
        this.btRemoveServer.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("MNEM_RemoveServer").charAt(0));
        this.btRemoveServer.setText(NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_RemoveServer"));
        this.btRemoveServer.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btRemoveServer, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btSetAsDefault, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_SetAsDefault"));
        this.btSetAsDefault.setActionCommand("SetAsDefault");
        this.btSetAsDefault.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btSetAsDefault, gridBagConstraints);
        this.btPathMapper.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("MNEM_PathMapper").charAt(0));
        this.btPathMapper.setText(NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_PathMapper"));
        this.btPathMapper.setActionCommand("PathMapper");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btPathMapper, gridBagConstraints);
        this.lbStatus.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("MNEM_Status").charAt(0));
        this.lbStatus.setLabelFor(this.tfStatus);
        this.lbStatus.setText(NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_Status"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lbStatus, gridBagConstraints);
        this.tfStatus.setColumns(20);
        this.tfStatus.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 6);
        this.add((Component)this.tfStatus, gridBagConstraints);
        this.btRetry.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("MNEM_Retry").charAt(0));
        this.btRetry.setText(NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_Retry"));
        this.btRetry.setEnabled(false);
        this.btRetry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditServerListDialog.this.btRetryActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.add((Component)this.btRetry, gridBagConstraints);
        this.lbReason.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("MNEM_Reason").charAt(0));
        this.lbReason.setLabelFor(this.lbReason);
        this.lbReason.setText(NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_Reason"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lbReason, gridBagConstraints);
        this.tfReason.setEditable(false);
        this.tfReason.setPreferredSize(new Dimension(40, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 6);
        this.add((Component)this.tfReason, gridBagConstraints);
        this.pbarStatusPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.pbarStatusPanel, gridBagConstraints);
    }

    private void btRetryActionPerformed(ActionEvent actionEvent) {
        this.revalidateRecord((String)this.lstDevHosts.getSelectedValue(), null, false);
    }

    private final class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (n == EditServerListDialog.this.getDefaultIndex()) {
                component.setFont(component.getFont().deriveFont(1));
            }
            return component;
        }
    }
}

