/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.util.Map;
import org.netbeans.modules.cnd.remote.mapper.RemoteHostInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellUtils {
    private static final String cshBinz = "setenv PATH /bin:/usr/bin:$PATH; ";
    private static final String shBinz = "PATH=/bin:/usr/bin:$PATH ";
    private static final String BashExport = "export";
    private static final String CshExport = "setenv";

    private ShellUtils() {
    }

    public static String wrapCommand(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ShellUtils.getPrefix(string)).append("bash -c '");
        stringBuilder.append(string2.replace('\\', '/'));
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    public static String prepareExportString(Map<String, String> map) {
        return ShellUtils.prepareExportString(false, map);
    }

    public static String prepareExportString(boolean bl, Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = ShellUtils.getExportCommand(bl);
        String string2 = bl ? " " : "=";
        for (String string3 : map.keySet()) {
            stringBuilder.append(string).append(string3).append(string2).append("\"").append(map.get(string3)).append("\";");
        }
        return stringBuilder.toString();
    }

    static String prepareExportString(String[] stringArray) {
        return ShellUtils.prepareExportString(false, stringArray);
    }

    static String getPrefix(String string) {
        return RemoteHostInfoProvider.getHostInfo(string).isCshShell() ? cshBinz : shBinz;
    }

    static String prepareExportString(boolean bl, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = ShellUtils.getExportCommand(bl);
        for (String string2 : stringArray) {
            string2 = string2.replace("=", bl ? " \"" : "=\"");
            stringBuilder.append(string).append(string2).append("\";");
        }
        return stringBuilder.toString();
    }

    private static String getExportCommand(boolean bl) {
        return (bl ? CshExport : BashExport) + " ";
    }
}

