/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.openide.util.Exceptions;

public abstract class RunFacade {
    protected String output = null;

    public static RunFacade getInstance(String string) {
        if (RemoteUtils.isLocalhost((String)string)) {
            return new RunFacadeLocal();
        }
        return new RunFacadeRemote(string);
    }

    public boolean run(String string) {
        return this.doRun(string) != -1;
    }

    protected abstract int doRun(String var1);

    public String getOutput() {
        return this.output;
    }

    private static class RunFacadeRemote
    extends RunFacade {
        private String hkey;

        public RunFacadeRemote(String string) {
            this.hkey = string;
        }

        public int doRun(String string) {
            RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.hkey, string);
            int n = remoteCommandSupport.run();
            this.output = remoteCommandSupport.getOutput();
            return n;
        }
    }

    private static class RunFacadeLocal
    extends RunFacade {
        private RunFacadeLocal() {
        }

        public int doRun(String string) {
            int n = -1;
            try {
                Process process = Runtime.getRuntime().exec(string);
                InputStream inputStream = process.getInputStream();
                if (inputStream != null) {
                    String string2;
                    StringBuilder stringBuilder = new StringBuilder();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2 == null) continue;
                        stringBuilder.append(string2).append('\n');
                    }
                    this.output = stringBuilder.toString();
                }
                process.waitFor();
                n = process.exitValue();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return n;
        }
    }
}

