/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.awt.Dialog;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.remote.ServerUpdateCache;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.ui.EditServerListDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerList
implements ServerList {
    private static final String CND_REMOTE = "cnd.remote";
    private static final String REMOTE_SERVERS = "cnd.remote.servers";
    private static final String DEFAULT_INDEX = "cnd.remote.default";
    private static RemoteServerList instance = null;
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private int defaultIndex;
    private final PropertyChangeSupport pcs;
    private final ChangeSupport cs;
    private final ArrayList<RemoteServerRecord> unlisted;
    private final ArrayList<RemoteServerRecord> items = new ArrayList();

    public static synchronized ServerList getInstance() {
        if (instance == null) {
            instance = new RemoteServerList();
        }
        return instance;
    }

    private RemoteServerList() {
        String string = this.getPreferences().get(REMOTE_SERVERS, null);
        this.defaultIndex = this.getPreferences().getInt(DEFAULT_INDEX, 0);
        this.pcs = new PropertyChangeSupport(this);
        this.cs = new ChangeSupport((Object)this);
        this.unlisted = new ArrayList();
        this.addServer("localhost", false, RemoteServerRecord.STATE_ONLINE);
        if (string != null) {
            for (String string2 : string.split(",")) {
                if ("localhost".equals(string2)) continue;
                this.addServer(string2, false, RemoteServerRecord.STATE_OFFLINE);
            }
        }
        this.refresh();
    }

    public synchronized ServerRecord get(String string) {
        for (RemoteServerRecord remoteServerRecord : this.items) {
            if (!string.equals(remoteServerRecord.getName())) continue;
            return remoteServerRecord;
        }
        for (RemoteServerRecord remoteServerRecord : this.unlisted) {
            if (!string.equals(remoteServerRecord.getName())) continue;
            return remoteServerRecord;
        }
        RemoteServerRecord remoteServerRecord = new RemoteServerRecord(string);
        this.unlisted.add(remoteServerRecord);
        return remoteServerRecord;
    }

    public synchronized ServerRecord getDefaultRecord() {
        return this.items.get(this.defaultIndex);
    }

    public synchronized int getDefaultIndex() {
        return this.defaultIndex;
    }

    public synchronized void setDefaultIndex(int n) {
        this.defaultIndex = n;
        this.getPreferences().putInt(DEFAULT_INDEX, n);
    }

    public synchronized String[] getServerNames() {
        String[] stringArray = new String[this.items.size()];
        for (int i = 0; i < this.items.size(); ++i) {
            stringArray[i] = this.items.get(i).getName();
        }
        return stringArray;
    }

    private void addServer(String string, boolean bl, Object object) {
        RemoteServerRecord remoteServerRecord = (RemoteServerRecord)this.addServer(string, bl, false);
        remoteServerRecord.setState(object);
    }

    public synchronized ServerRecord addServer(String string, boolean bl, boolean bl2) {
        RemoteServerRecord remoteServerRecord = null;
        for (RemoteServerRecord remoteServerRecord2 : this.items) {
            if (!remoteServerRecord2.getName().equals(string)) continue;
            if (bl) {
                this.defaultIndex = this.items.indexOf(remoteServerRecord2);
                this.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
            }
            return remoteServerRecord2;
        }
        for (RemoteServerRecord remoteServerRecord2 : this.unlisted) {
            if (!remoteServerRecord2.getName().equals(string)) continue;
            remoteServerRecord = remoteServerRecord2;
            break;
        }
        if (remoteServerRecord == null) {
            remoteServerRecord = new RemoteServerRecord(string, bl2);
        } else {
            remoteServerRecord.setDeleted(false);
            this.unlisted.remove(remoteServerRecord);
        }
        this.items.add(remoteServerRecord);
        if (bl) {
            this.defaultIndex = this.items.size() - 1;
        }
        this.refresh();
        String string2 = this.getPreferences().get(REMOTE_SERVERS, null);
        if (string2 == null) {
            this.getPreferences().put(REMOTE_SERVERS, string);
        } else {
            boolean bl3 = true;
            for (String string3 : string2.split(",")) {
                if (!string3.equals(string)) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                this.getPreferences().put(REMOTE_SERVERS, (String)string2 + ',' + string);
            }
        }
        this.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
        return remoteServerRecord;
    }

    public synchronized void removeServer(int n) {
        if (n >= 0 && n < this.items.size()) {
            RemoteServerRecord remoteServerRecord = this.items.remove(n);
            this.removeFromPreferences(remoteServerRecord.getName());
            this.refresh();
        }
    }

    public synchronized void removeServer(ServerRecord serverRecord) {
        if (this.items.remove(serverRecord)) {
            this.removeFromPreferences(serverRecord.getName());
            this.refresh();
        }
    }

    public synchronized void clear() {
        for (RemoteServerRecord remoteServerRecord : this.items) {
            remoteServerRecord.setDeleted(true);
        }
        this.getPreferences().remove(REMOTE_SERVERS);
        this.unlisted.addAll(this.items);
        this.items.clear();
    }

    private void removeFromPreferences(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RemoteServerRecord remoteServerRecord : this.items) {
            stringBuilder.append(remoteServerRecord.getName());
            stringBuilder.append(',');
        }
        this.getPreferences().put(REMOTE_SERVERS, stringBuilder.substring(0, stringBuilder.length() - 1));
    }

    public ServerUpdateCache show(ServerUpdateCache serverUpdateCache) {
        EditServerListDialog editServerListDialog = new EditServerListDialog(serverUpdateCache);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editServerListDialog, NbBundle.getMessage(RemoteServerList.class, (String)"TITLE_EditServerList"), true, 2, DialogDescriptor.OK_OPTION, null);
        editServerListDialog.setDialogDescriptor(dialogDescriptor);
        dialogDescriptor.addPropertyChangeListener((PropertyChangeListener)editServerListDialog);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            if (serverUpdateCache == null) {
                serverUpdateCache = new ServerUpdateCache();
            }
            serverUpdateCache.setDefaultIndex(editServerListDialog.getDefaultIndex());
            serverUpdateCache.setHostKeyList(editServerListDialog.getHostKeyList());
            return serverUpdateCache;
        }
        return null;
    }

    protected void refresh() {
        this.cs.fireChange();
    }

    public synchronized boolean contains(String string) {
        for (RemoteServerRecord remoteServerRecord : this.items) {
            if (!string.equals(remoteServerRecord.getName())) continue;
            return true;
        }
        return false;
    }

    public synchronized RemoteServerRecord getLocalhostRecord() {
        return this.items.get(0);
    }

    public boolean isValidExecutable(String string, String string2) {
        String string3;
        int n;
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            log.warning("RemoteServerList.isValidExecutable from EDT");
        }
        if ((n = RemoteCommandSupport.run(string, string3 = "test -x " + string2)) != 0 && !IpeUtils.isPathAbsolute((String)string2)) {
            string3 = "test -x `which " + string2 + "`";
            n = RemoteCommandSupport.run(string, string3);
        }
        return n == 0;
    }

    public synchronized Collection<? extends ServerRecord> getRecords() {
        return Collections.unmodifiableCollection(this.items);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object) {
        this.pcs.firePropertyChange(string, null, object);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(RemoteServerList.class);
    }
}

