/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConfigParser {
    private final Map<String, Map<String, String>> sections2attributes = new HashMap<String, Map<String, String>>();
    private final Map<String, String> orphanAttributes = new HashMap<String, String>();
    private final Pattern patternSection = Pattern.compile("\\[.+\\]");
    private final Pattern patternAttribute = Pattern.compile("[^=]+=[^=]+");
    private boolean parsed = false;

    public boolean parse(Reader reader) {
        if (this.parsed) {
            return false;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = null;
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if ((string2 = string2.trim()).length() > 0) {
                    if (this.patternAttribute.matcher(string2).matches()) {
                        int n = string2.indexOf(61);
                        String string3 = string2.substring(0, n).trim();
                        String string4 = string2.substring(n + 1).trim();
                        if (string == null) {
                            this.orphanAttributes.put(string3, string4);
                        } else {
                            this.sections2attributes.get(string).put(string3, string4);
                        }
                    } else if (this.patternSection.matcher(string2).matches() && !this.sections2attributes.containsKey(string = string2.substring(1, string2.length() - 1).trim())) {
                        this.sections2attributes.put(string, new HashMap());
                    }
                }
                string2 = bufferedReader.readLine();
            }
            this.parsed = true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return this.parsed;
    }

    public Set<String> getSections() {
        return this.parsed ? this.sections2attributes.keySet() : Collections.emptySet();
    }

    public Map<String, String> getAttributes(String string) {
        return this.parsed ? this.sections2attributes.get(string) : Collections.emptyMap();
    }

    public Map<String, String> getOrphanAttributes() {
        return this.parsed ? this.orphanAttributes : Collections.emptyMap();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        SimpleConfigParser.writeAttributes(stringBuilder, this.getOrphanAttributes());
        for (String string : this.getSections()) {
            Map<String, String> map = this.getAttributes(string);
            stringBuilder.append("[" + string + "]\n");
            SimpleConfigParser.writeAttributes(stringBuilder, map);
        }
        return stringBuilder.toString();
    }

    private static void writeAttributes(StringBuilder stringBuilder, Map<String, String> map) {
        for (String string : map.keySet()) {
            stringBuilder.append("\t" + string + "=" + map.get(string) + "\n");
        }
    }
}

