/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteHostInfoProvider
extends HostInfoProvider {
    private static final Map<String, RemoteHostInfo> hkey2hostInfo = new HashMap<String, RemoteHostInfo>();

    public static synchronized RemoteHostInfo getHostInfo(String string) {
        RemoteHostInfo remoteHostInfo = hkey2hostInfo.get(string);
        if (remoteHostInfo == null) {
            remoteHostInfo = new RemoteHostInfo(string);
            hkey2hostInfo.put(string, remoteHostInfo);
        }
        return remoteHostInfo;
    }

    public PathMap getMapper(String string) {
        return RemoteHostInfoProvider.getHostInfo(string).getMapper();
    }

    public Map<String, String> getEnv(String string) {
        return RemoteHostInfoProvider.getHostInfo(string).getEnv();
    }

    public String getLibDir(String string) {
        String string2 = RemoteHostInfoProvider.getHostInfo(string).getHome();
        if (string2 == null) {
            return null;
        }
        return string2 + "/" + ".netbeans/6.5/cnd2/lib/";
    }

    public boolean fileExists(String string, String string2) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(string, "test -d \"" + string2 + "\" -o -f \"" + string2 + "\"");
        return remoteCommandSupport.run() == 0;
    }

    public int getPlatform(String string) {
        return RemoteHostInfoProvider.getHostInfo(string).getPlatform();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoteHostInfo {
        private final String hkey;
        private String home = null;
        private PathMap mapper;
        private Map<String, String> envCache = null;
        private Boolean isCshShell;
        private Integer platform;

        private RemoteHostInfo(String string) {
            this.hkey = string;
        }

        public String getHome() {
            RemoteCommandSupport remoteCommandSupport;
            if (this.home == null && (remoteCommandSupport = new RemoteCommandSupport(this.hkey, "pwd")).run() == 0) {
                this.home = remoteCommandSupport.getOutput().trim();
            }
            return this.home;
        }

        public synchronized PathMap getMapper() {
            if (this.mapper == null) {
                this.mapper = RemotePathMap.getMapper(this.hkey);
            }
            return this.mapper;
        }

        public synchronized Map<String, String> getEnv() {
            if (this.envCache == null) {
                this.envCache = new HashMap<String, String>();
                RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.hkey, "env");
                if (remoteCommandSupport.run() == 0) {
                    String string = remoteCommandSupport.getOutput();
                    String[] stringArray = string.split("\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n = stringArray[i].indexOf(61);
                        if (n <= 0) continue;
                        this.envCache.put(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
                    }
                }
            }
            return this.envCache;
        }

        public boolean isCshShell() {
            if (this.isCshShell == null) {
                RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.hkey, "PATH=/bin:/usr/bin export");
                remoteCommandSupport.setPreserveCommand(true);
                this.isCshShell = new Boolean(remoteCommandSupport.run() != 0);
            }
            return this.isCshShell;
        }

        public int getPlatform() {
            if (this.platform == null) {
                RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.hkey, "uname -sm");
                int n = remoteCommandSupport.run() == 0 ? RemoteHostInfo.recognizePlatform(remoteCommandSupport.getOutput()) : 5;
                this.platform = new Integer(n);
            }
            return this.platform;
        }

        private static int recognizePlatform(String string) {
            if (string.startsWith("Windows")) {
                return 3;
            }
            if (string.startsWith("Linux")) {
                return 2;
            }
            if (string.startsWith("SunOS")) {
                return string.contains("86") ? 1 : 0;
            }
            if (string.toLowerCase().startsWith("mac")) {
                return 4;
            }
            return 5;
        }
    }
}

