/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;

public abstract class JDBCWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    protected transient int index = 0;
    private final transient Set listeners = new HashSet(1);
    private transient WizardDescriptor.Panel[] panels = null;
    private transient WizardDescriptor wiz;
    private transient WizardDescriptor.Iterator simpleIterator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels(this.wiz)[this.index];
    }

    public boolean hasNext() {
        return this.index < this.getPanels(this.wiz).length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public abstract String name();

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    protected abstract List createPanels(WizardDescriptor var1);

    protected abstract String[] createSteps();

    protected final WizardDescriptor.Panel[] getPanels(WizardDescriptor wizardDescriptor) {
        if (this.panels == null) {
            List list = this.createPanels(wizardDescriptor);
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[list.size()];
            this.panels = list.toArray(panelArray);
        }
        return this.panels;
    }

    protected final String[] getSteps() {
        return this.createSteps();
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.panels = this.getPanels(wizardDescriptor);
        this.wiz = wizardDescriptor;
        Object object = wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object == null || object instanceof String[]) {
            // empty if block
        }
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", Integer.valueOf(String.valueOf(i)));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz = null;
        this.panels = null;
    }

    public Set instantiate() throws IOException {
        return new HashSet();
    }

    protected WizardDescriptor.Iterator getSimpleIterator() {
        if (this.simpleIterator == null) {
            assert (this.panels != null && this.panels.length > 0);
            this.simpleIterator = new WizardDescriptor.ArrayIterator(this.panels);
        }
        return this.simpleIterator;
    }
}

