/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizard;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizardDescriptor;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizardIterator;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizardNameFinishPanel;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizardSelectionPanel;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizardTransferPanel;
import org.netbeans.modules.jdbcwizard.wizards.JNDINameFinishPanel;
import org.netbeans.modules.jdbcwizard.wizards.SimpleTargetChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class JDBCCollaborationWizard
extends JDBCWizard {
    public static final String DATABASE_SOURCES = "database_sources";
    public static final String JNDI_NAME = "jndi_name";
    public static final String DBTYPE = "dbtype";
    public static final String COLLABORATION_NAME = "collaboration_name";
    public static final String PROJECT = "project";
    public static final String RUNTIME_INPUTS = "runtime_inputs";
    public static final String SOURCE_OTDS = "source_otds";
    public static final int SOURCE_PANEL_INDEX = 2;
    public static final String SOURCE_TABLES = "source_tables";
    private WizardDescriptor descriptor;
    private JDBCWizardIterator iterator;
    private Project project;

    public JDBCCollaborationWizard() {
    }

    public JDBCCollaborationWizard(Project project) {
        this.project = project;
    }

    public static WizardDescriptor.Iterator newTemplateIterator() {
        JDBCCollaborationWizard jDBCCollaborationWizard = new JDBCCollaborationWizard();
        jDBCCollaborationWizard.initialize();
        return jDBCCollaborationWizard.getIterator();
    }

    public WizardDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor((WizardDescriptor.Iterator)this.iterator);
        }
        return this.descriptor;
    }

    public void setDescriptor(WizardDescriptor wizardDescriptor) {
        this.descriptor = wizardDescriptor;
    }

    public WizardDescriptor.Iterator getIterator() {
        return this.iterator;
    }

    public void initialize() {
        this.iterator = new WizardIterator(this);
    }

    protected void cancel() {
    }

    protected void cleanup() {
    }

    protected String getDialogTitle() {
        return NbBundle.getMessage(JDBCCollaborationWizard.class, (String)"TITLE_dlg_new_collab");
    }

    class WizardIterator
    extends JDBCWizardIterator {
        private WizardDescriptor.Panel collaborationNamePanel;
        private JDBCWizardSelectionPanel dataSelectionPanel;
        private JNDINameFinishPanel jndiNamePanel;
        private List panels;
        private JDBCWizardTransferPanel sourceTableSelectionPanel;
        private JDBCCollaborationWizard mWizard;

        public WizardIterator(JDBCCollaborationWizard jDBCCollaborationWizard2) {
            this.mWizard = jDBCCollaborationWizard2;
            this.collaborationNamePanel = new JDBCWizardNameFinishPanel(JDBCCollaborationWizard.this, NbBundle.getMessage(JDBCCollaborationWizard.class, (String)"TITLE_tblwizard_name"));
        }

        public String name() {
            return "";
        }

        public void initialize(WizardDescriptor wizardDescriptor) {
            this.mWizard.setDescriptor(wizardDescriptor);
            super.initialize(wizardDescriptor);
        }

        public void nextPanel() {
            if (this.current().equals(this.sourceTableSelectionPanel)) {
                JDBCWizardTransferPanel jDBCWizardTransferPanel = (JDBCWizardTransferPanel)this.current();
            }
            super.nextPanel();
        }

        public void previousPanel() {
            super.previousPanel();
        }

        protected List createPanels(WizardDescriptor wizardDescriptor) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            ArrayList arrayList5 = new ArrayList();
            Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
            if (project != null) {
                Sources sources = ProjectUtils.getSources((Project)project);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
                if (sourceGroupArray == null || sourceGroupArray.length < 1) {
                    sourceGroupArray = sources.getSourceGroups("generic");
                }
                this.collaborationNamePanel = new SimpleTargetChooserPanel(project, sourceGroupArray, null, false);
            }
            this.dataSelectionPanel = new JDBCWizardSelectionPanel(NbBundle.getMessage(JDBCCollaborationWizard.class, (String)"TITLE_tblwizard_selecttableobjects"));
            this.dataSelectionPanel.initialize();
            this.sourceTableSelectionPanel = new JDBCWizardTransferPanel(NbBundle.getMessage(JDBCCollaborationWizard.class, (String)"TITLE_tblwizard_selectsources"));
            this.jndiNamePanel = new JNDINameFinishPanel(NbBundle.getMessage(JDBCCollaborationWizard.class, (String)"STEP_tblwizard_jndiname"));
            this.panels = new ArrayList(4);
            if (this.collaborationNamePanel != null) {
                this.panels.add(this.collaborationNamePanel);
            }
            this.panels.add(this.dataSelectionPanel);
            this.panels.add(this.sourceTableSelectionPanel);
            this.panels.add(this.jndiNamePanel);
            return Collections.unmodifiableList(this.panels);
        }

        protected String[] createSteps() {
            try {
                return new String[]{"Choose File Type", NbBundle.getMessage(JDBCCollaborationWizard.class, (String)"STEP_tblwizard_name"), NbBundle.getMessage(JDBCCollaborationWizard.class, (String)"STEP_tblwizard_select"), NbBundle.getMessage(JDBCCollaborationWizard.class, (String)"STEP_tblwizard_sources"), NbBundle.getMessage(JDBCCollaborationWizard.class, (String)"STEP_tblwizard_jndiname")};
            }
            catch (MissingResourceException missingResourceException) {
                return new String[0];
            }
        }
    }

    class Descriptor
    extends JDBCWizardDescriptor {
        public Descriptor(WizardDescriptor.Iterator iterator) {
            super(iterator, JDBCCollaborationWizard.this.context);
        }
    }
}

