/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.wsdl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBConnectionDefinition;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.model.DB2QueryGenerator;
import org.netbeans.modules.jdbcwizard.builder.model.DBQueryModel;
import org.netbeans.modules.jdbcwizard.builder.model.DerbyQueryGenerator;
import org.netbeans.modules.jdbcwizard.builder.model.JdbcQueryGenerator;
import org.netbeans.modules.jdbcwizard.builder.model.MySQLQueryGenerator;
import org.netbeans.modules.jdbcwizard.builder.model.OracleQueryGenerator;
import org.netbeans.modules.jdbcwizard.builder.model.SQLServerQueryGenerator;
import org.netbeans.modules.jdbcwizard.builder.util.XMLCharUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLGenerator {
    public static HashMap builtInTypes = new HashMap();
    private static final Logger logger = Logger.getLogger(WSDLGenerator.class.getName());
    private static WSDLFactory factory;
    private static DocumentBuilderFactory docBuilderfactory;
    public WSDLReader reader = null;
    private Definition def;
    private String mWSDLFileName;
    private String wsdlFileLocation;
    private Document doc;
    private static final String IMPORT_ELEMENT = "xsd:import";
    private static final String NAMESPACE_ATTR = "namespace";
    private static final String SCHEMALOCATION_ATTR = "schemaLocation";
    private static final String TARGET_NS = "targetNamespace";
    private static final String TARGET_NS_PREFIX_STRING = "http://j2ee.netbeans.org/wsdl/";
    private static final String TNS_STRING = "xmlns:tns";
    private static final String NAME = "name";
    private static final String PART_ELEMENT = "part";
    private static final String NAME_ATTR = "name";
    private static final String ELEMENT_ATTR = "element";
    private static final String TARGETNAMESPACE = "http://j2ee.netbeans.org/xsd/tableSchema";
    private static final String INPUTMESSAGE_NAME = "inputMsg";
    private static final String OUTPUTMESSAGE_NAME = "outputMsg";
    private static final String XMLSCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String INSERT_QUERY = "insertQuery";
    private static final String UPDATE_QUERY = "updateQuery";
    private static final String DELETE_QUERY = "deleteQuery";
    private static final String FIND_QUERY = "findQuery";
    private static final String POLL_QUERY = "pollQuery";
    private static final String JDBC_SQL_ELEMENT = "jdbc:input";
    private static final String SQL_ELEMENT = "sql";
    private static final String PARAM_ORDER = "paramOrder";
    private static final String JDBC_NAMESPACE = "http://schemas.sun.com/jbi/wsdl-extensions/jdbc/";
    private static final String SCHEMA_ELE = "xsd:schema";
    private static final String PRIMARYKEY_ATTR = "PKName";
    private static final String TRANSACTION = "Transaction";
    private static final String MARK_COLUMN_VALUE = "MarkColumnValue";
    private static final String MARK_COLUMN_NAME = "MarkColumnName";
    private static final String POLL_POST_PROCESS = "PollingPostProcessing";
    private static final String TABLE_NAME = "TableName";
    private static final String NUMNBER_OF_RECORDS = "numberOfRecords";
    private static final String MOVEROW_TABLE_NAME = "MoveRowToTableName";
    private static final String POLLMILLI_SECONDS = "PollMilliSeconds";
    private static final String OPERATION_TYPE = "operationType";
    private static final String JNDI_NAME = "jndiname";
    private static final String JNDI_ADD_ELE = "jdbc:address";
    private static final String SERVICE_NAME = "Service";
    private static final String PORT_NAME = "Port";
    private DBTable mTable;
    private String xsdTopEleName;
    private String xsdName;
    private static final String XSD_EXT = ".xsd";
    private String mDBType;
    private String mJNDIName;
    private String mTableName = null;
    private DBConnectionDefinition dbinfo;
    private DBQueryModel dbDataAccessObject = null;

    public WSDLGenerator(DBTable dBTable, String string, String string2, String string3, String string4) {
        this.mWSDLFileName = string;
        this.wsdlFileLocation = string2;
        this.mTable = dBTable;
        this.mDBType = string3;
        this.mJNDIName = string4;
    }

    private static void initFactory() {
        if (factory == null) {
            try {
                factory = WSDLFactory.newInstance();
                docBuilderfactory = DocumentBuilderFactory.newInstance();
            }
            catch (WSDLException wSDLException) {
                logger.log(Level.WARNING, wSDLException.getMessage(), wSDLException);
            }
        }
    }

    public void setTopEleName() {
        this.xsdTopEleName = "ns:" + XMLCharUtil.makeValidNCName(this.mTable.getName());
    }

    public void setXSDName() {
        this.xsdName = XMLCharUtil.makeValidNCName(this.mTable.getName()) + XSD_EXT;
    }

    public void setDBInfo(DBConnectionDefinition dBConnectionDefinition) {
        this.dbinfo = dBConnectionDefinition;
    }

    private Definition getWsdlTemplate() throws WSDLException, ParserConfigurationException, SAXException, IOException {
        Definition definition = null;
        this.reader = factory.newWSDLReader();
        try {
            URL uRL = WSDLGenerator.class.getResource("jdbc.wsdl.template");
            if (uRL != null) {
                String string = uRL.getFile().indexOf(".jar") > 0 ? "jar:" + uRL.getFile() : uRL.getFile();
                docBuilderfactory.setNamespaceAware(true);
                docBuilderfactory.setValidating(false);
                this.doc = docBuilderfactory.newDocumentBuilder().parse(string);
                definition = this.reader.readWSDL(string, this.doc);
            } else {
                logger.log(Level.WARNING, "Unable to locate the wsdl template");
            }
        }
        catch (WSDLException wSDLException) {
            logger.log(Level.SEVERE, wSDLException.getMessage(), wSDLException);
            throw wSDLException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.log(Level.SEVERE, parserConfigurationException.getMessage(), parserConfigurationException);
            throw parserConfigurationException;
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, sAXException.getMessage(), sAXException);
            throw sAXException;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
            throw iOException;
        }
        return definition;
    }

    public Definition generateWSDL() {
        try {
            this.def = this.getWsdlTemplate();
            this.modifyWSDL();
            this.writeWsdl();
        }
        catch (WSDLException wSDLException) {
            logger.log(Level.SEVERE, wSDLException.getMessage(), wSDLException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.log(Level.SEVERE, parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return this.def;
    }

    private void modifyWSDL() throws WSDLException, Exception {
        this.modifyName();
        this.modifyTargetNamespace();
        this.modifySchEle();
        this.modiyMessageEles();
        this.modifyBindings();
        this.modifyServiceAndPortNames();
        this.modifyJNDIAddress();
    }

    private void modifyName() {
        Element element = this.doc.getDocumentElement();
        Attr attr = element.getAttributeNode("name");
        attr.setNodeValue(this.mWSDLFileName);
    }

    private void modifyTargetNamespace() {
        Element element = this.doc.getDocumentElement();
        Attr attr = element.getAttributeNode(TARGET_NS);
        attr.setNodeValue(TARGET_NS_PREFIX_STRING + this.mWSDLFileName);
        attr = element.getAttributeNode(TNS_STRING);
        attr.setNodeValue(TARGET_NS_PREFIX_STRING + this.mWSDLFileName);
    }

    public void modifySchEle() throws WSDLException, Exception {
        Node node;
        Node node2;
        Element element = this.doc.getDocumentElement();
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName(SCHEMA_ELE);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            element2 = (Element)node2;
            break;
        }
        Attr attr = element2.getAttributeNode(TARGET_NS);
        attr.setNodeValue(JDBC_NAMESPACE);
        node2 = null;
        NodeList nodeList2 = element.getElementsByTagName(IMPORT_ELEMENT);
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            node = nodeList2.item(i);
            if (!(node instanceof Element)) continue;
            node2 = (Element)node;
            break;
        }
        Attr attr2 = node2.getAttributeNode(NAMESPACE_ATTR);
        attr2.setNodeValue(TARGETNAMESPACE);
        node = node2.getAttributeNode(SCHEMALOCATION_ATTR);
        node.setNodeValue(this.xsdName);
    }

    public void modiyMessageEles() throws WSDLException, Exception {
        Node node;
        Element element = this.doc.getDocumentElement();
        Element element2 = this.getElementByName(element, INPUTMESSAGE_NAME);
        NodeList nodeList = element2.getChildNodes();
        Element element3 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            element3 = (Element)node;
            break;
        }
        Attr attr = element3.getAttributeNode(ELEMENT_ATTR);
        attr.setNodeValue(this.xsdTopEleName);
        node = null;
        Element element4 = this.getElementByName(element, OUTPUTMESSAGE_NAME);
        NodeList nodeList2 = element4.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node2 = nodeList2.item(i);
            if (!(node2 instanceof Element)) continue;
            node = (Element)node2;
            break;
        }
        Attr attr2 = node.getAttributeNode(ELEMENT_ATTR);
        attr2.setNodeValue(this.xsdTopEleName);
        this.def = this.reader.readWSDL(this.wsdlFileLocation, element);
    }

    public void modifyBindings() throws Exception {
        try {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            this.dbDataAccessObject = this.getQueryGenerator();
            this.dbDataAccessObject.init(this.mTable);
            this.mTableName = this.mTable.getName();
            string = this.dbDataAccessObject.createInsertQuery();
            string2 = this.dbDataAccessObject.createUpdateQuery();
            string3 = this.dbDataAccessObject.createDeleteQuery();
            string4 = this.dbDataAccessObject.createFindQuery();
            string5 = this.dbDataAccessObject.createPoolQuery();
            this.modifyInsert(this.dbDataAccessObject, string);
            this.modifyUpdate(this.dbDataAccessObject, string2);
            this.modifyDelete(this.dbDataAccessObject, string3);
            this.modifyFind(this.dbDataAccessObject, string4);
            this.modifyPoll(this.dbDataAccessObject, string5);
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Could not generate the WSDL");
        }
    }

    public void modifyInsert(DBQueryModel dBQueryModel, String string) throws WSDLException, Exception {
        try {
            String string2 = null;
            Element element = this.doc.getDocumentElement();
            Element element2 = this.getElementBySQL(element, INSERT_QUERY);
            string2 = dBQueryModel.getPrimaryKey();
            Attr attr = element2.getAttributeNode(OPERATION_TYPE);
            attr.setNodeValue("insert");
            Attr attr2 = element2.getAttributeNode(PARAM_ORDER);
            attr2.setNodeValue(dBQueryModel.getParamOrder(INSERT_QUERY));
            Attr attr3 = element2.getAttributeNode(SQL_ELEMENT);
            attr3.setNodeValue(string);
            Attr attr4 = element2.getAttributeNode(PRIMARYKEY_ATTR);
            attr4.setNodeValue(string2);
            Attr attr5 = element2.getAttributeNode(TRANSACTION);
            attr5.setNodeValue("NOTransaction");
            Attr attr6 = element2.getAttributeNode(TABLE_NAME);
            attr6.setNodeValue(this.mTableName);
            Attr attr7 = element2.getAttributeNode(NUMNBER_OF_RECORDS);
            attr7.setNodeValue("");
            Attr attr8 = element2.getAttributeNode(MARK_COLUMN_VALUE);
            attr8.setNodeValue("");
            Attr attr9 = element2.getAttributeNode(MOVEROW_TABLE_NAME);
            attr9.setNodeValue("");
            Attr attr10 = element2.getAttributeNode(MARK_COLUMN_NAME);
            attr10.setNodeValue("");
            Attr attr11 = element2.getAttributeNode(POLLMILLI_SECONDS);
            attr11.setNodeValue("5000");
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Could not generate the WSDL");
        }
    }

    public void modifyUpdate(DBQueryModel dBQueryModel, String string) throws WSDLException, Exception {
        try {
            String string2 = null;
            Element element = this.doc.getDocumentElement();
            Element element2 = this.getElementBySQL(element, UPDATE_QUERY);
            string2 = dBQueryModel.getPrimaryKey();
            Attr attr = element2.getAttributeNode(OPERATION_TYPE);
            attr.setNodeValue("update");
            Attr attr2 = element2.getAttributeNode(PARAM_ORDER);
            attr2.setNodeValue(dBQueryModel.getParamOrder(UPDATE_QUERY));
            Attr attr3 = element2.getAttributeNode(SQL_ELEMENT);
            attr3.setNodeValue(string);
            Attr attr4 = element2.getAttributeNode(PRIMARYKEY_ATTR);
            attr4.setNodeValue(string2);
            Attr attr5 = element2.getAttributeNode(TRANSACTION);
            attr5.setNodeValue("NOTransaction");
            Attr attr6 = element2.getAttributeNode(TABLE_NAME);
            attr6.setNodeValue(this.mTableName);
            Attr attr7 = element2.getAttributeNode(NUMNBER_OF_RECORDS);
            attr7.setNodeValue("");
            Attr attr8 = element2.getAttributeNode(MARK_COLUMN_VALUE);
            attr8.setNodeValue("");
            Attr attr9 = element2.getAttributeNode(MOVEROW_TABLE_NAME);
            attr9.setNodeValue("");
            Attr attr10 = element2.getAttributeNode(MARK_COLUMN_NAME);
            attr10.setNodeValue("");
            Attr attr11 = element2.getAttributeNode(POLLMILLI_SECONDS);
            attr11.setNodeValue("5000");
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Could not generate the WSDL");
        }
    }

    public void modifyDelete(DBQueryModel dBQueryModel, String string) throws WSDLException, Exception {
        try {
            String string2 = null;
            Element element = this.doc.getDocumentElement();
            Element element2 = this.getElementBySQL(element, DELETE_QUERY);
            string2 = dBQueryModel.getPrimaryKey();
            Attr attr = element2.getAttributeNode(OPERATION_TYPE);
            attr.setNodeValue("delete");
            Attr attr2 = element2.getAttributeNode(PARAM_ORDER);
            attr2.setNodeValue("");
            Attr attr3 = element2.getAttributeNode(SQL_ELEMENT);
            attr3.setNodeValue(string);
            Attr attr4 = element2.getAttributeNode(PRIMARYKEY_ATTR);
            attr4.setNodeValue(string2);
            Attr attr5 = element2.getAttributeNode(TRANSACTION);
            attr5.setNodeValue("NOTransaction");
            Attr attr6 = element2.getAttributeNode(TABLE_NAME);
            attr6.setNodeValue(this.mTableName);
            Attr attr7 = element2.getAttributeNode(NUMNBER_OF_RECORDS);
            attr7.setNodeValue("");
            Attr attr8 = element2.getAttributeNode(MARK_COLUMN_VALUE);
            attr8.setNodeValue("");
            Attr attr9 = element2.getAttributeNode(MOVEROW_TABLE_NAME);
            attr9.setNodeValue("");
            Attr attr10 = element2.getAttributeNode(MARK_COLUMN_NAME);
            attr10.setNodeValue("");
            Attr attr11 = element2.getAttributeNode(POLLMILLI_SECONDS);
            attr11.setNodeValue("5000");
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Could not generate the WSDL");
        }
    }

    public void modifyFind(DBQueryModel dBQueryModel, String string) throws WSDLException, Exception {
        try {
            String string2 = null;
            Element element = this.doc.getDocumentElement();
            Element element2 = this.getElementBySQL(element, FIND_QUERY);
            string2 = dBQueryModel.getPrimaryKey();
            Attr attr = element2.getAttributeNode(OPERATION_TYPE);
            attr.setNodeValue("find");
            Attr attr2 = element2.getAttributeNode(PARAM_ORDER);
            attr2.setNodeValue("");
            Attr attr3 = element2.getAttributeNode(SQL_ELEMENT);
            attr3.setNodeValue(string);
            Attr attr4 = element2.getAttributeNode(PRIMARYKEY_ATTR);
            attr4.setNodeValue(string2);
            Attr attr5 = element2.getAttributeNode(TRANSACTION);
            attr5.setNodeValue("NOTransaction");
            Attr attr6 = element2.getAttributeNode(TABLE_NAME);
            attr6.setNodeValue(this.mTableName);
            Attr attr7 = element2.getAttributeNode(NUMNBER_OF_RECORDS);
            attr7.setNodeValue("");
            Attr attr8 = element2.getAttributeNode(MARK_COLUMN_VALUE);
            attr8.setNodeValue("");
            Attr attr9 = element2.getAttributeNode(MOVEROW_TABLE_NAME);
            attr9.setNodeValue("");
            Attr attr10 = element2.getAttributeNode(MARK_COLUMN_NAME);
            attr10.setNodeValue("");
            Attr attr11 = element2.getAttributeNode(POLLMILLI_SECONDS);
            attr11.setNodeValue("5000");
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Could not generate the WSDL");
        }
    }

    public void modifyPoll(DBQueryModel dBQueryModel, String string) throws WSDLException, Exception {
        try {
            Element element = this.doc.getDocumentElement();
            String string2 = null;
            Element element2 = this.getElementBySQL(element, POLL_QUERY);
            string2 = dBQueryModel.getPrimaryKey();
            Attr attr = element2.getAttributeNode(OPERATION_TYPE);
            attr.setNodeValue("poll");
            Attr attr2 = element2.getAttributeNode(PARAM_ORDER);
            attr2.setNodeValue("");
            Attr attr3 = element2.getAttributeNode(SQL_ELEMENT);
            attr3.setNodeValue(string);
            Attr attr4 = element2.getAttributeNode(PRIMARYKEY_ATTR);
            attr4.setNodeValue(string2);
            Attr attr5 = element2.getAttributeNode(TRANSACTION);
            attr5.setNodeValue("NOTransaction");
            Attr attr6 = element2.getAttributeNode(TABLE_NAME);
            attr6.setNodeValue(this.mTableName);
            Attr attr7 = element2.getAttributeNode(NUMNBER_OF_RECORDS);
            attr7.setNodeValue("");
            Attr attr8 = element2.getAttributeNode(MARK_COLUMN_VALUE);
            attr8.setNodeValue("");
            Attr attr9 = element2.getAttributeNode(MOVEROW_TABLE_NAME);
            attr9.setNodeValue("");
            Attr attr10 = element2.getAttributeNode(MARK_COLUMN_NAME);
            attr10.setNodeValue("");
            Attr attr11 = element2.getAttributeNode(POLL_POST_PROCESS);
            attr11.setNodeValue("Delete");
            Attr attr12 = element2.getAttributeNode(POLLMILLI_SECONDS);
            attr12.setNodeValue("5000");
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Could not generate the WSDL");
        }
    }

    public void modifyServiceAndPortNames() throws WSDLException, Exception {
        try {
            Element element = this.doc.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !node.getLocalName().equalsIgnoreCase(SERVICE_NAME)) continue;
                Element element2 = (Element)node;
                Attr attr = element2.getAttributeNode("name");
                attr.setNodeValue(this.mWSDLFileName + SERVICE_NAME);
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || !node2.getLocalName().equalsIgnoreCase(PORT_NAME)) continue;
                    Element element3 = (Element)node2;
                    Attr attr2 = element3.getAttributeNode("name");
                    attr2.setNodeValue(this.mWSDLFileName + PORT_NAME);
                }
            }
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Could not generate the WSDL");
        }
    }

    public void modifyJNDIAddress() throws WSDLException, Exception {
        try {
            Element element = this.doc.getDocumentElement();
            Element element2 = this.getElementByAddress(element, JNDI_NAME);
            Attr attr = element2.getAttributeNode("jndiName");
            attr.setNodeValue(this.mJNDIName);
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Could not generate the WSDL");
        }
    }

    public DBQueryModel getQueryGenerator() {
        DBQueryModel dBQueryModel = null;
        dBQueryModel = this.mDBType.equalsIgnoreCase("DERBY") ? DerbyQueryGenerator.getInstance() : (this.mDBType.equalsIgnoreCase("ORACLE") ? OracleQueryGenerator.getInstance() : (this.mDBType.equalsIgnoreCase("DB2") ? DB2QueryGenerator.getInstance() : (this.mDBType.equalsIgnoreCase("SQLServer") ? SQLServerQueryGenerator.getInstance() : (this.mDBType.equalsIgnoreCase("MYSQL") ? MySQLQueryGenerator.getInstance() : JdbcQueryGenerator.getInstance()))));
        return dBQueryModel;
    }

    private Element getElementByName(Element element, String string) {
        if (element.getAttribute("name").equalsIgnoreCase(string)) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        Element element3 = null;
        for (int i = 0; i < nodeList.getLength() && element3 == null; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            if (element2.getAttribute("name").equalsIgnoreCase(string)) {
                element3 = element2;
                break;
            }
            element3 = this.getElementByName(element2, string);
            if (element3 == null || !element3.getAttribute("name").equalsIgnoreCase(string)) continue;
            return element3;
        }
        return element3;
    }

    private Element getElementBySQL(Element element, String string) {
        if (element.getAttribute(SQL_ELEMENT).equalsIgnoreCase(string)) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        Element element3 = null;
        for (int i = 0; i < nodeList.getLength() && element3 == null; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            if (element2.getAttribute("input").equalsIgnoreCase(string)) {
                element3 = element2;
                break;
            }
            element3 = this.getElementBySQL(element2, string);
            if (element3 == null || !element3.getAttribute(SQL_ELEMENT).equalsIgnoreCase(string)) continue;
            return element3;
        }
        return element3;
    }

    private Element getElementByAddress(Element element, String string) {
        if (element.getAttribute("jndiName").equalsIgnoreCase(string)) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        Element element3 = null;
        for (int i = 0; i < nodeList.getLength() && element3 == null; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            if (element2.getAttribute("jndiName").equalsIgnoreCase(string)) {
                element3 = element2;
                break;
            }
            element3 = this.getElementByAddress(element2, string);
            if (element3 == null || !element3.getAttribute("jndiName").equalsIgnoreCase(string)) continue;
            return element3;
        }
        return element3;
    }

    private void writeWsdl() throws WSDLException {
        try {
            WSDLWriter wSDLWriter = factory.newWSDLWriter();
            String string = this.wsdlFileLocation + File.separator + this.mWSDLFileName + ".wsdl";
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, FileEncodingQuery.getDefaultEncoding());
            wSDLWriter.writeWSDL(this.def, (Writer)outputStreamWriter);
            logger.log(Level.INFO, "Successfully generated wsdl file :" + string + " using the file encoding:" + FileEncodingQuery.getDefaultEncoding());
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                logger.log(Level.SEVERE, exception.getMessage());
            }
            if (exception instanceof IOException) {
                logger.log(Level.SEVERE, exception.getMessage());
            }
            if (exception instanceof WSDLException) {
                if (((WSDLException)((Object)exception)).getMessage().indexOf("Unsupported Java encoding for writing wsdl file") != -1) {
                    try {
                        WSDLWriter wSDLWriter = factory.newWSDLWriter();
                        String string = this.wsdlFileLocation + File.separator + this.mWSDLFileName + ".wsdl";
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                        wSDLWriter.writeWSDL(this.def, (Writer)outputStreamWriter);
                        logger.log(Level.INFO, "Successfully generated wsdl file :" + string + " using the file encoding: UTF-8");
                    }
                    catch (Exception exception2) {
                        logger.log(Level.SEVERE, exception2.getMessage());
                    }
                } else {
                    logger.log(Level.SEVERE, exception.getMessage());
                }
            }
            logger.log(Level.SEVERE, exception.getMessage());
        }
    }

    static {
        WSDLGenerator.initFactory();
    }
}

