/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.util.NbBundle;

public class KeyColumn {
    protected static final String RS_KEY_NAME = "PK_NAME";
    private static final String RS_COLUMN_NAME = "COLUMN_NAME";
    protected static final String RS_SEQUENCE_NUM = "KEY_SEQ";
    protected String columnName;
    protected String keyName;
    protected int sequenceNum;

    public static List createPrimaryKeyColumnList(ResultSet resultSet, boolean bl) throws SQLException {
        if (resultSet == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(KeyColumn.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_NULL_RS") + "(ERROR_NULL_RS)");
        }
        ArrayList<KeyColumn> arrayList = Collections.EMPTY_LIST;
        if (resultSet != null && resultSet.next()) {
            arrayList = new ArrayList<KeyColumn>();
            do {
                arrayList.add(new KeyColumn(resultSet, bl));
            } while (resultSet.next());
        }
        return arrayList;
    }

    public KeyColumn(String string, String string2, int n) {
        this.keyName = string;
        this.columnName = string2;
        this.sequenceNum = n;
    }

    protected KeyColumn() {
    }

    private KeyColumn(ResultSet resultSet, boolean bl) throws SQLException {
        if (resultSet == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(KeyColumn.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_VALID_RS") + "(ERROR_VALID_RS)");
        }
        if (bl) {
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            this.columnName = resultSet.getString(4);
            this.sequenceNum = resultSet.getShort(5);
            this.keyName = resultSet.getString(6);
        } else {
            this.keyName = resultSet.getString(RS_KEY_NAME);
            this.columnName = resultSet.getString(RS_COLUMN_NAME);
            this.sequenceNum = resultSet.getShort(RS_SEQUENCE_NUM);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getName() {
        return this.keyName;
    }

    public int getColumnSequence() {
        return this.sequenceNum;
    }
}

