/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.jdbcwizard.builder.ForeignKeyColumn;
import org.netbeans.modules.jdbcwizard.builder.IndexColumn;
import org.netbeans.modules.jdbcwizard.builder.KeyColumn;
import org.netbeans.modules.jdbcwizard.builder.Parameter;
import org.netbeans.modules.jdbcwizard.builder.PrepStmt;
import org.netbeans.modules.jdbcwizard.builder.Procedure;
import org.netbeans.modules.jdbcwizard.builder.ResultSetColumn;
import org.netbeans.modules.jdbcwizard.builder.ResultSetColumns;
import org.netbeans.modules.jdbcwizard.builder.Table;
import org.netbeans.modules.jdbcwizard.builder.TableColumn;

public final class DBMetaData {
    public static final int NAME = 0;
    public static final int CATALOG = 1;
    public static final int SCHEMA = 2;
    public static final int TYPE = 3;
    public static final String DB2 = "DB2";
    public static final String ORACLE = "ORACLE";
    public static final String SQLSERVER = "SQLSERVER";
    public static final String JDBC = "JDBC";
    public static final String VSAM_ADABAS_IAM = "LEGACY";
    public static final String JDBC_ODBC = "JDBC";
    public static final String DB2_TEXT = "DB2";
    public static final String ORACLE_TEXT = "ORACLE";
    public static final String DERBY = "DERBY";
    public static final String SQLSERVER_TEXT = "SQL SERVER";
    public static final String MYSQL_TEXT = "MySQL";
    public static final String MYSQL = "MYSQL";
    public static final String VSAM_ADABAS_IAM_TEXT = "VSAM/ADABAS/IAM";
    public static final String JDBC_TEXT = "JDBC-ODBC";
    public static final String[] DBTYPES = new String[]{"DB2", "ORACLE", "SQL SERVER", "JDBC-ODBC", "VSAM/ADABAS/IAM", "JDBC-ODBC", "MySQL"};
    public static final String[] JAVATYPES = new String[]{"boolean", "byte", "byte[]", "double", "float", "int", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.net.URL", "java.sql.Array", "java.sql.Blob", "java.sql.Clob", "java.sql.Date", "java.sql.Ref", "java.sql.Struct", "java.sql.Time", "java.sql.Timestamp", "long", "short"};
    public static final String[] SQLTYPES = new String[]{"ARRAY", "BIGINT", "BINARY", "BIT", "BLOB", "BOOLEAN", "CHAR", "CLOB", "DATALINK", "DATE", "DECIMAL", "DISTINCT", "DOUBLE", "FLOAT", "INTEGER", "JAVA_OBJECT", "LONGVARBINARY", "LONGVARCHAR", "NULL", "NUMERIC", "OTHER", "REAL", "REF", "SMALLINT", "STRUCT", "TIME", "TIMESTAMP", "TINYINT", "VARBINARY", "VARCHAR"};
    public static final int[] SQLTYPE_CODES = new int[]{2003, -5, -2, -7, 2004, 16, 1, 2005, 70, 91, 3, 2001, 8, 6, 4, 2000, -4, -1, 0, 2, 1111, 7, 2006, 5, 2002, 92, 93, -6, -3, 12};
    public static final HashMap SQLTOJAVATYPES = new HashMap();
    private static final String SYSTEM_TABLE = "SYSTEM TABLE";
    private static final String TABLE = "TABLE";
    private static final String VIEW = "VIEW";
    private static final Logger mLogger;

    public static final void checkPrimaryKeys(Table table, Connection connection) throws Exception {
        try {
            List list = DBMetaData.getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName(), connection);
            if (list.size() != 0) {
                table.setPrimaryKeyColumnList(list);
                HashSet<String> hashSet = new HashSet<String>();
                for (int i = 0; i < list.size(); ++i) {
                    KeyColumn keyColumn = (KeyColumn)list.get(i);
                    hashSet.add(keyColumn.getColumnName());
                }
                TableColumn[] tableColumnArray = table.getColumns();
                if (tableColumnArray != null) {
                    for (int i = 0; i < tableColumnArray.length; ++i) {
                        if (!hashSet.contains(tableColumnArray[i].getName())) continue;
                        tableColumnArray[i].setIsPrimaryKey(true);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static void checkForeignKeys(Table table, Connection connection) throws Exception {
        try {
            List list = DBMetaData.getForeignKeys(table.getCatalog(), table.getSchema(), table.getName(), connection);
            if (list != null) {
                table.setForeignKeyColumnList(list);
                HashSet<String> hashSet = new HashSet<String>();
                for (int i = 0; i < list.size(); ++i) {
                    ForeignKeyColumn foreignKeyColumn = (ForeignKeyColumn)list.get(i);
                    hashSet.add(foreignKeyColumn.getColumnName());
                }
                TableColumn[] tableColumnArray = table.getColumns();
                if (tableColumnArray != null) {
                    for (int i = 0; i < tableColumnArray.length; ++i) {
                        if (!hashSet.contains(tableColumnArray[i].getName())) continue;
                        tableColumnArray[i].setIsForeignKey(true);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static String getDBType(Connection connection) throws Exception {
        String string = "";
        String string2 = connection.getMetaData().getDatabaseProductName().toLowerCase();
        string = string2.equals("microsoft sql server") ? SQLSERVER : (string2.equals("mysql") ? MYSQL : (string2.equals("sql server") || string2.indexOf("jdbc") > -1 ? "JDBC" : (string2.indexOf("db2") > -1 || string2.equals("as") ? "DB2" : (string2.equals("exadas") || string2.equals("attunity connect driver") ? VSAM_ADABAS_IAM : (string2.indexOf("orac") > -1 ? "ORACLE" : (string2.indexOf("derby") > -1 ? DERBY : "JDBC"))))));
        return string;
    }

    public static int getDatabaseMajorVersion(Connection connection) throws Exception {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        return databaseMetaData.getDatabaseMajorVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getOracleRecycleBinTables(Connection connection) {
        List<String> list = new ArrayList();
        try {
            Statement statement = connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery("SELECT OBJECT_NAME FROM RECYCLEBIN WHERE TYPE = 'TABLE'");
                try {
                    while (resultSet.next()) {
                        list.add(resultSet.getString("OBJECT_NAME"));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    private static final String getJDBCSearchPattern(String string, Connection connection) throws Exception {
        try {
            String string2 = string;
            String string3 = connection.getMetaData().getSearchStringEscape();
            string2 = DBMetaData.replaceAllChars(string2, '%', string3 + "%");
            string2 = string2.replace('*', '%');
            string2 = string2.replace('?', '_');
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static final String[] getSchemas(Connection connection) throws Exception {
        try {
            ResultSet resultSet = connection.getMetaData().getSchemas();
            Vector<String> vector = new Vector<String>();
            Object[] objectArray = null;
            while (resultSet.next()) {
                String string = resultSet.getString("TABLE_SCHEM");
                vector.add(string);
            }
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
            resultSet.close();
            return objectArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static final String[][] getTablesOnly(String string, String string2, String string3, boolean bl, Connection connection) throws Exception {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[]{TABLE, SYSTEM_TABLE};
            stringArray = stringArray2;
        } else {
            String[] stringArray3;
            stringArray = stringArray3 = new String[]{TABLE};
        }
        return DBMetaData.getTables(string, string2, string3, stringArray, connection);
    }

    public static final String[][] getViewsOnly(String string, String string2, String string3, boolean bl, Connection connection) throws Exception {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[]{VIEW, SYSTEM_TABLE};
            stringArray = stringArray2;
        } else {
            String[] stringArray3;
            stringArray = stringArray3 = new String[]{VIEW};
        }
        return DBMetaData.getTables(string, string2, string3, stringArray, connection);
    }

    public static final String[][] getTablesAndViews(String string, String string2, String string3, boolean bl, Connection connection) throws Exception {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[]{TABLE, VIEW, SYSTEM_TABLE};
            stringArray = stringArray2;
        } else {
            String[] stringArray3;
            stringArray = stringArray3 = new String[]{TABLE, VIEW};
        }
        return DBMetaData.getTables(string, string2, string3, stringArray, connection);
    }

    public static final String[][] getTables(String string, String string2, String string3, String[] stringArray, Connection connection) throws Exception {
        try {
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            if (string3.equals("")) {
                string3 = null;
            }
            if (string3 != null) {
                string3 = DBMetaData.getJDBCSearchPattern(string3, connection);
            }
            ResultSet resultSet = connection.getMetaData().getTables(string, string2, string3, stringArray);
            Vector<String[]> vector = new Vector<String[]>();
            String[][] stringArray2 = null;
            while (resultSet.next()) {
                String string4 = resultSet.getString("TABLE_CAT");
                String string5 = resultSet.getString("TABLE_SCHEM");
                String string6 = resultSet.getString("TABLE_NAME");
                String string7 = resultSet.getString("TABLE_TYPE");
                if (string4 == null) {
                    string4 = "";
                }
                if (string5 == null) {
                    string5 = "";
                }
                String[] stringArray3 = new String[]{string6, string4, string5, string7};
                vector.add(stringArray3);
            }
            if (vector.size() > 0) {
                stringArray2 = new String[vector.size()][4];
                vector.copyInto((Object[])stringArray2);
            }
            resultSet.close();
            return stringArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static final PrepStmt getPrepStmtMetaData(String string, String string2, String string3, String string4, Connection connection) throws Exception {
        try {
            PrepStmt prepStmt = null;
            if (string4 == null || string4.equals("")) {
                return null;
            }
            prepStmt = new PrepStmt(string3, string, string2, string4);
            PreparedStatement preparedStatement = connection.prepareStatement(string4);
            Parameter[] parameterArray = null;
            parameterArray = DBMetaData.getPrepStmtParameters(preparedStatement, string4, connection);
            prepStmt.setParameters(parameterArray);
            ResultSetColumn[] resultSetColumnArray = null;
            resultSetColumnArray = DBMetaData.getPrepStmtResultSetColumns(preparedStatement);
            prepStmt.setResultSetColumns(resultSetColumnArray);
            preparedStatement.close();
            return prepStmt;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static final String[][] getProcedures(String string, String string2, String string3, Connection connection) throws Exception {
        try {
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            if (string3.equals("")) {
                string3 = null;
            }
            if (string3 != null) {
                string3 = DBMetaData.getJDBCSearchPattern(string3, connection);
            }
            Vector<String[]> vector = new Vector<String[]>();
            String[][] stringArray = null;
            ResultSet resultSet = connection.getMetaData().getProcedures(string, string2, string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("PROCEDURE_CAT");
                String string5 = resultSet.getString("PROCEDURE_SCHEM");
                String string6 = resultSet.getString("PROCEDURE_NAME");
                String string7 = DBMetaData.getProcedureTypeDescription(resultSet.getShort("PROCEDURE_TYPE"));
                if (string4 == null) {
                    string4 = "";
                }
                if (string5 == null) {
                    string5 = "";
                }
                String[] stringArray2 = new String[]{string6, string4, string5, string7};
                vector.add(stringArray2);
            }
            if (vector.size() > 0) {
                stringArray = new String[vector.size()][4];
                vector.copyInto((Object[])stringArray);
            }
            resultSet.close();
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static final List getPrimaryKeys(String string, String string2, String string3, Connection connection) throws Exception {
        List list = Collections.EMPTY_LIST;
        ResultSet resultSet = null;
        try {
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            resultSet = connection.getMetaData().getPrimaryKeys(string, string2, string3);
            list = connection.getMetaData().getDriverName().startsWith(JDBC_TEXT) ? KeyColumn.createPrimaryKeyColumnList(resultSet, true) : KeyColumn.createPrimaryKeyColumnList(resultSet, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return list;
    }

    public static final List getForeignKeys(String string, String string2, String string3, Connection connection) throws Exception {
        List list = Collections.EMPTY_LIST;
        ResultSet resultSet = null;
        try {
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            try {
                resultSet = connection.getMetaData().getImportedKeys(string, string2, string3);
                list = ForeignKeyColumn.createForeignKeyColumnList(resultSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                mLogger.warning("JDBC driver does not support java.sql.ParameterMetaData " + exception.getMessage());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return list;
    }

    public static final Procedure getProcedureMetaData(String string, String string2, String string3, String string4, Connection connection) throws Exception {
        try {
            Procedure procedure = new Procedure(string3, string, string2, string4);
            Vector<Parameter> vector = new Vector<Parameter>();
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            ResultSet resultSet = connection.getMetaData().getProcedureColumns(string, string2, string3, "%");
            Object[] objectArray = null;
            int n = 0;
            boolean bl = false;
            while (resultSet.next()) {
                ++n;
                String string5 = resultSet.getString("COLUMN_NAME");
                if (string5 != null) {
                    if (string5.charAt(0) == '@') {
                        string5 = string5.substring(1);
                    }
                } else {
                    string5 = "param" + String.valueOf(n);
                }
                String string6 = DBMetaData.getSQLTypeDescription(resultSet.getInt("DATA_TYPE"));
                String string7 = DBMetaData.getJavaFromSQLTypeDescription(string6);
                int n2 = resultSet.getInt("DATA_TYPE");
                if (n2 == 1111 && resultSet.getString("TYPE_NAME").equalsIgnoreCase("REF CURSOR")) {
                    string6 = "RESULTSET";
                    string7 = "java.sql.ResultSet";
                }
                String string8 = DBMetaData.getParamTypeDescription(resultSet.getShort("COLUMN_TYPE"));
                short s = resultSet.getShort("NULLABLE");
                int n3 = resultSet.getInt("PRECISION");
                short s2 = resultSet.getShort("SCALE");
                Parameter parameter = new Parameter(string5, string7);
                boolean bl2 = false;
                if (s == 1) {
                    bl2 = true;
                }
                parameter.setJavaType(string7);
                parameter.setSqlType(string6);
                parameter.setParamType(string8);
                parameter.setOrdinalPosition(n);
                parameter.setNumericPrecision(n3);
                parameter.setNumericScale(s2);
                parameter.setIsNullable(bl2);
                if (string8.equals("RETURN")) {
                    bl = true;
                }
                vector.add(parameter);
            }
            resultSet.close();
            if (vector.size() > 0) {
                objectArray = new Parameter[vector.size()];
                vector.copyInto(objectArray);
            }
            procedure.setParameters((Parameter[])objectArray);
            procedure.setHasReturn(bl);
            return procedure;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static final Table getTableMetaData(String string, String string2, String string3, String string4, Connection connection) throws Exception {
        ResultSet resultSet = null;
        try {
            Object object;
            Table table = new Table(string3, string, string2, string4);
            Vector<TableColumn> vector = new Vector<TableColumn>();
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            resultSet = connection.getMetaData().getColumns(string, string2, string3, "%");
            Object[] objectArray = null;
            while (resultSet.next()) {
                object = resultSet.getString("COLUMN_DEF");
                int n = resultSet.getInt("DATA_TYPE");
                String string5 = resultSet.getString("COLUMN_NAME");
                String string6 = DBMetaData.getSQLTypeDescription(n);
                String string7 = DBMetaData.getJavaFromSQLTypeDescription(string6);
                int n2 = resultSet.getInt("ORDINAL_POSITION");
                int n3 = resultSet.getInt("DECIMAL_DIGITS");
                int n4 = resultSet.getInt("COLUMN_SIZE");
                int n5 = resultSet.getInt("NUM_PREC_RADIX");
                TableColumn tableColumn = new TableColumn(string5, string7);
                boolean bl = false;
                if (resultSet.getString("IS_NULLABLE").equals("YES")) {
                    bl = true;
                }
                tableColumn.setJavaType(string7);
                tableColumn.setSqlType(string6);
                tableColumn.setIsNullable(bl);
                tableColumn.setIsSelected(true);
                tableColumn.setIsPrimaryKey(false);
                tableColumn.setIsForeignKey(false);
                tableColumn.setSqlTypeCode(n);
                tableColumn.setOrdinalPosition(n2);
                tableColumn.setNumericPrecision(n4);
                tableColumn.setNumericScale(n3);
                tableColumn.setNumericRadix(n5);
                if (object != null) {
                    tableColumn.setDefaultValue(((String)object).trim());
                }
                vector.add(tableColumn);
            }
            if (vector.size() > 0) {
                objectArray = new TableColumn[vector.size()];
                vector.copyInto(objectArray);
            }
            table.setColumns((TableColumn[])objectArray);
            DBMetaData.checkPrimaryKeys(table, connection);
            DBMetaData.checkForeignKeys(table, connection);
            try {
                resultSet = connection.getMetaData().getIndexInfo(string, string2, string3, false, true);
                table.setIndexList(IndexColumn.createIndexList(resultSet));
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = table;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static final Table getTableMetaDataForODBCDriver(String string, String string2, String string3, String string4, Connection connection) throws Exception {
        ResultSet resultSet = null;
        try {
            Object object;
            Table table = new Table(string3, string, string2, string4);
            Vector<TableColumn> vector = new Vector<TableColumn>();
            if (string.equals("")) {
                string = null;
            }
            if (string2.equals("")) {
                string2 = null;
            }
            resultSet = connection.getMetaData().getColumns(string, string2, string3, "%");
            Object[] objectArray = null;
            while (resultSet.next()) {
                object = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                int n = resultSet.getInt(5);
                String string8 = resultSet.getString(6);
                int n2 = resultSet.getInt(7);
                int n3 = resultSet.getInt(8);
                int n4 = resultSet.getInt(9);
                int n5 = resultSet.getInt(10);
                boolean bl = resultSet.getBoolean(11);
                String string9 = resultSet.getString(12);
                String string10 = resultSet.getString(13);
                String string11 = DBMetaData.getSQLTypeDescription(n);
                String string12 = DBMetaData.getJavaFromSQLTypeDescription(string11);
                TableColumn tableColumn = new TableColumn(string7, string12);
                boolean bl2 = false;
                if (resultSet.getString("IS_NULLABLE").equals("YES")) {
                    bl2 = true;
                }
                tableColumn.setJavaType(string12);
                tableColumn.setSqlType(string11);
                tableColumn.setIsNullable(bl2);
                tableColumn.setIsSelected(true);
                tableColumn.setIsPrimaryKey(false);
                tableColumn.setIsForeignKey(false);
                tableColumn.setSqlTypeCode(n);
                tableColumn.setNumericPrecision(n2);
                tableColumn.setNumericScale(n4);
                tableColumn.setNumericRadix(n5);
                if (string10 != null) {
                    tableColumn.setDefaultValue(string10.trim());
                }
                vector.add(tableColumn);
            }
            if (vector.size() > 0) {
                objectArray = new TableColumn[vector.size()];
                vector.copyInto(objectArray);
            }
            table.setColumns((TableColumn[])objectArray);
            DBMetaData.checkPrimaryKeys(table, connection);
            DBMetaData.checkForeignKeys(table, connection);
            try {
                resultSet = connection.getMetaData().getIndexInfo(string, string2, string3, false, true);
                table.setIndexList(IndexColumn.createIndexList(resultSet));
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = table;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static final String getJavaFromSQLTypeDescription(String string) {
        String string2 = "java.lang.String";
        Object v = SQLTOJAVATYPES.get(string);
        if (v != null) {
            string2 = v.toString();
        }
        return string2;
    }

    public static final String getSQLTypeDescription(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "OTHER";
    }

    public static final int getSQLTypeCode(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Must supply non-null String value for sqlText.");
        }
        string = string.trim().toUpperCase();
        for (int i = 0; i < SQLTYPES.length; ++i) {
            if (!SQLTYPES[i].equals(string)) continue;
            return SQLTYPE_CODES[i];
        }
        return 1111;
    }

    private static final String getJavaTypeDescription(int n) {
        String string = "java.lang.String";
        switch (n) {
            case 2003: {
                string = "java.sql.ARRAY";
            }
            case -5: {
                string = "long";
            }
            case -2: {
                string = "byte[]";
            }
            case -7: {
                string = "boolean";
            }
            case 2004: {
                string = "java.sql.Blob";
            }
            case 1: {
                string = "java.lang.String";
            }
            case 2005: {
                string = "java.sql.Clob";
            }
            case 91: {
                string = "java.sql.Date";
            }
            case 3: {
                string = "java.math.BigDecimal";
            }
            case 8: {
                string = "double";
            }
            case 6: {
                string = "double";
            }
            case 4: {
                string = "int";
            }
            case -4: {
                string = "byte[]";
            }
            case -1: {
                string = "java.lang.String";
            }
            case 2: {
                string = "java.math.BigDecimal";
            }
            case 7: {
                string = "float";
            }
            case 2006: {
                string = "java.sql.Ref";
            }
            case 5: {
                string = "short";
            }
            case 2002: {
                string = "java.sql.Struct";
            }
            case 92: {
                string = "java.sql.Time";
            }
            case 93: {
                string = "java.sql.Timestamp";
            }
            case -6: {
                string = "byte";
            }
            case -3: {
                string = "byte[]";
            }
            case 12: {
                string = "java.lang.String";
            }
        }
        return string;
    }

    private static final String getParamTypeDescription(int n) {
        String string = "";
        string = n == 1 ? "IN" : (n == 2 ? "INOUT" : (n == 4 ? "OUT" : (n == 5 ? "RETURN" : (n == 3 ? "RESULT" : "UNKNOWN"))));
        return string;
    }

    private static final String getProcedureTypeDescription(int n) {
        String string = "";
        string = n == 1 ? "PROCEDURE" : (n == 2 ? "FUNCTION" : (n == 0 ? "UNKNOWN" : "UNKNOWN"));
        return string;
    }

    private static final String getPrepStmtParamTypeDescription(int n) {
        String string = "";
        string = n == 1 ? "IN" : (n == 2 ? "INOUT" : (n == 4 ? "OUT" : (n == 0 ? "UNKNOWN" : "UNKNOWN")));
        return string;
    }

    private static final String replaceAllChars(String string, char c, String string2) {
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            string3 = string.charAt(i) == c ? string3 + string2 : string3 + string.charAt(i);
        }
        return string3;
    }

    private static final Parameter[] getPrepStmtParameters(PreparedStatement preparedStatement, String string, Connection connection) {
        Parameter[] parameterArray;
        block17: {
            String string2 = "";
            parameterArray = null;
            try {
                int n;
                ParameterMetaData parameterMetaData = null;
                try {
                    parameterMetaData = preparedStatement.getParameterMetaData();
                }
                catch (AbstractMethodError abstractMethodError) {
                    mLogger.log(Level.INFO, "JDBC driver does not support java.sql.ParameterMetaData " + abstractMethodError.getMessage());
                    return DBMetaData.handleUnsupportParameterMetaData(string);
                }
                catch (SQLException sQLException) {
                    mLogger.log(Level.INFO, "JDBC driver does not support java.sql.ParameterMetaData " + sQLException.getMessage());
                    return DBMetaData.handleUnsupportParameterMetaData(string);
                }
                catch (Exception exception) {
                    mLogger.log(Level.INFO, "JDBC driver does not support java.sql.ParameterMetaData " + exception.getMessage());
                    return DBMetaData.handleUnsupportParameterMetaData(string);
                }
                if (parameterMetaData == null || (n = parameterMetaData.getParameterCount()) <= 0) break block17;
                parameterArray = new Parameter[n];
                for (int i = 1; i <= n; ++i) {
                    Parameter parameter = new Parameter();
                    String string3 = "param" + String.valueOf(i);
                    parameter.setName(string3);
                    String string4 = "VARCHAR";
                    try {
                        string4 = DBMetaData.getSQLTypeDescription(parameterMetaData.getParameterType(i));
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        string2 = sQLException.getLocalizedMessage();
                    }
                    String string5 = "java.lang.String";
                    string5 = DBMetaData.getJavaFromSQLTypeDescription(string4);
                    int n2 = 0;
                    try {
                        n2 = parameterMetaData.getPrecision(i);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        string2 = sQLException.getLocalizedMessage();
                    }
                    int n3 = 0;
                    try {
                        n3 = parameterMetaData.getScale(i);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        string2 = sQLException.getLocalizedMessage();
                    }
                    String string6 = "IN";
                    try {
                        string6 = DBMetaData.getPrepStmtParamTypeDescription(parameterMetaData.getParameterMode(i));
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        string2 = sQLException.getLocalizedMessage();
                    }
                    boolean bl = true;
                    try {
                        bl = parameterMetaData.isNullable(i) == 1;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        string2 = sQLException.getLocalizedMessage();
                    }
                    parameter.setJavaType(string5);
                    parameter.setSqlType(string4);
                    parameter.setNumericPrecision(n2);
                    parameter.setNumericScale(n3);
                    parameter.setOrdinalPosition(i);
                    parameter.setParamType(string6);
                    parameter.setIsNullable(bl);
                    parameterArray[i - 1] = parameter;
                }
            }
            catch (Exception exception) {
                parameterArray = null;
                exception.printStackTrace();
                string2 = exception.getLocalizedMessage();
            }
        }
        return parameterArray;
    }

    private static final ResultSetColumn[] getPrepStmtResultSetColumns(PreparedStatement preparedStatement) {
        String string = "";
        ResultSetColumn[] resultSetColumnArray = null;
        try {
            ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
            int n = 0;
            if (resultSetMetaData != null) {
                n = resultSetMetaData.getColumnCount();
            }
            if (n > 0) {
                resultSetColumnArray = new ResultSetColumn[n];
                for (int i = 1; i <= n; ++i) {
                    ResultSetColumn resultSetColumn = new ResultSetColumn();
                    resultSetColumn.setName(resultSetMetaData.getColumnName(i));
                    resultSetColumn.setSqlType(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i)));
                    resultSetColumn.setJavaType(DBMetaData.getJavaFromSQLTypeDescription(resultSetColumn.getSqlType()));
                    resultSetColumn.setOrdinalPosition(i);
                    resultSetColumn.setNumericPrecision(resultSetMetaData.getPrecision(i));
                    resultSetColumn.setNumericScale(resultSetMetaData.getScale(i));
                    if (resultSetMetaData.isNullable(i) == 1) {
                        resultSetColumn.setIsNullable(true);
                    } else {
                        resultSetColumn.setIsNullable(false);
                    }
                    resultSetColumnArray[i - 1] = resultSetColumn;
                }
            }
        }
        catch (Exception exception) {
            resultSetColumnArray = null;
            exception.printStackTrace();
            string = exception.getLocalizedMessage();
        }
        return resultSetColumnArray;
    }

    private static final Parameter[] handleUnsupportParameterMetaData(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '?') continue;
            ++n;
        }
        Parameter[] parameterArray = new Parameter[n];
        for (int i = 1; i <= n; ++i) {
            Parameter parameter = new Parameter();
            String string2 = "param" + String.valueOf(i);
            parameter.setName(string2);
            parameter.setJavaType("java.lang.String");
            parameter.setSqlType("VARCHAR");
            parameter.setNumericPrecision(0);
            parameter.setNumericScale(0);
            parameter.setOrdinalPosition(i);
            parameter.setParamType("IN");
            parameter.setIsNullable(true);
            parameterArray[i - 1] = parameter;
        }
        return parameterArray;
    }

    public static final Procedure getProcResultSetColumns(String string, String string2, String string3, String string4, Connection connection) throws SQLException, NullPointerException {
        String string5 = "";
        String string6 = "";
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        Procedure procedure = new Procedure(string3, string, string2, new String("PROCEDURE"));
        ResultSetColumn resultSetColumn = new ResultSetColumn();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<ResultSetColumns> arrayList2 = new ArrayList<ResultSetColumns>();
        if (string.trim().equalsIgnoreCase("") || string == null) {
            bl3 = false;
        }
        try {
            Object object;
            int n2;
            int n3;
            int n4;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getProcedureColumns(string, string2, string3, string4);
            while (resultSet.next()) {
                if (resultSet.getShort("COLUMN_TYPE") != 5) continue;
                bl = true;
            }
            resultSet = databaseMetaData.getProcedureColumns(string, string2, string3, string4);
            while (resultSet.next()) {
                ++n;
            }
            if (n == 0) {
                bl2 = false;
            }
            if (bl) {
                string6 = "{ ? = call ";
                string6 = bl3 ? string6 + string + "." + string3 + "(" : string6 + string3 + "(";
                for (n4 = 1; n4 < n; ++n4) {
                    string6 = string6 + "?,";
                }
                if (bl2) {
                    string6 = string6.substring(0, string6.length() - 1);
                }
                string6 = string6 + ") }";
            } else {
                string6 = "call ";
                string6 = bl3 ? string6 + string + "." + string3 + "(" : string6 + string3 + "(";
                for (n4 = 0; n4 < n; ++n4) {
                    string6 = string6 + "?,";
                }
                if (bl2) {
                    string6 = string6.substring(0, string6.length() - 1);
                }
                string6 = string6 + ")";
            }
            CallableStatement callableStatement = connection.prepareCall(string6);
            resultSet = databaseMetaData.getProcedureColumns(string, string2, string3, string4);
            int n5 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                resultSet.next();
                String string7 = resultSet.getString("COLUMN_NAME");
                n2 = resultSet.getInt("DATA_TYPE");
                short s = resultSet.getShort("COLUMN_TYPE");
                object = resultSet.getString("TYPE_NAME");
                callableStatement.setNull(++n5, n2);
                if (s == 2 || s == 4) {
                    try {
                        if (n2 == 1111 && ((String)object).equals("OTHER")) {
                            n2 = 1111;
                            arrayList.add(Integer.valueOf(String.valueOf(n5)));
                        }
                        callableStatement.registerOutParameter(n5, n2);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        throw sQLException;
                    }
                }
                if (s != 5) continue;
                try {
                    if (n2 == 1111 && ((String)object).equals("OTHER")) {
                        n2 = 1111;
                        arrayList.add(Integer.valueOf(String.valueOf(n5)));
                    }
                    callableStatement.registerOutParameter(n5, n2);
                    continue;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    throw sQLException;
                }
            }
            n3 = callableStatement.execute() ? 1 : 0;
            int n6 = -1;
            n2 = arrayList.size();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ResultSetMetaData resultSetMetaData;
                object = new ArrayList();
                ++n6;
                int n7 = (Integer)iterator.next();
                try {
                    ResultSet resultSet2 = (ResultSet)callableStatement.getObject(n7);
                    resultSetMetaData = resultSet2.getMetaData();
                }
                catch (SQLException sQLException) {
                    resultSetMetaData = null;
                }
                int n8 = 0;
                if (resultSetMetaData != null) {
                    n8 = resultSetMetaData.getColumnCount();
                }
                for (int i = 1; i <= n8; ++i) {
                    ResultSetColumn resultSetColumn2 = new ResultSetColumn();
                    resultSetColumn2.setOrdinalPosition(i);
                    resultSetColumn2.setName(resultSetMetaData.getColumnName(i));
                    resultSetColumn2.setLabel(resultSetMetaData.getColumnLabel(i));
                    resultSetColumn2.setSqlType(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i)));
                    resultSetColumn2.setJavaType((String)SQLTOJAVATYPES.get(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i))));
                    if (resultSetMetaData.isNullable(i) == 1) {
                        resultSetColumn2.setIsNullable(true);
                    } else {
                        resultSetColumn2.setIsNullable(false);
                    }
                    boolean bl4 = ((ArrayList)object).add(resultSetColumn2);
                }
                if (((ArrayList)object).size() <= 0) continue;
                ResultSetColumns resultSetColumns = new ResultSetColumns();
                resultSetColumns.setColumns((ArrayList)object);
                resultSetColumns.setName(string3 + "_" + n6);
                arrayList2.add(resultSetColumns);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            string5 = sQLException.getLocalizedMessage();
            throw sQLException;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            string5 = nullPointerException.getLocalizedMessage();
            throw nullPointerException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string5 = exception.getLocalizedMessage();
        }
        procedure.setResultSetColumns(arrayList2);
        return procedure;
    }

    public static final Procedure getQueryResultSet(String string, String string2, String string3, String string4, Connection connection) throws SQLException, NullPointerException {
        String string5 = "";
        Procedure procedure = new Procedure(string3, string, string2, new String("PROCEDURE"));
        ResultSetColumns[] resultSetColumnsArray = null;
        ArrayList<ResultSetColumn> arrayList = new ArrayList<ResultSetColumn>();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Statement statement = connection.createStatement();
            String[] stringArray = DBMetaData.getQueryFields(string4);
            ResultSet resultSet = statement.executeQuery(string4);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string6;
                ResultSetColumn resultSetColumn = new ResultSetColumn();
                resultSetColumn.setOrdinalPosition(i);
                String string7 = resultSetMetaData.getColumnName(i).trim();
                String string8 = resultSetMetaData.getColumnLabel(i).trim();
                if (string7.equalsIgnoreCase("") || string7 == null) {
                    string6 = stringArray[i - 1];
                    resultSetColumn.setName(string6);
                } else {
                    resultSetColumn.setName(string7);
                }
                if (string8.equalsIgnoreCase("") || string8 == null) {
                    string6 = stringArray[i - 1];
                    resultSetColumn.setLabel(string6);
                } else {
                    resultSetColumn.setLabel(string8);
                }
                resultSetColumn.setSqlType(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i)));
                resultSetColumn.setJavaType((String)SQLTOJAVATYPES.get(DBMetaData.getSQLTypeDescription(resultSetMetaData.getColumnType(i))));
                if (resultSetMetaData.isNullable(i) == 1) {
                    resultSetColumn.setIsNullable(true);
                } else {
                    resultSetColumn.setIsNullable(false);
                }
                boolean bl = arrayList.add(resultSetColumn);
            }
            resultSetColumnsArray = new ResultSetColumns[]{new ResultSetColumns()};
            resultSetColumnsArray[0].setColumns(arrayList);
            resultSetColumnsArray[0].setName(string3 + "_0");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            string5 = sQLException.getLocalizedMessage();
            throw sQLException;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            string5 = nullPointerException.getLocalizedMessage();
            throw nullPointerException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string5 = exception.getLocalizedMessage();
        }
        procedure.setResultSetColumns(resultSetColumnsArray);
        return procedure;
    }

    public static final String getProcedureText(Procedure procedure, Connection connection) {
        String string = "";
        String string2 = "";
        String string3 = procedure.getName();
        String string4 = procedure.getCatalog();
        string2 = string4.equals("") || string4 == null ? "select text from user_source where name = '" + string3 + "'" : "select text from user_source where name = '" + string4 + "'";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                string = string + resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return string;
    }

    private static final String[] getQueryFields(String string) {
        String[] stringArray = null;
        String string2 = string.toUpperCase().trim();
        int n = string2.indexOf("FROM");
        String string3 = string.substring(7, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        int n2 = stringTokenizer.countTokens();
        stringArray = new String[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3] = stringTokenizer.nextToken().trim();
            ++n3;
        }
        return stringArray;
    }

    static {
        SQLTOJAVATYPES.put("ARRAY", "java.sql.Array");
        SQLTOJAVATYPES.put("BIGINT", "long");
        SQLTOJAVATYPES.put("BINARY", "byte[]");
        SQLTOJAVATYPES.put("BIT", "boolean");
        SQLTOJAVATYPES.put("BLOB", "java.sql.Blob");
        SQLTOJAVATYPES.put("BOOLEAN", "boolean");
        SQLTOJAVATYPES.put("CHAR", "java.lang.String");
        SQLTOJAVATYPES.put("CLOB", "java.sql.Clob");
        SQLTOJAVATYPES.put("DATALINK", "java.net.URL");
        SQLTOJAVATYPES.put("DATE", "java.sql.Date");
        SQLTOJAVATYPES.put("DECIMAL", "java.math.BigDecimal");
        SQLTOJAVATYPES.put("DISTINCT", "java.lang.String");
        SQLTOJAVATYPES.put("DOUBLE", "double");
        SQLTOJAVATYPES.put("FLOAT", "double");
        SQLTOJAVATYPES.put("INTEGER", "int");
        SQLTOJAVATYPES.put("JAVA_OBJECT", "java.lang.Object");
        SQLTOJAVATYPES.put("LONGVARBINARY", "byte[]");
        SQLTOJAVATYPES.put("LONGVARCHAR", "java.lang.String");
        SQLTOJAVATYPES.put("NULL", "java.lang.String");
        SQLTOJAVATYPES.put("NUMERIC", "java.math.BigDecimal");
        SQLTOJAVATYPES.put("OTHER", "java.lang.String");
        SQLTOJAVATYPES.put("REAL", "float");
        SQLTOJAVATYPES.put("REF", "java.sql.Ref");
        SQLTOJAVATYPES.put("SMALLINT", "short");
        SQLTOJAVATYPES.put("STRUCT", "java.sql.Struct");
        SQLTOJAVATYPES.put("TIME", "java.sql.Time");
        SQLTOJAVATYPES.put("TIMESTAMP", "java.sql.Timestamp");
        SQLTOJAVATYPES.put("TINYINT", "byte");
        SQLTOJAVATYPES.put("VARBINARY", "byte[]");
        SQLTOJAVATYPES.put("VARCHAR", "java.lang.String");
        SQLTOJAVATYPES.put("RESULTSET", "java.sql.ResultSet");
        mLogger = Logger.getLogger(DBMetaData.class.getName());
    }
}

