/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathItem;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectClassPathModifierSupport<T extends ClassPathItem> {
    private final Project project;
    private final UpdateHelper helper;
    private final ReferenceHelper refHelper;
    private final PropertyEvaluator eval;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final Properties properties;

    public static <T extends ClassPathItem> ProjectClassPathModifierSupport<T> create(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, SourceRoots sourceRoots, SourceRoots sourceRoots2, Properties properties) {
        return new ProjectClassPathModifierSupport<T>(project, updateHelper, propertyEvaluator, referenceHelper, sourceRoots, sourceRoots2, properties);
    }

    private ProjectClassPathModifierSupport(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, SourceRoots sourceRoots, SourceRoots sourceRoots2, Properties properties) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"helper", (Object)updateHelper);
        Parameters.notNull((CharSequence)"eval", (Object)propertyEvaluator);
        Parameters.notNull((CharSequence)"refHelper", (Object)referenceHelper);
        Parameters.notNull((CharSequence)"sourceRoots", (Object)sourceRoots);
        Parameters.notNull((CharSequence)"testSourceRoots", (Object)sourceRoots2);
        Parameters.notNull((CharSequence)"properties", (Object)properties);
        this.project = project;
        this.helper = updateHelper;
        this.eval = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = sourceRoots2;
        this.properties = properties;
    }

    public SourceGroup[] getExtensibleSourceGroups() {
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        assert (sources != null);
        return sources.getSourceGroups("java");
    }

    public String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
        return new String[]{"classpath/compile", "classpath/execute"};
    }

    public boolean handleRoots(final URL[] uRLArray, final String string, final Operation operation, final ClassPathItemProvider<T> classPathItemProvider) throws IOException, UnsupportedOperationException {
        assert (uRLArray != null) : "The classPathRoots cannot be null";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties editableProperties = ProjectClassPathModifierSupport.this.helper.getProperties("nbproject/project.properties");
                    String string2 = editableProperties.getProperty(string);
                    List list = classPathItemProvider.getClassPathItems(string2);
                    boolean bl = false;
                    for (URL uRL : uRLArray) {
                        File file;
                        assert (uRL != null);
                        assert (uRL.toExternalForm().endsWith("/"));
                        URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                        if (uRL2 == null) {
                            uRL2 = uRL;
                        }
                        if ((file = FileUtil.normalizeFile((File)new File(URI.create(uRL2.toExternalForm())))) == null) {
                            throw new IllegalArgumentException("The file must exist on disk");
                        }
                        ClassPathItem classPathItem = (ClassPathItem)classPathItemProvider.createClassPathItem(file, null);
                        if (operation == Operation.ADD && !list.contains(classPathItem)) {
                            list.add(classPathItem);
                            bl = true;
                            continue;
                        }
                        if (operation != Operation.REMOVE) continue;
                        if (list.remove(classPathItem)) {
                            bl = true;
                            continue;
                        }
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ClassPathItem classPathItem2 = (ClassPathItem)iterator.next();
                            if (!classPathItem2.isBroken() || classPathItem2.getType() != ClassPathItem.Type.JAR || !file.equals(classPathItem2.getFile())) continue;
                            iterator.remove();
                            bl = true;
                        }
                    }
                    if (bl) {
                        Object[] objectArray = classPathItemProvider.encodeToStrings(list);
                        editableProperties = ProjectClassPathModifierSupport.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, (String[])objectArray);
                        ProjectClassPathModifierSupport.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject(ProjectClassPathModifierSupport.this.project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public boolean handleAntArtifacts(final AntArtifact[] antArtifactArray, final URI[] uRIArray, final String string, final Operation operation, final ClassPathItemProvider<T> classPathItemProvider) throws IOException, UnsupportedOperationException {
        assert (antArtifactArray != null) : "Artifacts cannot be null";
        assert (uRIArray != null) : "ArtifactElements cannot be null";
        assert (antArtifactArray.length == uRIArray.length) : "Each artifact has to have corresponding artifactElement";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties editableProperties = ProjectClassPathModifierSupport.this.helper.getProperties("nbproject/project.properties");
                    String string2 = editableProperties.getProperty(string);
                    List list = classPathItemProvider.getClassPathItems(string2);
                    boolean bl = false;
                    for (int i = 0; i < antArtifactArray.length; ++i) {
                        assert (antArtifactArray[i] != null);
                        assert (uRIArray[i] != null);
                        ClassPathItem classPathItem = (ClassPathItem)classPathItemProvider.createClassPathItem(antArtifactArray[i], uRIArray[i], null);
                        if (operation == Operation.ADD && !list.contains(classPathItem)) {
                            list.add(classPathItem);
                            bl = true;
                            continue;
                        }
                        if (operation != Operation.REMOVE || !list.contains(classPathItem)) continue;
                        list.remove(classPathItem);
                        bl = true;
                    }
                    if (bl) {
                        String[] stringArray = classPathItemProvider.encodeToStrings(list);
                        editableProperties = ProjectClassPathModifierSupport.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        ProjectClassPathModifierSupport.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject(ProjectClassPathModifierSupport.this.project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public boolean handleLibraries(final Library[] libraryArray, final String string, final Operation operation, final ClassPathItemProvider<T> classPathItemProvider) throws IOException, UnsupportedOperationException {
        assert (libraryArray != null) : "Libraries cannot be null";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    EditableProperties editableProperties = ProjectClassPathModifierSupport.this.helper.getProperties("nbproject/project.properties");
                    String string2 = editableProperties.getProperty(string);
                    List list = classPathItemProvider.getClassPathItems(string2);
                    ArrayList<ClassPathItem> arrayList = new ArrayList<ClassPathItem>(libraryArray.length);
                    for (Library library : libraryArray) {
                        assert (library != null);
                        ClassPathItem classPathItem = (ClassPathItem)classPathItemProvider.createClassPathItem(library, null);
                        if (operation == Operation.ADD && !list.contains(classPathItem)) {
                            list.add(classPathItem);
                            arrayList.add(classPathItem);
                            continue;
                        }
                        if (operation != Operation.REMOVE || !list.contains(classPathItem)) continue;
                        list.remove(classPathItem);
                        arrayList.add(classPathItem);
                    }
                    if (!arrayList.isEmpty()) {
                        String[] stringArray = classPathItemProvider.encodeToStrings(list);
                        editableProperties = ProjectClassPathModifierSupport.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        if (operation == Operation.ADD) {
                            for (ClassPathItem classPathItem : arrayList) {
                                String string3 = classPathItemProvider.getLibraryReference(classPathItem);
                                string3 = string3.substring(2, string3.length() - 1);
                                ClassPathSupport.relativizeLibraryClassPath(editableProperties, ProjectClassPathModifierSupport.this.helper.getAntProjectHelper(), string3);
                            }
                        }
                        ProjectClassPathModifierSupport.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject(ProjectClassPathModifierSupport.this.project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public String getClassPathProperty(SourceGroup sourceGroup, String string) throws UnsupportedOperationException {
        assert (sourceGroup != null) : "SourceGroup cannot be null";
        assert (string != null) : "Type cannot be null";
        String string2 = this.getPropertyName(sourceGroup, string);
        if (string2 == null) {
            throw new UnsupportedOperationException("Modification of [" + sourceGroup.getRootFolder().getPath() + ", " + string + "] is not supported");
        }
        return string2;
    }

    private String getPropertyName(SourceGroup sourceGroup, String string) {
        FileObject fileObject = sourceGroup.getRootFolder();
        for (FileObject fileObject2 : this.sourceRoots.getRoots()) {
            if (!fileObject.equals(fileObject2)) continue;
            if ("classpath/compile".equals(string)) {
                return this.properties.sourceCompileTimeClassPath;
            }
            if ("classpath/execute".equals(string)) {
                return this.properties.sourceRunTimeClassPath;
            }
            return null;
        }
        for (FileObject fileObject2 : this.testSourceRoots.getRoots()) {
            if (!fileObject.equals(fileObject2)) continue;
            if ("classpath/compile".equals(string)) {
                return this.properties.testSourceCompileTimeClassPath;
            }
            if ("classpath/execute".equals(string)) {
                return this.properties.testSourceRunTimeClassPath;
            }
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ClassPathItemProvider<T> {
        public T createClassPathItem(File var1, String var2);

        public T createClassPathItem(AntArtifact var1, URI var2, String var3);

        public T createClassPathItem(Library var1, String var2);

        public List<T> getClassPathItems(String var1);

        public String[] encodeToStrings(List<T> var1);

        public String getLibraryReference(T var1);
    }

    public static final class Properties {
        final String sourceCompileTimeClassPath;
        final String sourceRunTimeClassPath;
        final String testSourceCompileTimeClassPath;
        final String testSourceRunTimeClassPath;

        public Properties(String string, String string2, String string3, String string4) {
            Parameters.notNull((CharSequence)"sourceCompileTimeClassPath", (Object)string);
            Parameters.notNull((CharSequence)"sourceRunTimeClassPath", (Object)string2);
            Parameters.notNull((CharSequence)"testSourceCompileTimeClassPath", (Object)string3);
            Parameters.notNull((CharSequence)"testSourceRunTimeClassPath", (Object)string4);
            this.sourceCompileTimeClassPath = string;
            this.sourceRunTimeClassPath = string2;
            this.testSourceCompileTimeClassPath = string3;
            this.testSourceRunTimeClassPath = string4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        ADD,
        REMOVE;

    }
}

