/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.BootClassPathImplementation;
import org.netbeans.modules.java.api.common.classpath.SourcePathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class DefaultClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final Properties properties;
    private final Map<ClassPathCache, ClassPath> cache = new HashMap<ClassPathCache, ClassPath>();
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public DefaultClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2, Properties properties) {
        Parameters.notNull((CharSequence)"helper", (Object)antProjectHelper);
        Parameters.notNull((CharSequence)"evaluator", (Object)propertyEvaluator);
        Parameters.notNull((CharSequence)"sourceRoots", (Object)sourceRoots);
        Parameters.notNull((CharSequence)"testSourceRoots", (Object)sourceRoots2);
        Parameters.notNull((CharSequence)"properties", (Object)properties);
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = sourceRoots2;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        this.properties = properties;
    }

    private synchronized FileObject getDir(String string) {
        String string2;
        FileObject fileObject = this.dirCache.get(string);
        if (!(fileObject != null && fileObject.isValid() || (string2 = this.evaluator.getProperty(string)) == null)) {
            fileObject = this.helper.resolveFileObject(string2);
            this.dirCache.put(string, fileObject);
        }
        return fileObject;
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(this.properties.buildClassesDir);
    }

    private FileObject getDistJar() {
        return this.getDir(this.properties.distJar);
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir(this.properties.buildTestClassesDir);
    }

    private FileType getType(FileObject fileObject) {
        for (FileObject fileObject2 : this.getPrimarySrcPath()) {
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return FileType.SOURCE;
        }
        for (FileObject fileObject2 : this.getTestSrcDir()) {
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return FileType.TEST_SOURCE;
        }
        FileObject fileObject3 = this.getBuildClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return FileType.CLASS;
        }
        fileObject3 = this.getDistJar();
        if (fileObject3 != null && fileObject3.equals(FileUtil.getArchiveFile((FileObject)fileObject))) {
            return FileType.CLASS_IN_JAR;
        }
        fileObject3 = this.getBuildTestClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return FileType.TEST_CLASS;
        }
        return FileType.UNKNOWN;
    }

    private synchronized ClassPath getCompileTimeClasspath(FileType fileType) {
        ClassPath classPath = null;
        switch (fileType) {
            case SOURCE: 
            case CLASS: {
                classPath = this.cache.get((Object)ClassPathCache.SOURCE_COMPILATION);
                if (classPath != null) break;
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.properties.sourceCompileTimeClassPath));
                this.cache.put(ClassPathCache.SOURCE_COMPILATION, classPath);
                break;
            }
            case TEST_SOURCE: {
                classPath = this.cache.get((Object)ClassPathCache.TEST_SOURCE_COMPILATION);
                if (classPath != null) break;
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.properties.testSourceCompileTimeClassPath));
                this.cache.put(ClassPathCache.TEST_SOURCE_COMPILATION, classPath);
                break;
            }
        }
        return classPath;
    }

    private synchronized ClassPath getRunTimeClasspath(FileType fileType) {
        ClassPath classPath = null;
        switch (fileType) {
            case SOURCE: 
            case CLASS: 
            case CLASS_IN_JAR: {
                classPath = this.cache.get((Object)ClassPathCache.SOURCE_RUNTIME);
                if (classPath != null) break;
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.properties.sourceRunTimeClassPath));
                this.cache.put(ClassPathCache.SOURCE_RUNTIME, classPath);
                break;
            }
            case TEST_SOURCE: 
            case TEST_CLASS: {
                classPath = this.cache.get((Object)ClassPathCache.TEST_SOURCE_RUNTIME);
                if (classPath != null) break;
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.properties.testSourceRunTimeClassPath));
                this.cache.put(ClassPathCache.TEST_SOURCE_RUNTIME, classPath);
                break;
            }
        }
        return classPath;
    }

    private synchronized ClassPath getSourcePath(FileType fileType) {
        ClassPath classPath = null;
        switch (fileType) {
            case SOURCE: 
            case CLASS: {
                classPath = this.cache.get((Object)ClassPathCache.SOURCE);
                if (classPath != null) break;
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper, this.evaluator));
                this.cache.put(ClassPathCache.SOURCE, classPath);
                break;
            }
            case TEST_SOURCE: {
                classPath = this.cache.get((Object)ClassPathCache.TEST_SOURCE);
                if (classPath != null) break;
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.testSourceRoots, this.helper, this.evaluator));
                this.cache.put(ClassPathCache.TEST_SOURCE, classPath);
                break;
            }
        }
        return classPath;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath classPath = this.cache.get((Object)ClassPathCache.BOOT);
        if (classPath == null) {
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.evaluator));
            this.cache.put(ClassPathCache.BOOT, classPath);
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        FileType fileType = this.getType(fileObject);
        if (string.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(fileType);
        }
        if (string.equals("classpath/execute")) {
            return this.getRunTimeClasspath(fileType);
        }
        if (string.equals("classpath/source")) {
            return this.getSourcePath(fileType);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(string)) {
            return new ClassPath[]{this.getCompileTimeClasspath(FileType.SOURCE), this.getCompileTimeClasspath(FileType.TEST_SOURCE)};
        }
        if ("classpath/source".equals(string)) {
            return new ClassPath[]{this.getSourcePath(FileType.SOURCE), this.getSourcePath(FileType.TEST_SOURCE)};
        }
        assert (false);
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String string) {
        if ("classpath/boot".equals(string)) {
            return this.getBootClassPath();
        }
        if ("classpath/compile".equals(string)) {
            return this.getCompileTimeClasspath(FileType.SOURCE);
        }
        if ("classpath/source".equals(string)) {
            return this.getSourcePath(FileType.SOURCE);
        }
        assert (false);
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dirCache.remove(propertyChangeEvent.getPropertyName());
    }

    public synchronized void clearDirectoryCache() {
        this.dirCache.clear();
    }

    public static final class Properties {
        final String buildClassesDir;
        final String buildTestClassesDir;
        final String distJar;
        final String[] sourceCompileTimeClassPath;
        final String[] testSourceCompileTimeClassPath;
        final String[] sourceRunTimeClassPath;
        final String[] testSourceRunTimeClassPath;

        public Properties(String string, String string2, String string3, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
            Parameters.notNull((CharSequence)"buildClassesDir", (Object)string);
            Parameters.notNull((CharSequence)"buildTestClassesDir", (Object)string2);
            Parameters.notNull((CharSequence)"distJar", (Object)string3);
            Parameters.notNull((CharSequence)"sourceCompileTimeClassPath", (Object)stringArray);
            Parameters.notNull((CharSequence)"testSourceCompileTimeClassPath", (Object)stringArray2);
            Parameters.notNull((CharSequence)"sourceRunTimeClassPath", (Object)stringArray3);
            Parameters.notNull((CharSequence)"testSourceRunTimeClassPath", (Object)stringArray4);
            this.buildClassesDir = string;
            this.buildTestClassesDir = string2;
            this.distJar = string3;
            this.sourceCompileTimeClassPath = stringArray;
            this.testSourceCompileTimeClassPath = stringArray2;
            this.sourceRunTimeClassPath = stringArray3;
            this.testSourceRunTimeClassPath = stringArray4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ClassPathCache {
        SOURCE_COMPILATION,
        TEST_SOURCE_COMPILATION,
        SOURCE,
        TEST_SOURCE,
        SOURCE_RUNTIME,
        TEST_SOURCE_RUNTIME,
        BOOT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FileType {
        UNKNOWN,
        SOURCE,
        TEST_SOURCE,
        CLASS,
        TEST_CLASS,
        CLASS_IN_JAR;

    }
}

