/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.Timer;
import javax.swing.text.Caret;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.loaders.CppEditorSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileFilter;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileModel;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorComponent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorPanelUI;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class NavigatorModel
implements CsmProgressListener,
CsmModelListener {
    private static final int DEFAULT_PARSING_DELAY = 2000;
    private DataObject cdo;
    private NavigatorPanelUI ui;
    private NavigatorComponent busyListener;
    private Action[] actions;
    private AbstractNode root;
    private CsmFileModel fileModel;
    private Timer checkModifiedTimer;
    private long lastModified = -1L;
    private Timer checkCursorTimer;
    private long lastCursorPos = -1L;
    private long lastCursorPosWhenChecked = 0L;
    private final Object lock = new String("NavigatorModel lock");

    public NavigatorModel(DataObject dataObject, NavigatorPanelUI navigatorPanelUI, NavigatorComponent navigatorComponent) {
        this.cdo = dataObject;
        this.ui = navigatorPanelUI;
        this.actions = new Action[]{new ShowForwardFunctionDeclarationsAction(), new ShowMacroAction(), new ShowIncludeAction(), new ShowTypedefAction(), new ShowVariableAction(), new ShowUsingAction()};
        this.root = new AbstractNode((Children)new Children.Array()){

            public Action[] getActions(boolean bl) {
                return NavigatorModel.this.actions;
            }
        };
        this.fileModel = new CsmFileModel(new CsmFileFilter(), this.actions);
        this.update(this.getCsmFile());
        if (this.getParsingDelay() > 0) {
            this.checkModifiedTimer = new Timer(this.getParsingDelay(), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NavigatorModel.this.checkModified();
                }
            });
            this.checkModifiedTimer.start();
        }
        this.checkCursorTimer = new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NavigatorModel.this.checkCursor();
            }
        });
        this.checkCursorTimer.start();
    }

    private int getParsingDelay() {
        return 2000;
    }

    private CsmFile getCsmFile() {
        CsmFile csmFile = CsmUtilities.getCsmFile((DataObject)this.cdo, (boolean)false);
        if (csmFile != null && !csmFile.isValid()) {
            csmFile = null;
        }
        return csmFile;
    }

    void removeNotify() {
        this.stopTimers();
    }

    void addNotify() {
        this.update(this.getCsmFile());
    }

    void addBusyListener(NavigatorComponent navigatorComponent) {
        this.busyListener = navigatorComponent;
    }

    void removeBusyListener(NavigatorComponent navigatorComponent) {
        this.busyListener = null;
    }

    public Node getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(CsmFile csmFile) {
        try {
            if (this.busyListener != null) {
                this.busyListener.busyStart();
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.fileModel.setFile(csmFile)) {
                    final Children children = this.root.getChildren();
                    if (!Children.MUTEX.isReadAccess()) {
                        Children.MUTEX.writeAccess(new Runnable(){

                            public void run() {
                                children.remove(children.getNodes());
                                children.add(NavigatorModel.this.fileModel.getNodes());
                            }
                        });
                    }
                }
            }
        }
        finally {
            if (this.busyListener != null) {
                this.busyListener.busyEnd();
            }
        }
        this.ui.newContentReady();
    }

    private void checkModified() {
        this.stopTimers();
        this.updateNodesIfModified(this.getCppEditorSupport(), this.findCurrentJEditorPane());
        this.restartTimers();
    }

    private void updateNodesIfModified(CppEditorSupport cppEditorSupport, JEditorPane jEditorPane) {
        if (jEditorPane == null || cppEditorSupport.getLastModified() <= this.lastModified) {
            return;
        }
        long l = System.currentTimeMillis() - cppEditorSupport.getLastModified();
        if (l < (long)this.getParsingDelay()) {
            return;
        }
        this.lastModified = cppEditorSupport.getLastModified();
        this.lastCursorPos = -1L;
        this.lastCursorPosWhenChecked = 0L;
    }

    private void checkCursor() {
        JEditorPane jEditorPane;
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.stop();
        }
        if ((jEditorPane = this.findCurrentJEditorPane()) != null) {
            Caret caret = jEditorPane.getCaret();
            if ((long)caret.getDot() != this.lastCursorPos && (long)caret.getDot() == this.lastCursorPosWhenChecked) {
                this.lastCursorPosWhenChecked = this.lastCursorPos = (long)caret.getDot();
                this.setSelection(this.lastCursorPos);
            }
            this.lastCursorPosWhenChecked = caret.getDot();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelection(long l) {
        Object object = this.lock;
        synchronized (object) {
            Node node = this.fileModel.setSelection(l);
            if (node != null) {
                this.ui.selectNode(node);
            }
        }
    }

    private JEditorPane findCurrentJEditorPane() {
        JEditorPane jEditorPane = null;
        CppEditorSupport cppEditorSupport = this.getCppEditorSupport();
        if (cppEditorSupport != null) {
            JEditorPane[] jEditorPaneArray = cppEditorSupport.getOpenedPanes();
            if (jEditorPaneArray == null) {
                return null;
            }
            if (jEditorPaneArray.length >= 1) {
                jEditorPane = jEditorPaneArray[0];
            }
        }
        return jEditorPane;
    }

    private CppEditorSupport getCppEditorSupport() {
        if (this.cdo != null) {
            return (CppEditorSupport)this.cdo.getCookie(CppEditorSupport.class);
        }
        return null;
    }

    private void restartTimers() {
        if (this.checkModifiedTimer != null) {
            this.checkModifiedTimer.restart();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.restart();
        }
    }

    private void stopTimers() {
        if (this.checkModifiedTimer != null) {
            this.checkModifiedTimer.stop();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.stop();
        }
    }

    public void projectParsingStarted(CsmProject csmProject) {
    }

    public void projectFilesCounted(CsmProject csmProject, int n) {
    }

    public void projectParsingFinished(CsmProject csmProject) {
    }

    public void projectParsingCancelled(CsmProject csmProject) {
    }

    public void fileInvalidated(CsmFile csmFile) {
    }

    public void fileParsingStarted(CsmFile csmFile) {
    }

    public void projectLoaded(CsmProject csmProject) {
        CsmFile csmFile = this.getCsmFile();
        if (csmFile != null && csmProject.equals(csmFile.getProject()) && csmFile.isParsed()) {
            this.fileParsedOrProjectLoaded(csmFile);
        }
    }

    public void fileParsingFinished(CsmFile csmFile) {
        if (csmFile.equals(this.getCsmFile())) {
            this.fileParsedOrProjectLoaded(csmFile);
        }
    }

    private void fileParsedOrProjectLoaded(CsmFile csmFile) {
        this.stopTimers();
        this.update(csmFile);
        this.restartTimers();
    }

    public void parserIdle() {
    }

    public void projectOpened(CsmProject csmProject) {
    }

    public void projectClosed(CsmProject csmProject) {
        CsmFile csmFile = this.getCsmFile();
        if (csmFile == null || csmFile.getProject() == csmProject) {
            this.stopTimers();
            this.update(null);
            this.restartTimers();
        } else {
            this.stopTimers();
            this.update(csmFile);
            this.restartTimers();
        }
    }

    public void modelChanged(CsmChangeEvent csmChangeEvent) {
        CsmFile csmFile;
        if (csmChangeEvent.getRemovedFiles().size() > 0 && ((csmFile = this.getCsmFile()) == null || csmChangeEvent.getRemovedFiles().contains(csmFile))) {
            this.stopTimers();
            this.update(null);
            this.restartTimers();
        }
    }

    private class ShowUsingAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowUsingAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowUsingText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NavigatorModel.this.fileModel.getFilter().setShowUsing(!NavigatorModel.this.fileModel.getFilter().isShowUsing());
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowUsing());
            return this.menuItem;
        }
    }

    private class ShowVariableAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowVariableAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowVariableText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NavigatorModel.this.fileModel.getFilter().setShowVariable(!NavigatorModel.this.fileModel.getFilter().isShowVariable());
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowVariable());
            return this.menuItem;
        }
    }

    private class ShowTypedefAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowTypedefAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowTypedefText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NavigatorModel.this.fileModel.getFilter().setShowTypedef(!NavigatorModel.this.fileModel.getFilter().isShowTypedef());
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowTypedef());
            return this.menuItem;
        }
    }

    private class ShowIncludeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowIncludeAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowIncludeText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NavigatorModel.this.fileModel.getFilter().setShowInclude(!NavigatorModel.this.fileModel.getFilter().isShowInclude());
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowInclude());
            return this.menuItem;
        }
    }

    private class ShowMacroAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowMacroAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowMacroText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NavigatorModel.this.fileModel.getFilter().setShowMacro(!NavigatorModel.this.fileModel.getFilter().isShowMacro());
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowMacro());
            return this.menuItem;
        }
    }

    private class ShowForwardFunctionDeclarationsAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowForwardFunctionDeclarationsAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowForwardFunctionDeclarationsText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NavigatorModel.this.fileModel.getFilter().setShowForwardFunctionDeclarations(!NavigatorModel.this.fileModel.getFilter().isShowForwardFunctionDeclarations());
            NavigatorModel.this.update(NavigatorModel.this.getCsmFile());
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowForwardFunctionDeclarations());
            return this.menuItem;
        }
    }
}

