/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FreePlaceNodesLayouter {
    PageFlowSceneListener pfsl = new PageFlowSceneListener();
    PageFlowObjectSceneListener pfosl = new PageFlowObjectSceneListener();
    final PageFlowScene scene;
    private final Map<String, Point> positions = new HashMap<String, Point>();
    private final int SEP_X = 250;
    private final int SEP_Y = 150;
    private static final UnsupportedOperationException uoe = new UnsupportedOperationException("Not supported yet");
    private final Collection<Page> nodesAdded = new HashSet<Page>();

    public FreePlaceNodesLayouter(PageFlowScene pageFlowScene) {
        this(pageFlowScene, false);
    }

    public static final void performLayout(PageFlowScene pageFlowScene) {
        FreePlaceNodesLayouter freePlaceNodesLayouter = new FreePlaceNodesLayouter(pageFlowScene, true);
        Collection collection = pageFlowScene.getNodes();
        for (Page page : collection) {
            Widget widget = pageFlowScene.findWidget(page);
            widget.setPreferredLocation(null);
        }
        pageFlowScene.validate();
        freePlaceNodesLayouter.layoutNodesLocations(pageFlowScene, pageFlowScene.getNodes());
        pageFlowScene.validate();
    }

    public void registerListeners(PageFlowScene pageFlowScene) {
        pageFlowScene.addSceneListener(this.pfsl);
        pageFlowScene.addObjectSceneListener(this.pfosl, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_ADDED});
    }

    public void unregisterListeners(PageFlowScene pageFlowScene) {
        pageFlowScene.removeSceneListener(this.pfsl);
        pageFlowScene.removeObjectSceneListener(this.pfosl, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_ADDED});
    }

    private FreePlaceNodesLayouter(PageFlowScene pageFlowScene, boolean bl) {
        this.scene = pageFlowScene;
        if (!bl) {
            this.registerListeners(pageFlowScene);
        }
    }

    public FreePlaceNodesLayouter(PageFlowScene pageFlowScene, Rectangle rectangle) {
        this(pageFlowScene);
    }

    public void layoutNodesLocations(PageFlowScene pageFlowScene, Collection<Page> collection) {
        Collection collection2 = pageFlowScene.getNodes();
        for (Page page : collection) {
            Widget widget = pageFlowScene.findWidget(page);
            if (widget == null) {
                return;
            }
            if (widget.getPreferredLocation() != null) {
                this.positions.put(page.getDisplayName(), widget.getPreferredLocation());
                continue;
            }
            Point point = this.positions.get(page.getDisplayName());
            if (point == null) {
                point = this.getNewComponentLocation(pageFlowScene, this.positions, collection2);
            }
            this.positions.put(page.getDisplayName(), point);
            widget.setPreferredLocation(point);
        }
    }

    public void addNode(Page page) {
        this.nodesAdded.add(page);
    }

    private Point getNewComponentLocation(PageFlowScene pageFlowScene, Map map, Collection<Page> collection) {
        int n = 0;
        while (true) {
            for (int i = 0; i <= n; ++i) {
                int n2 = 150 + 250 * (n - i);
                int n3 = 150 * (1 + i);
                if (!this.isThereEmptyPlace(pageFlowScene, map, collection, n2, n3)) continue;
                return new Point(n2, n3);
            }
            ++n;
        }
    }

    private boolean isThereEmptyPlace(PageFlowScene pageFlowScene, Map map, Collection<Page> collection, int n, int n2) {
        Rectangle rectangle = new Rectangle(n, n2, 100, 150);
        if (collection != null) {
            for (Page page : collection) {
                Point point = (Point)map.get(page.getDisplayName());
                if (point == null) {
                    point = pageFlowScene.findWidget(page).getLocation();
                }
                if (point != null && rectangle.contains(point)) {
                    return false;
                }
                Rectangle rectangle2 = pageFlowScene.findWidget(page).getBounds();
                if (rectangle2 == null || !rectangle.contains(rectangle2)) continue;
                return false;
            }
        }
        return true;
    }

    private class PageFlowSceneListener
    implements Scene.SceneListener {
        private PageFlowSceneListener() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
        }

        public void sceneValidated() {
            if (!FreePlaceNodesLayouter.this.nodesAdded.isEmpty()) {
                FreePlaceNodesLayouter.this.layoutNodesLocations(FreePlaceNodesLayouter.this.scene, FreePlaceNodesLayouter.this.nodesAdded);
                FreePlaceNodesLayouter.this.nodesAdded.clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PageFlowObjectSceneListener
    implements ObjectSceneListener {
        private PageFlowObjectSceneListener() {
        }

        public void objectAdded(ObjectSceneEvent objectSceneEvent, Object object) {
            if (((PageFlowScene)objectSceneEvent.getObjectScene()).isNode(object)) {
                FreePlaceNodesLayouter.this.nodesAdded.add((Page)object);
            }
        }

        public void objectRemoved(ObjectSceneEvent objectSceneEvent, Object object) {
            throw uoe;
        }

        public void objectStateChanged(ObjectSceneEvent objectSceneEvent, Object object, ObjectState objectState, ObjectState objectState2) {
            throw uoe;
        }

        public void selectionChanged(ObjectSceneEvent objectSceneEvent, Set<Object> set, Set<Object> set2) {
            throw uoe;
        }

        public void highlightingChanged(ObjectSceneEvent objectSceneEvent, Set<Object> set, Set<Object> set2) {
            throw uoe;
        }

        public void hoverChanged(ObjectSceneEvent objectSceneEvent, Object object, Object object2) {
            throw uoe;
        }

        public void focusChanged(ObjectSceneEvent objectSceneEvent, Object object, Object object2) {
            throw uoe;
        }
    }
}

