/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.util.JRubyNonExistentFile;
import org.jruby.nb.nb.util.SafePropertyAccessor;

public class JRubyFile
extends File {
    private static final long serialVersionUID = 435364547567567L;

    public static JRubyFile create(String string, String string2) {
        return JRubyFile.createNoUnicodeConversion(string, string2);
    }

    private static JRubyFile createNoUnicodeConversion(String string, String string2) {
        if (string2 == null || string2.equals("") || Ruby.isSecurityRestricted()) {
            return JRubyNonExistentFile.NOT_EXIST;
        }
        File file = new File(string2);
        if (!file.isAbsolute() && !(file = new File(string, string2)).isAbsolute()) {
            throw new IllegalArgumentException("Neither current working directory (" + string + ") nor pathname (" + string2 + ") led to an absolute path");
        }
        return new JRubyFile(file);
    }

    public static String getFileProperty(String string) {
        String string2 = SafePropertyAccessor.getProperty(string, "/");
        return string2.replace(File.separatorChar, '/');
    }

    private JRubyFile(File file) {
        this(file.getAbsolutePath());
    }

    protected JRubyFile(String string) {
        super(string);
    }

    public String getAbsolutePath() {
        return new File(super.getPath()).getAbsolutePath().replace(File.separatorChar, '/');
    }

    public String getCanonicalPath() throws IOException {
        String string = super.getCanonicalPath().replace(File.separatorChar, '/');
        if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getPath() {
        return super.getPath().replace(File.separatorChar, '/');
    }

    public String toString() {
        return super.toString().replace(File.separatorChar, '/');
    }

    public File getAbsoluteFile() {
        return new JRubyFile(this.getAbsolutePath());
    }

    public File getCanonicalFile() throws IOException {
        return new JRubyFile(this.getCanonicalPath());
    }

    public String getParent() {
        String string = super.getParent();
        if (string != null) {
            string = string.replace(File.separatorChar, '/');
        }
        return string;
    }

    public File getParentFile() {
        String string = this.getParent();
        if (string == null) {
            return this;
        }
        return new JRubyFile(string);
    }

    public static File[] listRoots() {
        File[] fileArray = File.listRoots();
        File[] fileArray2 = new JRubyFile[fileArray.length];
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            fileArray2[i] = new JRubyFile(fileArray[i].getPath());
        }
        return fileArray2;
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        return new JRubyFile(File.createTempFile(string, string2, file));
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return new JRubyFile(File.createTempFile(string, string2));
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = super.list(filenameFilter);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].replace(File.separatorChar, '/');
        }
        return stringArray2;
    }

    public File[] listFiles() {
        File[] fileArray = super.listFiles();
        if (fileArray == null) {
            return null;
        }
        File[] fileArray2 = new JRubyFile[fileArray.length];
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            fileArray2[i] = JRubyFile.createNoUnicodeConversion(super.getAbsolutePath(), fileArray[i].getPath());
        }
        return fileArray2;
    }

    public File[] listFiles(FileFilter fileFilter) {
        File[] fileArray = super.listFiles(fileFilter);
        if (fileArray == null) {
            return null;
        }
        File[] fileArray2 = new JRubyFile[fileArray.length];
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            fileArray2[i] = JRubyFile.createNoUnicodeConversion(super.getAbsolutePath(), fileArray[i].getPath());
        }
        return fileArray2;
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        File[] fileArray = super.listFiles(filenameFilter);
        if (fileArray == null) {
            return null;
        }
        File[] fileArray2 = new JRubyFile[fileArray.length];
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            fileArray2[i] = JRubyFile.createNoUnicodeConversion(super.getAbsolutePath(), fileArray[i].getPath());
        }
        return fileArray2;
    }
}

