/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime.scope;

import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.parser.BlockStaticScope;
import org.jruby.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.runtime.DynamicScope;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.scope.OneVarDynamicScope;

public class TwoVarDynamicScope
extends OneVarDynamicScope {
    protected IRubyObject variableValueOne;

    public TwoVarDynamicScope(StaticScope staticScope, DynamicScope dynamicScope) {
        super(staticScope, dynamicScope);
    }

    public TwoVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 2) {
            throw new RuntimeException("TwoVarDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    public DynamicScope cloneScope() {
        return new TwoVarDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
    }

    public IRubyObject getValue(int n, int n2) {
        if (n2 > 0) {
            return this.parent.getValue(n, n2 - 1);
        }
        assert (n < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (n) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject getValueDepthZeroOrNil(int n, IRubyObject iRubyObject) {
        assert (n < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (n) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = iRubyObject;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = iRubyObject;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject iRubyObject) {
        if (this.variableValueOne == null) {
            this.variableValueOne = iRubyObject;
            return this.variableValueOne;
        }
        return this.variableValueOne;
    }

    public IRubyObject setValue(int n, IRubyObject iRubyObject, int n2) {
        if (n2 > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(n, iRubyObject, n2 - 1);
        }
        assert (n < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (n) {
            case 0: {
                this.variableValueZero = iRubyObject;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = iRubyObject;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject setValueDepthZero(IRubyObject iRubyObject, int n) {
        assert (n < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (n) {
            case 0: {
                this.variableValueZero = iRubyObject;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = iRubyObject;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    public IRubyObject setValueOneDepthZero(IRubyObject iRubyObject) {
        this.variableValueOne = iRubyObject;
        return this.variableValueOne;
    }

    public void setArgValues(IRubyObject[] iRubyObjectArray, int n) {
        assert (n <= 2) : "TwoVarDynamicScope only supports scopes with two variables, not " + n;
        switch (n) {
            case 2: {
                this.variableValueOne = iRubyObjectArray[1];
            }
            case 1: {
                this.variableValueZero = iRubyObjectArray[0];
            }
        }
    }

    public void setArgValues(IRubyObject iRubyObject) {
        this.variableValueZero = iRubyObject;
    }

    public void setArgValues(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.variableValueZero = iRubyObject;
        this.variableValueOne = iRubyObject2;
    }

    public void setArgValues(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        assert (false) : "TwoVarDynamicScope only supports two variables not three";
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int n = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (n <= 2) : "TwoVarDynamicScope only supports scopes with two variables";
        if (this.staticScope.getRestArg() < 0) {
            switch (n) {
                case 0: {
                    return IRubyObject.NULL_ARRAY;
                }
                case 1: {
                    return new IRubyObject[]{this.variableValueZero};
                }
                case 2: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
                }
            }
            throw new RuntimeException("more args requested than available variables");
        }
        IRubyObject iRubyObject = this.getValue(this.staticScope.getRestArg(), 0);
        assert (iRubyObject != null);
        RubyArray rubyArray = RuntimeHelpers.splatValue(iRubyObject);
        IRubyObject[] iRubyObjectArray = new IRubyObject[n + rubyArray.size()];
        System.arraycopy(rubyArray.toJavaArray(), 0, iRubyObjectArray, n, rubyArray.size());
        switch (n) {
            case 2: {
                iRubyObjectArray[1] = this.variableValueOne;
            }
            case 1: {
                iRubyObjectArray[0] = this.variableValueZero;
            }
        }
        return iRubyObjectArray;
    }

    public String toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] stringArray = this.staticScope.getVariables();
        stringBuffer.append(stringArray[0]).append("=");
        if (this.variableValueZero == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValueZero);
        }
        stringBuffer.append(",");
        if (this.variableValueOne == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.variableValueOne);
        }
        stringBuffer.append("]");
        if (this.parent != null) {
            stringBuffer.append("\n");
            this.parent.toString(stringBuffer, string + "  ");
        }
        return stringBuffer.toString();
    }
}

