/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime.marshal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jruby.nb.nb.IncludedModuleWrapper;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyBignum;
import org.jruby.nb.nb.RubyBoolean;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyFloat;
import org.jruby.nb.nb.RubyHash;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyRegexp;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.RubyStruct;
import org.jruby.nb.nb.RubySymbol;
import org.jruby.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.builtin.Variable;
import org.jruby.nb.nb.runtime.marshal.CoreObjectType;
import org.jruby.nb.nb.runtime.marshal.MarshalCache;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalStream
extends FilterOutputStream {
    private final Ruby runtime;
    private final MarshalCache cache;
    private final int depthLimit;
    private int depth = 0;
    private static final char TYPE_IVAR = 'I';
    private static final char TYPE_USRMARSHAL = 'U';
    private static final char TYPE_USERDEF = 'u';
    private static final char TYPE_UCLASS = 'C';

    public MarshalStream(Ruby ruby, OutputStream outputStream, int n) throws IOException {
        super(outputStream);
        this.runtime = ruby;
        this.depthLimit = n >= 0 ? n : Integer.MAX_VALUE;
        this.cache = new MarshalCache();
        outputStream.write(4);
        outputStream.write(8);
    }

    public void dumpObject(IRubyObject iRubyObject) throws IOException {
        ++this.depth;
        if (this.depth > this.depthLimit) {
            throw this.runtime.newArgumentError("exceed depth limit");
        }
        this.writeAndRegister(iRubyObject);
        --this.depth;
        if (this.depth == 0) {
            this.out.flush();
        }
    }

    public void registerLinkTarget(IRubyObject iRubyObject) {
        if (MarshalStream.shouldBeRegistered(iRubyObject)) {
            this.cache.register(iRubyObject);
        }
    }

    static boolean shouldBeRegistered(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return false;
        }
        if (iRubyObject instanceof RubyBoolean) {
            return false;
        }
        if (iRubyObject instanceof RubyFixnum) {
            return !MarshalStream.isMarshalFixnum((RubyFixnum)iRubyObject);
        }
        return true;
    }

    private static boolean isMarshalFixnum(RubyFixnum rubyFixnum) {
        return rubyFixnum.getLongValue() <= 0x3FFFFFFFL && rubyFixnum.getLongValue() >= -1073741824L;
    }

    private void writeAndRegister(IRubyObject iRubyObject) throws IOException {
        if (this.cache.isRegistered(iRubyObject)) {
            this.cache.writeLink(this, iRubyObject);
        } else if (this.hasNewUserDefinedMarshaling(iRubyObject)) {
            this.userNewMarshal(iRubyObject);
        } else if (this.hasUserDefinedMarshaling(iRubyObject)) {
            this.userMarshal(iRubyObject);
        } else {
            this.writeDirectly(iRubyObject);
        }
    }

    private List<Variable<IRubyObject>> getVariables(IRubyObject iRubyObject) throws IOException {
        int n;
        List<Variable<IRubyObject>> list = null;
        if (iRubyObject instanceof CoreObjectType && (n = ((CoreObjectType)((Object)iRubyObject)).getNativeTypeIndex()) != 14) {
            if (!iRubyObject.isImmediate() && iRubyObject.hasVariables() && n != 13 && n != 12) {
                list = iRubyObject.getVariableList();
                this.write(73);
            }
            RubyClass rubyClass = iRubyObject.getMetaClass();
            switch (n) {
                case 3: 
                case 4: 
                case 9: 
                case 10: {
                    rubyClass = this.dumpExtended(rubyClass);
                }
            }
            if (n != iRubyObject.getMetaClass().index && n != 15) {
                this.writeUserClass(iRubyObject, rubyClass);
            }
        }
        return list;
    }

    private void writeDirectly(IRubyObject iRubyObject) throws IOException {
        List<Variable<IRubyObject>> list = this.getVariables(iRubyObject);
        this.writeObjectData(iRubyObject);
        if (list != null) {
            this.dumpVariables(list);
        }
    }

    public static String getPathFromClass(RubyModule rubyModule) {
        RubyModule rubyModule2;
        String string = rubyModule.getName();
        if (string.charAt(0) == '#') {
            String string2 = rubyModule.isClass() ? "class" : "module";
            throw rubyModule.getRuntime().newTypeError("can't dump anonymous " + string2 + " " + string);
        }
        RubyModule rubyModule3 = rubyModule2 = rubyModule.isModule() ? rubyModule : ((RubyClass)rubyModule).getRealClass();
        if (rubyModule.getRuntime().getClassFromPath(string) != rubyModule2) {
            throw rubyModule.getRuntime().newTypeError(string + " can't be referred");
        }
        return string;
    }

    private void writeObjectData(IRubyObject iRubyObject) throws IOException {
        if (iRubyObject instanceof CoreObjectType) {
            int n = ((CoreObjectType)((Object)iRubyObject)).getNativeTypeIndex();
            switch (n) {
                case 3: {
                    this.write(91);
                    RubyArray.marshalTo((RubyArray)iRubyObject, this);
                    return;
                }
                case 7: {
                    this.write(70);
                    return;
                }
                case 1: {
                    RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
                    if (MarshalStream.isMarshalFixnum(rubyFixnum)) {
                        this.write(105);
                        this.writeInt((int)rubyFixnum.getLongValue());
                        return;
                    }
                    iRubyObject = RubyBignum.newBignum(iRubyObject.getRuntime(), rubyFixnum.getLongValue());
                }
                case 2: {
                    this.write(108);
                    RubyBignum.marshalTo((RubyBignum)iRubyObject, this);
                    return;
                }
                case 13: {
                    if (((RubyClass)iRubyObject).isSingleton()) {
                        throw this.runtime.newTypeError("singleton class can't be dumped");
                    }
                    this.write(99);
                    RubyClass.marshalTo((RubyClass)iRubyObject, this);
                    return;
                }
                case 11: {
                    this.write(102);
                    RubyFloat.marshalTo((RubyFloat)iRubyObject, this);
                    return;
                }
                case 10: {
                    RubyHash rubyHash = (RubyHash)iRubyObject;
                    if (rubyHash.getIfNone().isNil()) {
                        this.write(123);
                    } else {
                        if (rubyHash.hasDefaultProc()) {
                            throw rubyHash.getRuntime().newTypeError("can't dump hash with default proc");
                        }
                        this.write(125);
                    }
                    RubyHash.marshalTo(rubyHash, this);
                    return;
                }
                case 12: {
                    this.write(109);
                    RubyModule.marshalTo((RubyModule)iRubyObject, this);
                    return;
                }
                case 5: {
                    this.write(48);
                    return;
                }
                case 14: {
                    this.dumpDefaultObjectHeader(iRubyObject.getMetaClass());
                    iRubyObject.getMetaClass().getRealClass().marshal(iRubyObject, this);
                    return;
                }
                case 9: {
                    this.write(47);
                    RubyRegexp.marshalTo((RubyRegexp)iRubyObject, this);
                    return;
                }
                case 4: {
                    this.registerLinkTarget(iRubyObject);
                    this.write(34);
                    this.writeString(iRubyObject.convertToString().getByteList());
                    return;
                }
                case 15: {
                    RubyStruct.marshalTo((RubyStruct)iRubyObject, this);
                    return;
                }
                case 8: {
                    this.registerLinkTarget(iRubyObject);
                    this.write(58);
                    this.writeString(iRubyObject.toString());
                    return;
                }
                case 6: {
                    this.write(84);
                    return;
                }
            }
        } else {
            this.dumpDefaultObjectHeader(iRubyObject.getMetaClass());
            iRubyObject.getMetaClass().getRealClass().marshal(iRubyObject, this);
        }
    }

    private boolean hasNewUserDefinedMarshaling(IRubyObject iRubyObject) {
        return iRubyObject.respondsTo("marshal_dump");
    }

    private void userNewMarshal(IRubyObject iRubyObject) throws IOException {
        this.registerLinkTarget(iRubyObject);
        this.write(85);
        RubyClass rubyClass = iRubyObject.getMetaClass().getRealClass();
        this.dumpObject(RubySymbol.newSymbol(this.runtime, rubyClass.getName()));
        IRubyObject iRubyObject2 = iRubyObject.callMethod(this.runtime.getCurrentContext(), "marshal_dump");
        this.dumpObject(iRubyObject2);
    }

    private boolean hasUserDefinedMarshaling(IRubyObject iRubyObject) {
        return iRubyObject.respondsTo("_dump");
    }

    private void userMarshal(IRubyObject iRubyObject) throws IOException {
        this.registerLinkTarget(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject.callMethod(this.runtime.getCurrentContext(), "_dump", this.runtime.newFixnum(this.depthLimit));
        if (!(iRubyObject2 instanceof RubyString)) {
            throw this.runtime.newTypeError(iRubyObject2, this.runtime.getString());
        }
        RubyString rubyString = (RubyString)iRubyObject2;
        boolean bl = rubyString.hasVariables();
        if (bl) {
            this.write(73);
        }
        this.write(117);
        RubyClass rubyClass = iRubyObject.getMetaClass().getRealClass();
        this.dumpObject(RubySymbol.newSymbol(this.runtime, rubyClass.getName()));
        this.writeString(rubyString.getByteList());
        if (bl) {
            this.dumpVariables(rubyString.getVariableList());
        }
    }

    public void writeUserClass(IRubyObject iRubyObject, RubyClass rubyClass) throws IOException {
        this.write(67);
        if (rubyClass.getName().charAt(0) == '#') {
            throw iRubyObject.getRuntime().newTypeError("can't dump anonymous class " + rubyClass.getName());
        }
        this.dumpObject(this.runtime.newSymbol(rubyClass.getName()));
    }

    public void dumpInstanceVars(Map map) throws IOException {
        this.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "internal: deprecated dumpInstanceVars() called", "dumpInstanceVars");
        this.writeInt(map.size());
        for (String string : map.keySet()) {
            IRubyObject iRubyObject = (IRubyObject)map.get(string);
            this.writeAndRegister(this.runtime.newSymbol(string));
            this.dumpObject(iRubyObject);
        }
    }

    public void dumpVariables(List<Variable<IRubyObject>> list) throws IOException {
        this.writeInt(list.size());
        for (Variable<IRubyObject> variable : list) {
            this.writeAndRegister(this.runtime.newSymbol(variable.getName()));
            this.dumpObject(variable.getValue());
        }
    }

    private boolean hasSingletonMethods(RubyClass rubyClass) {
        for (Map.Entry<String, DynamicMethod> entry : rubyClass.getMethods().entrySet()) {
            DynamicMethod dynamicMethod = entry.getValue();
            if (dynamicMethod.getImplementationClass() != rubyClass) continue;
            return true;
        }
        return false;
    }

    private RubyClass dumpExtended(RubyClass rubyClass) throws IOException {
        if (rubyClass.isSingleton()) {
            if (this.hasSingletonMethods(rubyClass) || rubyClass.hasVariables()) {
                throw rubyClass.getRuntime().newTypeError("singleton can't be dumped");
            }
            rubyClass = rubyClass.getSuperClass();
        }
        while (rubyClass.isIncluded()) {
            this.write(101);
            this.dumpObject(RubySymbol.newSymbol(this.runtime, ((IncludedModuleWrapper)rubyClass).getNonIncludedClass().getName()));
            rubyClass = rubyClass.getSuperClass();
        }
        return rubyClass;
    }

    public void dumpDefaultObjectHeader(RubyClass rubyClass) throws IOException {
        this.dumpDefaultObjectHeader('o', rubyClass);
    }

    public void dumpDefaultObjectHeader(char c, RubyClass rubyClass) throws IOException {
        this.dumpExtended(rubyClass);
        this.write(c);
        RubySymbol rubySymbol = RubySymbol.newSymbol(this.runtime, MarshalStream.getPathFromClass(rubyClass.getRealClass()));
        this.dumpObject(rubySymbol);
    }

    public void writeString(String string) throws IOException {
        this.writeInt(string.length());
        this.out.write(RubyString.stringToBytes(string));
    }

    public void writeString(ByteList byteList) throws IOException {
        int n = byteList.length();
        this.writeInt(n);
        this.out.write(byteList.unsafeBytes(), byteList.begin(), n);
    }

    public void dumpSymbol(String string) throws IOException {
        this.write(58);
        this.writeInt(string.length());
        this.out.write(RubyString.stringToBytes(string));
    }

    public void writeInt(int n) throws IOException {
        if (n == 0) {
            this.out.write(0);
        } else if (0 < n && n < 123) {
            this.out.write(n + 5);
        } else if (-124 < n && n < 0) {
            this.out.write(n - 5 & 0xFF);
        } else {
            int n2;
            byte[] byArray = new byte[4];
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray[n2] = (byte)(n & 0xFF);
                if ((n >>= 8) == 0 || n == -1) break;
            }
            int n3 = n2 + 1;
            this.out.write(n < 0 ? -n3 : n3);
            this.out.write(byArray, 0, n2 + 1);
        }
    }
}

