/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime;

import org.jruby.nb.nb.parser.EvalStaticScope;
import org.jruby.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.scope.FourVarDynamicScope;
import org.jruby.nb.nb.runtime.scope.ManyVarsDynamicScope;
import org.jruby.nb.nb.runtime.scope.NoVarsDynamicScope;
import org.jruby.nb.nb.runtime.scope.OneVarDynamicScope;
import org.jruby.nb.nb.runtime.scope.ThreeVarDynamicScope;
import org.jruby.nb.nb.runtime.scope.TwoVarDynamicScope;

public abstract class DynamicScope {
    protected final StaticScope staticScope;
    protected final DynamicScope parent;
    protected DynamicScope evalScope;

    protected DynamicScope(StaticScope staticScope, DynamicScope dynamicScope) {
        this.staticScope = staticScope;
        this.parent = dynamicScope;
    }

    protected DynamicScope(StaticScope staticScope) {
        this(staticScope, null);
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope, DynamicScope dynamicScope) {
        switch (staticScope.getNumberOfVariables()) {
            case 0: {
                return new NoVarsDynamicScope(staticScope, dynamicScope);
            }
            case 1: {
                return new OneVarDynamicScope(staticScope, dynamicScope);
            }
            case 2: {
                return new TwoVarDynamicScope(staticScope, dynamicScope);
            }
            case 3: {
                return new ThreeVarDynamicScope(staticScope, dynamicScope);
            }
            case 4: {
                return new FourVarDynamicScope(staticScope, dynamicScope);
            }
        }
        return new ManyVarsDynamicScope(staticScope, dynamicScope);
    }

    public static DynamicScope newDummyScope(StaticScope staticScope, DynamicScope dynamicScope) {
        return new ManyVarsDynamicScope(staticScope, dynamicScope);
    }

    public DynamicScope getNthParentScope(int n) {
        DynamicScope dynamicScope = this;
        for (int n2 = 0; n2 < n && dynamicScope != null; dynamicScope = dynamicScope.getNextCapturedScope(), ++n2) {
        }
        return dynamicScope;
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope) {
        return DynamicScope.newDynamicScope(staticScope, null);
    }

    public final DynamicScope getEvalScope() {
        if (this.evalScope == null) {
            DynamicScope dynamicScope = this.getNextCapturedScope();
            this.evalScope = dynamicScope != null && dynamicScope.getEvalScope() == this ? this : new ManyVarsDynamicScope(new EvalStaticScope(this.getStaticScope()), this);
        }
        return this.evalScope;
    }

    public DynamicScope getFlipScope() {
        if (this.staticScope.getLocalScope() == this.staticScope) {
            return this;
        }
        return this.parent.getFlipScope();
    }

    public final DynamicScope getNextCapturedScope() {
        return this.parent;
    }

    public final StaticScope getStaticScope() {
        return this.staticScope;
    }

    public final String[] getAllNamesInScope() {
        return this.staticScope.getAllNamesInScope();
    }

    public String toString() {
        return this.toString(new StringBuffer(), "");
    }

    public abstract void growIfNeeded();

    public abstract String toString(StringBuffer var1, String var2);

    public abstract DynamicScope cloneScope();

    public abstract IRubyObject[] getValues();

    public abstract IRubyObject getValue(int var1, int var2);

    public abstract IRubyObject getValueOrNil(int var1, int var2, IRubyObject var3);

    public abstract IRubyObject getValueDepthZeroOrNil(int var1, IRubyObject var2);

    public abstract IRubyObject getValueZeroDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueOneDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueTwoDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueThreeDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject setValue(int var1, IRubyObject var2, int var3);

    public IRubyObject setValue(IRubyObject iRubyObject, int n, int n2) {
        return this.setValue(n, iRubyObject, n2);
    }

    public abstract IRubyObject setValueDepthZero(IRubyObject var1, int var2);

    public abstract IRubyObject setValueZeroDepthZero(IRubyObject var1);

    public abstract IRubyObject setValueOneDepthZero(IRubyObject var1);

    public abstract IRubyObject setValueTwoDepthZero(IRubyObject var1);

    public abstract IRubyObject setValueThreeDepthZero(IRubyObject var1);

    public abstract void setArgValues(IRubyObject[] var1, int var2);

    public abstract void setArgValues(IRubyObject var1);

    public abstract void setArgValues(IRubyObject var1, IRubyObject var2);

    public abstract void setArgValues(IRubyObject var1, IRubyObject var2, IRubyObject var3);

    public abstract IRubyObject[] getArgValues();
}

