/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jruby.nb.nb.nb.util.GenericMap;

public class WeakIdentityHashMap
extends GenericMap
implements Map {
    private static final float DEFAULT_RATIO = 0.75f;
    private static final Object NULL_KEY = new Object();
    private final ReferenceQueue queue = new ReferenceQueue();
    private Entry[] table;
    private int range;
    private float ratio;

    private static Object unmaskKey(Object object) {
        if (object == NULL_KEY) {
            return null;
        }
        return object;
    }

    private Object maskKey(Object object) {
        if (object == null) {
            return NULL_KEY;
        }
        return object;
    }

    private int index(int n) {
        return (n & 0x7FFFFFF) % this.range;
    }

    public WeakIdentityHashMap() {
        this.clear();
    }

    public WeakIdentityHashMap(int n) {
        this.clear(Math.max(3, Math.round((float)n / 0.75f)));
    }

    public void clear() {
        this.clear(3);
    }

    void clear(int n) {
        this.range = n;
        this.size = 0;
        this.ratio = 0.75f;
        this.table = new Entry[this.range];
    }

    private void expunge() {
        Entry entry;
        while ((entry = (Entry)this.queue.poll()) != null) {
            this.removeEntry(entry);
        }
    }

    public Object get(Object object) {
        Object object2 = this.maskKey(object);
        int n = this.keyHash(object2);
        return this.get(n, object2);
    }

    private Object get(int n, Object object) {
        int n2 = this.index(n);
        this.expunge();
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.sameKey(n, object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean containsKey(Object object) {
        Object object2 = this.maskKey(object);
        int n = this.keyHash(object2);
        return this.containsKey(n, object2);
    }

    private boolean containsKey(int n, Object object) {
        int n2 = this.index(n);
        this.expunge();
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.sameKey(n, object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object put(Object object, Object object2) {
        Object object3 = this.maskKey(object);
        int n = this.keyHash(object3);
        return this.put(n, object3, object2);
    }

    private Object put(int n, Object object, Object object2) {
        int n2 = this.index(n);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.sameKey(n, object)) {
                return entry.setValue(object2);
            }
            entry = entry.next;
        }
        this.expunge();
        if (1.0f * (float)this.size / (float)this.range > this.ratio) {
            this.grow();
            n2 = this.index(n);
        }
        this.table[n2] = new Entry(n, object, object2, this.table[n2], this.queue);
        ++this.size;
        return null;
    }

    public Object remove(Object object) {
        object = this.maskKey(object);
        int n = this.keyHash(object);
        return this.remove(n, object);
    }

    public Object remove(int n, Object object) {
        object = this.maskKey(object);
        int n2 = this.index(n);
        Entry entry = this.table[n2];
        if (entry != null) {
            if (entry.sameKey(n, object)) {
                this.table[n2] = entry.next;
                --this.size;
                return entry.getValue();
            }
            Entry entry2 = entry.next;
            while (entry2 != null) {
                if (entry2.sameKey(n, object)) {
                    entry.next = entry2.next;
                    --this.size;
                    return entry2.getValue();
                }
                entry = entry2;
                entry2 = entry2.next;
            }
        }
        return null;
    }

    private void removeEntry(Entry entry) {
        int n = this.index(entry.key_hash);
        Entry entry2 = this.table[n];
        if (entry2 != null) {
            if (entry2 == entry) {
                this.table[n] = entry2.next;
                --this.size;
                return;
            }
            Entry entry3 = entry2.next;
            while (entry3 != null) {
                if (entry3 == entry) {
                    entry2.next = entry3.next;
                    --this.size;
                    return;
                }
                entry2 = entry3;
                entry3 = entry3.next;
            }
        }
        this.valueRemoved(entry.value);
    }

    protected void valueRemoved(Object object) {
    }

    private void grow() {
        int n = this.range;
        Entry[] entryArray = this.table;
        this.range = n * 2 + 1;
        this.table = new Entry[this.range];
        for (int i = 0; i < n; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry.next;
                int n2 = this.index(entry.key_hash);
                entry.next = this.table[n2];
                this.table[n2] = entry;
                entry = entry2;
            }
        }
    }

    protected Iterator entryIterator() {
        return new EntryIterator();
    }

    protected final int keyHash(Object object) {
        return System.identityHashCode(object);
    }

    protected final boolean keyEquals(Object object, Object object2) {
        return object == object2;
    }

    public int size() {
        this.expunge();
        return super.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    final class EntryIterator
    implements Iterator {
        private int idx = 0;
        private Entry entry;

        EntryIterator() {
            WeakIdentityHashMap.this.expunge();
            this.entry = WeakIdentityHashMap.this.table[0];
            this.locateNext();
        }

        private void locateNext() {
            while (this.entry == null) {
                ++this.idx;
                if (this.idx == WeakIdentityHashMap.this.range) {
                    return;
                }
                this.entry = WeakIdentityHashMap.this.table[this.idx];
            }
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        public Object next() {
            Entry entry = this.entry;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this.entry = this.entry.next;
            this.locateNext();
            return entry;
        }

        public void remove() {
            Entry entry = this.entry;
            WeakIdentityHashMap.this.expunge();
            this.entry = this.entry.next;
            this.locateNext();
            WeakIdentityHashMap.this.removeEntry(entry);
        }
    }

    class Entry
    extends WeakReference
    implements Map.Entry {
        private final int key_hash;
        private Entry next;
        private Object value;

        public int hashCode() {
            return this.key_hash ^ WeakIdentityHashMap.this.valueHash(this.getValue());
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.getKey() == entry.getKey() && WeakIdentityHashMap.this.valueEquals(this.getValue(), entry.getValue());
            }
            return false;
        }

        Entry(int n, Object object, Object object2, Entry entry, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.key_hash = n;
            this.value = object2;
            this.next = entry;
        }

        Object getMaskedKey() {
            return super.get();
        }

        public Object getKey() {
            return WeakIdentityHashMap.unmaskKey(this.getMaskedKey());
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        boolean sameKey(int n, Object object) {
            return this.getMaskedKey() == object;
        }
    }
}

