/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.util;

import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBignum;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyFloat;
import org.jruby.nb.nb.nb.RubyInteger;
import org.jruby.nb.nb.nb.RubyKernel;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.Convert;
import org.jruby.nb.nb.nb.util.TypeConverter;
import org.jruby.util.ByteList;

public class Sprintf {
    private static final int FLAG_NONE = 0;
    private static final int FLAG_SPACE = 1;
    private static final int FLAG_ZERO = 2;
    private static final int FLAG_PLUS = 4;
    private static final int FLAG_MINUS = 8;
    private static final int FLAG_SHARP = 16;
    private static final int FLAG_WIDTH = 32;
    private static final int FLAG_PRECISION = 64;
    private static final byte[] PREFIX_OCTAL = new byte[]{48};
    private static final byte[] PREFIX_HEX_LC = new byte[]{48, 120};
    private static final byte[] PREFIX_HEX_UC = new byte[]{48, 88};
    private static final byte[] PREFIX_BINARY_LC = new byte[]{48, 98};
    private static final byte[] PREFIX_BINARY_UC = new byte[]{48, 66};
    private static final byte[] PREFIX_NEGATIVE = new byte[]{46, 46};
    private static final byte[] NAN_VALUE = new byte[]{78, 97, 78};
    private static final byte[] INFINITY_VALUE = new byte[]{73, 110, 102};
    private static final BigInteger BIG_32 = BigInteger.valueOf(0x100000000L);
    private static final BigInteger BIG_64 = BIG_32.shiftLeft(32);
    private static final BigInteger BIG_MINUS_32 = BigInteger.valueOf(-4294967296L);
    private static final BigInteger BIG_MINUS_64 = BIG_MINUS_32.shiftLeft(32);
    private static final int INITIAL_BUFFER_SIZE = 32;
    private static final String ERR_MALFORMED_FORMAT = "malformed format string";
    private static final String ERR_MALFORMED_NUM = "malformed format string - %[0-9]";
    private static final String ERR_MALFORMED_DOT_NUM = "malformed format string - %.[0-9]";
    private static final String ERR_MALFORMED_STAR_NUM = "malformed format string - %*[0-9]";
    private static final String ERR_ILLEGAL_FORMAT_CHAR = "illegal format character - %";

    private Sprintf() {
    }

    public static CharSequence sprintf(Locale locale, CharSequence charSequence, IRubyObject iRubyObject) {
        return Sprintf.rubySprintf(charSequence, new Args(locale, iRubyObject));
    }

    public static RubyString sprintf(Ruby ruby, Locale locale, CharSequence charSequence, IRubyObject iRubyObject) {
        Buffer buffer = Sprintf.rubySprintfToBuffer(charSequence, new Args(locale, iRubyObject));
        RubyString rubyString = ruby.newString(buffer.toByteList());
        if (buffer.tainted) {
            rubyString.setTaint(true);
        }
        return rubyString;
    }

    public static CharSequence sprintf(CharSequence charSequence, IRubyObject iRubyObject) {
        return Sprintf.rubySprintf(charSequence, new Args(iRubyObject));
    }

    public static CharSequence sprintf(Ruby ruby, CharSequence charSequence, int n) {
        return Sprintf.rubySprintf(charSequence, new Args(ruby, n));
    }

    public static CharSequence sprintf(Ruby ruby, CharSequence charSequence, long l) {
        return Sprintf.rubySprintf(charSequence, new Args(ruby, l));
    }

    public static CharSequence sprintf(Locale locale, RubyString rubyString, IRubyObject iRubyObject) {
        return Sprintf.rubySprintf((CharSequence)rubyString.getByteList(), new Args(locale, iRubyObject));
    }

    public static CharSequence sprintf(RubyString rubyString, IRubyObject iRubyObject) {
        return Sprintf.rubySprintf((CharSequence)rubyString.getByteList(), new Args(iRubyObject));
    }

    private static CharSequence rubySprintf(CharSequence charSequence, Args args) {
        return Sprintf.rubySprintfToBuffer(charSequence, args).toByteList();
    }

    /*
     * Unable to fully structure code
     */
    private static Buffer rubySprintfToBuffer(CharSequence var0, Args var1_1) {
        var3_2 = new Buffer();
        if (var0 instanceof ByteList) {
            var8_3 = (ByteList)var0;
            var2_4 = var8_3.unsafeBytes();
            var4_6 = var9_5 = var8_3.begin();
            var5_7 = var9_5 + var8_3.length();
            var6_8 = var9_5;
            var7_9 = var9_5;
        } else {
            var2_4 = Sprintf.stringToBytes(var0, false);
            var4_6 = 0;
            var5_7 = var0.length();
            var6_8 = 0;
            var7_9 = 0;
        }
        while (var4_6 < var5_7) {
            var6_8 = var4_6;
            while (var4_6 < var5_7 && var2_4[var4_6] != 37) {
                ++var4_6;
            }
            if (var4_6 > var6_8) {
                var3_2.write(var2_4, var6_8, var4_6 - var6_8);
                var6_8 = var4_6;
            }
            if (var4_6++ >= var5_7) break;
            var8_3 = null;
            var9_5 = 0;
            var10_10 = 0;
            var11_11 = 0;
            var12_12 = 0;
            var13_13 = 0;
            var14_14 = true;
            block59: while (var14_14 && var4_6 < var5_7) {
                var13_13 = var2_4[var4_6];
                switch (var13_13) {
                    default: {
                        if (var13_13 == 0 && var9_5 == 0) {
                            var3_2.write(37);
                            var3_2.write(var13_13);
                            var14_14 = false;
                            ++var4_6;
                            continue block59;
                        }
                        if (Sprintf.isPrintable(var13_13)) {
                            Sprintf.raiseArgumentError(var1_1, "malformed format string - %" + (char)var13_13);
                            continue block59;
                        }
                        Sprintf.raiseArgumentError(var1_1, "malformed format string");
                        continue block59;
                    }
                    case 32: {
                        var9_5 |= 1;
                        ++var4_6;
                        continue block59;
                    }
                    case 48: {
                        var9_5 |= 2;
                        ++var4_6;
                        continue block59;
                    }
                    case 43: {
                        var9_5 |= 4;
                        ++var4_6;
                        continue block59;
                    }
                    case 45: {
                        var9_5 |= 8;
                        ++var4_6;
                        continue block59;
                    }
                    case 35: {
                        var9_5 |= 16;
                        ++var4_6;
                        continue block59;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        var12_12 = 0;
                        while (var4_6 < var5_7 && Sprintf.isDigit(var13_13 = var2_4[var4_6])) {
                            var12_12 = Sprintf.extendWidth(var1_1, var12_12, var13_13);
                            ++var4_6;
                        }
                        Sprintf.checkOffset(var1_1, var4_6, var5_7, "malformed format string - %[0-9]");
                        if (var13_13 == 36) {
                            if (var8_3 != null) {
                                Sprintf.raiseArgumentError(var1_1, "value given twice - " + var12_12 + "$");
                            }
                            var8_3 = var1_1.getNth(var12_12);
                            ++var4_6;
                            continue block59;
                        }
                        var10_10 = var12_12;
                        var9_5 |= 32;
                        continue block59;
                    }
                    case 42: {
                        if ((var9_5 & 32) != 0) {
                            Sprintf.raiseArgumentError(var1_1, "width given twice");
                        }
                        var9_5 |= 32;
                        Sprintf.checkOffset(var1_1, ++var4_6, var5_7, "malformed format string - %*[0-9]");
                        var7_9 = var4_6;
                        var12_12 = 0;
                        while (var4_6 < var5_7 && Sprintf.isDigit(var13_13 = var2_4[var4_6])) {
                            var12_12 = Sprintf.extendWidth(var1_1, var12_12, var13_13);
                            ++var4_6;
                        }
                        Sprintf.checkOffset(var1_1, var4_6, var5_7, "malformed format string - %*[0-9]");
                        if (var13_13 == 36) {
                            var10_10 = var1_1.getNthInt(var12_12);
                            if (var10_10 < 0) {
                                var9_5 |= 8;
                                var10_10 = -var10_10;
                            }
                            ++var4_6;
                            continue block59;
                        }
                        var10_10 = var1_1.nextInt();
                        if (var10_10 < 0) {
                            var9_5 |= 8;
                            var10_10 = -var10_10;
                        }
                        var4_6 = var7_9;
                        continue block59;
                    }
                    case 46: {
                        if ((var9_5 & 64) != 0) {
                            Sprintf.raiseArgumentError(var1_1, "precision given twice");
                        }
                        var9_5 |= 64;
                        Sprintf.checkOffset(var1_1, ++var4_6, var5_7, "malformed format string - %.[0-9]");
                        var13_13 = var2_4[var4_6];
                        if (var13_13 == 42) {
                            Sprintf.checkOffset(var1_1, ++var4_6, var5_7, "malformed format string - %*[0-9]");
                            var7_9 = var4_6;
                            var12_12 = 0;
                            while (var4_6 < var5_7 && Sprintf.isDigit(var13_13 = var2_4[var4_6])) {
                                var12_12 = Sprintf.extendWidth(var1_1, var12_12, var13_13);
                                ++var4_6;
                            }
                            Sprintf.checkOffset(var1_1, var4_6, var5_7, "malformed format string - %*[0-9]");
                            if (var13_13 == 36) {
                                var11_11 = var1_1.getNthInt(var12_12);
                                if (var11_11 < 0) {
                                    var9_5 &= -65;
                                }
                                ++var4_6;
                                continue block59;
                            }
                            var11_11 = var1_1.nextInt();
                            if (var11_11 < 0) {
                                var9_5 &= -65;
                            }
                            var4_6 = var7_9;
                            continue block59;
                        }
                        var12_12 = 0;
                        while (var4_6 < var5_7 && Sprintf.isDigit(var13_13 = var2_4[var4_6])) {
                            var12_12 = Sprintf.extendWidth(var1_1, var12_12, var13_13);
                            ++var4_6;
                        }
                        Sprintf.checkOffset(var1_1, var4_6, var5_7, "malformed format string - %.[0-9]");
                        var11_11 = var12_12;
                        continue block59;
                    }
                    case 10: {
                        --var4_6;
                    }
                    case 37: {
                        if (var9_5 != 0) {
                            Sprintf.raiseArgumentError(var1_1, "illegal format character - %");
                        }
                        var3_2.write(37);
                        ++var4_6;
                        var14_14 = false;
                        continue block59;
                    }
                    case 99: {
                        if (var8_3 == null) {
                            var8_3 = var1_1.next();
                        }
                        var15_15 = 0;
                        if (var8_3 instanceof RubyString) {
                            var16_19 = ((RubyString)var8_3).getByteList();
                            if (var16_19.length() == 1) {
                                var15_15 = var16_19.unsafeBytes()[var16_19.begin()];
                            } else {
                                Sprintf.raiseArgumentError(var1_1, "%c requires a character");
                            }
                        } else {
                            var15_15 = var1_1.intValue((IRubyObject)var8_3);
                        }
                        if ((var9_5 & 32) != 0 && var10_10 > 1) {
                            if ((var9_5 & 8) != 0) {
                                var3_2.write(var15_15);
                                var3_2.fill(32, var10_10 - 1);
                            } else {
                                var3_2.fill(32, var10_10 - 1);
                                var3_2.write(var15_15);
                            }
                        } else {
                            var3_2.write(var15_15);
                        }
                        ++var4_6;
                        var14_14 = false;
                        continue block59;
                    }
                    case 112: 
                    case 115: {
                        if (var8_3 == null) {
                            var8_3 = var1_1.next();
                        }
                        if (var13_13 == 112) {
                            var8_3 = var8_3.callMethod(var8_3.getRuntime().getCurrentContext(), "inspect");
                        }
                        var15_16 = var8_3.asString().getByteList();
                        var16_20 = var15_16.length();
                        if (var8_3.isTaint()) {
                            Buffer.access$002(var3_2, true);
                        }
                        if ((var9_5 & 64) != 0 && var11_11 < var16_20) {
                            var16_20 = var11_11;
                        }
                        if ((var9_5 & 32) != 0 && var10_10 > var16_20) {
                            var10_10 -= var16_20;
                            if ((var9_5 & 8) != 0) {
                                var3_2.write(var15_16.unsafeBytes(), var15_16.begin(), var16_20);
                                var3_2.fill(32, var10_10);
                            } else {
                                var3_2.fill(32, var10_10);
                                var3_2.write(var15_16.unsafeBytes(), var15_16.begin(), var16_20);
                            }
                        } else {
                            var3_2.write(var15_16.unsafeBytes(), var15_16.begin(), var16_20);
                        }
                        ++var4_6;
                        var14_14 = false;
                        continue block59;
                    }
                    case 66: 
                    case 88: 
                    case 98: 
                    case 100: 
                    case 105: 
                    case 111: 
                    case 117: 
                    case 120: {
                        if (var8_3 == null) {
                            var8_3 = var1_1.next();
                        }
                        if ((var15_17 = var8_3.getMetaClass().index) != 1 && var15_17 != 2) {
                            switch (var15_17) {
                                case 11: {
                                    var8_3 = RubyNumeric.dbl2num(var8_3.getRuntime(), ((RubyFloat)var8_3).getValue());
                                    break;
                                }
                                case 4: {
                                    var8_3 = RubyNumeric.str2inum(var8_3.getRuntime(), (RubyString)var8_3, 0, true);
                                    break;
                                }
                                default: {
                                    var8_3 = var8_3.respondsTo("to_int") != false ? TypeConverter.convertToType((IRubyObject)var8_3, var8_3.getRuntime().getInteger(), MethodIndex.TO_INT, "to_int", true) : TypeConverter.convertToType((IRubyObject)var8_3, var8_3.getRuntime().getInteger(), MethodIndex.TO_I, "to_i", true);
                                }
                            }
                            var15_17 = var8_3.getMetaClass().index;
                        }
                        var16_19 = null;
                        var17_21 = 0;
                        var18_22 = null;
                        var21_28 = 0;
                        var22_29 = 0;
                        if (var13_13 == 105) {
                            var13_13 = 100;
                        }
                        if (var13_13 == 117 && (var9_5 & 5) != 0) {
                            var13_13 = 100;
                        }
                        var19_24 = var13_13 == 100 || (var9_5 & 5) != 0;
                        switch (var13_13) {
                            case 111: {
                                var23_30 = 8;
                                break;
                            }
                            case 88: 
                            case 120: {
                                var23_30 = 16;
                                break;
                            }
                            case 66: 
                            case 98: {
                                var23_30 = 2;
                                break;
                            }
                            default: {
                                var23_30 = 10;
                            }
                        }
                        if ((var9_5 & 16) != 0) {
                            switch (var13_13) {
                                case 111: {
                                    var18_22 = Sprintf.PREFIX_OCTAL;
                                    break;
                                }
                                case 120: {
                                    var18_22 = Sprintf.PREFIX_HEX_LC;
                                    break;
                                }
                                case 88: {
                                    var18_22 = Sprintf.PREFIX_HEX_UC;
                                    break;
                                }
                                case 98: {
                                    var18_22 = Sprintf.PREFIX_BINARY_LC;
                                    break;
                                }
                                case 66: {
                                    var18_22 = Sprintf.PREFIX_BINARY_UC;
                                }
                            }
                            if (var18_22 != null) {
                                var10_10 -= var18_22.length;
                            }
                        }
                        if (var15_17 == 1) {
                            v0 = var20_25 = ((RubyFixnum)var8_3).getLongValue() < 0L;
                            var16_19 = var20_25 && var13_13 == 117 ? (Object)Sprintf.getUnsignedNegativeBytes((RubyFixnum)var8_3) : (Object)Sprintf.getFixnumBytes((RubyFixnum)var8_3, var23_30, var19_24, var13_13 == 88);
                        } else {
                            v1 = var20_25 = ((RubyBignum)var8_3).getValue().signum() < 0;
                            var16_19 = var20_25 != false && var13_13 == 117 ? (Object)Sprintf.getUnsignedNegativeBytes((RubyBignum)var8_3) : (Object)Sprintf.getBignumBytes((RubyBignum)var8_3, var23_30, var19_24, var13_13 == 88);
                        }
                        var24_31 = 0;
                        if (var19_24) {
                            if (var20_25) {
                                var21_28 = 45;
                                --var10_10;
                                var17_21 = 1;
                            } else if ((var9_5 & 4) != 0) {
                                var21_28 = 43;
                                --var10_10;
                            } else if ((var9_5 & 1) != 0) {
                                var21_28 = 32;
                                --var10_10;
                            }
                        } else if (var20_25) {
                            if (var23_30 == 10) {
                                Sprintf.warning(IRubyWarnings.ID.NEGATIVE_NUMBER_FOR_U, var1_1, "negative number for %u specifier");
                                var22_29 = 46;
                                var24_31 += 2;
                            } else {
                                if ((var9_5 & 66) == 0) {
                                    var24_31 += 2;
                                }
                                var17_21 = Sprintf.skipSignBits((byte[])var16_19, var23_30);
                                switch (var13_13) {
                                    case 66: 
                                    case 98: {
                                        var22_29 = 49;
                                        break;
                                    }
                                    case 111: {
                                        var22_29 = 55;
                                        break;
                                    }
                                    case 120: {
                                        var22_29 = 102;
                                        break;
                                    }
                                    case 88: {
                                        var22_29 = 70;
                                    }
                                }
                                if (var22_29 != 0) {
                                    ++var24_31;
                                }
                            }
                        }
                        var25_32 = ((ByteList)var16_19).length - var17_21;
                        var24_31 += var25_32;
                        if ((var9_5 & 66) == 2) {
                            var11_11 = var10_10;
                            var10_10 = 0;
                        } else {
                            if (var11_11 < var24_31) {
                                var11_11 = var24_31;
                            }
                            var10_10 -= var11_11;
                        }
                        if ((var9_5 & 8) == 0) {
                            var3_2.fill(32, var10_10);
                            var10_10 = 0;
                        }
                        if (var21_28 != 0) {
                            var3_2.write(var21_28);
                        }
                        if (var18_22 != null) {
                            var3_2.write(var18_22);
                        }
                        if (var24_31 < var11_11) {
                            if (var22_29 == 0) {
                                var3_2.fill(48, var11_11 - var24_31);
                            } else if (var22_29 == 46) {
                                var3_2.fill(var22_29, var11_11 - var24_31);
                                var3_2.write(Sprintf.PREFIX_NEGATIVE);
                            } else {
                                var3_2.fill(var22_29, var11_11 - var24_31 + 1);
                            }
                        } else if (var22_29 != 0) {
                            if ((var9_5 & 66) == 0) {
                                var3_2.write(Sprintf.PREFIX_NEGATIVE);
                            }
                            if (var22_29 != 46) {
                                var3_2.write(var22_29);
                            }
                        }
                        var3_2.write((byte[])var16_19, var17_21, var25_32);
                        if (var10_10 > 0) {
                            var3_2.fill(32, var10_10);
                        }
                        ++var4_6;
                        var14_14 = false;
                        continue block59;
                    }
                    case 69: 
                    case 71: 
                    case 101: 
                    case 102: 
                    case 103: 
                }
                if (var8_3 == null) {
                    var8_3 = var1_1.next();
                }
                if (!(var8_3 instanceof RubyFloat)) {
                    var8_3 = RubyKernel.new_float((IRubyObject)var8_3, (IRubyObject)var8_3);
                }
                var17_21 = (var15_18 = ((RubyFloat)var8_3).getDoubleValue()) != var15_18 ? 1 : 0;
                var18_23 = var15_18 == Infinity || var15_18 == -Infinity;
                var19_24 = var15_18 < 0.0;
                var21_28 = 0;
                var22_29 = 0;
                var23_30 = 0;
                if (var17_21 != 0 || var18_23) {
                    if (var17_21 != 0) {
                        var20_26 = Sprintf.NAN_VALUE;
                        var23_30 = Sprintf.NAN_VALUE.length;
                    } else {
                        var20_26 = Sprintf.INFINITY_VALUE;
                        var23_30 = Sprintf.INFINITY_VALUE.length;
                    }
                    if (var19_24) {
                        var24_31 = 45;
                        --var10_10;
                    } else if ((var9_5 & 4) != 0) {
                        var24_31 = 43;
                        --var10_10;
                    } else if ((var9_5 & 1) != 0) {
                        var24_31 = 32;
                        --var10_10;
                    } else {
                        var24_31 = 0;
                    }
                    if ((var10_10 -= var23_30) > 0 && (var9_5 & 10) == 0) {
                        var3_2.fill(32, var10_10);
                        var10_10 = 0;
                    }
                    if (var24_31 != 0) {
                        var3_2.write(var24_31);
                    }
                    if (var10_10 > 0 && (var9_5 & 8) == 0) {
                        var3_2.fill(48, var10_10);
                        var10_10 = 0;
                    }
                    var3_2.write(var20_26);
                    if (var10_10 > 0) {
                        var3_2.fill(32, var10_10);
                    }
                    ++var4_6;
                    var14_14 = false;
                    continue;
                }
                var25_33 = Double.toString(var15_18);
                var26_34 = var25_33.length();
                var20_27 = new byte[var26_34];
                var27_35 = 0;
                var28_36 = var19_24 != false ? 1 : 0;
                var29_37 = 0;
                block64: while (var28_36 < var26_34) {
                    var30_38 = (byte)var25_33.charAt(var28_36++);
                    switch (var30_38) {
                        case 48: {
                            if (var21_28 <= 0) ** GOTO lbl402
                            ++var27_35;
                            ** GOTO lbl402
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (var27_35 > 0) {
                                while (var27_35 > 0) {
                                    var20_27[var21_28++] = 48;
                                    --var27_35;
                                }
                            }
                            var20_27[var21_28++] = var30_38;
                            ** GOTO lbl402
                        }
                        case 46: {
                            break block64;
                        }
lbl402:
                        // 4 sources

                        default: {
                            continue block64;
                        }
                    }
                }
                var29_37 = var21_28 + var27_35;
                block66: while (var28_36 < var26_34) {
                    var30_38 = (byte)var25_33.charAt(var28_36++);
                    switch (var30_38) {
                        case 48: {
                            if (var21_28 > 0) {
                                ++var27_35;
                            } else {
                                --var22_29;
                            }
                            ** GOTO lbl424
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (var27_35 > 0) {
                                while (var27_35 > 0) {
                                    var20_27[var21_28++] = 48;
                                    --var27_35;
                                }
                            }
                            var20_27[var21_28++] = var30_38;
                            ** GOTO lbl424
                        }
                        case 69: {
                            break block66;
                        }
lbl424:
                        // 4 sources

                        default: {
                            continue block66;
                        }
                    }
                }
                if (var28_36 < var26_34) {
                    var32_40 = 0;
                    if (var25_33.charAt(var28_36) == '-') {
                        var31_39 = -1;
                        ++var28_36;
                    } else {
                        var31_39 = 1;
                    }
                    while (var28_36 < var26_34) {
                        var32_40 = var32_40 * 10 + (var25_33.charAt(var28_36++) - 48);
                    }
                    var22_29 += var32_40 * var31_39;
                }
                var22_29 += var29_37 - var21_28;
                if (var21_28 == 0) {
                    var20_27[0] = 48;
                    var21_28 = 1;
                    var22_29 = 0;
                }
                if (var19_24) {
                    var24_31 = 45;
                    --var10_10;
                } else if ((var9_5 & 4) != 0) {
                    var24_31 = 43;
                    --var10_10;
                } else if ((var9_5 & 1) != 0) {
                    var24_31 = 32;
                    --var10_10;
                } else {
                    var24_31 = 0;
                }
                if ((var9_5 & 64) == 0) {
                    var11_11 = 6;
                }
                switch (var13_13) {
                    case 69: 
                    case 71: {
                        var37_45 = 69;
                        break;
                    }
                    case 101: 
                    case 103: {
                        var37_45 = 101;
                        break;
                    }
                    default: {
                        var37_45 = 0;
                    }
                }
                switch (var13_13) {
                    case 71: 
                    case 103: {
                        v2 = var22_29 + var21_28 - 1 < -4 || var22_29 + var21_28 > (var11_11 == 0 ? 1 : var11_11) ? true : (var38_46 = false);
                        if (var38_46) {
                            var34_42 = var21_28 - 1;
                            if ((var11_11 = Math.max(0, var11_11 - 1)) < var34_42) {
                                var39_47 = Sprintf.round(var20_27, var21_28, var11_11, var11_11 != 0);
                                if (var39_47 > var21_28) {
                                    var21_28 = var39_47;
                                }
                                var34_42 = Math.min(var21_28 - 1, var11_11);
                            }
                            var39_47 = (var9_5 & 16) != 0 ? 1 : 0;
                            ++var23_30;
                            var23_30 = (var22_29 += var21_28 - 1) > 99 ? (var23_30 += 5) : (var23_30 += 4);
                            if (var39_47 != 0) {
                                ++var23_30;
                            }
                            if (var11_11 > 0) {
                                if (var39_47 == 0) {
                                    for (var40_48 = var34_42; var40_48 >= 1 && var20_27[var40_48] == 48; --var40_48) {
                                        --var34_42;
                                    }
                                    if (var34_42 > 0) {
                                        ++var23_30;
                                        var23_30 += var34_42;
                                    }
                                } else {
                                    var23_30 += var11_11;
                                }
                            }
                            if ((var10_10 -= var23_30) > 0 && (var9_5 & 10) == 0) {
                                var3_2.fill(32, var10_10);
                                var10_10 = 0;
                            }
                            if (var24_31 != 0) {
                                var3_2.write(var24_31);
                            }
                            if (var10_10 > 0 && (var9_5 & 8) == 0) {
                                var3_2.fill(48, var10_10);
                                var10_10 = 0;
                            }
                            var3_2.write(var20_27[0]);
                            v3 = var40_48 = var39_47 != 0 || var11_11 > 0 && var34_42 > 0 ? 1 : 0;
                            if (var40_48 != 0) {
                                var3_2.write(var1_1.getDecimalSeparator());
                            }
                            if (var11_11 > 0 && var34_42 > 0) {
                                var3_2.write(var20_27, 1, var34_42);
                                var11_11 -= var34_42;
                            }
                            if (var11_11 > 0 && var39_47 != 0) {
                                var3_2.fill(48, var11_11);
                            }
                            Sprintf.writeExp(var3_2, var22_29, var37_45);
                            if (var10_10 <= 0) break;
                            var3_2.fill(32, var10_10);
                            break;
                        }
                        var31_39 = Math.max(0, Math.min(var21_28 + var22_29, var21_28));
                        var32_40 = Math.max(0, var22_29);
                        var33_41 = var31_39 + var32_40;
                        var34_42 = var21_28 - var31_39;
                        var35_43 = Math.max(0, -(var34_42 + var22_29));
                        var36_44 = var35_43 + var34_42;
                        if ((var11_11 = Math.max(0, var11_11 - var33_41)) < var34_42) {
                            var39_47 = Sprintf.round(var20_27, var21_28, var31_39 + var11_11 - 1, var11_11 != 0);
                            if (var39_47 > var21_28) {
                                var21_28 = var39_47;
                                var31_39 = Math.max(0, Math.min(var21_28 + var22_29, var21_28));
                                var33_41 = var31_39 + var32_40;
                                var34_42 = var21_28 - var31_39;
                                var35_43 = Math.max(0, -(var34_42 + var22_29));
                                var11_11 = Math.max(0, var11_11 - 1);
                            }
                            var34_42 = var11_11;
                            var36_44 = var35_43 + var34_42;
                        }
                        var23_30 += var33_41;
                        if (var36_44 > 0) {
                            var23_30 += var36_44 + 1;
                        } else if ((var9_5 & 16) != 0) {
                            ++var23_30;
                            if (var11_11 > 0) {
                                var23_30 += var11_11;
                            }
                        }
                        if ((var10_10 -= var23_30) > 0 && (var9_5 & 10) == 0) {
                            var3_2.fill(32, var10_10);
                            var10_10 = 0;
                        }
                        if (var24_31 != 0) {
                            var3_2.write(var24_31);
                        }
                        if (var10_10 > 0 && (var9_5 & 8) == 0) {
                            var3_2.fill(48, var10_10);
                            var10_10 = 0;
                        }
                        if (var33_41 > 0) {
                            if (var31_39 > 0) {
                                var3_2.write(var20_27, 0, var31_39);
                            }
                            if (var32_40 > 0) {
                                var3_2.fill(48, var32_40);
                            }
                        } else {
                            var3_2.write(48);
                        }
                        if (var36_44 > 0 || (var9_5 & 16) != 0) {
                            var3_2.write(var1_1.getDecimalSeparator());
                        }
                        if (var36_44 > 0) {
                            if (var35_43 > 0) {
                                var3_2.fill(48, var35_43);
                                var11_11 -= var35_43;
                            }
                            if (var34_42 > 0) {
                                var3_2.write(var20_27, var31_39, var34_42);
                                var11_11 -= var34_42;
                            }
                            if ((var9_5 & 16) != 0 && var11_11 > 0) {
                                var3_2.fill(48, var11_11);
                            }
                        }
                        if ((var9_5 & 16) != 0 && var11_11 > 0) {
                            var3_2.fill(48, var11_11);
                        }
                        if (var10_10 <= 0) break;
                        var3_2.fill(32, var10_10);
                        break;
                    }
                    case 102: {
                        var31_39 = Math.max(0, Math.min(var21_28 + var22_29, var21_28));
                        var32_40 = Math.max(0, var22_29);
                        var33_41 = var31_39 + var32_40;
                        var34_42 = var21_28 - var31_39;
                        var35_43 = Math.max(0, -(var34_42 + var22_29));
                        var36_44 = var35_43 + var34_42;
                        if (var11_11 < var36_44) {
                            if (var11_11 < var35_43) {
                                var34_42 = 0;
                                var35_43 = var11_11;
                            } else {
                                var39_47 = Sprintf.round(var20_27, var21_28, var31_39 + var11_11 - var35_43 - 1, var11_11 != 0);
                                if (var39_47 > var21_28) {
                                    var21_28 = var39_47;
                                    var31_39 = Math.max(0, Math.min(var21_28 + var22_29, var21_28));
                                    var33_41 = var31_39 + var32_40;
                                    var34_42 = var21_28 - var31_39;
                                    var35_43 = Math.max(0, -(var34_42 + var22_29));
                                    var36_44 = var35_43 + var34_42;
                                }
                                var34_42 = var11_11 - var35_43;
                            }
                            var36_44 = var35_43 + var34_42;
                        }
                        if (var11_11 > 0) {
                            var23_30 += Math.max(1, var33_41) + 1 + var11_11;
                        } else {
                            var23_30 += Math.max(1, var33_41);
                            if ((var9_5 & 16) != 0) {
                                ++var23_30;
                            }
                        }
                        if ((var10_10 -= var23_30) > 0 && (var9_5 & 10) == 0) {
                            var3_2.fill(32, var10_10);
                            var10_10 = 0;
                        }
                        if (var24_31 != 0) {
                            var3_2.write(var24_31);
                        }
                        if (var10_10 > 0 && (var9_5 & 8) == 0) {
                            var3_2.fill(48, var10_10);
                            var10_10 = 0;
                        }
                        if (var33_41 > 0) {
                            if (var31_39 > 0) {
                                var3_2.write(var20_27, 0, var31_39);
                            }
                            if (var32_40 > 0) {
                                var3_2.fill(48, var32_40);
                            }
                        } else {
                            var3_2.write(48);
                        }
                        if (var11_11 > 0 || (var9_5 & 16) != 0) {
                            var3_2.write(var1_1.getDecimalSeparator());
                        }
                        if (var11_11 > 0) {
                            if (var35_43 > 0) {
                                var3_2.fill(48, var35_43);
                                var11_11 -= var35_43;
                            }
                            if (var34_42 > 0) {
                                var3_2.write(var20_27, var31_39, var34_42);
                                var11_11 -= var34_42;
                            }
                            if (var11_11 > 0) {
                                var3_2.fill(48, var11_11);
                            }
                        }
                        if (var10_10 <= 0) break;
                        var3_2.fill(32, var10_10);
                        break;
                    }
                    case 69: 
                    case 101: {
                        var34_42 = var21_28 - 1;
                        if (var11_11 < var34_42) {
                            var39_47 = Sprintf.round(var20_27, var21_28, var11_11, var11_11 != 0);
                            if (var39_47 > var21_28) {
                                var21_28 = var39_47;
                            }
                            var34_42 = Math.min(var21_28 - 1, var11_11);
                        }
                        var39_47 = (var9_5 & 16) != 0 ? 1 : 0;
                        ++var23_30;
                        var23_30 = (var22_29 += var21_28 - 1) > 99 ? (var23_30 += 5) : (var23_30 += 4);
                        if (var11_11 > 0) {
                            var23_30 += 1 + var11_11;
                        } else if (var39_47 != 0) {
                            ++var23_30;
                        }
                        if ((var10_10 -= var23_30) > 0 && (var9_5 & 10) == 0) {
                            var3_2.fill(32, var10_10);
                            var10_10 = 0;
                        }
                        if (var24_31 != 0) {
                            var3_2.write(var24_31);
                        }
                        if (var10_10 > 0 && (var9_5 & 8) == 0) {
                            var3_2.fill(48, var10_10);
                            var10_10 = 0;
                        }
                        var3_2.write(var20_27[0]);
                        if (var11_11 > 0) {
                            var3_2.write(var1_1.getDecimalSeparator());
                            if (var34_42 > 0) {
                                var3_2.write(var20_27, 1, var34_42);
                                var11_11 -= var34_42;
                            }
                            if (var11_11 > 0) {
                                var3_2.fill(48, var11_11);
                            }
                        } else if ((var9_5 & 16) != 0) {
                            var3_2.write(var1_1.getDecimalSeparator());
                        }
                        Sprintf.writeExp(var3_2, var22_29, var37_45);
                        if (var10_10 <= 0) break;
                        var3_2.fill(32, var10_10);
                    }
                }
                ++var4_6;
                var14_14 = false;
            }
            if (!var14_14) continue;
            if (var9_5 == 0) {
                var3_2.write(37);
                continue;
            }
            Sprintf.raiseArgumentError(var1_1, "illegal format character - %");
        }
        if (Args.access$100(var1_1) == 0 && Args.access$200(var1_1) < Args.access$300(var1_1)) {
            if (Args.access$400(var1_1).getDebug().isTrue()) {
                var1_1.raiseArgumentError("too many arguments for format string");
            } else if (Args.access$400(var1_1).getVerbose().isTrue()) {
                var1_1.warn(IRubyWarnings.ID.TOO_MANY_ARGUMENTS, "too many arguments for format string");
            }
        }
        return var3_2;
    }

    private static void writeExp(Buffer buffer, int n, byte by) {
        buffer.write(by);
        buffer.write(n >= 0 ? 43 : 45);
        if (n < 0) {
            n = -n;
        }
        if (n > 99) {
            buffer.write(n / 100 + 48);
            buffer.write(n % 100 / 10 + 48);
        } else {
            buffer.write(n / 10 + 48);
        }
        buffer.write(n % 10 + 48);
    }

    private static final void raiseArgumentError(Args args, String string) {
        args.raiseArgumentError(string);
    }

    private static final void warning(IRubyWarnings.ID iD, Args args, String string) {
        args.warning(iD, string);
    }

    private static final void checkOffset(Args args, int n, int n2, String string) {
        if (n >= n2) {
            Sprintf.raiseArgumentError(args, string);
        }
    }

    private static final int extendWidth(Args args, int n, byte by) {
        int n2 = n * 10 + (by - 48);
        if (n2 / 10 != n) {
            Sprintf.raiseArgumentError(args, "width too big");
        }
        return n2;
    }

    private static final boolean isDigit(byte by) {
        return by >= 48 && by <= 57;
    }

    private static final boolean isPrintable(byte by) {
        return by > 32 && by < 127;
    }

    private static final int skipSignBits(byte[] byArray, int n) {
        int n2;
        int n3 = byArray.length;
        switch (n) {
            case 2: {
                for (n2 = 0; n2 < n3 && byArray[n2] == 49; ++n2) {
                }
                break;
            }
            case 8: {
                if (n3 > 0 && byArray[0] == 51) {
                    ++n2;
                }
                while (n2 < n3 && byArray[n2] == 55) {
                    ++n2;
                }
                break;
            }
            case 10: {
                if (n3 <= 0 || byArray[0] != 45) break;
                ++n2;
                break;
            }
            case 16: {
                byte by;
                while (n2 < n3 && ((by = byArray[n2]) == 102 || by == 70)) {
                    ++n2;
                }
                break;
            }
        }
        return n2;
    }

    private static final int round(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = n2 + 1;
        if (n3 >= n || byArray[n3] < 53 || bl && byArray[n3] == 53 && n3 == n - 1) {
            return n;
        }
        if (n2 < 0) {
            System.arraycopy(byArray, 0, byArray, 1, n);
            byArray[0] = 49;
            return n + 1;
        }
        int n4 = n2;
        byArray[n4] = (byte)(byArray[n4] + 1);
        while (byArray[n2] > 57) {
            byArray[n2] = 48;
            if (--n2 >= 0) {
                int n5 = n2;
                byArray[n5] = (byte)(byArray[n5] + 1);
                continue;
            }
            System.arraycopy(byArray, 0, byArray, 1, n);
            byArray[0] = 49;
            return n + 1;
        }
        return n;
    }

    private static final byte[] getFixnumBytes(RubyFixnum rubyFixnum, int n, boolean bl, boolean bl2) {
        long l = rubyFixnum.getLongValue();
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            if (bl) {
                return Convert.intToByteArray((int)l, n, bl2);
            }
            switch (n) {
                case 2: {
                    return Convert.intToBinaryBytes((int)l);
                }
                case 8: {
                    return Convert.intToOctalBytes((int)l);
                }
                default: {
                    return Convert.intToCharBytes((int)l);
                }
                case 16: 
            }
            return Convert.intToHexBytes((int)l, bl2);
        }
        if (bl) {
            return Convert.longToByteArray(l, n, bl2);
        }
        switch (n) {
            case 2: {
                return Convert.longToBinaryBytes(l);
            }
            case 8: {
                return Convert.longToOctalBytes(l);
            }
            default: {
                return Convert.longToCharBytes(l);
            }
            case 16: 
        }
        return Convert.longToHexBytes(l, bl2);
    }

    private static final byte[] getBignumBytes(RubyBignum rubyBignum, int n, boolean bl, boolean bl2) {
        BigInteger bigInteger = rubyBignum.getValue();
        if (bl || n == 10 || bigInteger.signum() >= 0) {
            return Sprintf.stringToBytes(bigInteger.toString(n), bl2);
        }
        byte[] byArray = bigInteger.toByteArray();
        switch (n) {
            case 2: {
                return Convert.twosComplementToBinaryBytes(byArray);
            }
            case 8: {
                return Convert.twosComplementToOctalBytes(byArray);
            }
            case 16: {
                return Convert.twosComplementToHexBytes(byArray, bl2);
            }
        }
        return Sprintf.stringToBytes(bigInteger.toString(n), bl2);
    }

    private static final byte[] getUnsignedNegativeBytes(RubyInteger rubyInteger) {
        BigInteger bigInteger;
        if (rubyInteger instanceof RubyFixnum) {
            long l = ((RubyFixnum)rubyInteger).getLongValue();
            if (l >= -4294967296L) {
                return Convert.longToCharBytes(0x100000000L + l);
            }
            bigInteger = BigInteger.valueOf(l);
        } else {
            bigInteger = ((RubyBignum)rubyInteger).getValue();
        }
        int n = 0;
        BigInteger bigInteger2 = BIG_MINUS_64;
        while (bigInteger.compareTo(bigInteger2) < 0) {
            bigInteger2 = bigInteger2.shiftLeft(32);
            ++n;
        }
        bigInteger2 = n > 0 ? BIG_64.shiftLeft(32 * n) : BIG_64;
        return Sprintf.stringToBytes(bigInteger2.add(bigInteger).toString(), false);
    }

    private static final byte[] stringToBytes(CharSequence charSequence, boolean bl) {
        int n = charSequence.length();
        byte[] byArray = new byte[n];
        if (bl) {
            int n2 = n;
            while (--n2 >= 0) {
                byte by = (byte)(charSequence.charAt(n2) & 0xFF);
                if (by >= 97 && by <= 122) {
                    byArray[n2] = (byte)(by & 0xFFFFFFDF);
                    continue;
                }
                byArray[n2] = by;
            }
        } else {
            int n3 = n;
            while (--n3 >= 0) {
                byArray[n3] = (byte)(charSequence.charAt(n3) & 0xFF);
            }
        }
        return byArray;
    }

    private static class Buffer {
        byte[] buf;
        int size;
        private boolean tainted = false;

        Buffer() {
            this.buf = new byte[32];
        }

        Buffer(int n) {
            this.buf = new byte[n];
        }

        final void write(int n) {
            int n2 = this.size + 1;
            if (n2 > this.buf.length) {
                byte[] byArray = new byte[Math.max(this.buf.length << 1, n2)];
                System.arraycopy(this.buf, 0, byArray, 0, this.size);
                this.buf = byArray;
            }
            this.buf[this.size] = (byte)(n & 0xFF);
            this.size = n2;
        }

        final void write(byte[] byArray, int n, int n2) {
            if (n2 <= 0 || n < 0) {
                return;
            }
            int n3 = this.size + n2;
            if (n3 > this.buf.length) {
                byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n3)];
                System.arraycopy(this.buf, 0, byArray2, 0, this.size);
                this.buf = byArray2;
            }
            System.arraycopy(byArray, n, this.buf, this.size, n2);
            this.size = n3;
        }

        final void write(byte[] byArray) {
            this.write(byArray, 0, byArray.length);
        }

        final void fill(int n, int n2) {
            if (n2 <= 0) {
                return;
            }
            int n3 = this.size + n2;
            if (n3 > this.buf.length) {
                byte[] byArray = new byte[Math.max(this.buf.length << 1, n3)];
                System.arraycopy(this.buf, 0, byArray, 0, this.size);
                this.buf = byArray;
            }
            byte by = (byte)(n & 0xFF);
            while (--n2 >= 0) {
                this.buf[this.size + n2] = by;
            }
            this.size = n3;
        }

        final void set(int n, int n2) {
            if (n2 < 0) {
                n2 += this.size;
            }
            if (n2 >= 0 && n2 < this.size) {
                this.buf[n2] = (byte)(n & 0xFF);
            }
        }

        final void set(int n) {
            if (this.size > 0) {
                this.buf[this.size - 1] = (byte)(n & 0xFF);
            }
        }

        final ByteList toByteList() {
            return new ByteList(this.buf, 0, this.size);
        }

        public final String toString() {
            return new String(this.buf, 0, this.size);
        }

        static /* synthetic */ boolean access$002(Buffer buffer, boolean bl) {
            buffer.tainted = bl;
            return buffer.tainted;
        }
    }

    private static class Args {
        private final Ruby runtime;
        private final Locale locale;
        private final IRubyObject rubyObject;
        private final List rubyArray;
        private final int length;
        private int unnumbered;
        private int numbered;

        Args(Locale locale, IRubyObject iRubyObject) {
            if (iRubyObject == null) {
                throw new IllegalArgumentException("null IRubyObject passed to sprintf");
            }
            this.locale = locale == null ? Locale.getDefault() : locale;
            this.rubyObject = iRubyObject;
            if (iRubyObject instanceof RubyArray) {
                this.rubyArray = ((RubyArray)iRubyObject).getList();
                this.length = this.rubyArray.size();
            } else {
                this.length = 1;
                this.rubyArray = null;
            }
            this.runtime = iRubyObject.getRuntime();
        }

        Args(IRubyObject iRubyObject) {
            this(Locale.getDefault(), iRubyObject);
        }

        Args(Ruby ruby, long l) {
            this(RubyFixnum.newFixnum(ruby, l));
        }

        final void raiseArgumentError(String string) {
            throw this.runtime.newArgumentError(string);
        }

        final void warn(IRubyWarnings.ID iD, String string) {
            this.runtime.getWarnings().warn(iD, string, new Object[0]);
        }

        final void warning(IRubyWarnings.ID iD, String string) {
            this.runtime.getWarnings().warning(iD, string, new Object[0]);
        }

        final IRubyObject next() {
            if (this.numbered > 0) {
                this.raiseArgumentError("unnumbered" + (this.unnumbered + 1) + "mixed with numbered");
            }
            if (this.unnumbered >= this.length) {
                this.raiseArgumentError("too few arguments");
            }
            IRubyObject iRubyObject = this.rubyArray == null ? this.rubyObject : (IRubyObject)this.rubyArray.get(this.unnumbered);
            ++this.unnumbered;
            return iRubyObject;
        }

        final IRubyObject get(int n) {
            if (this.unnumbered > 0) {
                this.raiseArgumentError("numbered(" + this.numbered + ") after unnumbered(" + this.unnumbered + ")");
            }
            if (n < 0) {
                this.raiseArgumentError("invalid index - " + (n + 1) + '$');
            }
            if (n >= this.length) {
                this.raiseArgumentError("too few arguments");
            }
            this.numbered = n + 1;
            return this.rubyArray == null ? this.rubyObject : (IRubyObject)this.rubyArray.get(n);
        }

        final IRubyObject getNth(int n) {
            return this.get(n - 1);
        }

        final int nextInt() {
            return this.intValue(this.next());
        }

        final int getInt(int n) {
            return this.intValue(this.get(n));
        }

        final int getNthInt(int n) {
            return this.intValue(this.get(n - 1));
        }

        final int intValue(IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return (int)((RubyNumeric)iRubyObject).getLongValue();
            }
            iRubyObject = TypeConverter.convertToType(iRubyObject, iRubyObject.getRuntime().getFixnum(), MethodIndex.TO_INT, "to_int", true);
            return (int)((RubyFixnum)iRubyObject).getLongValue();
        }

        final byte getDecimalSeparator() {
            return (byte)new DecimalFormatSymbols(this.locale).getDecimalSeparator();
        }

        static /* synthetic */ int access$100(Args args) {
            return args.numbered;
        }

        static /* synthetic */ int access$200(Args args) {
            return args.unnumbered;
        }

        static /* synthetic */ int access$300(Args args) {
            return args.length;
        }

        static /* synthetic */ Ruby access$400(Args args) {
            return args.runtime;
        }
    }
}

