/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.management;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.compiler.JITCompilerMBean;
import org.jruby.nb.nb.nb.management.ClassCacheMBean;
import org.jruby.nb.nb.nb.management.ConfigMBean;
import org.jruby.nb.nb.nb.management.MethodCacheMBean;

public class BeanManager {
    public final String base;
    private final Ruby ruby;
    private final boolean managementEnabled;

    public BeanManager(Ruby ruby, boolean bl) {
        this.ruby = ruby;
        this.managementEnabled = bl;
        this.base = "org.jruby.nb.nb.nb:type=Runtime,name=" + ruby.hashCode() + ",";
    }

    public void register(JITCompilerMBean jITCompilerMBean) {
        if (this.managementEnabled) {
            this.register(this.base + "service=JITCompiler", jITCompilerMBean);
        }
    }

    public void register(ConfigMBean configMBean) {
        if (this.managementEnabled) {
            this.register(this.base + "service=Config", configMBean);
        }
    }

    public void register(MethodCacheMBean methodCacheMBean) {
        if (this.managementEnabled) {
            this.register(this.base + "service=MethodCache", methodCacheMBean);
        }
    }

    public void register(ClassCacheMBean classCacheMBean) {
        if (this.managementEnabled) {
            this.register(this.base + "service=ClassCache", classCacheMBean);
        }
    }

    public void unregisterCompiler() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=JITCompiler");
        }
    }

    public void unregisterConfig() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=Config");
        }
    }

    public void unregisterClassCache() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=ClassCache");
        }
    }

    public void unregisterMethodCache() {
        if (this.managementEnabled) {
            this.unregister(this.base + "service=MethodCache");
        }
    }

    private void register(String string, Object object) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(string);
            mBeanServer.registerMBean(object, objectName);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            Logger.getLogger(BeanManager.class.getName()).log(Level.SEVERE, null, instanceAlreadyExistsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            Logger.getLogger(BeanManager.class.getName()).log(Level.SEVERE, null, mBeanRegistrationException);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            Logger.getLogger(BeanManager.class.getName()).log(Level.SEVERE, null, notCompliantMBeanException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Logger.getLogger(BeanManager.class.getName()).log(Level.SEVERE, null, malformedObjectNameException);
        }
        catch (NullPointerException nullPointerException) {
            Logger.getLogger(BeanManager.class.getName()).log(Level.SEVERE, null, nullPointerException);
        }
    }

    private void unregister(String string) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(string);
            mBeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            Logger.getLogger(BeanManager.class.getName()).log(Level.SEVERE, null, mBeanRegistrationException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Logger.getLogger(BeanManager.class.getName()).log(Level.SEVERE, null, malformedObjectNameException);
        }
        catch (NullPointerException nullPointerException) {
            Logger.getLogger(BeanManager.class.getName()).log(Level.SEVERE, null, nullPointerException);
        }
    }
}

