/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.lexer.yacc;

import java.io.IOException;
import org.jruby.nb.nb.nb.ast.RegexpNode;
import org.jruby.nb.nb.nb.ast.StrNode;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.lexer.yacc.LexerSource;
import org.jruby.nb.nb.nb.lexer.yacc.RubyYaccLexer;
import org.jruby.nb.nb.nb.lexer.yacc.StrTerm;
import org.jruby.nb.nb.nb.lexer.yacc.SyntaxException;
import org.jruby.nb.nb.nb.lexer.yacc.Token;
import org.jruby.util.ByteList;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private int nest;

    public StringTerm(int n, int n2, int n3) {
        this.flags = n;
        this.begin = (char)n2;
        this.end = (char)n3;
        this.nest = 0;
    }

    public int parseString(RubyYaccLexer rubyYaccLexer, LexerSource lexerSource) throws IOException {
        boolean bl = false;
        if (this.flags == -1) {
            rubyYaccLexer.setValue(new Token("\"", rubyYaccLexer.getPosition()));
            return 374;
        }
        int n = lexerSource.read();
        if ((this.flags & 8) != 0 && Character.isWhitespace(n)) {
            while (Character.isWhitespace(n = lexerSource.read())) {
            }
            bl = true;
        }
        if ((this.processingEmbedded == 0 || this.processingEmbedded == 1) && n == this.end && this.nest == 0) {
            if ((this.flags & 8) != 0) {
                if (this.processingEmbedded == 1) {
                    rubyYaccLexer.setValue(new Token("" + this.end, rubyYaccLexer.getPosition()));
                    return 374;
                }
                this.flags = -1;
                rubyYaccLexer.getPosition();
                return 32;
            }
            if ((this.flags & 4) != 0) {
                rubyYaccLexer.setValue(new RegexpNode(lexerSource.getPosition(), ByteList.create((CharSequence)""), this.parseRegexpFlags(lexerSource)));
                return 315;
            }
            rubyYaccLexer.setValue(new Token("\"", rubyYaccLexer.getPosition()));
            return 374;
        }
        if (bl) {
            lexerSource.unread(n);
            rubyYaccLexer.getPosition();
            return 32;
        }
        if (this.processingEmbedded == 2 && n == 125) {
            this.processingEmbedded = 1;
            rubyYaccLexer.setValue(new Token("}", rubyYaccLexer.getPosition()));
            return 312;
        }
        if (this.begin == '\u0000' && this.flags == 0) {
            ByteList byteList = new ByteList();
            lexerSource.unread(n);
            if (this.parseSimpleStringIntoBuffer(lexerSource, byteList) == -1) {
                throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, lexerSource.getPosition(), "unterminated string meets end of file", new Object[0]);
            }
            rubyYaccLexer.setValue(new StrNode(rubyYaccLexer.getPosition(), byteList));
            return 312;
        }
        ByteList byteList = new ByteList();
        if ((this.flags & 2) != 0 && n == 35) {
            n = lexerSource.read();
            switch (n) {
                case 36: 
                case 64: {
                    if (this.processingEmbedded == 1) {
                        this.processingEmbedded = 3;
                    }
                    lexerSource.unread(n);
                    rubyYaccLexer.setValue(new Token("#" + n, rubyYaccLexer.getPosition()));
                    return 373;
                }
                case 123: {
                    if (this.processingEmbedded == 1) {
                        this.processingEmbedded = 2;
                    }
                    rubyYaccLexer.setValue(new Token("#" + n, rubyYaccLexer.getPosition()));
                    return 372;
                }
            }
            byteList.append((byte)35);
        }
        lexerSource.unread(n);
        int n2 = this.processingEmbedded == 2 ? this.parseDExprIntoBuffer(rubyYaccLexer, lexerSource, byteList) : this.parseStringIntoBuffer(rubyYaccLexer, lexerSource, byteList);
        if (n2 == -1) {
            throw new UnterminatedStringException(lexerSource.getPosition(), "unterminated string meets end of file");
        }
        rubyYaccLexer.setValue(new StrNode(rubyYaccLexer.getPosition(), byteList));
        if (this.processingEmbedded == 3) {
            this.processingEmbedded = 1;
        } else if (this.processingEmbedded == 2 && byteList.length() == 0) {
            this.processingEmbedded = 1;
        }
        return 312;
    }

    private int parseRegexpFlags(LexerSource lexerSource) throws IOException {
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(10);
        int n3 = lexerSource.read();
        while (n3 != -1 && Character.isLetter(n3)) {
            switch (n3) {
                case 105: {
                    n2 |= 1;
                    break;
                }
                case 120: {
                    n2 |= 2;
                    break;
                }
                case 109: {
                    n2 |= 4;
                    break;
                }
                case 111: {
                    n2 |= 0x80;
                    break;
                }
                case 110: {
                    n = 16;
                    break;
                }
                case 101: {
                    n = 32;
                    break;
                }
                case 115: {
                    n = 48;
                    break;
                }
                case 117: {
                    n = 64;
                    break;
                }
                case 106: {
                    n2 |= 0x100;
                    break;
                }
                default: {
                    stringBuilder.append((char)n3);
                }
            }
            n3 = lexerSource.read();
        }
        lexerSource.unread(n3);
        if (stringBuilder.length() != 0) {
            throw new SyntaxException(SyntaxException.PID.REGEXP_UNKNOWN_OPTION, lexerSource.getPosition(), "unknown regexp option" + (stringBuilder.length() > 1 ? "s" : "") + " - " + stringBuilder.toString(), stringBuilder.toString());
        }
        return n2 | n;
    }

    public int parseSimpleStringIntoBuffer(LexerSource lexerSource, ByteList byteList) throws IOException {
        int n;
        while ((n = lexerSource.read()) != -1) {
            if (n == this.end) {
                lexerSource.unread(n);
                break;
            }
            if (n == 92 && ((n = lexerSource.read()) == 10 || n != this.end) && n != 92) {
                byteList.append(92);
            }
            byteList.append(n);
        }
        return n;
    }

    public int parseStringIntoBuffer(RubyYaccLexer rubyYaccLexer, LexerSource lexerSource, ByteList byteList) throws IOException {
        int n;
        boolean bl;
        boolean bl2 = (this.flags & 8) != 0;
        boolean bl3 = (this.flags & 2) != 0;
        boolean bl4 = (this.flags & 1) != 0;
        boolean bl5 = bl = (this.flags & 4) != 0;
        block4: while ((n = lexerSource.read()) != -1) {
            block16: {
                block19: {
                    block18: {
                        block17: {
                            block15: {
                                if (this.begin == '\u0000' || n != this.begin) break block15;
                                ++this.nest;
                                break block16;
                            }
                            if (this.processingEmbedded == 2 && n == 125) {
                                lexerSource.unread(n);
                                break;
                            }
                            if (this.processingEmbedded == 3 && n != 95 && n != 36 && n != 64 && !Character.isLetter(n)) {
                                lexerSource.unread(n);
                                break;
                            }
                            if (n != this.end) break block17;
                            if (this.nest == 0) {
                                lexerSource.unread(n);
                                break;
                            }
                            --this.nest;
                            break block16;
                        }
                        if (n != 35 || !bl3 || lexerSource.peek(10)) break block18;
                        int n2 = lexerSource.read();
                        if (n2 == 36 || n2 == 64 || n2 == 123) {
                            lexerSource.unread(n2);
                            lexerSource.unread(n);
                            break;
                        }
                        lexerSource.unread(n2);
                        break block16;
                    }
                    if (n != 92) break block19;
                    n = lexerSource.read();
                    switch (n) {
                        case 10: {
                            if (bl2) break;
                            if (bl3) continue block4;
                            byteList.append(92);
                            break;
                        }
                        case 92: {
                            if (bl4) {
                                byteList.append(n);
                                break;
                            }
                            break block16;
                        }
                        default: {
                            if (bl) {
                                lexerSource.unread(n);
                                this.parseEscapeIntoBuffer(lexerSource, byteList);
                                continue block4;
                            }
                            if (bl3) {
                                lexerSource.unread(n);
                                if (bl4) {
                                    byteList.append(92);
                                }
                                n = rubyYaccLexer.readEscape();
                                break;
                            }
                            if (bl2 && Character.isWhitespace(n)) break;
                            if (n != this.end && (this.begin == '\u0000' || n != this.begin)) {
                                byteList.append(92);
                                break;
                            }
                            break block16;
                        }
                    }
                    break block16;
                }
                if (bl2 && Character.isWhitespace(n)) {
                    lexerSource.unread(n);
                    break;
                }
            }
            byteList.append(n);
        }
        return n;
    }

    public int parseDExprIntoBuffer(RubyYaccLexer rubyYaccLexer, LexerSource lexerSource, ByteList byteList) throws IOException {
        int n;
        boolean bl;
        boolean bl2 = (this.flags & 8) != 0;
        boolean bl3 = (this.flags & 2) != 0;
        boolean bl4 = (this.flags & 1) != 0;
        boolean bl5 = bl = (this.flags & 4) != 0;
        block4: while ((n = lexerSource.read()) != -1) {
            block13: {
                block15: {
                    block14: {
                        block12: {
                            if (n != 123) break block12;
                            ++this.nest;
                            break block13;
                        }
                        if (n != 125) break block14;
                        if (this.nest == 0) {
                            lexerSource.unread(n);
                            break;
                        }
                        --this.nest;
                        break block13;
                    }
                    if (n != 92) break block15;
                    n = lexerSource.read();
                    switch (n) {
                        case 10: {
                            if (bl2) break;
                            if (bl3) continue block4;
                            byteList.append(92);
                            break;
                        }
                        case 92: {
                            if (bl4) {
                                byteList.append(n);
                                break;
                            }
                            break block13;
                        }
                        default: {
                            if (bl) {
                                lexerSource.unread(n);
                                this.parseEscapeIntoBuffer(lexerSource, byteList);
                                continue block4;
                            }
                            if (bl3) {
                                lexerSource.unread(n);
                                if (bl4) {
                                    byteList.append(92);
                                }
                                n = rubyYaccLexer.readEscape();
                                break;
                            }
                            if (bl2 && Character.isWhitespace(n)) break;
                            if (n != this.end && (this.begin == '\u0000' || n != this.begin)) {
                                byteList.append(92);
                                break;
                            }
                            break block13;
                        }
                    }
                    break block13;
                }
                if (bl2 && Character.isWhitespace(n)) {
                    lexerSource.unread(n);
                    break;
                }
            }
            byteList.append(n);
        }
        return n;
    }

    private void escaped(LexerSource lexerSource, ByteList byteList) throws IOException {
        int n = lexerSource.read();
        switch (n) {
            case 92: {
                this.parseEscapeIntoBuffer(lexerSource, byteList);
                break;
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, lexerSource.getPosition(), "Invalid escape character syntax", new Object[0]);
            }
            default: {
                byteList.append(n);
            }
        }
    }

    private void parseEscapeIntoBuffer(LexerSource lexerSource, ByteList byteList) throws IOException {
        int n = lexerSource.read();
        block0 : switch (n) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                byteList.append(92);
                byteList.append(n);
                for (int i = 0; i < 2; ++i) {
                    n = lexerSource.read();
                    if (n == -1) {
                        throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, lexerSource.getPosition(), "Invalid escape character syntax", new Object[0]);
                    }
                    if (!RubyYaccLexer.isOctChar(n)) {
                        lexerSource.unread(n);
                        break block0;
                    }
                    byteList.append(n);
                }
                break;
            }
            case 120: {
                byteList.append(92);
                byteList.append(n);
                n = lexerSource.read();
                if (!RubyYaccLexer.isHexChar(n)) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, lexerSource.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                byteList.append(n);
                n = lexerSource.read();
                if (RubyYaccLexer.isHexChar(n)) {
                    byteList.append(n);
                    break;
                }
                lexerSource.unread(n);
                break;
            }
            case 77: {
                n = lexerSource.read();
                if (n != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, lexerSource.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                byteList.append(new byte[]{92, 77, 45});
                this.escaped(lexerSource, byteList);
                break;
            }
            case 67: {
                n = lexerSource.read();
                if (n != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, lexerSource.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                byteList.append(new byte[]{92, 67, 45});
                this.escaped(lexerSource, byteList);
                break;
            }
            case 99: {
                byteList.append(new byte[]{92, 99});
                this.escaped(lexerSource, byteList);
                break;
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, lexerSource.getPosition(), "Invalid escape character syntax", new Object[0]);
            }
            default: {
                if (n != 92 || n != this.end) {
                    byteList.append(92);
                }
                byteList.append(n);
            }
        }
    }

    public boolean isSubstituting() {
        return (this.flags & 2) != 0;
    }

    public Object getMutableState() {
        return new MutableTermState(this.processingEmbedded, this.nest);
    }

    public void setMutableState(Object object) {
        MutableTermState mutableTermState = (MutableTermState)object;
        if (mutableTermState != null) {
            this.processingEmbedded = mutableTermState.processingEmbedded;
            this.nest = mutableTermState.nest;
        }
    }

    public void splitEmbeddedTokens() {
        if (this.processingEmbedded == 0) {
            this.processingEmbedded = 1;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StringTerm stringTerm = (StringTerm)object;
        if (this.flags != stringTerm.flags) {
            return false;
        }
        if (this.end != stringTerm.end) {
            return false;
        }
        if (this.processingEmbedded != stringTerm.processingEmbedded) {
            return false;
        }
        if (this.begin != stringTerm.begin) {
            return false;
        }
        return this.nest == stringTerm.nest;
    }

    private static String toFuncString(int n) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 1) != 0) {
            stringBuilder.append("escape|");
        }
        if ((n & 2) != 0) {
            stringBuilder.append("expand|");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("regexp|");
        }
        if ((n & 8) != 0) {
            stringBuilder.append("qwords|");
        }
        if ((n & 0x10) != 0) {
            stringBuilder.append("symbol|");
        }
        if ((n & 0x20) != 0) {
            stringBuilder.append("indent|");
        }
        if ((string = stringBuilder.toString()).endsWith("|")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.length() == 0) {
            string = "-";
        }
        return string;
    }

    public String toString() {
        return "StringTerm[flags=" + StringTerm.toFuncString(this.flags) + ",end=" + this.end + ",begin=" + this.begin + ",nest=" + this.nest + ",embed=" + this.processingEmbedded + "]";
    }

    public int hashCode() {
        int n = 7;
        n = 13 * n + this.flags;
        n = 13 * n + this.end;
        n = 13 * n + this.begin;
        n = 13 * n + this.nest;
        n = 13 * n + this.processingEmbedded;
        return n;
    }

    public static class UnterminatedStringException
    extends SyntaxException {
        public UnterminatedStringException(ISourcePosition iSourcePosition, String string) {
            super(SyntaxException.PID.STRING_HITS_EOF, iSourcePosition, string, new Object[0]);
        }
    }

    private class MutableTermState {
        private int nest;
        private int processingEmbedded;

        private MutableTermState(int n, int n2) {
            this.processingEmbedded = n;
            this.nest = n2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MutableTermState mutableTermState = (MutableTermState)object;
            if (this.nest != mutableTermState.nest) {
                return false;
            }
            return this.processingEmbedded == mutableTermState.processingEmbedded;
        }

        public int hashCode() {
            int n = 7;
            n = 83 * n + this.nest;
            n = 83 * n + this.processingEmbedded;
            return n;
        }

        public String toString() {
            return "StringTermState[nest=" + this.nest + ",embed=" + this.processingEmbedded + "]";
        }
    }
}

