/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.lexer.yacc;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import org.jruby.nb.nb.nb.ast.BackRefNode;
import org.jruby.nb.nb.nb.ast.BignumNode;
import org.jruby.nb.nb.nb.ast.CommentNode;
import org.jruby.nb.nb.nb.ast.FixnumNode;
import org.jruby.nb.nb.nb.ast.FloatNode;
import org.jruby.nb.nb.nb.ast.NthRefNode;
import org.jruby.nb.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.nb.lexer.yacc.HeredocTerm;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePositionFactory;
import org.jruby.nb.nb.nb.lexer.yacc.LexerSource;
import org.jruby.nb.nb.nb.lexer.yacc.StackState;
import org.jruby.nb.nb.nb.lexer.yacc.StrTerm;
import org.jruby.nb.nb.nb.lexer.yacc.StringTerm;
import org.jruby.nb.nb.nb.lexer.yacc.SyntaxException;
import org.jruby.nb.nb.nb.lexer.yacc.Token;
import org.jruby.nb.nb.nb.parser.ParserSupport;
import org.jruby.util.ByteList;

public class RubyYaccLexer {
    private static ByteList END_MARKER = new ByteList(new byte[]{95, 69, 78, 68, 95, 95});
    private static ByteList BEGIN_DOC_MARKER = new ByteList(new byte[]{98, 101, 103, 105, 110});
    private static ByteList END_DOC_MARKER = new ByteList(new byte[]{101, 110, 100});
    private static HashMap<String, Keyword> map = new HashMap();
    private int token;
    Object yaccValue;
    private LexerSource src;
    private ParserSupport parserSupport = null;
    private IRubyWarnings warnings;
    private LexState lex_state;
    private boolean preserveSpaces;
    public HeredocContext heredocContext;
    private StringBuilder tokenBuffer = new StringBuilder(60);
    private StackState conditionState = new StackState();
    private StackState cmdArgumentState = new StackState();
    private StrTerm lex_strterm;
    private boolean commandStart;
    private boolean doComments;
    static final int EOF = -1;
    static final int STR_FUNC_ESCAPE = 1;
    static final int STR_FUNC_EXPAND = 2;
    static final int STR_FUNC_REGEXP = 4;
    static final int STR_FUNC_QWORDS = 8;
    static final int STR_FUNC_SYMBOL = 16;
    static final int STR_FUNC_INDENT = 32;
    private static final int str_squote = 0;
    private static final int str_dquote = 2;
    private static final int str_xquote = 2;
    private static final int str_regexp = 7;
    private static final int str_ssym = 16;
    private static final int str_dsym = 18;
    private boolean setSpaceSeen;

    private int getFloatToken(String string) {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.warnings.warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, this.getPosition(), "Float " + string + " out of range.", string);
            d = string.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        this.yaccValue = new FloatNode(this.getPosition(), d);
        return 314;
    }

    private Object newBignumNode(String string, int n) {
        return new BignumNode(this.getPosition(), new BigInteger(string, n));
    }

    private Object newFixnumNode(String string, int n) throws NumberFormatException {
        return new FixnumNode(this.getPosition(), Long.parseLong(string, n));
    }

    public static Keyword getKeyword(String string) {
        return map.get(string);
    }

    public RubyYaccLexer() {
        this.reset();
    }

    public void reset() {
        this.token = 0;
        this.yaccValue = null;
        this.src = null;
        this.lex_state = null;
        this.lex_state = LexState.EXPR_BEG;
        this.resetStacks();
        this.lex_strterm = null;
        this.commandStart = true;
    }

    public boolean advance() throws IOException {
        this.token = this.yylex();
        return this.token != -1;
    }

    public int token() {
        return this.token;
    }

    public StringBuilder getTokenBuffer() {
        return this.tokenBuffer;
    }

    public Object value() {
        return this.yaccValue;
    }

    public ISourcePositionFactory getPositionFactory() {
        return this.src.getPositionFactory();
    }

    public ISourcePosition getPosition(ISourcePosition iSourcePosition, boolean bl) {
        return this.src.getPosition(iSourcePosition, bl);
    }

    public ISourcePosition getPosition() {
        return this.src.getPosition(null, false);
    }

    public void setParserSupport(ParserSupport parserSupport) {
        this.parserSupport = parserSupport;
        if (parserSupport.getConfiguration() != null) {
            this.doComments = parserSupport.getConfiguration().hasExtraPositionInformation();
        }
    }

    public void setSource(LexerSource lexerSource) {
        this.src = lexerSource;
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strTerm) {
        this.lex_strterm = strTerm;
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    public void setWarnings(IRubyWarnings iRubyWarnings) {
        this.warnings = iRubyWarnings;
    }

    public void setState(LexState lexState) {
        this.lex_state = lexState;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }

    public void setValue(Object object) {
        this.yaccValue = object;
    }

    private boolean isNext_identchar() throws IOException {
        int n = this.src.read();
        this.src.unread(n);
        return n != -1 && (Character.isLetterOrDigit(n) || n == 95);
    }

    private void determineExpressionState() {
        switch (this.lex_state) {
            case EXPR_FNAME: 
            case EXPR_DOT: {
                this.lex_state = LexState.EXPR_ARG;
                break;
            }
            default: {
                this.lex_state = LexState.EXPR_BEG;
            }
        }
    }

    private Object getInteger(String string, int n) {
        try {
            return this.newFixnumNode(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            return this.newBignumNode(string, n);
        }
    }

    static final boolean isHexChar(int n) {
        return Character.isDigit(n) || 97 <= n && n <= 102 || 65 <= n && n <= 70;
    }

    static final boolean isOctChar(int n) {
        return 48 <= n && n <= 55;
    }

    public static final boolean isIdentifierChar(int n) {
        return Character.isLetterOrDigit(n) || n == 95;
    }

    private int parseQuote(int n) throws IOException {
        int n2;
        boolean bl;
        int n3;
        if (!Character.isLetterOrDigit(n)) {
            n3 = n;
            n = 81;
            bl = true;
        } else {
            bl = false;
            n3 = this.src.read();
            if (Character.isLetterOrDigit(n3)) {
                throw new SyntaxException(SyntaxException.PID.STRING_UNKNOWN_TYPE, this.getPosition(), "unknown type of %string", new Object[0]);
            }
        }
        if (n == -1 || n3 == -1) {
            throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, this.getPosition(), "unterminated quoted string meets end of file", new Object[0]);
        }
        switch (n3) {
            case 40: {
                n2 = 41;
                break;
            }
            case 91: {
                n2 = 93;
                break;
            }
            case 123: {
                n2 = 125;
                break;
            }
            case 60: {
                n2 = 62;
                break;
            }
            default: {
                n2 = n3;
                n3 = 0;
            }
        }
        switch (n) {
            case 81: {
                this.lex_strterm = new StringTerm(2, n3, n2);
                this.yaccValue = new Token("%" + (bl ? "" + n2 : "" + n + n3), this.getPosition());
                return 367;
            }
            case 113: {
                this.lex_strterm = new StringTerm(0, n3, n2);
                this.yaccValue = new Token("%" + n + n3, this.getPosition());
                return 367;
            }
            case 87: {
                this.lex_strterm = new StringTerm(10, n3, n2);
                while (Character.isWhitespace(n = this.src.read())) {
                }
                this.src.unread(n);
                this.yaccValue = new Token("%" + n + n3, this.getPosition());
                return 370;
            }
            case 119: {
                this.lex_strterm = new StringTerm(8, n3, n2);
                while (Character.isWhitespace(n = this.src.read())) {
                }
                this.src.unread(n);
                this.yaccValue = new Token("%" + n + n3, this.getPosition());
                return 371;
            }
            case 120: {
                this.lex_strterm = new StringTerm(2, n3, n2);
                this.yaccValue = new Token("%" + n + n3, this.getPosition());
                return 368;
            }
            case 114: {
                this.lex_strterm = new StringTerm(7, n3, n2);
                this.yaccValue = new Token("%" + n + n3, this.getPosition());
                return 369;
            }
            case 115: {
                this.lex_strterm = new StringTerm(16, n3, n2);
                this.lex_state = LexState.EXPR_FNAME;
                this.yaccValue = new Token("%" + n + n3, this.getPosition());
                return 366;
            }
        }
        throw new SyntaxException(SyntaxException.PID.STRING_UNKNOWN_TYPE, this.getPosition(), "Unknown type of %string. Expected 'Q', 'q', 'w', 'x', 'r' or any non letter character, but found '" + n + "'.", new Object[0]);
    }

    private int hereDocumentIdentifier() throws IOException {
        int n;
        ByteList byteList;
        int n2 = this.src.read();
        int n3 = 0;
        if (n2 == 45) {
            n2 = this.src.read();
            n3 = 32;
        }
        if (n2 == 39 || n2 == 34 || n2 == 96) {
            n3 = n2 == 39 ? (n3 |= 0) : (n2 == 34 ? (n3 |= 2) : (n3 |= 2));
            byteList = new ByteList();
            n = n2;
            while ((n2 = this.src.read()) != -1 && n2 != n) {
                byteList.append(n2);
            }
            if (n2 == -1) {
                throw new SyntaxException(SyntaxException.PID.STRING_MARKER_MISSING, this.getPosition(), "unterminated here document identifier", new Object[0]);
            }
        } else {
            if (!RubyYaccLexer.isIdentifierChar(n2)) {
                this.src.unread(n2);
                if ((n3 & 0x20) != 0) {
                    this.src.unread(45);
                }
                return 0;
            }
            byteList = new ByteList();
            n = 34;
            n3 |= 2;
            do {
                byteList.append(n2);
            } while ((n2 = this.src.read()) != -1 && RubyYaccLexer.isIdentifierChar(n2));
            this.src.unread(n2);
        }
        if (this.preserveSpaces) {
            HeredocTerm heredocTerm = new HeredocTerm(byteList, n3, null);
            if (n == 96) {
                this.yaccValue = new Token("`", this.getPosition());
                return 368;
            }
            this.yaccValue = new Token("\"", this.getPosition());
            this.heredocContext = this.heredocContext == null ? new HeredocContext(heredocTerm) : this.heredocContext.add(heredocTerm);
            return 367;
        }
        ByteList byteList2 = this.src.readLineBytes();
        byteList2.append(10);
        this.lex_strterm = new HeredocTerm(byteList, n3, byteList2);
        if (n == 96) {
            this.yaccValue = new Token("`", this.getPosition());
            return 368;
        }
        this.yaccValue = new Token("\"", this.getPosition());
        this.getPosition();
        return 367;
    }

    private void arg_ambiguous() {
        this.warnings.warning(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.getPosition(), "Ambiguous first argument; make sure.", new Object[0]);
    }

    protected int readComment(int n) throws IOException {
        if (this.doComments) {
            return this.readCommentLong(n);
        }
        return this.src.skipUntil(10);
    }

    private int readCommentLong(int n) throws IOException {
        ISourcePosition iSourcePosition = this.src.getPosition();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append((char)n);
        while ((n = this.src.read()) != 10 && n != -1) {
            this.tokenBuffer.append((char)n);
        }
        this.src.unread(n);
        if (this.parserSupport != null) {
            ISourcePosition iSourcePosition2 = iSourcePosition.union(this.getPosition());
            this.parserSupport.getResult().addComment(new CommentNode(iSourcePosition2, this.tokenBuffer.toString()));
        } else {
            this.getPosition();
        }
        return n;
    }

    private int yylex() throws IOException {
        int n;
        boolean bl = false;
        if (this.setSpaceSeen) {
            bl = true;
            this.setSpaceSeen = false;
        }
        if (this.heredocContext != null) {
            HeredocTerm heredocTerm;
            if (this.heredocContext.isLookingForEnd()) {
                heredocTerm = this.heredocContext.getTerm();
                this.lex_strterm = heredocTerm;
            } else if (this.src.isANewLine()) {
                heredocTerm = this.heredocContext.getTerm();
                this.lex_strterm = heredocTerm;
                this.heredocContext = this.heredocContext.pop();
            }
        }
        if (this.lex_strterm != null) {
            try {
                int n2 = this.lex_strterm.parseString(this, this.src);
                if (n2 == 374 || n2 == 315) {
                    this.lex_strterm = null;
                    this.lex_state = LexState.EXPR_END;
                    if (this.heredocContext != null && this.heredocContext.isLookingForEnd()) {
                        this.heredocContext = this.heredocContext.pop();
                    }
                }
                return n2;
            }
            catch (SyntaxException syntaxException) {
                this.lex_strterm = null;
                this.lex_state = LexState.EXPR_END;
                throw syntaxException;
            }
        }
        boolean bl2 = this.commandStart;
        this.commandStart = false;
        block43: while (true) {
            n = this.src.read();
            switch (n) {
                case -1: 
                case 4: 
                case 26: {
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    if (this.preserveSpaces) {
                        while ((n = this.src.read()) == 32 || n == 9 || n == 12 || n == 13 || n == 11) {
                        }
                        this.src.unread(n);
                        this.yaccValue = new Token("whitespace", this.getPosition());
                        this.setSpaceSeen = true;
                        return 50001;
                    }
                    this.getPosition();
                    bl = true;
                    continue block43;
                }
                case 35: {
                    if (this.preserveSpaces) {
                        while ((n = this.src.read()) != 10 && n != -1) {
                        }
                        this.yaccValue = new Token("line-comment", this.getPosition());
                        this.setSpaceSeen = bl;
                        if (this.lex_state != LexState.EXPR_BEG && this.lex_state != LexState.EXPR_FNAME && this.lex_state != LexState.EXPR_DOT && this.lex_state != LexState.EXPR_CLASS) {
                            this.commandStart = true;
                            this.lex_state = LexState.EXPR_BEG;
                        }
                        return 50000;
                    }
                    if (this.readComment(n) == -1) {
                        return -1;
                    }
                }
                case 10: {
                    while ((n = this.src.read()) == 10) {
                    }
                    this.src.unread(n);
                    this.getPosition();
                    if (this.preserveSpaces) {
                        this.src.setIsANewLine(true);
                        this.yaccValue = new Token("whitespace", this.getPosition());
                        if (this.lex_state != LexState.EXPR_BEG && this.lex_state != LexState.EXPR_FNAME && this.lex_state != LexState.EXPR_DOT && this.lex_state != LexState.EXPR_CLASS) {
                            this.commandStart = true;
                            this.lex_state = LexState.EXPR_BEG;
                        }
                        return 50001;
                    }
                    switch (this.lex_state) {
                        case EXPR_FNAME: 
                        case EXPR_DOT: 
                        case EXPR_BEG: 
                        case EXPR_CLASS: {
                            continue block43;
                        }
                    }
                    this.commandStart = true;
                    this.lex_state = LexState.EXPR_BEG;
                    return 10;
                }
                case 42: {
                    return this.star(bl);
                }
                case 33: {
                    return this.bang();
                }
                case 61: {
                    if (this.src.wasBeginOfLine()) {
                        boolean bl3 = this.preserveSpaces;
                        if (this.src.matchMarker(BEGIN_DOC_MARKER, false, false)) {
                            if (bl3) {
                                this.tokenBuffer.setLength(0);
                                this.tokenBuffer.append((CharSequence)BEGIN_DOC_MARKER);
                            }
                            if (Character.isWhitespace(n = this.src.read())) {
                                this.src.unread(n);
                                do {
                                    n = this.src.read();
                                    if (bl3) {
                                        this.tokenBuffer.append((char)n);
                                    }
                                    while (n == 10) {
                                        n = this.src.read();
                                        if (!bl3) continue;
                                        this.tokenBuffer.append((char)n);
                                    }
                                    if (n != -1) continue;
                                    throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, this.getPosition(), "embedded document meets end of file", new Object[0]);
                                } while (n != 61 || !this.src.wasBeginOfLine() || !this.src.matchMarker(END_DOC_MARKER, false, false));
                                if (bl3) {
                                    this.tokenBuffer.append((CharSequence)END_DOC_MARKER);
                                }
                                ByteList byteList = this.src.readLineBytes();
                                if (bl3) {
                                    this.tokenBuffer.append((CharSequence)byteList);
                                }
                                this.src.unread(10);
                                if (!bl3) continue block43;
                                this.yaccValue = new Token("here-doc", this.getPosition());
                                return 50002;
                            }
                            this.src.unread(n);
                        }
                    }
                    this.determineExpressionState();
                    n = this.src.read();
                    if (n == 61) {
                        n = this.src.read();
                        if (n == 61) {
                            this.yaccValue = new Token("===", this.getPosition());
                            return 322;
                        }
                        this.src.unread(n);
                        this.yaccValue = new Token("==", this.getPosition());
                        return 321;
                    }
                    if (n == 126) {
                        this.yaccValue = new Token("=~", this.getPosition());
                        return 328;
                    }
                    if (n == 62) {
                        this.yaccValue = new Token("=>", this.getPosition());
                        return 340;
                    }
                    this.src.unread(n);
                    this.yaccValue = new Token("=", this.getPosition());
                    return 61;
                }
                case 60: {
                    return this.lessThan(bl);
                }
                case 62: {
                    return this.greaterThan();
                }
                case 34: {
                    return this.doubleQuote();
                }
                case 96: {
                    return this.backtick(bl2);
                }
                case 39: {
                    return this.singleQuote();
                }
                case 63: {
                    return this.questionMark();
                }
                case 38: {
                    return this.ampersand(bl);
                }
                case 124: {
                    return this.pipe();
                }
                case 43: {
                    return this.plus(bl);
                }
                case 45: {
                    return this.minus(bl);
                }
                case 46: {
                    return this.dot();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(n);
                }
                case 41: {
                    return this.rightParen();
                }
                case 93: {
                    return this.rightBracket();
                }
                case 125: {
                    return this.rightCurly();
                }
                case 58: {
                    return this.colon(bl);
                }
                case 47: {
                    return this.slash(bl);
                }
                case 94: {
                    return this.caret();
                }
                case 59: {
                    this.commandStart = true;
                }
                case 44: {
                    return this.comma(n);
                }
                case 126: {
                    return this.tilde();
                }
                case 40: {
                    return this.leftParen(bl);
                }
                case 91: {
                    return this.leftBracket(bl);
                }
                case 123: {
                    return this.leftCurly();
                }
                case 92: {
                    n = this.src.read();
                    if (n == 10) {
                        bl = true;
                        continue block43;
                    }
                    this.src.unread(n);
                    this.yaccValue = new Token("\\", this.getPosition());
                    return 92;
                }
                case 37: {
                    return this.percent(bl);
                }
                case 36: {
                    return this.dollar();
                }
                case 64: {
                    return this.at();
                }
                case 95: {
                    if (this.src.wasBeginOfLine() && this.src.matchMarker(END_MARKER, false, true)) {
                        if (this.parserSupport != null) {
                            this.parserSupport.getResult().setEndOffset(this.src.getOffset());
                        }
                        return -1;
                    }
                    return this.identifier(n, bl2);
                }
            }
            break;
        }
        return this.identifier(n, bl2);
    }

    private int identifierToken(LexState lexState, int n, String string) {
        if (n == 304 && lexState != LexState.EXPR_DOT && this.parserSupport != null && this.parserSupport.getCurrentScope().isDefined(string) >= 0) {
            this.lex_state = LexState.EXPR_END;
        }
        this.yaccValue = new Token(string, n, this.getPosition());
        return n;
    }

    private int getIdentifier(int n) throws IOException {
        do {
            this.tokenBuffer.append((char)n);
        } while (RubyYaccLexer.isIdentifierChar(n = this.src.read()));
        return n;
    }

    private int ampersand(boolean bl) throws IOException {
        int n = this.src.read();
        switch (n) {
            case 38: {
                this.lex_state = LexState.EXPR_BEG;
                n = this.src.read();
                if (n == 61) {
                    this.yaccValue = new Token("&&", this.getPosition());
                    this.lex_state = LexState.EXPR_BEG;
                    return 339;
                }
                this.src.unread(n);
                this.yaccValue = new Token("&&", this.getPosition());
                return 326;
            }
            case 61: {
                this.yaccValue = new Token("&", this.getPosition());
                this.lex_state = LexState.EXPR_BEG;
                return 339;
            }
        }
        this.src.unread(n);
        ISourcePosition iSourcePosition = this.getPosition();
        if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && bl && !Character.isWhitespace(n)) {
            this.warnings.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, iSourcePosition, "`&' interpreted as argument prefix", "&");
            n = 351;
        } else {
            n = this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID ? 351 : 352;
        }
        this.determineExpressionState();
        this.yaccValue = new Token("&", iSourcePosition);
        return n;
    }

    private int at() throws IOException {
        int n;
        int n2 = this.src.read();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('@');
        if (n2 == 64) {
            this.tokenBuffer.append('@');
            n2 = this.src.read();
            n = 309;
        } else {
            n = 307;
        }
        if (Character.isDigit(n2)) {
            if (this.tokenBuffer.length() == 1) {
                throw new SyntaxException(SyntaxException.PID.IVAR_BAD_NAME, this.getPosition(), "`@" + n2 + "' is not allowed as an instance variable name", new Object[0]);
            }
            throw new SyntaxException(SyntaxException.PID.CVAR_BAD_NAME, this.getPosition(), "`@@" + n2 + "' is not allowed as a class variable name", new Object[0]);
        }
        if (!RubyYaccLexer.isIdentifierChar(n2)) {
            this.src.unread(n2);
            this.yaccValue = new Token("@", this.getPosition());
            return 64;
        }
        n2 = this.getIdentifier(n2);
        this.src.unread(n2);
        LexState lexState = this.lex_state;
        this.lex_state = LexState.EXPR_END;
        return this.identifierToken(lexState, n, this.tokenBuffer.toString().intern());
    }

    private int backtick(boolean bl) throws IOException {
        this.yaccValue = new Token("`", this.getPosition());
        switch (this.lex_state) {
            case EXPR_FNAME: {
                this.lex_state = LexState.EXPR_END;
                return 365;
            }
            case EXPR_DOT: {
                this.lex_state = bl ? LexState.EXPR_CMDARG : LexState.EXPR_ARG;
                return 365;
            }
        }
        this.lex_strterm = new StringTerm(2, 0, 96);
        return 368;
    }

    private int bang() throws IOException {
        int n = this.src.read();
        this.lex_state = LexState.EXPR_BEG;
        switch (n) {
            case 61: {
                this.yaccValue = new Token("!=", this.getPosition());
                return 323;
            }
            case 126: {
                this.yaccValue = new Token("!~", this.getPosition());
                return 329;
            }
        }
        this.src.unread(n);
        this.yaccValue = new Token("!", this.getPosition());
        return 361;
    }

    private int caret() throws IOException {
        int n = this.src.read();
        if (n == 61) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("^", this.getPosition());
            return 339;
        }
        this.determineExpressionState();
        this.src.unread(n);
        this.yaccValue = new Token("^", this.getPosition());
        return 362;
    }

    private int colon(boolean bl) throws IOException {
        int n = this.src.read();
        if (n == 58) {
            if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || this.lex_state == LexState.EXPR_CLASS || (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && bl) {
                this.lex_state = LexState.EXPR_BEG;
                this.yaccValue = new Token("::", this.getPosition());
                return 338;
            }
            this.lex_state = LexState.EXPR_DOT;
            this.yaccValue = new Token(":", this.getPosition());
            return 337;
        }
        if (this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG || Character.isWhitespace(n)) {
            this.src.unread(n);
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token(":", this.getPosition());
            return 58;
        }
        switch (n) {
            case 39: {
                this.lex_strterm = new StringTerm(16, 0, n);
                break;
            }
            case 34: {
                this.lex_strterm = new StringTerm(18, 0, n);
                break;
            }
            default: {
                this.src.unread(n);
            }
        }
        this.lex_state = LexState.EXPR_FNAME;
        this.yaccValue = new Token(":", this.getPosition());
        return 366;
    }

    private int comma(int n) throws IOException {
        this.lex_state = LexState.EXPR_BEG;
        this.yaccValue = new Token(",", this.getPosition());
        return n;
    }

    private int dollar() throws IOException {
        LexState lexState = this.lex_state;
        this.lex_state = LexState.EXPR_END;
        int n = this.src.read();
        switch (n) {
            case 95: {
                n = this.src.read();
                if (RubyYaccLexer.isIdentifierChar(n)) {
                    this.tokenBuffer.setLength(0);
                    this.tokenBuffer.append("$_");
                    n = this.getIdentifier(n);
                    this.src.unread(n);
                    lexState = this.lex_state;
                    this.lex_state = LexState.EXPR_END;
                    return this.identifierToken(lexState, 306, this.tokenBuffer.toString().intern());
                }
                this.src.unread(n);
                n = 95;
            }
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 126: {
                this.yaccValue = new Token("$" + (char)n, 306, this.getPosition());
                return 306;
            }
            case 45: {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                this.tokenBuffer.append((char)n);
                n = this.src.read();
                if (RubyYaccLexer.isIdentifierChar(n)) {
                    this.tokenBuffer.append((char)n);
                } else {
                    this.src.unread(n);
                }
                this.yaccValue = new Token(this.tokenBuffer.toString(), 306, this.getPosition());
                return 306;
            }
            case 38: 
            case 39: 
            case 43: 
            case 96: {
                if (lexState == LexState.EXPR_FNAME) {
                    this.yaccValue = new Token("$" + (char)n, 306, this.getPosition());
                    return 306;
                }
                this.yaccValue = new BackRefNode(this.getPosition(), n);
                return 311;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                do {
                    this.tokenBuffer.append((char)n);
                } while (Character.isDigit(n = this.src.read()));
                this.src.unread(n);
                if (lexState == LexState.EXPR_FNAME) {
                    this.yaccValue = new Token(this.tokenBuffer.toString(), 306, this.getPosition());
                    return 306;
                }
                this.yaccValue = new NthRefNode(this.getPosition(), Integer.parseInt(this.tokenBuffer.substring(1)));
                return 310;
            }
            case 48: {
                this.lex_state = LexState.EXPR_END;
                return this.identifierToken(lexState, 306, ("$" + (char)n).intern());
            }
        }
        if (!RubyYaccLexer.isIdentifierChar(n)) {
            this.src.unread(n);
            this.yaccValue = new Token("$", this.getPosition());
            return 36;
        }
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('$');
        int n2 = this.getIdentifier(n);
        this.src.unread(n2);
        lexState = this.lex_state;
        this.lex_state = LexState.EXPR_END;
        return this.identifierToken(lexState, 306, this.tokenBuffer.toString().intern());
    }

    private int dot() throws IOException {
        this.lex_state = LexState.EXPR_BEG;
        int n = this.src.read();
        if (n == 46) {
            n = this.src.read();
            if (n == 46) {
                this.yaccValue = new Token("...", this.getPosition());
                return 332;
            }
            this.src.unread(n);
            this.yaccValue = new Token("..", this.getPosition());
            return 331;
        }
        this.src.unread(n);
        if (Character.isDigit(n)) {
            throw new SyntaxException(SyntaxException.PID.FLOAT_MISSING_ZERO, this.getPosition(), "no .<digit> floating literal anymore; put 0 before dot", new Object[0]);
        }
        this.lex_state = LexState.EXPR_DOT;
        this.yaccValue = new Token(".", this.getPosition());
        return 330;
    }

    private int doubleQuote() throws IOException {
        this.lex_strterm = new StringTerm(2, 0, 34);
        this.yaccValue = new Token("\"", this.getPosition());
        return 367;
    }

    private int greaterThan() throws IOException {
        this.determineExpressionState();
        int n = this.src.read();
        switch (n) {
            case 61: {
                this.yaccValue = new Token(">=", this.getPosition());
                return 324;
            }
            case 62: {
                n = this.src.read();
                if (n == 61) {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token(">>", this.getPosition());
                    return 339;
                }
                this.src.unread(n);
                this.yaccValue = new Token(">>", this.getPosition());
                return 336;
            }
        }
        this.src.unread(n);
        this.yaccValue = new Token(">", this.getPosition());
        return 359;
    }

    private int identifier(int n, boolean bl) throws IOException {
        Keyword keyword;
        if (!RubyYaccLexer.isIdentifierChar(n)) {
            String string = "\\" + Integer.toOctalString(n & 0xFF);
            throw new SyntaxException(SyntaxException.PID.CHARACTER_BAD, this.getPosition(), "Invalid char `" + string + "' ('" + (char)n + "') in expression", string);
        }
        this.tokenBuffer.setLength(0);
        int n2 = n;
        boolean bl2 = this.src.wasBeginOfLine();
        n = this.getIdentifier(n);
        boolean bl3 = false;
        if (n == 33 || n == 63) {
            if (!this.src.peek(61)) {
                bl3 = true;
                this.tokenBuffer.append((char)n);
            } else {
                this.src.unread(n);
            }
        } else {
            this.src.unread(n);
        }
        this.src.setIsANewLine(bl2);
        int n3 = 0;
        LexState lexState = this.lex_state;
        if (bl3) {
            n3 = 305;
        } else {
            if (this.lex_state == LexState.EXPR_FNAME) {
                n = this.src.read();
                if (n == 61) {
                    int n4 = this.src.read();
                    if (n4 != 126 && n4 != 62 && (n4 != 61 || n4 == 10 && this.src.peek(62))) {
                        n3 = 304;
                        this.tokenBuffer.append((char)n);
                        this.src.unread(n4);
                    } else {
                        this.src.unread(n4);
                        this.src.unread(n);
                    }
                } else {
                    this.src.unread(n);
                }
            }
            n3 = n3 == 0 && Character.isUpperCase(n2) ? 308 : 304;
        }
        String string = this.tokenBuffer.toString().intern();
        if (this.lex_state != LexState.EXPR_DOT && (keyword = RubyYaccLexer.getKeyword(string)) != null) {
            LexState lexState2 = this.lex_state;
            this.lex_state = keyword.state;
            if (lexState2 == LexState.EXPR_FNAME) {
                this.yaccValue = new Token(keyword.name, this.getPosition());
            } else {
                this.yaccValue = new Token(string, this.getPosition());
                if (keyword.id0 == 280) {
                    if (this.conditionState.isInState()) {
                        return 281;
                    }
                    if (lexState2 != LexState.EXPR_CMDARG && this.cmdArgumentState.isInState()) {
                        return 282;
                    }
                    if (lexState2 == LexState.EXPR_ENDARG) {
                        return 282;
                    }
                    return 280;
                }
            }
            if (lexState2 == LexState.EXPR_BEG) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.lex_state = LexState.EXPR_BEG;
            }
            return keyword.id1;
        }
        switch (this.lex_state) {
            case EXPR_DOT: 
            case EXPR_BEG: 
            case EXPR_MID: 
            case EXPR_ARG: 
            case EXPR_CMDARG: {
                this.lex_state = bl ? LexState.EXPR_CMDARG : LexState.EXPR_ARG;
                break;
            }
            default: {
                this.lex_state = LexState.EXPR_END;
            }
        }
        return this.identifierToken(lexState, n3, string);
    }

    private int leftBracket(boolean bl) throws IOException {
        int n = 91;
        switch (this.lex_state) {
            case EXPR_FNAME: 
            case EXPR_DOT: {
                this.lex_state = LexState.EXPR_ARG;
                n = this.src.read();
                if (n == 93) {
                    if (this.src.peek(61)) {
                        n = this.src.read();
                        this.yaccValue = new Token("[]=", this.getPosition());
                        return 334;
                    }
                    this.yaccValue = new Token("[]", this.getPosition());
                    return 333;
                }
                this.src.unread(n);
                this.yaccValue = new Token("[", this.getPosition());
                return 91;
            }
            case EXPR_BEG: 
            case EXPR_MID: {
                n = 345;
                break;
            }
            case EXPR_ARG: 
            case EXPR_CMDARG: {
                if (!bl) break;
                n = 345;
            }
        }
        this.lex_state = LexState.EXPR_BEG;
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.yaccValue = new Token("[", this.getPosition());
        return n;
    }

    private int leftCurly() {
        int n;
        switch (this.lex_state) {
            case EXPR_ARG: 
            case EXPR_CMDARG: 
            case EXPR_END: {
                n = 363;
                break;
            }
            case EXPR_ENDARG: {
                n = 348;
                break;
            }
            default: {
                n = 347;
            }
        }
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.lex_state = LexState.EXPR_BEG;
        this.yaccValue = new Token("{", this.getPosition());
        return n;
    }

    private int leftParen(boolean bl) throws IOException {
        int n;
        this.commandStart = true;
        switch (this.lex_state) {
            case EXPR_BEG: 
            case EXPR_MID: {
                n = 341;
                break;
            }
            case EXPR_CMDARG: {
                n = bl ? 344 : 342;
                break;
            }
            case EXPR_ARG: {
                if (bl) {
                    this.warnings.warn(IRubyWarnings.ID.ARGUMENT_EXTRA_SPACE, this.getPosition(), "don't put space before argument parentheses", new Object[0]);
                }
            }
            default: {
                n = 342;
            }
        }
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.lex_state = LexState.EXPR_BEG;
        this.yaccValue = new Token("(", this.getPosition());
        return n;
    }

    private int lessThan(boolean bl) throws IOException {
        int n;
        int n2 = this.src.read();
        if (n2 == 60 && this.lex_state != LexState.EXPR_END && this.lex_state != LexState.EXPR_DOT && this.lex_state != LexState.EXPR_ENDARG && this.lex_state != LexState.EXPR_CLASS && (this.lex_state != LexState.EXPR_ARG && this.lex_state != LexState.EXPR_CMDARG || bl) && (n = this.hereDocumentIdentifier()) != 0) {
            return n;
        }
        this.determineExpressionState();
        switch (n2) {
            case 61: {
                n2 = this.src.read();
                if (n2 == 62) {
                    this.yaccValue = new Token("<=>", this.getPosition());
                    return 320;
                }
                this.src.unread(n2);
                this.yaccValue = new Token("<=", this.getPosition());
                return 325;
            }
            case 60: {
                n2 = this.src.read();
                if (n2 == 61) {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("<<", this.getPosition());
                    return 339;
                }
                this.src.unread(n2);
                this.yaccValue = new Token("<<", this.getPosition());
                return 335;
            }
        }
        this.yaccValue = new Token("<", this.getPosition());
        this.src.unread(n2);
        return 358;
    }

    private int minus(boolean bl) throws IOException {
        int n = this.src.read();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.lex_state = LexState.EXPR_ARG;
            if (n == 64) {
                this.yaccValue = new Token("-@", this.getPosition());
                return 317;
            }
            this.src.unread(n);
            this.yaccValue = new Token("-", this.getPosition());
            return 357;
        }
        if (n == 61) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("-", this.getPosition());
            return 339;
        }
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && bl && !Character.isWhitespace(n)) {
            if (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) {
                this.arg_ambiguous();
            }
            this.lex_state = LexState.EXPR_BEG;
            this.src.unread(n);
            this.yaccValue = new Token("-", this.getPosition());
            if (Character.isDigit(n)) {
                return 318;
            }
            return 317;
        }
        this.lex_state = LexState.EXPR_BEG;
        this.src.unread(n);
        this.yaccValue = new Token("-", this.getPosition());
        return 357;
    }

    private int percent(boolean bl) throws IOException {
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
            return this.parseQuote(this.src.read());
        }
        int n = this.src.read();
        if (n == 61) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("%", this.getPosition());
            return 339;
        }
        if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && bl && !Character.isWhitespace(n)) {
            return this.parseQuote(n);
        }
        this.determineExpressionState();
        this.src.unread(n);
        this.yaccValue = new Token("%", this.getPosition());
        return 354;
    }

    private int pipe() throws IOException {
        int n = this.src.read();
        switch (n) {
            case 124: {
                this.lex_state = LexState.EXPR_BEG;
                n = this.src.read();
                if (n == 61) {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("||", this.getPosition());
                    return 339;
                }
                this.src.unread(n);
                this.yaccValue = new Token("||", this.getPosition());
                return 327;
            }
            case 61: {
                this.lex_state = LexState.EXPR_BEG;
                this.yaccValue = new Token("|", this.getPosition());
                return 339;
            }
        }
        this.determineExpressionState();
        this.src.unread(n);
        this.yaccValue = new Token("|", this.getPosition());
        return 360;
    }

    private int plus(boolean bl) throws IOException {
        int n = this.src.read();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.lex_state = LexState.EXPR_ARG;
            if (n == 64) {
                this.yaccValue = new Token("+@", this.getPosition());
                return 316;
            }
            this.src.unread(n);
            this.yaccValue = new Token("+", this.getPosition());
            return 356;
        }
        if (n == 61) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("+", this.getPosition());
            return 339;
        }
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && bl && !Character.isWhitespace(n)) {
            if (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) {
                this.arg_ambiguous();
            }
            this.lex_state = LexState.EXPR_BEG;
            this.src.unread(n);
            if (Character.isDigit(n)) {
                n = 43;
                return this.parseNumber(n);
            }
            this.yaccValue = new Token("+", this.getPosition());
            return 316;
        }
        this.lex_state = LexState.EXPR_BEG;
        this.src.unread(n);
        this.yaccValue = new Token("+", this.getPosition());
        return 356;
    }

    private int questionMark() throws IOException {
        if (this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        int n = this.src.read();
        if (n == -1) {
            throw new SyntaxException(SyntaxException.PID.INCOMPLETE_CHAR_SYNTAX, this.getPosition(), "incomplete character syntax", new Object[0]);
        }
        if (Character.isWhitespace(n)) {
            if (this.lex_state != LexState.EXPR_ARG && this.lex_state != LexState.EXPR_CMDARG) {
                int n2 = 0;
                switch (n) {
                    case 32: {
                        n2 = 115;
                        break;
                    }
                    case 10: {
                        n2 = 110;
                        break;
                    }
                    case 9: {
                        n2 = 116;
                        break;
                    }
                    case 13: {
                        n2 = 114;
                        break;
                    }
                    case 12: {
                        n2 = 102;
                    }
                }
                if (n2 != 0) {
                    this.warnings.warn(IRubyWarnings.ID.INVALID_CHAR_SEQUENCE, this.getPosition(), "invalid character syntax; use ?\\" + n2, new Object[0]);
                }
            }
            this.src.unread(n);
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        if (RubyYaccLexer.isIdentifierChar(n) && !this.src.peek(10) && this.isNext_identchar()) {
            this.src.unread(n);
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        if (n == 92) {
            n = this.readEscape();
        }
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new FixnumNode(this.getPosition(), n &= 0xFF);
        return 313;
    }

    private int rightBracket() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new Token(")", this.getPosition());
        return 346;
    }

    private int rightCurly() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new Token("}", this.getPosition());
        return 364;
    }

    private int rightParen() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new Token(")", this.getPosition());
        return 343;
    }

    private int singleQuote() throws IOException {
        this.lex_strterm = new StringTerm(0, 0, 39);
        this.yaccValue = new Token("'", this.getPosition());
        return 367;
    }

    private int slash(boolean bl) throws IOException {
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
            this.lex_strterm = new StringTerm(7, 0, 47);
            this.yaccValue = new Token("/", this.getPosition());
            return 369;
        }
        int n = this.src.read();
        if (n == 61) {
            this.yaccValue = new Token("/", this.getPosition());
            this.lex_state = LexState.EXPR_BEG;
            return 339;
        }
        this.src.unread(n);
        if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && bl && !Character.isWhitespace(n)) {
            this.arg_ambiguous();
            this.lex_strterm = new StringTerm(7, 0, 47);
            this.yaccValue = new Token("/", this.getPosition());
            return 369;
        }
        this.determineExpressionState();
        this.yaccValue = new Token("/", this.getPosition());
        return 355;
    }

    private int star(boolean bl) throws IOException {
        int n = this.src.read();
        switch (n) {
            case 42: {
                n = this.src.read();
                if (n == 61) {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("**", this.getPosition());
                    return 339;
                }
                this.src.unread(n);
                this.yaccValue = new Token("**", this.getPosition());
                n = 319;
                break;
            }
            case 61: {
                this.lex_state = LexState.EXPR_BEG;
                this.yaccValue = new Token("*", this.getPosition());
                return 339;
            }
            default: {
                this.src.unread(n);
                if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && bl && !Character.isWhitespace(n)) {
                    this.warnings.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, this.getPosition(), "`*' interpreted as argument prefix", "*");
                    n = 349;
                } else {
                    n = this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID ? 349 : 350;
                }
                this.yaccValue = new Token("*", this.getPosition());
            }
        }
        this.determineExpressionState();
        return n;
    }

    private int tilde() throws IOException {
        int n;
        if ((this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) && (n = this.src.read()) != 64) {
            this.src.unread(n);
        }
        this.determineExpressionState();
        this.yaccValue = new Token("~", this.getPosition());
        return 353;
    }

    private int parseNumber(int n) throws IOException {
        int n2;
        this.lex_state = LexState.EXPR_END;
        this.tokenBuffer.setLength(0);
        if (n == 45) {
            this.tokenBuffer.append((char)n);
            n = this.src.read();
        } else if (n == 43) {
            n = this.src.read();
        }
        int n3 = 0;
        if (n == 48) {
            n2 = this.tokenBuffer.length();
            n = this.src.read();
            switch (n) {
                case 88: 
                case 120: {
                    n = this.src.read();
                    if (RubyYaccLexer.isHexChar(n)) {
                        while (true) {
                            if (n == 95) {
                                if (n3 != 0) break;
                                n3 = n;
                            } else {
                                if (!RubyYaccLexer.isHexChar(n)) break;
                                n3 = 0;
                                this.tokenBuffer.append((char)n);
                            }
                            n = this.src.read();
                        }
                    }
                    this.src.unread(n);
                    if (this.tokenBuffer.length() == n2) {
                        throw new SyntaxException(SyntaxException.PID.BAD_HEX_NUMBER, this.getPosition(), "Hexadecimal number without hex-digits.", new Object[0]);
                    }
                    if (n3 != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 16);
                    return 313;
                }
                case 66: 
                case 98: {
                    n = this.src.read();
                    if (n == 48 || n == 49) {
                        while (true) {
                            if (n == 95) {
                                if (n3 != 0) break;
                                n3 = n;
                            } else {
                                if (n != 48 && n != 49) break;
                                n3 = 0;
                                this.tokenBuffer.append((char)n);
                            }
                            n = this.src.read();
                        }
                    }
                    this.src.unread(n);
                    if (this.tokenBuffer.length() == n2) {
                        throw new SyntaxException(SyntaxException.PID.EMPTY_BINARY_NUMBER, this.getPosition(), "Binary number without digits.", new Object[0]);
                    }
                    if (n3 != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 2);
                    return 313;
                }
                case 68: 
                case 100: {
                    n = this.src.read();
                    if (Character.isDigit(n)) {
                        while (true) {
                            if (n == 95) {
                                if (n3 != 0) break;
                                n3 = n;
                            } else {
                                if (!Character.isDigit(n)) break;
                                n3 = 0;
                                this.tokenBuffer.append((char)n);
                            }
                            n = this.src.read();
                        }
                    }
                    this.src.unread(n);
                    if (this.tokenBuffer.length() == n2) {
                        throw new SyntaxException(SyntaxException.PID.EMPTY_BINARY_NUMBER, this.getPosition(), "Binary number without digits.", new Object[0]);
                    }
                    if (n3 != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                    return 313;
                }
                case 111: {
                    n = this.src.read();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 95: {
                    while (true) {
                        if (n == 95) {
                            if (n3 != 0) break;
                            n3 = n;
                        } else {
                            if (n < 48 || n > 55) break;
                            n3 = 0;
                            this.tokenBuffer.append((char)n);
                        }
                        n = this.src.read();
                    }
                    if (this.tokenBuffer.length() > n2) {
                        this.src.unread(n);
                        if (n3 != 0) {
                            throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                        }
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 8);
                        return 313;
                    }
                }
                case 56: 
                case 57: {
                    throw new SyntaxException(SyntaxException.PID.BAD_OCTAL_DIGIT, this.getPosition(), "Illegal octal digit.", new Object[0]);
                }
                case 46: 
                case 69: 
                case 101: {
                    this.tokenBuffer.append('0');
                    break;
                }
                default: {
                    this.src.unread(n);
                    this.yaccValue = new FixnumNode(this.getPosition(), 0L);
                    return 313;
                }
            }
        }
        n2 = 0;
        boolean bl = false;
        while (true) {
            switch (n) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n3 = 0;
                    this.tokenBuffer.append((char)n);
                    break;
                }
                case 46: {
                    if (n3 != 0) {
                        this.src.unread(n);
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    if (n2 != 0 || bl) {
                        this.src.unread(n);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, n3);
                    }
                    int n4 = this.src.read();
                    if (!Character.isDigit(n4)) {
                        this.src.unread(n4);
                        this.src.unread(46);
                        if (n == 95) break;
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                        return 313;
                    }
                    this.tokenBuffer.append('.');
                    this.tokenBuffer.append((char)n4);
                    n2 = 1;
                    n3 = 0;
                    break;
                }
                case 69: 
                case 101: {
                    if (n3 != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    if (bl) {
                        this.src.unread(n);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, n3);
                    }
                    this.tokenBuffer.append((char)n);
                    bl = true;
                    n3 = n;
                    n = this.src.read();
                    if (n == 45 || n == 43) {
                        this.tokenBuffer.append((char)n);
                        n3 = n;
                        break;
                    }
                    this.src.unread(n);
                    break;
                }
                case 95: {
                    if (n3 != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    n3 = n;
                    break;
                }
                default: {
                    this.src.unread(n);
                    return this.getNumberToken(this.tokenBuffer.toString(), bl || n2 != 0, n3);
                }
            }
            n = this.src.read();
        }
    }

    private int getNumberToken(String string, boolean bl, int n) {
        if (n != 0) {
            throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
        }
        if (bl) {
            return this.getFloatToken(string);
        }
        this.yaccValue = this.getInteger(string, 10);
        return 313;
    }

    public int readEscape() throws IOException {
        int n = this.src.read();
        switch (n) {
            case 92: {
                return n;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.src.unread(n);
                return this.scanOct(3);
            }
            case 120: {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < 2; ++n2) {
                    int n4 = this.src.read();
                    if (!RubyYaccLexer.isHexChar(n4)) {
                        this.src.unread(n4);
                        break;
                    }
                    n3 = (char)(n3 << 4);
                    n3 = (char)(n3 | Integer.parseInt("" + (char)n4, 16) & 0xF);
                }
                if (n2 == 0) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                return n3;
            }
            case 98: {
                return 8;
            }
            case 115: {
                return 32;
            }
            case 77: {
                n = this.src.read();
                if (n != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                n = this.src.read();
                if (n == 92) {
                    return (char)(this.readEscape() | 0x80);
                }
                if (n == -1) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                return (char)(n & 0xFF | 0x80);
            }
            case 67: {
                n = this.src.read();
                if (n != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
            }
            case 99: {
                n = this.src.read();
                if (n == 92) {
                    n = this.readEscape();
                } else {
                    if (n == 63) {
                        return 375;
                    }
                    if (n == -1) {
                        throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                    }
                }
                return (char)(n & 0x9F);
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
            }
        }
        return n;
    }

    private char scanOct(int n) throws IOException {
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            int n2 = this.src.read();
            if (!RubyYaccLexer.isOctChar(n2)) {
                this.src.unread(n2);
                break;
            }
            c = (char)(c << 3);
            c = (char)(c | Integer.parseInt("" + (char)n2, 8));
        }
        return c;
    }

    public void setPreserveSpaces(boolean bl) {
        this.preserveSpaces = bl;
    }

    public boolean getPreserveSpaces() {
        return this.preserveSpaces;
    }

    public LexState getLexState() {
        return this.lex_state;
    }

    public void setLexState(LexState lexState) {
        this.lex_state = lexState;
    }

    public boolean isSetSpaceSeen() {
        return this.setSpaceSeen;
    }

    public void setSpaceSeen(boolean bl) {
        this.setSpaceSeen = bl;
    }

    public boolean isCommandStart() {
        return this.commandStart;
    }

    public void setCommandStart(boolean bl) {
        this.commandStart = bl;
    }

    public LexerSource getSource() {
        return this.src;
    }

    static {
        map.put("end", Keyword.END);
        map.put("else", Keyword.ELSE);
        map.put("case", Keyword.CASE);
        map.put("ensure", Keyword.ENSURE);
        map.put("module", Keyword.MODULE);
        map.put("elsif", Keyword.ELSIF);
        map.put("def", Keyword.DEF);
        map.put("rescue", Keyword.RESCUE);
        map.put("not", Keyword.NOT);
        map.put("then", Keyword.THEN);
        map.put("yield", Keyword.YIELD);
        map.put("for", Keyword.FOR);
        map.put("self", Keyword.SELF);
        map.put("false", Keyword.FALSE);
        map.put("retry", Keyword.RETRY);
        map.put("return", Keyword.RETURN);
        map.put("true", Keyword.TRUE);
        map.put("if", Keyword.IF);
        map.put("defined?", Keyword.DEFINED_P);
        map.put("super", Keyword.SUPER);
        map.put("undef", Keyword.UNDEF);
        map.put("break", Keyword.BREAK);
        map.put("in", Keyword.IN);
        map.put("do", Keyword.DO);
        map.put("nil", Keyword.NIL);
        map.put("until", Keyword.UNTIL);
        map.put("unless", Keyword.UNLESS);
        map.put("or", Keyword.OR);
        map.put("next", Keyword.NEXT);
        map.put("when", Keyword.WHEN);
        map.put("redo", Keyword.REDO);
        map.put("and", Keyword.AND);
        map.put("begin", Keyword.BEGIN);
        map.put("__LINE__", Keyword.__LINE__);
        map.put("class", Keyword.CLASS);
        map.put("__FILE__", Keyword.__FILE__);
        map.put("END", Keyword.LEND);
        map.put("BEGIN", Keyword.LBEGIN);
        map.put("while", Keyword.WHILE);
        map.put("alias", Keyword.ALIAS);
    }

    public static class HeredocContext {
        private HeredocTerm[] heredocTerms;
        private boolean[] lookingForEnds;

        public HeredocContext(HeredocTerm heredocTerm) {
            this.heredocTerms = new HeredocTerm[]{heredocTerm, heredocTerm};
            this.lookingForEnds = new boolean[]{false, true};
        }

        private HeredocContext(HeredocTerm[] heredocTermArray, boolean[] blArray) {
            this.heredocTerms = heredocTermArray;
            this.lookingForEnds = blArray;
        }

        private HeredocContext add(HeredocTerm heredocTerm) {
            HeredocTerm[] heredocTermArray = new HeredocTerm[this.heredocTerms.length + 2];
            System.arraycopy(this.heredocTerms, 0, heredocTermArray, 0, this.heredocTerms.length);
            heredocTermArray[this.heredocTerms.length] = heredocTerm;
            heredocTermArray[this.heredocTerms.length + 1] = heredocTerm;
            boolean[] blArray = new boolean[this.lookingForEnds.length + 2];
            System.arraycopy(this.lookingForEnds, 0, blArray, 0, this.lookingForEnds.length);
            blArray[this.lookingForEnds.length] = false;
            blArray[this.lookingForEnds.length + 1] = true;
            HeredocContext heredocContext = new HeredocContext(heredocTermArray, blArray);
            return heredocContext;
        }

        private HeredocTerm getTerm() {
            return this.heredocTerms[0];
        }

        private HeredocContext pop() {
            if (this.heredocTerms.length > 1) {
                HeredocTerm[] heredocTermArray = new HeredocTerm[this.heredocTerms.length - 1];
                System.arraycopy(this.heredocTerms, 1, heredocTermArray, 0, heredocTermArray.length);
                boolean[] blArray = new boolean[this.lookingForEnds.length - 1];
                System.arraycopy(this.lookingForEnds, 1, blArray, 0, blArray.length);
                HeredocContext heredocContext = new HeredocContext(heredocTermArray, blArray);
                return heredocContext;
            }
            return null;
        }

        public boolean isLookingForEnd() {
            return this.lookingForEnds[0];
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("HeredocContext(count=");
            stringBuilder.append(Integer.toString(this.heredocTerms.length));
            stringBuilder.append("):");
            for (int i = 0; i < this.heredocTerms.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("end:");
                stringBuilder.append(this.lookingForEnds[i]);
                stringBuilder.append(",term:");
                stringBuilder.append(this.heredocTerms[i]);
            }
            return stringBuilder.toString();
        }

        public int hashCode() {
            return this.heredocTerms[0].getMutableState().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof HeredocContext) {
                HeredocContext heredocContext = (HeredocContext)object;
                if (heredocContext.heredocTerms.length != this.heredocTerms.length) {
                    return false;
                }
                return this.heredocTerms[0].getMutableState().equals(heredocContext.heredocTerms[0].getMutableState());
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LexState
    extends Enum<LexState> {
        public static final /* enum */ LexState EXPR_BEG = new LexState();
        public static final /* enum */ LexState EXPR_END = new LexState();
        public static final /* enum */ LexState EXPR_ARG = new LexState();
        public static final /* enum */ LexState EXPR_CMDARG = new LexState();
        public static final /* enum */ LexState EXPR_ENDARG = new LexState();
        public static final /* enum */ LexState EXPR_MID = new LexState();
        public static final /* enum */ LexState EXPR_FNAME = new LexState();
        public static final /* enum */ LexState EXPR_DOT = new LexState();
        public static final /* enum */ LexState EXPR_CLASS = new LexState();
        private int ordinal;
        private static final /* synthetic */ LexState[] $VALUES;

        public static final LexState[] values() {
            return (LexState[])$VALUES.clone();
        }

        public static LexState valueOf(String string) {
            return Enum.valueOf(LexState.class, string);
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public static LexState fromOrdinal(int n) {
            switch (n) {
                case 0: {
                    return EXPR_BEG;
                }
                case 1: {
                    return EXPR_END;
                }
                case 2: {
                    return EXPR_ARG;
                }
                case 3: {
                    return EXPR_CMDARG;
                }
                case 4: {
                    return EXPR_ENDARG;
                }
                case 5: {
                    return EXPR_MID;
                }
                case 6: {
                    return EXPR_FNAME;
                }
                case 7: {
                    return EXPR_DOT;
                }
                case 8: {
                    return EXPR_CLASS;
                }
            }
            return null;
        }

        static {
            $VALUES = new LexState[]{EXPR_BEG, EXPR_END, EXPR_ARG, EXPR_CMDARG, EXPR_ENDARG, EXPR_MID, EXPR_FNAME, EXPR_DOT, EXPR_CLASS};
            LexState.EXPR_BEG.ordinal = 0;
            LexState.EXPR_END.ordinal = 1;
            LexState.EXPR_ARG.ordinal = 2;
            LexState.EXPR_CMDARG.ordinal = 3;
            LexState.EXPR_ENDARG.ordinal = 4;
            LexState.EXPR_MID.ordinal = 5;
            LexState.EXPR_FNAME.ordinal = 6;
            LexState.EXPR_DOT.ordinal = 7;
            LexState.EXPR_CLASS.ordinal = 8;
            assert (LexState.EXPR_CLASS.ordinal == EXPR_CLASS.ordinal());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keyword {
        END("end", 264, 264, LexState.EXPR_END),
        ELSE("else", 269, 269, LexState.EXPR_BEG),
        CASE("case", 270, 270, LexState.EXPR_BEG),
        ENSURE("ensure", 263, 263, LexState.EXPR_BEG),
        MODULE("module", 258, 258, LexState.EXPR_BEG),
        ELSIF("elsif", 268, 268, LexState.EXPR_BEG),
        DEF("def", 259, 259, LexState.EXPR_FNAME),
        RESCUE("rescue", 262, 297, LexState.EXPR_MID),
        NOT("not", 292, 292, LexState.EXPR_BEG),
        THEN("then", 267, 267, LexState.EXPR_BEG),
        YIELD("yield", 284, 284, LexState.EXPR_ARG),
        FOR("for", 274, 274, LexState.EXPR_BEG),
        SELF("self", 286, 286, LexState.EXPR_END),
        FALSE("false", 289, 289, LexState.EXPR_END),
        RETRY("retry", 278, 278, LexState.EXPR_END),
        RETURN("return", 283, 283, LexState.EXPR_MID),
        TRUE("true", 288, 288, LexState.EXPR_END),
        IF("if", 265, 293, LexState.EXPR_BEG),
        DEFINED_P("defined?", 299, 299, LexState.EXPR_ARG),
        SUPER("super", 285, 285, LexState.EXPR_ARG),
        UNDEF("undef", 260, 260, LexState.EXPR_FNAME),
        BREAK("break", 275, 275, LexState.EXPR_MID),
        IN("in", 279, 279, LexState.EXPR_BEG),
        DO("do", 280, 280, LexState.EXPR_BEG),
        NIL("nil", 287, 287, LexState.EXPR_END),
        UNTIL("until", 273, 296, LexState.EXPR_BEG),
        UNLESS("unless", 266, 294, LexState.EXPR_BEG),
        OR("or", 291, 291, LexState.EXPR_BEG),
        NEXT("next", 276, 276, LexState.EXPR_MID),
        WHEN("when", 271, 271, LexState.EXPR_BEG),
        REDO("redo", 277, 277, LexState.EXPR_END),
        AND("and", 290, 290, LexState.EXPR_BEG),
        BEGIN("begin", 261, 261, LexState.EXPR_BEG),
        __LINE__("__LINE__", 302, 302, LexState.EXPR_END),
        CLASS("class", 257, 257, LexState.EXPR_CLASS),
        __FILE__("__FILE__", 303, 303, LexState.EXPR_END),
        LEND("END", 301, 301, LexState.EXPR_END),
        LBEGIN("BEGIN", 300, 300, LexState.EXPR_END),
        WHILE("while", 272, 295, LexState.EXPR_BEG),
        ALIAS("alias", 298, 298, LexState.EXPR_FNAME);

        public final String name;
        public final int id0;
        public final int id1;
        public final LexState state;

        private Keyword(String string2, int n2, int n3, LexState lexState) {
            this.name = string2;
            this.id0 = n2;
            this.id1 = n3;
            this.state = lexState;
        }
    }
}

