/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.lexer.yacc;

import java.io.IOException;
import java.util.List;
import org.jruby.nb.nb.nb.lexer.yacc.CapturingByteListLexerSource;
import org.jruby.nb.nb.nb.lexer.yacc.LexerSource;
import org.jruby.nb.nb.nb.parser.ParserConfiguration;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteListLexerSource
extends LexerSource {
    private int begin;
    private int realSize;
    private int index;
    private byte[] bytes;

    public ByteListLexerSource(String string, ByteList byteList, List<String> list, int n, boolean bl) {
        super(string, list, n, bl);
        this.bytes = byteList.bytes;
        this.begin = this.index = byteList.begin();
        this.realSize = byteList.realSize;
    }

    @Override
    public boolean matchMarker(ByteList byteList, boolean bl, boolean bl2) throws IOException {
        int n;
        int n2 = this.index;
        if (bl) {
            while ((n = this.read()) != -1) {
                if (Character.isWhitespace(n) && n != 10) continue;
                --this.index;
                break;
            }
        }
        for (n = 0; n < byteList.length(); ++n) {
            if (byteList.charAt(n) == this.read()) continue;
            this.index = n2;
            return false;
        }
        if (!bl2) {
            return true;
        }
        n = (char)this.internalRead();
        if (n == -1 || n == 10) {
            return true;
        }
        this.index = n2;
        return false;
    }

    @Override
    public boolean peek(int n) throws IOException {
        if (this.index >= this.realSize) {
            return n == -1;
        }
        return this.bytes[this.index] == n;
    }

    private byte internalRead() {
        return this.index >= this.realSize ? (byte)-1 : this.bytes[this.index++];
    }

    @Override
    public int read() throws IOException {
        int n = this.internalRead();
        switch (n) {
            case 13: {
                n = this.internalRead();
                if (n != 10) {
                    this.unread((char)n);
                    n = 10;
                    ++this.line;
                    break;
                }
                ++this.offset;
                break;
            }
            case 10: {
                ++this.line;
            }
        }
        return n;
    }

    @Override
    public ByteList readLineBytes() throws IOException {
        int n = 0;
        int n2 = this.read();
        while (n2 != 10 && n2 != -1) {
            ++n;
            n2 = this.read();
        }
        return new ByteList(this.bytes, this.index - n - 1, n, false);
    }

    @Override
    public int skipUntil(int n) throws IOException {
        n = this.read();
        while (n != 10 && n != -1) {
            n = this.read();
        }
        return n;
    }

    @Override
    public void unread(int n) {
        if (n == -1) {
            return;
        }
        --this.index;
        if (n == 10) {
            --this.line;
        }
    }

    @Override
    public void unreadMany(CharSequence charSequence) {
        int n = charSequence.length();
        this.index -= n;
    }

    @Override
    public boolean wasBeginOfLine() {
        return this.index == 0 || this.bytes[this.index - 1] == 10;
    }

    @Override
    public boolean lastWasBeginOfLine() {
        return this.index == 0 || this.bytes[this.index] == 10;
    }

    public static LexerSource getSource(String string, ByteList byteList, List<String> list, ParserConfiguration parserConfiguration) {
        if (list != null) {
            return new CapturingByteListLexerSource(string, byteList, list, parserConfiguration.getLineNumber(), parserConfiguration.hasExtraPositionInformation());
        }
        return new ByteListLexerSource(string, byteList, list, parserConfiguration.getLineNumber(), parserConfiguration.hasExtraPositionInformation());
    }

    @Override
    public int getOffset() {
        return this.index - this.begin + this.offset;
    }

    @Override
    public ByteList readUntil(char c) throws IOException {
        int n;
        int n2;
        for (n2 = n = this.index; n2 < this.realSize && this.bytes[n2] != c; ++n2) {
        }
        if (n2 >= this.realSize) {
            return null;
        }
        this.index = n2;
        return new ByteList(this.bytes, n, n2 - n, false);
    }

    public String toString() {
        try {
            ByteList byteList = new ByteList(20);
            byteList.append(this.bytes[this.index - 1]);
            byteList.append(this.bytes[this.index]);
            byteList.append(new byte[]{45, 62});
            for (int i = this.index + 1; i < this.index + 20 && this.index <= this.realSize; ++i) {
                byteList.append(this.bytes[i]);
            }
            byteList.append(new byte[]{32, 46, 46, 46});
            return byteList.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int chompReadAhead() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isANewLine() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIsANewLine(boolean bl) {
    }

    @Override
    public void setOffset(int n) {
    }
}

