/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.internal.runtime.methods;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyInstanceConfig;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.anno.JavaMethodDescriptor;
import org.jruby.nb.nb.nb.compiler.ASTInspector;
import org.jruby.nb.nb.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.nb.nb.compiler.impl.StandardASMCompiler;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.nb.nb.internal.runtime.methods.CompiledMethod;
import org.jruby.nb.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.MethodFactory;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.CodegenUtils;
import org.jruby.nb.nb.nb.util.JRubyClassLoader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationMethodFactory
extends MethodFactory
implements Opcodes {
    private static final boolean DEBUG = false;
    private static final String COMPILED_SUPER_CLASS = CodegenUtils.p(CompiledMethod.class);
    private static final String COMPILED_CALL_SIG = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class));
    private static final String COMPILED_CALL_SIG_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    private static final String COMPILED_CALL_SIG_ONE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_ONE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_TWO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_TWO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_THREE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_THREE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
    private static final String JAVA_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class));
    private static final String JAVA_INDEXED_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class, Integer.TYPE));
    public static final int THIS_INDEX = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int RECEIVER_INDEX = 2;
    public static final int CLASS_INDEX = 3;
    public static final int NAME_INDEX = 4;
    public static final int ARGS_INDEX = 5;
    public static final int BLOCK_INDEX = 6;
    protected JRubyClassLoader classLoader;
    private boolean seenUndefinedClasses = false;

    public InvocationMethodFactory(ClassLoader classLoader) {
        this.classLoader = classLoader instanceof JRubyClassLoader ? (JRubyClassLoader)classLoader : new JRubyClassLoader(classLoader);
    }

    @Override
    public DynamicMethod getCompiledMethodLazily(RubyModule rubyModule, String string, Arity arity, Visibility visibility, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        return new CompiledMethod.LazyCompiledMethod(rubyModule, string, arity, visibility, staticScope, object, callConfiguration, new InvocationMethodFactory(this.classLoader));
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule rubyModule, String string, Arity arity, Visibility visibility, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        String string2 = COMPILED_SUPER_CLASS;
        Class<?> clazz = object.getClass();
        String string3 = clazz.getName() + "Invoker" + string + arity;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(string3);
            try {
                Object object2;
                if (clazz2 == null) {
                    object2 = CodegenUtils.p(clazz);
                    String string4 = (String)object2 + "Invoker" + string + arity;
                    ClassWriter classWriter = this.createCompiledCtor(string4, string2);
                    SkinnyMethodAdapter skinnyMethodAdapter = null;
                    String string5 = null;
                    boolean bl = false;
                    if (staticScope.getRestArg() >= 0 || staticScope.getOptionalArgs() > 0 || staticScope.getRequiredArgs() > 3) {
                        string5 = COMPILED_CALL_SIG_BLOCK;
                        skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "call", string5, null, null));
                    } else {
                        bl = true;
                        skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "call", COMPILED_CALL_SIG_BLOCK, null, null));
                        skinnyMethodAdapter.start();
                        skinnyMethodAdapter.aload(1);
                        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                        skinnyMethodAdapter.aload(5);
                        skinnyMethodAdapter.pushInt(staticScope.getRequiredArgs());
                        skinnyMethodAdapter.pushInt(staticScope.getRequiredArgs());
                        skinnyMethodAdapter.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
                        skinnyMethodAdapter.pop();
                        skinnyMethodAdapter.aload(0);
                        skinnyMethodAdapter.aload(1);
                        skinnyMethodAdapter.aload(2);
                        skinnyMethodAdapter.aload(3);
                        skinnyMethodAdapter.aload(4);
                        for (int i = 0; i < staticScope.getRequiredArgs(); ++i) {
                            skinnyMethodAdapter.aload(5);
                            skinnyMethodAdapter.ldc(i);
                            skinnyMethodAdapter.arrayload();
                        }
                        skinnyMethodAdapter.aload(6);
                        switch (staticScope.getRequiredArgs()) {
                            case 0: {
                                string5 = COMPILED_CALL_SIG_ZERO_BLOCK;
                                break;
                            }
                            case 1: {
                                string5 = COMPILED_CALL_SIG_ONE_BLOCK;
                                break;
                            }
                            case 2: {
                                string5 = COMPILED_CALL_SIG_TWO_BLOCK;
                                break;
                            }
                            case 3: {
                                string5 = COMPILED_CALL_SIG_THREE_BLOCK;
                            }
                        }
                        skinnyMethodAdapter.invokevirtual(string4, "call", string5);
                        skinnyMethodAdapter.areturn();
                        skinnyMethodAdapter.end();
                        skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "call", string5, null, null));
                    }
                    skinnyMethodAdapter.visitCode();
                    Label label = new Label();
                    skinnyMethodAdapter.visitLineNumber(0, label);
                    if (!callConfiguration.isNoop()) {
                        if (bl) {
                            this.invokeCallConfigPre(skinnyMethodAdapter, COMPILED_SUPER_CLASS, staticScope.getRequiredArgs(), true, callConfiguration);
                        } else {
                            this.invokeCallConfigPre(skinnyMethodAdapter, COMPILED_SUPER_CLASS, -1, true, callConfiguration);
                        }
                    }
                    Label label2 = new Label();
                    Label label3 = new Label();
                    Label label4 = new Label();
                    Label label5 = new Label();
                    Label label6 = new Label();
                    Label label7 = new Label();
                    Label label8 = new Label();
                    if (callConfiguration != CallConfiguration.FRAME_ONLY) {
                        skinnyMethodAdapter.trycatch(label2, label3, label7, CodegenUtils.p(JumpException.ReturnJump.class));
                    }
                    skinnyMethodAdapter.trycatch(label2, label3, label8, CodegenUtils.p(JumpException.RedoJump.class));
                    skinnyMethodAdapter.trycatch(label2, label3, label4, null);
                    if (callConfiguration != CallConfiguration.FRAME_ONLY) {
                        skinnyMethodAdapter.trycatch(label7, label5, label4, null);
                    }
                    skinnyMethodAdapter.trycatch(label8, label6, label4, null);
                    skinnyMethodAdapter.label(label2);
                    skinnyMethodAdapter.aload(0);
                    skinnyMethodAdapter.getfield(string4, "$scriptObject", CodegenUtils.ci(Object.class));
                    skinnyMethodAdapter.checkcast((String)object2);
                    skinnyMethodAdapter.aload(1);
                    skinnyMethodAdapter.aload(2);
                    if (bl) {
                        for (int i = 0; i < staticScope.getRequiredArgs(); ++i) {
                            skinnyMethodAdapter.aload(5 + i);
                        }
                        skinnyMethodAdapter.aload(5 + staticScope.getRequiredArgs());
                        skinnyMethodAdapter.invokevirtual((String)object2, string, StandardASMCompiler.METHOD_SIGNATURES[staticScope.getRequiredArgs()]);
                    } else {
                        skinnyMethodAdapter.aload(5);
                        skinnyMethodAdapter.aload(6);
                        skinnyMethodAdapter.invokevirtual((String)object2, string, StandardASMCompiler.METHOD_SIGNATURES[4]);
                    }
                    skinnyMethodAdapter.label(label3);
                    if (!callConfiguration.isNoop()) {
                        this.invokeCallConfigPost(skinnyMethodAdapter, COMPILED_SUPER_CLASS, callConfiguration);
                    }
                    skinnyMethodAdapter.visitInsn(176);
                    if (callConfiguration != CallConfiguration.FRAME_ONLY) {
                        skinnyMethodAdapter.label(label7);
                        skinnyMethodAdapter.aload(0);
                        skinnyMethodAdapter.swap();
                        skinnyMethodAdapter.aload(1);
                        skinnyMethodAdapter.swap();
                        skinnyMethodAdapter.invokevirtual(COMPILED_SUPER_CLASS, "handleReturn", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, JumpException.ReturnJump.class));
                        skinnyMethodAdapter.label(label5);
                        if (!callConfiguration.isNoop()) {
                            this.invokeCallConfigPost(skinnyMethodAdapter, COMPILED_SUPER_CLASS, callConfiguration);
                        }
                        skinnyMethodAdapter.areturn();
                    }
                    skinnyMethodAdapter.label(label8);
                    skinnyMethodAdapter.pop();
                    skinnyMethodAdapter.aload(1);
                    skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                    skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "newRedoLocalJumpError", CodegenUtils.sig(RaiseException.class, new Class[0]));
                    skinnyMethodAdapter.label(label6);
                    if (!callConfiguration.isNoop()) {
                        this.invokeCallConfigPost(skinnyMethodAdapter, COMPILED_SUPER_CLASS, callConfiguration);
                    }
                    skinnyMethodAdapter.athrow();
                    skinnyMethodAdapter.label(label4);
                    if (!callConfiguration.isNoop()) {
                        this.invokeCallConfigPost(skinnyMethodAdapter, COMPILED_SUPER_CLASS, callConfiguration);
                    }
                    skinnyMethodAdapter.athrow();
                    clazz2 = this.endCall(classWriter, skinnyMethodAdapter, string3);
                }
                object2 = (CompiledMethod)clazz2.newInstance();
                ((CompiledMethod)object2).init(rubyModule, arity, visibility, staticScope, object, callConfiguration);
                return object2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw rubyModule.getRuntime().newLoadError(exception.getMessage());
            }
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule rubyModule, List<JavaMethodDescriptor> list) {
        JavaMethodDescriptor javaMethodDescriptor = list.get(0);
        String string = javaMethodDescriptor.name;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            try {
                Class clazz = this.getAnnotatedMethodClass(list);
                int n = Integer.MAX_VALUE;
                int n2 = 0;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                for (JavaMethodDescriptor javaMethodDescriptor2 : list) {
                    int n3 = -1;
                    if (javaMethodDescriptor2.optional == 0 && !javaMethodDescriptor2.rest) {
                        if (javaMethodDescriptor2.required == 0) {
                            n3 = javaMethodDescriptor2.actualRequired <= 3 ? javaMethodDescriptor2.actualRequired : -1;
                        } else if (javaMethodDescriptor2.required >= 0 && javaMethodDescriptor2.required <= 3) {
                            n3 = javaMethodDescriptor2.required;
                        }
                    }
                    if (n3 < n) {
                        n = n3;
                    }
                    if (n3 > n2) {
                        n2 = n3;
                    }
                    bl |= javaMethodDescriptor2.anno.frame();
                    bl2 |= javaMethodDescriptor2.anno.scope();
                    bl3 |= javaMethodDescriptor2.anno.backtrace();
                }
                JavaMethod javaMethod = (JavaMethod)clazz.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{rubyModule, javaMethodDescriptor.anno.visibility()});
                javaMethod.setArity(Arity.OPTIONAL);
                javaMethod.setJavaName(string);
                javaMethod.setSingleton(javaMethodDescriptor.isStatic);
                javaMethod.setCallConfig(CallConfiguration.getCallConfig(bl, bl2, bl3));
                return javaMethod;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw rubyModule.getRuntime().newLoadError(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAnnotatedMethodClass(List<JavaMethodDescriptor> list) throws Exception {
        if (list.size() == 1) {
            return this.getAnnotatedMethodClass(list.get(0));
        }
        JavaMethodDescriptor javaMethodDescriptor = list.get(0);
        String string = javaMethodDescriptor.name;
        String string2 = CodegenUtils.getAnnotatedBindingClassName(string, javaMethodDescriptor.declaringClassName, javaMethodDescriptor.isStatic, javaMethodDescriptor.actualRequired, javaMethodDescriptor.optional, true, javaMethodDescriptor.anno.frame());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            string2 = string2 + "_DBG";
        }
        String string3 = string2.replace('.', '/');
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            for (JavaMethodDescriptor object : list) {
                int n3 = -1;
                if (object.hasVarArgs) {
                    bl = true;
                } else {
                    if (object.optional == 0 && !object.rest) {
                        if (object.required == 0) {
                            n3 = object.actualRequired <= 3 ? object.actualRequired : -1;
                        } else if (object.required >= 0 && object.required <= 3) {
                            n3 = object.required;
                        }
                    }
                    if (n3 < n) {
                        n = n3;
                    }
                    if (n3 > n2) {
                        n2 = n3;
                    }
                }
                bl2 |= object.hasBlock;
            }
            if (clazz == null) {
                Object object2 = null;
                switch (n) {
                    case 0: {
                        switch (n2) {
                            case 1: {
                                if (bl) {
                                    if (bl2) {
                                        object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrNBlock.class);
                                        break;
                                    }
                                    object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrN.class);
                                    break;
                                }
                                if (bl2) {
                                    object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneBlock.class);
                                    break;
                                }
                                object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOne.class);
                                break;
                            }
                            case 2: {
                                if (bl) {
                                    if (bl2) {
                                        object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoOrNBlock.class);
                                        break;
                                    }
                                    object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoOrN.class);
                                    break;
                                }
                                if (bl2) {
                                    object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoBlock.class);
                                    break;
                                }
                                object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwo.class);
                                break;
                            }
                            case 3: {
                                if (bl) {
                                    if (bl2) {
                                        object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoOrThreeOrNBlock.class);
                                        break;
                                    }
                                    object2 = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoOrThreeOrN.class);
                                    break;
                                }
                                object2 = bl2 ? CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoOrThreeBlock.class) : CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoOrThree.class);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (n2) {
                            case 2: {
                                if (bl2) {
                                    object2 = CodegenUtils.p(JavaMethod.JavaMethodOneOrTwoBlock.class);
                                    break;
                                }
                                object2 = CodegenUtils.p(JavaMethod.JavaMethodOneOrTwo.class);
                                break;
                            }
                            case 3: {
                                object2 = bl2 ? CodegenUtils.p(JavaMethod.JavaMethodOneOrTwoOrThreeBlock.class) : CodegenUtils.p(JavaMethod.JavaMethodOneOrTwoOrThree.class);
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (n2) {
                            case 3: {
                                object2 = CodegenUtils.p(JavaMethod.JavaMethodTwoOrThree.class);
                            }
                        }
                        break;
                    }
                    case -1: {
                        object2 = CodegenUtils.p(JavaMethod.JavaMethodNoBlock.class);
                    }
                }
                if (object2 == null) {
                    throw new RuntimeException("invalid multi combination");
                }
                ClassWriter classWriter = this.createJavaMethodCtor(string3, (String)object2);
                for (JavaMethodDescriptor javaMethodDescriptor2 : list) {
                    int n4 = -1;
                    if (javaMethodDescriptor2.optional == 0 && !javaMethodDescriptor2.rest) {
                        if (javaMethodDescriptor2.required == 0) {
                            n4 = javaMethodDescriptor2.actualRequired <= 3 ? javaMethodDescriptor2.actualRequired : -1;
                        } else if (javaMethodDescriptor2.required >= 0 && javaMethodDescriptor2.required <= 3) {
                            n4 = javaMethodDescriptor2.required;
                        }
                    }
                    boolean bl3 = javaMethodDescriptor2.hasBlock;
                    SkinnyMethodAdapter skinnyMethodAdapter = null;
                    skinnyMethodAdapter = this.beginMethod(classWriter, "call", n4, bl3);
                    skinnyMethodAdapter.visitCode();
                    Label label = new Label();
                    skinnyMethodAdapter.visitLineNumber(0, label);
                    this.createAnnotatedMethodInvocation(javaMethodDescriptor2, skinnyMethodAdapter, (String)object2, n4, bl3);
                    this.endMethod(skinnyMethodAdapter);
                }
                clazz = this.endClass(classWriter, string2);
            }
            return clazz;
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule rubyModule, JavaMethodDescriptor javaMethodDescriptor) {
        String string = javaMethodDescriptor.name;
        String string2 = CodegenUtils.getAnnotatedBindingClassName(string, javaMethodDescriptor.declaringClassName, javaMethodDescriptor.isStatic, javaMethodDescriptor.actualRequired, javaMethodDescriptor.optional, false, javaMethodDescriptor.anno.frame());
        String string3 = string2.replace('.', '/');
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            try {
                Class clazz = this.getAnnotatedMethodClass(javaMethodDescriptor);
                JavaMethod javaMethod = (JavaMethod)clazz.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{rubyModule, javaMethodDescriptor.anno.visibility()});
                javaMethod.setArity(Arity.fromAnnotation(javaMethodDescriptor.anno, javaMethodDescriptor.actualRequired));
                javaMethod.setJavaName(string);
                javaMethod.setSingleton(javaMethodDescriptor.isStatic);
                javaMethod.setCallConfig(CallConfiguration.getCallConfigByAnno(javaMethodDescriptor.anno));
                return javaMethod;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw rubyModule.getRuntime().newLoadError(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAnnotatedMethodClass(JavaMethodDescriptor javaMethodDescriptor) throws Exception {
        String string = javaMethodDescriptor.name;
        String string2 = CodegenUtils.getAnnotatedBindingClassName(string, javaMethodDescriptor.declaringClassName, javaMethodDescriptor.isStatic, javaMethodDescriptor.actualRequired, javaMethodDescriptor.optional, false, javaMethodDescriptor.anno.frame());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            string2 = string2 + "_DBG";
        }
        String string3 = string2.replace('.', '/');
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class clazz = this.tryClass(string2);
            if (clazz == null) {
                int n = -1;
                if (javaMethodDescriptor.optional == 0 && !javaMethodDescriptor.rest) {
                    if (javaMethodDescriptor.required == 0) {
                        n = javaMethodDescriptor.actualRequired <= 3 ? javaMethodDescriptor.actualRequired : -1;
                    } else if (javaMethodDescriptor.required >= 0 && javaMethodDescriptor.required <= 3) {
                        n = javaMethodDescriptor.required;
                    }
                }
                boolean bl = javaMethodDescriptor.hasBlock;
                String string4 = CodegenUtils.p(this.selectSuperClass(n, bl));
                ClassWriter classWriter = this.createJavaMethodCtor(string3, string4);
                SkinnyMethodAdapter skinnyMethodAdapter = null;
                skinnyMethodAdapter = this.beginMethod(classWriter, "call", n, bl);
                skinnyMethodAdapter.visitCode();
                Label label = new Label();
                skinnyMethodAdapter.visitLineNumber(0, label);
                this.createAnnotatedMethodInvocation(javaMethodDescriptor, skinnyMethodAdapter, string4, n, bl);
                this.endMethod(skinnyMethodAdapter);
                clazz = this.endClass(classWriter, string2);
            }
            return clazz;
        }
    }

    public void prepareAnnotatedMethod(RubyModule rubyModule, JavaMethod javaMethod, JavaMethodDescriptor javaMethodDescriptor) {
        String string = javaMethodDescriptor.name;
        javaMethod.setArity(Arity.fromAnnotation(javaMethodDescriptor.anno, javaMethodDescriptor.actualRequired));
        javaMethod.setJavaName(string);
        javaMethod.setSingleton(javaMethodDescriptor.isStatic);
        javaMethod.setCallConfig(CallConfiguration.getCallConfigByAnno(javaMethodDescriptor.anno));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void defineIndexedAnnotatedMethods(RubyModule rubyModule, Class clazz, MethodFactory.MethodDefiningCallback methodDefiningCallback) {
        String string = CodegenUtils.p(clazz);
        String string2 = CodegenUtils.p(JavaMethod.class);
        String string3 = clazz.getName() + "Invoker";
        String string4 = string + "Invoker";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class clazz2 = this.tryClass(string3);
            try {
                Object object;
                Object object2;
                ArrayList<Method> arrayList = new ArrayList<Method>();
                Method[] methodArray = clazz.getDeclaredMethods();
                for (Method object32 : methodArray) {
                    object2 = object32.getAnnotation(JRubyMethod.class);
                    if (object2 == null) continue;
                    arrayList.add(object32);
                }
                ArrayList arrayList2 = new ArrayList(arrayList);
                Collections.sort(arrayList2, new Comparator<Method>(){

                    @Override
                    public int compare(Method method, Method method2) {
                        return method.getName().compareTo(method2.getName());
                    }
                });
                HashMap hashMap = new HashMap();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    hashMap.put(arrayList2.get(i), i);
                }
                if (clazz2 == null) {
                    int n;
                    ClassWriter classWriter = this.createIndexedJavaMethodCtor(string4, string2);
                    Object var15_20 = null;
                    SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "call", COMPILED_CALL_SIG_BLOCK, null, null));
                    skinnyMethodAdapter.visitCode();
                    object2 = new Label();
                    skinnyMethodAdapter.visitLineNumber(0, (Label)object2);
                    Label label = new Label();
                    object = new Label[arrayList2.size()];
                    for (n = 0; n < ((Label[])object).length; ++n) {
                        object[n] = new Label();
                    }
                    skinnyMethodAdapter.aload(0);
                    skinnyMethodAdapter.getfield(string4, "methodIndex", CodegenUtils.ci(Integer.TYPE));
                    skinnyMethodAdapter.tableswitch(0, ((Label[])object).length - 1, label, (Label[])object);
                    for (n = 0; n < arrayList2.size(); ++n) {
                        skinnyMethodAdapter.label((Label)object[n]);
                        String string5 = this.getAnnotatedMethodForIndex(classWriter, (Method)arrayList2.get(n), n, string2);
                        skinnyMethodAdapter.aload(0);
                        skinnyMethodAdapter.aload(1);
                        skinnyMethodAdapter.aload(2);
                        skinnyMethodAdapter.aload(3);
                        skinnyMethodAdapter.aload(4);
                        skinnyMethodAdapter.aload(5);
                        skinnyMethodAdapter.aload(6);
                        skinnyMethodAdapter.invokevirtual(string4, string5, COMPILED_CALL_SIG_BLOCK);
                        skinnyMethodAdapter.areturn();
                    }
                    skinnyMethodAdapter.label(label);
                    skinnyMethodAdapter.aload(1);
                    skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                    skinnyMethodAdapter.ldc("Error: fell off switched invoker for class: " + rubyModule.getBaseName());
                    skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "newRuntimeError", CodegenUtils.sig(RaiseException.class, String.class));
                    skinnyMethodAdapter.athrow();
                    clazz2 = this.endCall(classWriter, skinnyMethodAdapter, string3);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    Method method = (Method)arrayList.get(i);
                    object2 = method.getAnnotation(JRubyMethod.class);
                    if (object2.frame()) {
                        for (String string5 : object2.name()) {
                            ASTInspector.FRAME_AWARE_METHODS.add(string5);
                        }
                    }
                    int n = (Integer)hashMap.get(method);
                    object = (JavaMethod)clazz2.getConstructor(RubyModule.class, Visibility.class, Integer.TYPE).newInstance(new Object[]{rubyModule, object2.visibility(), n});
                    ((JavaMethod)object).setArity(Arity.fromAnnotation((JRubyMethod)object2));
                    ((JavaMethod)object).setJavaName(method.getName());
                    ((JavaMethod)object).setSingleton(Modifier.isStatic(method.getModifiers()));
                    ((DynamicMethod)object).setCallConfig(CallConfiguration.getCallConfigByAnno((JRubyMethod)object2));
                    methodDefiningCallback.define(rubyModule, new JavaMethodDescriptor(method), (DynamicMethod)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw rubyModule.getRuntime().newLoadError(exception.getMessage());
            }
        }
    }

    private void checkArity(SkinnyMethodAdapter skinnyMethodAdapter, StaticScope staticScope) {
        Label label = new Label();
        Label label2 = new Label();
        if (staticScope.getRestArg() >= 0) {
            if (staticScope.getRequiredArgs() > 0) {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.arraylength();
                skinnyMethodAdapter.ldc(staticScope.getRequiredArgs());
                skinnyMethodAdapter.if_icmplt(label);
            }
        } else if (staticScope.getOptionalArgs() > 0) {
            if (staticScope.getRequiredArgs() > 0) {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.arraylength();
                skinnyMethodAdapter.ldc(staticScope.getRequiredArgs());
                skinnyMethodAdapter.if_icmplt(label);
            }
            skinnyMethodAdapter.aload(5);
            skinnyMethodAdapter.arraylength();
            skinnyMethodAdapter.ldc(staticScope.getRequiredArgs() + staticScope.getOptionalArgs());
            skinnyMethodAdapter.if_icmpgt(label);
        } else {
            skinnyMethodAdapter.aload(5);
            skinnyMethodAdapter.arraylength();
            skinnyMethodAdapter.ldc(staticScope.getRequiredArgs());
            skinnyMethodAdapter.if_icmpne(label);
        }
        skinnyMethodAdapter.go_to(label2);
        skinnyMethodAdapter.label(label);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        skinnyMethodAdapter.aload(5);
        skinnyMethodAdapter.ldc(staticScope.getRequiredArgs());
        skinnyMethodAdapter.ldc(staticScope.getRequiredArgs() + staticScope.getOptionalArgs());
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
        skinnyMethodAdapter.pop();
        skinnyMethodAdapter.label(label2);
    }

    private void checkArity(JRubyMethod jRubyMethod, SkinnyMethodAdapter skinnyMethodAdapter, int n) {
        Label label = new Label();
        Label label2 = new Label();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        if (jRubyMethod.rest()) {
            if (jRubyMethod.required() > 0) {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.arraylength();
                skinnyMethodAdapter.ldc(jRubyMethod.required());
                skinnyMethodAdapter.if_icmplt(label);
            }
        } else if (jRubyMethod.optional() > 0) {
            if (jRubyMethod.required() > 0) {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.arraylength();
                skinnyMethodAdapter.ldc(jRubyMethod.required());
                skinnyMethodAdapter.if_icmplt(label);
            }
            skinnyMethodAdapter.aload(5);
            skinnyMethodAdapter.arraylength();
            skinnyMethodAdapter.ldc(jRubyMethod.required() + jRubyMethod.optional());
            skinnyMethodAdapter.if_icmpgt(label);
        } else {
            skinnyMethodAdapter.aload(5);
            skinnyMethodAdapter.arraylength();
            skinnyMethodAdapter.ldc(jRubyMethod.required());
            skinnyMethodAdapter.if_icmpne(label);
        }
        skinnyMethodAdapter.go_to(label2);
        skinnyMethodAdapter.label(label);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        skinnyMethodAdapter.aload(5);
        skinnyMethodAdapter.ldc(jRubyMethod.required());
        skinnyMethodAdapter.ldc(jRubyMethod.required() + jRubyMethod.optional());
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
        skinnyMethodAdapter.pop();
        skinnyMethodAdapter.label(label2);
    }

    private ClassWriter createCompiledCtor(String string, String string2) throws Exception {
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visit(RubyInstanceConfig.JAVA_VERSION, 33, string, null, string2, null);
        classWriter.visitSource(string.replace('.', '/') + ".gen", null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string2, "<init>", "()V");
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        return classWriter;
    }

    private ClassWriter createJavaMethodCtor(String string, String string2) throws Exception {
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visit(RubyInstanceConfig.JAVA_VERSION, 33, string, null, string2, null);
        classWriter.visitSource(string.replace('.', '/') + ".gen", null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", JAVA_SUPER_SIG, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(183, string2, "<init>", JAVA_SUPER_SIG);
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        return classWriter;
    }

    @Deprecated
    private ClassWriter createIndexedJavaMethodCtor(String string, String string2) throws Exception {
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visit(RubyInstanceConfig.JAVA_VERSION, 33, string, null, string2, null);
        classWriter.visitSource(string.replace('.', '/') + ".gen", null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", JAVA_INDEXED_SUPER_SIG, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(21, 3);
        methodVisitor.visitMethodInsn(183, string2, "<init>", JAVA_INDEXED_SUPER_SIG);
        Label label = new Label();
        methodVisitor.visitLineNumber(0, label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        return classWriter;
    }

    private void invokeCallConfigPost(SkinnyMethodAdapter skinnyMethodAdapter, String string, CallConfiguration callConfiguration) {
        if (callConfiguration != CallConfiguration.NO_FRAME_NO_SCOPE) {
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.aload(1);
            if (callConfiguration == CallConfiguration.FRAME_AND_SCOPE) {
                skinnyMethodAdapter.invokevirtual(string, "postFrameAndScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfiguration == CallConfiguration.FRAME_ONLY) {
                skinnyMethodAdapter.invokevirtual(string, "postFrameOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfiguration == CallConfiguration.SCOPE_ONLY) {
                skinnyMethodAdapter.invokevirtual(string, "postScopeOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfiguration == CallConfiguration.BACKTRACE_ONLY) {
                skinnyMethodAdapter.invokevirtual(string, "postBacktraceOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfiguration == CallConfiguration.BACKTRACE_AND_SCOPE) {
                skinnyMethodAdapter.invokevirtual(string, "postBacktraceAndScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            }
        }
    }

    private void invokeCallConfigPre(SkinnyMethodAdapter skinnyMethodAdapter, String string, int n, boolean bl, CallConfiguration callConfiguration) {
        if (callConfiguration != CallConfiguration.NO_FRAME_NO_SCOPE) {
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.aload(1);
            if (callConfiguration == CallConfiguration.FRAME_AND_SCOPE) {
                skinnyMethodAdapter.aload(2);
                skinnyMethodAdapter.aload(4);
                this.loadBlockForPre(skinnyMethodAdapter, n, bl);
                skinnyMethodAdapter.invokevirtual(string, "preFrameAndScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class)));
            } else if (callConfiguration == CallConfiguration.FRAME_ONLY) {
                skinnyMethodAdapter.aload(2);
                skinnyMethodAdapter.aload(4);
                this.loadBlockForPre(skinnyMethodAdapter, n, bl);
                skinnyMethodAdapter.invokevirtual(string, "preFrameOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class)));
            } else if (callConfiguration == CallConfiguration.SCOPE_ONLY) {
                skinnyMethodAdapter.invokevirtual(string, "preScopeOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfiguration == CallConfiguration.BACKTRACE_ONLY) {
                skinnyMethodAdapter.aload(4);
                skinnyMethodAdapter.invokevirtual(string, "preBacktraceOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class)));
            } else if (callConfiguration == CallConfiguration.BACKTRACE_AND_SCOPE) {
                skinnyMethodAdapter.aload(4);
                skinnyMethodAdapter.invokevirtual(string, "preBacktraceAndScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class)));
            }
        }
    }

    private void loadArguments(SkinnyMethodAdapter skinnyMethodAdapter, JRubyMethod jRubyMethod, int n) {
        switch (n) {
            default: {
                skinnyMethodAdapter.aload(5);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                skinnyMethodAdapter.aload(5);
                break;
            }
            case 2: {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.aload(6);
                break;
            }
            case 3: {
                skinnyMethodAdapter.aload(5);
                skinnyMethodAdapter.aload(6);
                skinnyMethodAdapter.aload(7);
            }
        }
    }

    private void loadBlockForPre(SkinnyMethodAdapter skinnyMethodAdapter, int n, boolean bl) {
        switch (n) {
            default: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 6);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 0: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 5);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 1: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 6);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 2: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 7);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 3: {
                if (bl) {
                    skinnyMethodAdapter.visitVarInsn(25, 8);
                    break;
                }
                skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
        }
    }

    private void loadBlock(SkinnyMethodAdapter skinnyMethodAdapter, int n, boolean bl) {
        switch (n) {
            default: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 6);
                break;
            }
            case 0: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 5);
                break;
            }
            case 1: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 6);
                break;
            }
            case 2: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 7);
                break;
            }
            case 3: {
                if (!bl) break;
                skinnyMethodAdapter.visitVarInsn(25, 8);
            }
        }
    }

    private void loadReceiver(String string, JavaMethodDescriptor javaMethodDescriptor, SkinnyMethodAdapter skinnyMethodAdapter) {
        if (Modifier.isStatic(javaMethodDescriptor.modifiers)) {
            if (javaMethodDescriptor.hasContext) {
                skinnyMethodAdapter.aload(1);
            }
            skinnyMethodAdapter.aload(2);
        } else {
            skinnyMethodAdapter.aload(2);
            skinnyMethodAdapter.checkcast(string);
            if (javaMethodDescriptor.hasContext) {
                skinnyMethodAdapter.aload(1);
            }
        }
    }

    private Class tryClass(String string) {
        try {
            Class<?> clazz = null;
            clazz = this.classLoader == null ? Class.forName(string, true, this.classLoader) : this.classLoader.loadClass(string);
            if (clazz != null && this.seenUndefinedClasses) {
                System.err.println("WARNING: while creating new bindings, found an existing binding; likely a collision: " + string);
                Thread.dumpStack();
            }
            return clazz;
        }
        catch (Exception exception) {
            this.seenUndefinedClasses = true;
            return null;
        }
    }

    protected Class endCall(ClassWriter classWriter, MethodVisitor methodVisitor, String string) {
        this.endMethod(methodVisitor);
        return this.endClass(classWriter, string);
    }

    protected void endMethod(MethodVisitor methodVisitor) {
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    protected Class endClass(ClassWriter classWriter, String string) {
        classWriter.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        return this.classLoader.defineClass(string, byArray);
    }

    private void loadArgument(MethodVisitor methodVisitor, int n, int n2) {
        methodVisitor.visitVarInsn(25, n);
        methodVisitor.visitLdcInsn(new Integer(n2));
        methodVisitor.visitInsn(50);
    }

    private SkinnyMethodAdapter beginMethod(ClassWriter classWriter, String string, int n, boolean bl) {
        switch (n) {
            default: {
                if (bl) {
                    return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG, null, null));
            }
            case 0: {
                if (bl) {
                    return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_ZERO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_ZERO, null, null));
            }
            case 1: {
                if (bl) {
                    return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_ONE_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_ONE, null, null));
            }
            case 2: {
                if (bl) {
                    return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_TWO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_TWO, null, null));
            }
            case 3: 
        }
        if (bl) {
            return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_THREE_BLOCK, null, null));
        }
        return new SkinnyMethodAdapter(classWriter.visitMethod(1, string, COMPILED_CALL_SIG_THREE, null, null));
    }

    private Class selectSuperClass(int n, boolean bl) {
        switch (n) {
            default: {
                if (bl) {
                    return JavaMethod.class;
                }
                return JavaMethod.JavaMethodNoBlock.class;
            }
            case 0: {
                if (bl) {
                    return JavaMethod.JavaMethodZeroBlock.class;
                }
                return JavaMethod.JavaMethodZero.class;
            }
            case 1: {
                if (bl) {
                    return JavaMethod.JavaMethodOneBlock.class;
                }
                return JavaMethod.JavaMethodOne.class;
            }
            case 2: {
                if (bl) {
                    return JavaMethod.JavaMethodTwoBlock.class;
                }
                return JavaMethod.JavaMethodTwo.class;
            }
            case 3: 
        }
        if (bl) {
            return JavaMethod.JavaMethodThreeBlock.class;
        }
        return JavaMethod.JavaMethodThree.class;
    }

    @Deprecated
    private String getAnnotatedMethodForIndex(ClassWriter classWriter, Method method, int n, String string) {
        String string2 = "call" + n + "_" + method.getName();
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, string2, COMPILED_CALL_SIG_BLOCK, null, null));
        skinnyMethodAdapter.visitCode();
        Label label = new Label();
        skinnyMethodAdapter.visitLineNumber(0, label);
        this.createAnnotatedMethodInvocation(new JavaMethodDescriptor(method), skinnyMethodAdapter, string, -1, true);
        this.endMethod(skinnyMethodAdapter);
        return string2;
    }

    private void createAnnotatedMethodInvocation(JavaMethodDescriptor javaMethodDescriptor, SkinnyMethodAdapter skinnyMethodAdapter, String string, int n, boolean bl) {
        String string2 = javaMethodDescriptor.declaringClassPath;
        String string3 = javaMethodDescriptor.name;
        this.checkArity(javaMethodDescriptor.anno, skinnyMethodAdapter, n);
        CallConfiguration callConfiguration = CallConfiguration.getCallConfigByAnno(javaMethodDescriptor.anno);
        if (!callConfiguration.isNoop()) {
            this.invokeCallConfigPre(skinnyMethodAdapter, string, n, bl, callConfiguration);
        }
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.invokeCCallTrace(skinnyMethodAdapter);
        }
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Label label4 = new Label();
        Label label5 = new Label();
        if (!callConfiguration.isNoop()) {
            skinnyMethodAdapter.trycatch(label, label2, label3, null);
        }
        skinnyMethodAdapter.label(label);
        this.loadReceiver(string2, javaMethodDescriptor, skinnyMethodAdapter);
        this.loadArguments(skinnyMethodAdapter, javaMethodDescriptor.anno, n);
        this.loadBlock(skinnyMethodAdapter, n, bl);
        if (Modifier.isStatic(javaMethodDescriptor.modifiers)) {
            skinnyMethodAdapter.invokestatic(string2, string3, javaMethodDescriptor.signature);
        } else {
            skinnyMethodAdapter.invokevirtual(string2, string3, javaMethodDescriptor.signature);
        }
        skinnyMethodAdapter.label(label2);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.invokeCReturnTrace(skinnyMethodAdapter);
        }
        if (!callConfiguration.isNoop()) {
            this.invokeCallConfigPost(skinnyMethodAdapter, string, callConfiguration);
        }
        skinnyMethodAdapter.visitInsn(176);
        if (!callConfiguration.isNoop()) {
            skinnyMethodAdapter.label(label3);
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.invokeCReturnTrace(skinnyMethodAdapter);
            }
            if (!callConfiguration.isNoop()) {
                this.invokeCallConfigPost(skinnyMethodAdapter, string, callConfiguration);
            }
            skinnyMethodAdapter.athrow();
        }
    }

    private void invokeCCallTrace(SkinnyMethodAdapter skinnyMethodAdapter) {
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.aload(4);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(JavaMethod.class), "callTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String.class));
    }

    private void invokeCReturnTrace(SkinnyMethodAdapter skinnyMethodAdapter) {
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.aload(4);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(JavaMethod.class), "returnTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String.class));
    }
}

