/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.internal.runtime;

import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.nb.internal.runtime.GlobalVariable;
import org.jruby.nb.nb.nb.internal.runtime.ValueAccessor;
import org.jruby.nb.nb.nb.runtime.IAccessor;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

public class UndefinedAccessor
implements IAccessor {
    private final Ruby runtime;
    private final GlobalVariable globalVariable;
    private final String name;

    public UndefinedAccessor(Ruby ruby, GlobalVariable globalVariable, String string) {
        assert (ruby != null);
        assert (globalVariable != null);
        assert (string != null);
        this.runtime = ruby;
        this.globalVariable = globalVariable;
        this.name = string;
    }

    public IRubyObject getValue() {
        this.runtime.getWarnings().warning(IRubyWarnings.ID.ACCESSOR_NOT_INITIALIZED, "global variable `" + this.name + "' not initialized", this.name);
        return this.runtime.getNil();
    }

    public IRubyObject setValue(IRubyObject iRubyObject) {
        assert (iRubyObject != null);
        this.globalVariable.setAccessor(new ValueAccessor(iRubyObject));
        return iRubyObject;
    }
}

