/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ext.socket;

import com.sun.jna.ptr.IntByReference;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.ext.socket.RubyUNIXSocket;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"UNIXServer"}, parent="UNIXSocket")
public class RubyUNIXServer
extends RubyUNIXSocket {
    private static ObjectAllocator UNIXSERVER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyUNIXServer(ruby, rubyClass);
        }
    };

    static void createUNIXServer(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("UNIXServer", ruby.fastGetClass("UNIXSocket"), UNIXSERVER_ALLOCATOR);
        ruby.getObject().fastSetConstant("UNIXserver", rubyClass);
        rubyClass.defineAnnotatedMethods(RubyUNIXServer.class);
    }

    public RubyUNIXServer(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject iRubyObject) throws Exception {
        this.init_unixsock(iRubyObject, true);
        return this;
    }

    @JRubyMethod
    public IRubyObject accept() throws Exception {
        RubyUNIXSocket.LibCSocket.sockaddr_un sockaddr_un2 = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        int n = INSTANCE.accept(this.fd, sockaddr_un2, new IntByReference(106));
        if (n < 0) {
            this.rb_sys_fail(null);
        }
        Ruby ruby = this.getRuntime();
        RubyUNIXSocket rubyUNIXSocket = (RubyUNIXSocket)RuntimeHelpers.invoke(ruby.getCurrentContext(), ruby.fastGetClass("UNIXSocket"), "allocate");
        rubyUNIXSocket.fd = n;
        rubyUNIXSocket.fpath = new String(sockaddr_un2.sun_path);
        rubyUNIXSocket.init_sock();
        return rubyUNIXSocket;
    }

    @JRubyMethod
    public IRubyObject accept_nonblock() throws Exception {
        RubyUNIXSocket.LibCSocket.sockaddr_un sockaddr_un2 = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        IntByReference intByReference = new IntByReference(106);
        int n = INSTANCE.fcntl(this.fd, 3, 0);
        INSTANCE.fcntl(this.fd, 4, n | 4);
        int n2 = INSTANCE.accept(this.fd, sockaddr_un2, new IntByReference(106));
        if (n2 < 0) {
            this.rb_sys_fail(null);
        }
        Ruby ruby = this.getRuntime();
        RubyUNIXSocket rubyUNIXSocket = (RubyUNIXSocket)RuntimeHelpers.invoke(ruby.getCurrentContext(), ruby.fastGetClass("UNIXSocket"), "allocate");
        rubyUNIXSocket.fd = n2;
        rubyUNIXSocket.fpath = new String(sockaddr_un2.sun_path);
        rubyUNIXSocket.init_sock();
        return rubyUNIXSocket;
    }

    @JRubyMethod
    public IRubyObject sysaccept() throws Exception {
        return this.accept();
    }

    @JRubyMethod
    public IRubyObject listen(IRubyObject iRubyObject) {
        if (INSTANCE.listen(this.fd, RubyNumeric.fix2int(iRubyObject)) < 0) {
            this.rb_sys_fail("listen(2)");
        }
        return this.getRuntime().newFixnum(0);
    }
}

