/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ext.ffi;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.ext.ffi.Factory;

public abstract class Platform {
    private static final String DARWIN = "darwin";
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String FREEBSD = "freebsd";
    private static final String OPENBSD = "openbsd";
    private static final String SOLARIS = "solaris";
    public static final Map<String, String> OS_NAMES = new HashMap<String, String>(){
        {
            this.put("Mac OS X", Platform.DARWIN);
        }
    };
    public static final Map<String, String> ARCH_NAMES = new HashMap<String, String>(){
        {
            this.put("x86", "i386");
        }
    };
    public static final String ARCH = Platform.getArchitecture();
    public static final String OS = Platform.getOperatingSystem();
    public static final boolean IS_WINDOWS = OS.equals("windows");
    public static final boolean IS_MAC = OS.equals("darwin");
    public static final boolean IS_FREEBSD = OS.equals("freebsd");
    public static final boolean IS_OPENBSD = OS.equals("openbsd");
    public static final boolean IS_LINUX = OS.equals("linux");
    public static final boolean IS_SOLARIS = OS.equals("solaris");
    public static final boolean IS_BSD = IS_MAC || IS_FREEBSD || IS_OPENBSD;
    public static final String LIBC = IS_WINDOWS ? "msvcrt" : "c";
    public static final String NAME = String.format("%s-%s", ARCH, OS);
    public static final int BIG_ENDIAN = 4321;
    public static final int LITTLE_ENDIAN = 1234;
    public static final int BYTE_ORDER = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234;

    public static final Platform getPlatform() {
        return Factory.getInstance().getPlatform();
    }

    private static final String getOperatingSystem() {
        String string = System.getProperty("os.name").toLowerCase();
        for (String string2 : OS_NAMES.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return OS_NAMES.get(string2);
        }
        if (string.startsWith(WINDOWS)) {
            return WINDOWS;
        }
        return string;
    }

    private static final String getArchitecture() {
        String string = System.getProperty("os.arch").toLowerCase();
        for (String string2 : ARCH_NAMES.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return ARCH_NAMES.get(string2);
        }
        return string;
    }

    protected Platform() {
    }

    public void init(Ruby ruby, RubyModule rubyModule) {
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("Platform");
        rubyModule2.defineConstant("ADDRESS_SIZE", ruby.newFixnum(this.addressSize()));
        rubyModule2.defineConstant("LONG_SIZE", ruby.newFixnum(this.longSize()));
        rubyModule2.defineConstant("OS", ruby.newString(OS));
        rubyModule2.defineConstant("ARCH", ruby.newString(ARCH));
        rubyModule2.defineConstant("NAME", ruby.newString(NAME));
        rubyModule2.defineConstant("IS_WINDOWS", ruby.newBoolean(IS_WINDOWS));
        rubyModule2.defineConstant("IS_BSD", ruby.newBoolean(IS_BSD));
        rubyModule2.defineConstant("IS_FREEBSD", ruby.newBoolean(IS_FREEBSD));
        rubyModule2.defineConstant("IS_OPENBSD", ruby.newBoolean(IS_OPENBSD));
        rubyModule2.defineConstant("IS_SOLARIS", ruby.newBoolean(IS_SOLARIS));
        rubyModule2.defineConstant("IS_LINUX", ruby.newBoolean(IS_LINUX));
        rubyModule2.defineConstant("IS_MAC", ruby.newBoolean(IS_MAC));
        rubyModule2.defineConstant("LIBC", ruby.newString(LIBC));
        rubyModule2.defineConstant("BYTE_ORDER", ruby.newFixnum(BYTE_ORDER));
        rubyModule2.defineConstant("BIG_ENDIAN", ruby.newFixnum(4321));
        rubyModule2.defineConstant("LITTLE_ENDIAN", ruby.newFixnum(1234));
    }

    public static String getProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public abstract int addressSize();

    public abstract int longSize();
}

