/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ext;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jline.CandidateListCompletionHandler;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.History;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.load.Library;

@JRubyModule(name={"Readline"}, include={"Enumerable"})
public class Readline {
    public static void createReadline(Ruby ruby) throws IOException {
        ConsoleHolder consoleHolder = new ConsoleHolder();
        consoleHolder.history = new History();
        consoleHolder.currentCompletor = null;
        RubyModule rubyModule = ruby.defineModule("Readline");
        rubyModule.dataWrapStruct(consoleHolder);
        rubyModule.defineAnnotatedMethods(Readline.class);
        IRubyObject iRubyObject = ruby.getObject().callMethod(ruby.getCurrentContext(), "new");
        rubyModule.fastSetConstant("HISTORY", iRubyObject);
        iRubyObject.getSingletonClass().includeModule(ruby.getEnumerable());
        iRubyObject.getSingletonClass().defineAnnotatedMethods(HistoryMethods.class);
        rubyModule.fastSetConstant("VERSION", ruby.newString("JLine wrapper"));
    }

    protected static void initReadline(Ruby ruby, ConsoleHolder consoleHolder) throws IOException {
        consoleHolder.readline = new ConsoleReader();
        consoleHolder.readline.setUseHistory(false);
        consoleHolder.readline.setUsePagination(true);
        consoleHolder.readline.setBellEnabled(false);
        ((CandidateListCompletionHandler)consoleHolder.readline.getCompletionHandler()).setAlwaysIncludeNewline(false);
        if (consoleHolder.currentCompletor == null) {
            consoleHolder.currentCompletor = new RubyFileNameCompletor();
        }
        consoleHolder.readline.addCompletor(consoleHolder.currentCompletor);
        consoleHolder.readline.setHistory(consoleHolder.history);
    }

    public static History getHistory(ConsoleHolder consoleHolder) {
        return consoleHolder.history;
    }

    public static ConsoleHolder getHolder(Ruby ruby) {
        return (ConsoleHolder)ruby.fastGetModule("Readline").dataGetStruct();
    }

    public static void setCompletor(ConsoleHolder consoleHolder, Completor completor) {
        if (consoleHolder.readline != null) {
            consoleHolder.readline.removeCompletor(consoleHolder.currentCompletor);
        }
        consoleHolder.currentCompletor = completor;
        if (consoleHolder.readline != null) {
            consoleHolder.readline.addCompletor(consoleHolder.currentCompletor);
        }
    }

    public static Completor getCompletor(ConsoleHolder consoleHolder) {
        return consoleHolder.currentCompletor;
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) throws IOException {
        ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
        if (consoleHolder.readline == null) {
            Readline.initReadline(iRubyObject.getRuntime(), consoleHolder);
        }
        IRubyObject iRubyObject4 = iRubyObject.getRuntime().getNil();
        consoleHolder.readline.getTerminal().disableEcho();
        String string = consoleHolder.readline.readLine(iRubyObject2.toString());
        consoleHolder.readline.getTerminal().enableEcho();
        if (null != string) {
            if (iRubyObject3.isTrue()) {
                consoleHolder.readline.getHistory().addToHistory(string);
            }
            iRubyObject4 = iRubyObject.getRuntime().newString(string);
        }
        return iRubyObject4;
    }

    @JRubyMethod(name={"completion_append_character="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_append_character(IRubyObject iRubyObject, IRubyObject iRubyObject2) throws Exception {
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"completion_proc="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_proc(IRubyObject iRubyObject, IRubyObject iRubyObject2) throws Exception {
        if (!iRubyObject2.respondsTo("call")) {
            throw iRubyObject.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(Readline.getHolder(iRubyObject.getRuntime()), new ProcCompletor(iRubyObject2));
        return iRubyObject.getRuntime().getNil();
    }

    public static class RubyFileNameCompletor
    extends FileNameCompletor {
        public int complete(String string, int n, List list) {
            int n2 = (string = string.substring(0, n)).lastIndexOf(" ");
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            return n2 + 1 + super.complete(string, n, list);
        }
    }

    public static class ProcCompletor
    implements Completor {
        IRubyObject procCompletor;

        public ProcCompletor(IRubyObject iRubyObject) {
            this.procCompletor = iRubyObject;
        }

        public int complete(String string, int n, List list) {
            ThreadContext threadContext;
            IRubyObject iRubyObject;
            int n2 = (string = string.substring(0, n)).lastIndexOf(" ");
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            if ((iRubyObject = RuntimeHelpers.invoke(threadContext = this.procCompletor.getRuntime().getCurrentContext(), this.procCompletor, "call", this.procCompletor.getRuntime().newString(string)).callMethod(threadContext, MethodIndex.TO_A, "to_a")) instanceof List) {
                for (Object e : (List)((Object)iRubyObject)) {
                    if (e == null) continue;
                    list.add(e.toString());
                }
                Collections.sort(list);
            }
            return n - string.length();
        }
    }

    public static class HistoryMethods {
        @JRubyMethod(name={"push", "<<"}, rest=true)
        public static IRubyObject s_push(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) throws Exception {
            ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                RubyString rubyString = iRubyObjectArray[i].convertToString();
                consoleHolder.history.addToHistory(rubyString.getUnicodeValue());
            }
            return iRubyObject.getRuntime().getNil();
        }

        @JRubyMethod(name={"pop"})
        public static IRubyObject s_pop(IRubyObject iRubyObject) throws Exception {
            Ruby ruby = iRubyObject.getRuntime();
            ConsoleHolder consoleHolder = Readline.getHolder(ruby);
            List list = consoleHolder.history.getHistoryList();
            String string = (String)list.get(list.size() - 1);
            return ruby.newString(string);
        }

        @JRubyMethod(name={"to_a"})
        public static IRubyObject s_hist_to_a(IRubyObject iRubyObject) throws Exception {
            ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
            RubyArray rubyArray = iRubyObject.getRuntime().newArray();
            Iterator iterator = consoleHolder.history.getHistoryList().iterator();
            while (iterator.hasNext()) {
                rubyArray.append(iRubyObject.getRuntime().newString((String)iterator.next()));
            }
            return rubyArray;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject s_hist_to_s(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("HISTORY");
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject s_hist_get(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Ruby ruby = iRubyObject.getRuntime();
            ConsoleHolder consoleHolder = Readline.getHolder(ruby);
            int n = (int)iRubyObject2.convertToInteger().getLongValue();
            try {
                return ruby.newString((String)consoleHolder.history.getHistoryList().get(n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw ruby.newIndexError("invalid history index: " + n);
            }
        }

        @JRubyMethod(name={"[]="})
        public static IRubyObject s_hist_set(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            throw iRubyObject.getRuntime().newNotImplementedError("the []=() function is unimplemented on this machine");
        }

        @JRubyMethod(name={"shift"})
        public static IRubyObject s_hist_shift(IRubyObject iRubyObject) {
            throw iRubyObject.getRuntime().newNotImplementedError("the shift function is unimplemented on this machine");
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject s_hist_length(IRubyObject iRubyObject) {
            ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
            return iRubyObject.getRuntime().newFixnum(consoleHolder.history.size());
        }

        @JRubyMethod(name={"empty?"})
        public static IRubyObject s_hist_empty_p(IRubyObject iRubyObject) {
            ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
            return iRubyObject.getRuntime().newBoolean(consoleHolder.history.size() == 0);
        }

        @JRubyMethod(name={"delete_at"})
        public static IRubyObject s_hist_delete_at(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            throw iRubyObject.getRuntime().newNotImplementedError("the delete_at function is unimplemented on this machine");
        }

        @JRubyMethod(name={"each"})
        public static IRubyObject s_hist_each(IRubyObject iRubyObject, Block block) {
            ConsoleHolder consoleHolder = Readline.getHolder(iRubyObject.getRuntime());
            Iterator iterator = consoleHolder.history.getHistoryList().iterator();
            while (iterator.hasNext()) {
                block.yield(iRubyObject.getRuntime().getCurrentContext(), iRubyObject.getRuntime().newString((String)iterator.next()));
            }
            return iRubyObject;
        }
    }

    public static class ConsoleHolder {
        public ConsoleReader readline;
        public Completor currentCompletor;
        public History history;
    }

    public static class Service
    implements Library {
        public void load(Ruby ruby, boolean bl) throws IOException {
            Readline.createReadline(ruby);
        }
    }
}

