/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.ast.BlockAcceptingNode;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.types.IArityNode;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZSuperNode
extends Node
implements IArityNode,
BlockAcceptingNode {
    private Node iterNode;

    public ZSuperNode(ISourcePosition iSourcePosition) {
        super(iSourcePosition, NodeType.ZSUPERNODE);
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitZSuperNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.optional();
    }

    @Override
    public List<Node> childNodes() {
        return this.iterNode != null ? ZSuperNode.createList(this.iterNode) : EMPTY_LIST;
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node node) {
        this.iterNode = node;
        return this;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Block block2 = ASTInterpreter.getBlock(ruby, threadContext, iRubyObject, block, this.iterNode);
        return RuntimeHelpers.callZSuper(ruby, threadContext, block2, iRubyObject);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        String string = threadContext.getFrameName();
        RubyModule rubyModule = threadContext.getFrameKlazz();
        if (string != null && rubyModule != null && rubyModule.getSuperClass().isMethodBound(string, false)) {
            return "super";
        }
        return null;
    }
}

