/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.ast.Colon3Node;
import org.jruby.nb.nb.nb.ast.IScopingNode;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNode
extends Node
implements IScopingNode {
    private final Colon3Node cpath;
    private final StaticScope scope;
    private final Node bodyNode;

    public ModuleNode(ISourcePosition iSourcePosition, Colon3Node colon3Node, StaticScope staticScope, Node node) {
        super(iSourcePosition, NodeType.MODULENODE);
        assert (colon3Node != null) : "cpath is not null";
        assert (staticScope != null) : "scope is not null";
        assert (node != null) : "bodyNode is not null";
        this.cpath = colon3Node;
        this.scope = staticScope;
        this.bodyNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitModuleNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Colon3Node getCPath() {
        return this.cpath;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.cpath, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyModule rubyModule = this.cpath.getEnclosingModule(ruby, threadContext, iRubyObject, block);
        if (rubyModule == null) {
            throw ruby.newTypeError("no outer class/module");
        }
        String string = this.cpath.getName();
        RubyModule rubyModule2 = rubyModule.defineOrGetModuleUnder(string);
        this.scope.setModule(rubyModule2);
        return ASTInterpreter.evalClassDefinitionBody(ruby, threadContext, this.scope, this.bodyNode, rubyModule2, iRubyObject, block);
    }
}

