/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.nb.MetaClass;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.ast.ArgsNode;
import org.jruby.nb.nb.nb.ast.ArgumentNode;
import org.jruby.nb.nb.nb.ast.MethodDefNode;
import org.jruby.nb.nb.nb.ast.NilNode;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.types.INameNode;
import org.jruby.nb.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.nb.internal.runtime.methods.DefaultMethod;
import org.jruby.nb.nb.nb.internal.runtime.methods.WrapperMethod;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefnNode
extends MethodDefNode
implements INameNode {
    private final Visibility visibility;

    public DefnNode(ISourcePosition iSourcePosition, ArgumentNode argumentNode, ArgsNode argsNode, StaticScope staticScope, Node node, Visibility visibility) {
        super(iSourcePosition, argumentNode, argsNode, staticScope, node, NodeType.DEFNNODE);
        this.visibility = visibility;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitDefnNode(this);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public String getName() {
        return this.nameNode.getName();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.nameNode, this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyModule rubyModule = threadContext.getRubyClass();
        if (rubyModule == ruby.getDummy()) {
            throw ruby.newTypeError("no class/module to add method");
        }
        String string = this.getName();
        if (rubyModule == ruby.getObject() && string == "initialize") {
            ruby.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop", "Object#initialize");
        }
        if (string == "__id__" || string == "__send__") {
            ruby.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + string + "' may cause serious problem", string);
        }
        Visibility visibility = threadContext.getCurrentVisibility();
        if (string == "initialize" || string == "initialize_copy" || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        this.scope.determineModule();
        Node node = this.bodyNode == null ? new NilNode(this.getPosition()) : this.bodyNode;
        DefaultMethod defaultMethod = new DefaultMethod(rubyModule, this.scope, node, this.argsNode, visibility, this.getPosition());
        rubyModule.addMethod(string, defaultMethod);
        if (threadContext.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
            rubyModule.getSingletonClass().addMethod(string, new WrapperMethod((RubyModule)rubyModule.getSingletonClass(), defaultMethod, Visibility.PUBLIC));
            rubyModule.callMethod(threadContext, "singleton_method_added", ruby.fastNewSymbol(string));
        }
        if (rubyModule.isSingleton()) {
            ((MetaClass)rubyModule).getAttached().callMethod(threadContext, "singleton_method_added", ruby.fastNewSymbol(string));
        } else {
            rubyModule.callMethod(threadContext, "method_added", ruby.fastNewSymbol(string));
        }
        return ruby.getNil();
    }
}

