/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.RubySymbol;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.internal.runtime.JumpTarget;
import org.jruby.nb.nb.nb.java.MiniJava;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"Proc"})
public class RubyProc
extends RubyObject
implements JumpTarget {
    private Block block = Block.NULL_BLOCK;
    private Block.Type type;
    private String file;
    private int line;
    private static ObjectAllocator PROC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            RubyProc rubyProc = RubyProc.newProc(ruby, Block.Type.PROC);
            rubyProc.setMetaClass(rubyClass);
            return rubyProc;
        }
    };

    public RubyProc(Ruby ruby, RubyClass rubyClass, Block.Type type) {
        super(ruby, rubyClass);
        this.type = type;
    }

    public static RubyClass createProcClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Proc", ruby.getObject(), PROC_ALLOCATOR);
        ruby.setProc(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyProc.class);
        return rubyClass;
    }

    public Block getBlock() {
        return this.block;
    }

    public static RubyProc newProc(Ruby ruby, Block.Type type) {
        return new RubyProc(ruby, ruby.getProc(), type);
    }

    public static RubyProc newProc(Ruby ruby, Block block, Block.Type type) {
        RubyProc rubyProc = new RubyProc(ruby, ruby.getProc(), type);
        rubyProc.callInit(NULL_ARRAY, block);
        return rubyProc;
    }

    @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (!block.isGiven()) {
            block = threadContext.getPreviousFrame().getBlock();
        }
        if (block.isGiven() && block.getProcObject() != null) {
            return block.getProcObject();
        }
        IRubyObject iRubyObject2 = ((RubyClass)iRubyObject).allocate();
        iRubyObject2.callMethod(threadContext, "initialize", iRubyObjectArray, block);
        return iRubyObject2;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, Block block) {
        if (!block.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (this.type != Block.Type.LAMBDA || block == null) {
            // empty if block
        }
        this.block = block.cloneBlock();
        this.block.type = this.type;
        this.block.setProcObject(this);
        this.file = threadContext.getFile();
        this.line = threadContext.getLine();
        return this;
    }

    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        RubyProc rubyProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        rubyProc.block = this.getBlock();
        rubyProc.file = this.file;
        rubyProc.line = this.line;
        return rubyProc;
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyProc rubyProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        rubyProc.block = this.getBlock();
        rubyProc.file = this.file;
        rubyProc.line = this.line;
        return rubyProc;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyProc)) {
            return this.getRuntime().getFalse();
        }
        if (this == iRubyObject || this.block == ((RubyProc)iRubyObject).block) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return RubyString.newString(this.getRuntime(), "#<Proc:0x" + Integer.toString(this.block.hashCode(), 16) + "@" + this.file + ":" + (this.line + 1) + ">");
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.call(threadContext, iRubyObjectArray, null);
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject) {
        assert (iRubyObjectArray != null);
        Ruby ruby = this.getRuntime();
        Block block = this.block.cloneBlock();
        JumpTarget jumpTarget = block.getBinding().getFrame().getJumpTarget();
        try {
            if (iRubyObject != null) {
                block.getBinding().setSelf(iRubyObject);
            }
            return block.call(threadContext, iRubyObjectArray);
        }
        catch (JumpException.BreakJump breakJump) {
            switch (this.block.type) {
                case LAMBDA: {
                    if (breakJump.getTarget() == jumpTarget) {
                        return (IRubyObject)breakJump.getValue();
                    }
                    throw ruby.newLocalJumpError("break", (IRubyObject)breakJump.getValue(), "unexpected break");
                }
                case PROC: {
                    if (block.isEscaped()) {
                        throw ruby.newLocalJumpError("break", (IRubyObject)breakJump.getValue(), "break from proc-closure");
                    }
                    throw breakJump;
                }
            }
            throw breakJump;
        }
        catch (JumpException.ReturnJump returnJump) {
            JumpTarget jumpTarget2 = returnJump.getTarget();
            if (jumpTarget2 == jumpTarget && this.block.type == Block.Type.LAMBDA) {
                return (IRubyObject)returnJump.getValue();
            }
            if (this.type == Block.Type.THREAD) {
                throw ruby.newThreadError("return can't jump across threads");
            }
            throw returnJump;
        }
        catch (JumpException.RetryJump retryJump) {
            throw ruby.newLocalJumpError("retry", (IRubyObject)retryJump.getValue(), "retry not supported outside rescue");
        }
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.arity().getValue());
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }

    public IRubyObject as(Class clazz) {
        final Ruby ruby = this.getRuntime();
        if (!clazz.isInterface()) {
            throw ruby.newTypeError(clazz.getCanonicalName() + " is not an interface");
        }
        return MiniJava.javaToRuby(ruby, Proxy.newProxyInstance(Ruby.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                IRubyObject[] iRubyObjectArray = new IRubyObject[objectArray.length + 1];
                iRubyObjectArray[0] = RubySymbol.newSymbol(ruby, method.getName());
                for (int i = 1; i < iRubyObjectArray.length; ++i) {
                    iRubyObjectArray[i] = MiniJava.javaToRuby(ruby, objectArray[i - 1]);
                }
                return MiniJava.rubyToJava(RubyProc.this.call(ruby.getCurrentContext(), iRubyObjectArray));
            }
        }));
    }
}

