/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.nb.nb.nb.Finalizable;
import org.jruby.nb.nb.nb.MetaClass;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyFloat;
import org.jruby.nb.nb.nb.RubyHash;
import org.jruby.nb.nb.nb.RubyInteger;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNil;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.javasupport.JavaObject;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.CallType;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.builtin.InstanceVariables;
import org.jruby.nb.nb.nb.runtime.builtin.InternalVariables;
import org.jruby.nb.nb.nb.runtime.builtin.Variable;
import org.jruby.nb.nb.nb.runtime.component.VariableEntry;
import org.jruby.nb.nb.nb.runtime.marshal.CoreObjectType;
import org.jruby.nb.nb.nb.util.IdUtil;
import org.jruby.nb.nb.nb.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Object"}, include={"Kernel"})
public class RubyObject
implements Cloneable,
IRubyObject,
Serializable,
CoreObjectType,
InstanceVariables,
InternalVariables {
    public static final IRubyObject NEVER = new RubyObject();
    public static final IRubyObject UNDEF = new RubyObject();
    protected transient RubyClass metaClass;
    protected volatile transient VariableTableEntry[] variableTable;
    protected transient int variableTableSize;
    protected transient int variableTableThreshold;
    protected transient Object dataStruct;
    protected int flags;
    public static final int ALL_F = -1;
    public static final int FALSE_F = 1;
    public static final int NIL_F = 2;
    public static final int FROZEN_F = 4;
    public static final int TAINTED_F = 8;
    public static final int FL_USHIFT = 4;
    public static final int USER0_F = 16;
    public static final int USER1_F = 32;
    public static final int USER2_F = 64;
    public static final int USER3_F = 128;
    public static final int USER4_F = 256;
    public static final int USER5_F = 512;
    public static final int USER6_F = 1024;
    public static final int USER7_F = 2048;
    private transient Finalizer finalizer;
    public static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyObject(ruby, rubyClass);
        }
    };
    protected static final String ERR_INSECURE_SET_INST_VAR = "Insecure: can't modify instance variable";
    protected static final int VARIABLE_TABLE_DEFAULT_CAPACITY = 8;
    protected static final int VARIABLE_TABLE_MAXIMUM_CAPACITY = 0x40000000;
    protected static final float VARIABLE_TABLE_LOAD_FACTOR = 0.75f;
    protected static final VariableTableEntry[] VARIABLE_TABLE_EMPTY_TABLE = new VariableTableEntry[0];

    private RubyObject() {
    }

    public final void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public final boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public RubyObject(Ruby ruby, RubyClass rubyClass) {
        this.metaClass = rubyClass;
        if (ruby.isObjectSpaceEnabled()) {
            this.addToObjectSpace(ruby);
        }
        if (ruby.getSafeLevel() >= 3) {
            this.taint(ruby);
        }
    }

    protected RubyObject(Ruby ruby, RubyClass rubyClass, boolean bl) {
        this.metaClass = rubyClass;
        if (bl) {
            this.addToObjectSpace(ruby);
        }
        if (ruby.getSafeLevel() >= 3) {
            this.taint(ruby);
        }
    }

    private void addToObjectSpace(Ruby ruby) {
        assert (ruby.isObjectSpaceEnabled());
        ruby.getObjectSpace().add(this);
    }

    public static RubyClass createObjectClass(Ruby ruby, RubyClass rubyClass) {
        rubyClass.index = 14;
        rubyClass.defineAnnotatedMethods(ObjectMethods.class);
        return rubyClass;
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    @Override
    public int getNativeTypeIndex() {
        return 14;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public RubyClass makeMetaClass(RubyClass rubyClass) {
        MetaClass metaClass = new MetaClass(this.getRuntime(), rubyClass);
        this.setMetaClass(metaClass);
        metaClass.setAttached(this);
        metaClass.setMetaClass(rubyClass.getRealClass().getMetaClass());
        return metaClass;
    }

    @Override
    public Class getJavaClass() {
        if (this.dataGetStruct() instanceof JavaObject) {
            return ((JavaObject)this.dataGetStruct()).getValue().getClass();
        }
        return this.getClass();
    }

    public static void puts(Object object) {
        System.out.println(object.toString());
    }

    public boolean equals(Object object) {
        return object == this || object instanceof IRubyObject && this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.EQUALEQUAL, "==", (IRubyObject)object).isTrue();
    }

    public String toString() {
        return RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s").toString();
    }

    @Override
    public final Ruby getRuntime() {
        return this.getMetaClass().getClassRuntime();
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(RubyClass rubyClass) {
        this.metaClass = rubyClass;
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void setFrozen(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    protected final void testFrozen(String string) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(string + " " + this.getMetaClass().getName());
        }
    }

    protected void checkFrozen() {
        this.testFrozen("can't modify frozen ");
    }

    @Override
    public boolean isTaint() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void setTaint(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    public final boolean isNil() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final boolean isTrue() {
        return (this.flags & 1) == 0;
    }

    public final boolean isFalse() {
        return (this.flags & 1) != 0;
    }

    @Override
    public final boolean respondsTo(String string) {
        if (this.getMetaClass().searchMethod("respond_to?") == this.getRuntime().getRespondToMethod()) {
            return this.getMetaClass().isMethodBound(string, false);
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "respond_to?", this.getRuntime().newSymbol(string)).isTrue();
    }

    @Override
    public RubyClass getSingletonClass() {
        RubyClass rubyClass = this.getMetaClass().isSingleton() && ((MetaClass)this.getMetaClass()).getAttached() == this ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass());
        rubyClass.setTaint(this.isTaint());
        if (this.isFrozen()) {
            rubyClass.setFrozen(true);
        }
        return rubyClass;
    }

    protected RubyClass getSingletonClassClone() {
        RubyClass rubyClass = this.getMetaClass();
        if (!rubyClass.isSingleton()) {
            return rubyClass;
        }
        MetaClass metaClass = new MetaClass(this.getRuntime());
        metaClass.flags = this.flags;
        if (this instanceof RubyClass) {
            metaClass.setMetaClass(metaClass);
        } else {
            metaClass.setMetaClass(rubyClass.getSingletonClassClone());
        }
        metaClass.setSuperClass(rubyClass.getSuperClass());
        if (rubyClass.hasVariables()) {
            metaClass.syncVariables(rubyClass.getVariableList());
        }
        rubyClass.cloneMethods(metaClass);
        ((MetaClass)metaClass.getMetaClass()).setAttached(metaClass);
        metaClass.setAttached(((MetaClass)rubyClass).getAttached());
        return metaClass;
    }

    private static void initCopy(IRubyObject iRubyObject, RubyObject rubyObject) {
        assert (!iRubyObject.isFrozen()) : "frozen object (" + iRubyObject.getMetaClass().getName() + ") allocated";
        rubyObject.copySpecialInstanceVariables(iRubyObject);
        if (rubyObject.hasVariables()) {
            iRubyObject.syncVariables(rubyObject.getVariableList());
        }
        iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "initialize_copy", rubyObject);
    }

    @Override
    public IRubyObject infectBy(IRubyObject iRubyObject) {
        if (iRubyObject.isTaint()) {
            this.setTaint(true);
        }
        return this;
    }

    @Override
    public IRubyObject callSuper(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        RubyModule rubyModule = threadContext.getFrameKlazz();
        RubyClass rubyClass = RuntimeHelpers.findImplementerIfNecessary(this.getMetaClass(), rubyModule).getSuperClass();
        if (rubyClass == null) {
            String string = threadContext.getFrameName();
            return RuntimeHelpers.callMethodMissing(threadContext, (IRubyObject)this, rubyModule.searchMethod(string), string, iRubyObjectArray, (IRubyObject)this, CallType.SUPER, block);
        }
        return RuntimeHelpers.invokeAs(threadContext, rubyClass, this, threadContext.getFrameName(), iRubyObjectArray, CallType.SUPER, block);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext threadContext, String string) {
        return RuntimeHelpers.invoke(threadContext, this, string);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)this, string, iRubyObject);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext threadContext, String string, IRubyObject[] iRubyObjectArray) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)this, string, iRubyObjectArray);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext threadContext, String string, IRubyObject[] iRubyObjectArray, Block block) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)this, string, iRubyObjectArray, block);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext threadContext, int n, String string) {
        return RuntimeHelpers.invoke(threadContext, this, string);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext threadContext, int n, String string, IRubyObject iRubyObject) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)this, string, iRubyObject, Block.NULL_BLOCK);
    }

    public final void callInit(IRubyObject[] iRubyObjectArray, Block block) {
        this.callMethod(this.getRuntime().getCurrentContext(), "initialize", iRubyObjectArray, block);
    }

    @Override
    public String asJavaString() {
        IRubyObject iRubyObject = this.checkStringType();
        if (!iRubyObject.isNil()) {
            return ((RubyString)iRubyObject).asJavaString();
        }
        throw this.getRuntime().newTypeError(this.inspect().toString() + " is not a symbol");
    }

    @Override
    public RubyArray convertToArray() {
        return (RubyArray)TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getArray(), MethodIndex.TO_ARY, "to_ary");
    }

    @Override
    public RubyHash convertToHash() {
        return (RubyHash)TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getHash(), MethodIndex.TO_HASH, "to_hash");
    }

    @Override
    public RubyFloat convertToFloat() {
        return (RubyFloat)TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getFloat(), MethodIndex.TO_F, "to_f");
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.convertToInteger(MethodIndex.TO_INT, "to_int");
    }

    @Override
    public RubyInteger convertToInteger(int n, String string) {
        IRubyObject iRubyObject = TypeConverter.convertToType(this, this.getRuntime().getInteger(), n, string, true);
        if (!(iRubyObject instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#" + string + " should return Integer");
        }
        return (RubyInteger)iRubyObject;
    }

    @Override
    public RubyString convertToString() {
        return (RubyString)TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getString(), MethodIndex.TO_STR, "to_str");
    }

    public final IRubyObject convertToType(RubyClass rubyClass, int n) {
        return TypeConverter.convertToType((IRubyObject)this, rubyClass, n, MethodIndex.NAMES.get(n));
    }

    @Override
    public RubyString asString() {
        IRubyObject iRubyObject = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s");
        if (!(iRubyObject instanceof RubyString)) {
            return (RubyString)this.anyToString();
        }
        if (this.isTaint()) {
            iRubyObject.setTaint(true);
        }
        return (RubyString)iRubyObject;
    }

    @Override
    public IRubyObject checkStringType() {
        IRubyObject iRubyObject = TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getString(), MethodIndex.TO_STR, "to_str");
        if (!iRubyObject.isNil() && !(iRubyObject instanceof RubyString)) {
            iRubyObject = RubyString.newEmptyString(this.getRuntime());
        }
        return iRubyObject;
    }

    @Override
    public IRubyObject checkArrayType() {
        return TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getArray(), MethodIndex.TO_ARY, "to_ary");
    }

    @Deprecated
    public IRubyObject specificEval(ThreadContext threadContext, RubyModule rubyModule, IRubyObject[] iRubyObjectArray, Block block) {
        int n;
        String string;
        if (block.isGiven()) {
            if (iRubyObjectArray.length > 0) {
                throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 0);
            }
            return this.yieldUnder(threadContext, rubyModule, block);
        }
        if (iRubyObjectArray.length == 0) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (iRubyObjectArray.length > 3) {
            String string2 = threadContext.getFrameName();
            throw this.getRuntime().newArgumentError("wrong # of arguments: " + string2 + "(src) or " + string2 + "{..}");
        }
        RubyString rubyString = iRubyObjectArray[0] instanceof RubyString ? (RubyString)iRubyObjectArray[0] : iRubyObjectArray[0].convertToString();
        if (iRubyObjectArray.length > 1) {
            string = iRubyObjectArray[1].convertToString().asJavaString();
            n = iRubyObjectArray.length > 2 ? (int)(iRubyObjectArray[2].convertToInteger().getLongValue() - 1L) : 0;
        } else {
            string = "(eval)";
            n = 0;
        }
        return this.evalUnder(threadContext, rubyModule, rubyString, string, n);
    }

    public IRubyObject specificEval(ThreadContext threadContext, RubyModule rubyModule, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(threadContext, rubyModule, block);
        }
        throw threadContext.getRuntime().newArgumentError("block not supplied");
    }

    public IRubyObject specificEval(ThreadContext threadContext, RubyModule rubyModule, IRubyObject iRubyObject, Block block) {
        if (block.isGiven()) {
            throw threadContext.getRuntime().newArgumentError(1, 0);
        }
        RubyString rubyString = iRubyObject instanceof RubyString ? (RubyString)iRubyObject : iRubyObject.convertToString();
        String string = "(eval)";
        int n = 0;
        return this.evalUnder(threadContext, rubyModule, rubyString, string, n);
    }

    public IRubyObject specificEval(ThreadContext threadContext, RubyModule rubyModule, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (block.isGiven()) {
            throw threadContext.getRuntime().newArgumentError(2, 0);
        }
        RubyString rubyString = iRubyObject instanceof RubyString ? (RubyString)iRubyObject : iRubyObject.convertToString();
        String string = iRubyObject2.convertToString().asJavaString();
        int n = 0;
        return this.evalUnder(threadContext, rubyModule, rubyString, string, n);
    }

    public IRubyObject specificEval(ThreadContext threadContext, RubyModule rubyModule, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        if (block.isGiven()) {
            throw threadContext.getRuntime().newArgumentError(2, 0);
        }
        RubyString rubyString = iRubyObject instanceof RubyString ? (RubyString)iRubyObject : iRubyObject.convertToString();
        String string = iRubyObject2.convertToString().asJavaString();
        int n = (int)(iRubyObject3.convertToInteger().getLongValue() - 1L);
        return this.evalUnder(threadContext, rubyModule, rubyString, string, n);
    }

    public IRubyObject evalUnder(ThreadContext threadContext, RubyModule rubyModule, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.evalUnder(threadContext, rubyModule, iRubyObject.convertToString(), iRubyObject2.convertToString().toString(), (int)(iRubyObject3.convertToInteger().getLongValue() - 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject evalUnder(ThreadContext threadContext, RubyModule rubyModule, RubyString rubyString, String string, int n) {
        Visibility visibility = threadContext.getCurrentVisibility();
        threadContext.setCurrentVisibility(Visibility.PUBLIC);
        threadContext.preExecuteUnder(rubyModule, Block.NULL_BLOCK);
        try {
            IRubyObject iRubyObject = ASTInterpreter.evalSimple(threadContext, (IRubyObject)this, rubyString, string, n);
            Object var9_8 = null;
            threadContext.postExecuteUnder();
            threadContext.setCurrentVisibility(visibility);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            threadContext.postExecuteUnder();
            threadContext.setCurrentVisibility(visibility);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject yieldUnder(ThreadContext threadContext, RubyModule rubyModule, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject;
        threadContext.preExecuteUnder(rubyModule, block);
        Visibility visibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            boolean bl;
            IRubyObject iRubyObject2;
            if (iRubyObjectArray.length == 1) {
                iRubyObject2 = iRubyObjectArray[0];
                bl = false;
            } else {
                iRubyObject2 = RubyArray.newArrayNoCopy(threadContext.getRuntime(), iRubyObjectArray);
                bl = true;
            }
            block = block.cloneBlock();
            block.getBinding().setSelf(this);
            block.getBinding().getFrame().setSelf(this);
            iRubyObject = block.yield(threadContext, iRubyObject2, this, threadContext.getRubyClass(), bl);
            Object var10_11 = null;
        }
        catch (JumpException.BreakJump breakJump) {
            try {
                IRubyObject iRubyObject3 = (IRubyObject)breakJump.getValue();
                Object var10_12 = null;
                block.getBinding().setVisibility(visibility);
                threadContext.postExecuteUnder();
                return iRubyObject3;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                block.getBinding().setVisibility(visibility);
                threadContext.postExecuteUnder();
                throw throwable;
            }
        }
        block.getBinding().setVisibility(visibility);
        threadContext.postExecuteUnder();
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject yieldUnder(ThreadContext threadContext, RubyModule rubyModule, Block block) {
        IRubyObject iRubyObject;
        threadContext.preExecuteUnder(rubyModule, block);
        Visibility visibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            block = block.cloneBlock();
            block.getBinding().setSelf(this);
            block.getBinding().getFrame().setSelf(this);
            iRubyObject = block.yield(threadContext, this, this, threadContext.getRubyClass(), false);
            Object var8_7 = null;
        }
        catch (JumpException.BreakJump breakJump) {
            try {
                IRubyObject iRubyObject2 = (IRubyObject)breakJump.getValue();
                Object var8_8 = null;
                block.getBinding().setVisibility(visibility);
                threadContext.postExecuteUnder();
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                block.getBinding().setVisibility(visibility);
                threadContext.postExecuteUnder();
                throw throwable;
            }
        }
        block.getBinding().setVisibility(visibility);
        threadContext.postExecuteUnder();
        return iRubyObject;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this == iRubyObject ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject equal_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this == iRubyObject ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    @Override
    public boolean eql(IRubyObject iRubyObject) {
        return this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.EQL_P, "eql?", iRubyObject).isTrue();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject iRubyObject) {
        return this == iRubyObject ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext threadContext, IRubyObject iRubyObject) {
        return threadContext.getRuntime().newBoolean(RubyObject.equalInternal(threadContext, this, iRubyObject));
    }

    protected static boolean equalInternal(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject == iRubyObject2 || iRubyObject.callMethod(threadContext, MethodIndex.EQUALEQUAL, "==", iRubyObject2).isTrue();
    }

    protected static boolean eqlInternal(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject == iRubyObject2 || iRubyObject.callMethod(threadContext, MethodIndex.EQL_P, "eql?", iRubyObject2).isTrue();
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != iRubyObject.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    @JRubyMethod(name={"respond_to?"})
    public RubyBoolean respond_to_p(IRubyObject iRubyObject) {
        String string = iRubyObject.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(string, true));
    }

    @JRubyMethod(name={"respond_to?"})
    public RubyBoolean respond_to_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(string, !iRubyObject2.isTrue()));
    }

    @Override
    @JRubyMethod(name={"object_id", "__id__"})
    public synchronized IRubyObject id() {
        return this.getRuntime().newFixnum(this.getRuntime().getObjectSpace().idOf(this));
    }

    @JRubyMethod(name={"id"})
    public synchronized IRubyObject id_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#id will be deprecated; use Object#object_id", "Object#id", "Object#object_id");
        return this.id();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(super.hashCode());
    }

    public int hashCode() {
        IRubyObject iRubyObject = this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.HASH, "hash");
        if (iRubyObject instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(iRubyObject);
        }
        return super.hashCode();
    }

    @JRubyMethod(name={"class"})
    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    @JRubyMethod(name={"type"})
    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#type is deprecated; use Object#class", "Object#type", "Object#class");
        return this.type();
    }

    @Override
    @JRubyMethod(name={"clone"}, frame=true)
    public IRubyObject rbClone() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't clone " + this.getMetaClass().getName());
        }
        RubyObject rubyObject = (RubyObject)this.getMetaClass().getRealClass().allocate();
        rubyObject.setMetaClass(this.getSingletonClassClone());
        if (this.isTaint()) {
            rubyObject.setTaint(true);
        }
        RubyObject.initCopy(rubyObject, this);
        if (this.isFrozen()) {
            rubyObject.setFrozen(true);
        }
        return rubyObject;
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't dup " + this.getMetaClass().getName());
        }
        IRubyObject iRubyObject = this.getMetaClass().getRealClass().allocate();
        if (this.isTaint()) {
            iRubyObject.setTaint(true);
        }
        RubyObject.initCopy(iRubyObject, this);
        return iRubyObject;
    }

    protected void copySpecialInstanceVariables(IRubyObject iRubyObject) {
    }

    @JRubyMethod(name={"display"}, optional=1)
    public IRubyObject display(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray.length == 0 ? threadContext.getRuntime().getGlobalVariables().get("$>") : iRubyObjectArray[0];
        iRubyObject.callMethod(threadContext, "write", this);
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"tainted?"})
    public RubyBoolean tainted_p(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.isTaint());
    }

    @JRubyMethod(name={"taint"})
    public IRubyObject taint(ThreadContext threadContext) {
        this.taint(threadContext.getRuntime());
        return this;
    }

    private void taint(Ruby ruby) {
        ruby.secure(4);
        if (!this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(true);
        }
    }

    @JRubyMethod(name={"untaint"})
    public IRubyObject untaint(ThreadContext threadContext) {
        threadContext.getRuntime().secure(3);
        if (this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(false);
        }
        return this;
    }

    @JRubyMethod(name={"freeze"})
    public IRubyObject freeze(ThreadContext threadContext) {
        if ((this.flags & 4) == 0) {
            if (threadContext.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw threadContext.getRuntime().newSecurityError("Insecure: can't freeze object");
            }
            this.flags |= 4;
        }
        return this;
    }

    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.isFrozen());
    }

    private StringBuilder inspectObj(StringBuilder stringBuilder) {
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        String string = "";
        for (Variable<IRubyObject> variable : this.getInstanceVariableList()) {
            stringBuilder.append(string).append(" ").append(variable.getName()).append("=");
            stringBuilder.append(variable.getValue().callMethod(threadContext, "inspect"));
            string = ",";
        }
        stringBuilder.append(">");
        return stringBuilder;
    }

    static RubyString inspect(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyString.objAsString(threadContext, iRubyObject.callMethod(threadContext, "inspect"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        Ruby ruby = this.getRuntime();
        if (!this.isImmediate() && !(this instanceof RubyClass) && this != ruby.getObject() && this != ruby.getModule() && !(this instanceof RubyModule) && this.hasVariables()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getMetaClass().getRealClass().getName();
            stringBuilder.append("#<").append(string).append(":0x");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            if (ruby.isInspecting(this)) {
                stringBuilder.append(" ...>");
                return ruby.newString(stringBuilder.toString());
            }
            try {
                ruby.registerInspecting(this);
                RubyString rubyString = ruby.newString(this.inspectObj(stringBuilder).toString());
                Object var6_5 = null;
                ruby.unregisterInspecting(this);
                return rubyString;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ruby.unregisterInspecting(this);
                throw throwable;
            }
        }
        if (this.isNil()) {
            return RubyNil.inspect(this);
        }
        return RuntimeHelpers.invoke(ruby.getCurrentContext(), this, "to_s");
    }

    @JRubyMethod(name={"instance_of?"}, required=1)
    public RubyBoolean instance_of_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.type() == iRubyObject) {
            return threadContext.getRuntime().getTrue();
        }
        if (!(iRubyObject instanceof RubyModule)) {
            throw threadContext.getRuntime().newTypeError("class or module required");
        }
        return threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"kind_of?", "is_a?"}, required=1)
    public RubyBoolean kind_of_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyModule)) {
            throw threadContext.getRuntime().newTypeError("class or module required");
        }
        return threadContext.getRuntime().newBoolean(((RubyModule)iRubyObject).isInstance(this));
    }

    @JRubyMethod(name={"methods"}, optional=1)
    public IRubyObject methods(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        boolean bl = true;
        if (iRubyObjectArray.length == 1) {
            bl = iRubyObjectArray[0].isTrue();
        }
        RubyArray rubyArray = null;
        if (this.getMetaClass().isSingleton()) {
            rubyArray = this.getMetaClass().instance_methods(new IRubyObject[]{threadContext.getRuntime().getFalse()});
            if (bl) {
                rubyArray.concat(this.getMetaClass().getSuperClass().instance_methods(new IRubyObject[]{threadContext.getRuntime().getTrue()}));
            }
        } else {
            rubyArray = bl ? this.getMetaClass().instance_methods(new IRubyObject[]{threadContext.getRuntime().getTrue()}) : threadContext.getRuntime().newEmptyArray();
        }
        return rubyArray;
    }

    @JRubyMethod(name={"public_methods"}, optional=1)
    public IRubyObject public_methods(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            iRubyObjectArray = new IRubyObject[]{threadContext.getRuntime().getTrue()};
        }
        return this.getMetaClass().public_instance_methods(iRubyObjectArray);
    }

    @JRubyMethod(name={"protected_methods"}, optional=1)
    public IRubyObject protected_methods(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            iRubyObjectArray = new IRubyObject[]{threadContext.getRuntime().getTrue()};
        }
        return this.getMetaClass().protected_instance_methods(iRubyObjectArray);
    }

    @JRubyMethod(name={"private_methods"}, optional=1)
    public IRubyObject private_methods(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            iRubyObjectArray = new IRubyObject[]{threadContext.getRuntime().getTrue()};
        }
        return this.getMetaClass().private_instance_methods(iRubyObjectArray);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1)
    public RubyArray singleton_methods(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyArray rubyArray;
        boolean bl = true;
        if (iRubyObjectArray.length == 1) {
            bl = iRubyObjectArray[0].isTrue();
        }
        if (this.getMetaClass().isSingleton()) {
            rubyArray = this.getMetaClass().instance_methods(new IRubyObject[]{threadContext.getRuntime().getFalse()});
            if (bl) {
                RubyClass rubyClass = this.getMetaClass().getSuperClass();
                while (rubyClass.isIncluded()) {
                    rubyArray.concat(rubyClass.instance_methods(new IRubyObject[]{threadContext.getRuntime().getFalse()}));
                    rubyClass = rubyClass.getSuperClass();
                }
            }
        } else {
            rubyArray = threadContext.getRuntime().newEmptyArray();
        }
        return rubyArray;
    }

    @JRubyMethod(name={"method"}, required=1)
    public IRubyObject method(IRubyObject iRubyObject) {
        return this.getMetaClass().newMethod(this, iRubyObject.asJavaString(), true);
    }

    @Override
    public IRubyObject anyToString() {
        String string = this.getMetaClass().getRealClass().getName();
        RubyString rubyString = this.getRuntime().newString("#<" + string + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        rubyString.setTaint(this.isTaint());
        return rubyString;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.anyToString();
    }

    @JRubyMethod(name={"to_a"}, visibility=Visibility.PUBLIC)
    public RubyArray to_a() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "default 'to_a' will be obsolete", "to_a");
        return this.getRuntime().newArray(this);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext threadContext, Block block) {
        return this.specificEval(threadContext, this.getInstanceEvalClass(), block);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.specificEval(threadContext, this.getInstanceEvalClass(), iRubyObject, block);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return this.specificEval(threadContext, this.getInstanceEvalClass(), iRubyObject, iRubyObject2, block);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        return this.specificEval(threadContext, this.getInstanceEvalClass(), iRubyObject, iRubyObject2, iRubyObject3, block);
    }

    @Deprecated
    public IRubyObject instance_eval(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        RubyClass rubyClass = this.isImmediate() ? threadContext.getRuntime().getDummy() : this.getSingletonClass();
        return this.specificEval(threadContext, (RubyModule)rubyClass, iRubyObjectArray, block);
    }

    private RubyModule getInstanceEvalClass() {
        if (this.isImmediate()) {
            return this.getRuntime().getDummy();
        }
        return this.getSingletonClass();
    }

    @JRubyMethod(name={"instance_exec"}, optional=3, frame=true)
    public IRubyObject instance_exec(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        if (!block.isGiven()) {
            throw threadContext.getRuntime().newArgumentError("block not supplied");
        }
        RubyClass rubyClass = this.isImmediate() ? threadContext.getRuntime().getDummy() : this.getSingletonClass();
        return this.yieldUnder(threadContext, rubyClass, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"extend"}, required=1, rest=true)
    public IRubyObject extend(IRubyObject[] iRubyObjectArray) {
        Ruby ruby = this.getRuntime();
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (iRubyObjectArray[i].isModule()) continue;
            throw ruby.newTypeError(iRubyObjectArray[i], ruby.getModule());
        }
        ThreadContext threadContext = ruby.getCurrentContext();
        for (int i = iRubyObjectArray.length - 1; i >= 0; --i) {
            iRubyObjectArray[i].callMethod(threadContext, "extend_object", this);
            iRubyObjectArray[i].callMethod(threadContext, "extended", this);
        }
        return this;
    }

    public IRubyObject initialize() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext threadContext, Block block) {
        throw threadContext.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        String string = iRubyObject.asJavaString();
        return this.getMetaClass().finvoke(threadContext, (IRubyObject)this, string, block);
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        String string = iRubyObject.asJavaString();
        return this.getMetaClass().finvoke(threadContext, (IRubyObject)this, string, iRubyObject2, block);
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        String string = iRubyObject.asJavaString();
        return this.getMetaClass().finvoke(threadContext, (IRubyObject)this, string, iRubyObject2, iRubyObject3, block);
    }

    @JRubyMethod(name={"send", "__send__"}, rest=true)
    public IRubyObject send(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject[] iRubyObjectArray2;
        String string = iRubyObjectArray[0].asJavaString();
        int n = iRubyObjectArray.length - 1;
        if (n == 0) {
            iRubyObjectArray2 = IRubyObject.NULL_ARRAY;
        } else {
            iRubyObjectArray2 = new IRubyObject[n];
            System.arraycopy(iRubyObjectArray, 1, iRubyObjectArray2, 0, iRubyObjectArray2.length);
        }
        return this.getMetaClass().finvoke(threadContext, (IRubyObject)this, string, iRubyObjectArray2, block);
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p(ThreadContext threadContext) {
        return threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(ThreadContext threadContext, IRubyObject iRubyObject) {
        return threadContext.getRuntime().getFalse();
    }

    public IRubyObject to_java() {
        throw this.getRuntime().newTypeError(this.getMetaClass().getBaseName() + " cannot coerce to a Java type.");
    }

    public IRubyObject as(Class clazz) {
        throw this.getRuntime().newTypeError(this.getMetaClass().getBaseName() + " cannot coerce to a Java type.");
    }

    @Override
    public RubyClass getType() {
        return this.type();
    }

    @Override
    public synchronized void dataWrapStruct(Object object) {
        this.dataStruct = object;
    }

    @Override
    public synchronized Object dataGetStruct() {
        return this.dataStruct;
    }

    @Override
    public void addFinalizer(IRubyObject iRubyObject) {
        if (this.finalizer == null) {
            this.finalizer = new Finalizer(this.getRuntime().getObjectSpace().idOf(this));
            this.getRuntime().addFinalizer(this.finalizer);
        }
        this.finalizer.addFinalizer(iRubyObject);
    }

    @Override
    public void removeFinalizers() {
        if (this.finalizer != null) {
            this.finalizer.removeFinalizers();
            this.finalizer = null;
            this.getRuntime().removeFinalizer(this.finalizer);
        }
    }

    @JRubyMethod(name={"instance_variable_defined?"}, required=1)
    public IRubyObject instance_variable_defined_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.variableTableContains(this.validateInstanceVariable(iRubyObject.asJavaString()))) {
            return threadContext.getRuntime().getTrue();
        }
        return threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"instance_variable_get"}, required=1)
    public IRubyObject instance_variable_get(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = this.variableTableFetch(this.validateInstanceVariable(iRubyObject.asJavaString()));
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"instance_variable_set"}, required=2)
    public IRubyObject instance_variable_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.ensureInstanceVariablesSettable();
        return this.variableTableStore(this.validateInstanceVariable(iRubyObject.asJavaString()), iRubyObject2);
    }

    @JRubyMethod(name={"remove_instance_variable"}, required=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject remove_instance_variable(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        this.ensureInstanceVariablesSettable();
        IRubyObject iRubyObject2 = this.variableTableRemove(this.validateInstanceVariable(iRubyObject.asJavaString()));
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        throw threadContext.getRuntime().newNameError("instance variable " + iRubyObject.asJavaString() + " not defined", iRubyObject.asJavaString());
    }

    @JRubyMethod(name={"instance_variables"})
    public RubyArray instance_variables(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        List<String> list = this.getInstanceVariableNameList();
        RubyArray rubyArray = ruby.newArray(list.size());
        for (String string : list) {
            rubyArray.append(ruby.newString(string));
        }
        return rubyArray;
    }

    @Override
    public InstanceVariables getInstanceVariables() {
        return this;
    }

    @Override
    public boolean hasInstanceVariable(String string) {
        assert (IdUtil.isInstanceVariable(string));
        return this.variableTableContains(string);
    }

    @Override
    public boolean fastHasInstanceVariable(String string) {
        assert (IdUtil.isInstanceVariable(string));
        return this.variableTableFastContains(string);
    }

    @Override
    public IRubyObject getInstanceVariable(String string) {
        assert (IdUtil.isInstanceVariable(string));
        return this.variableTableFetch(string);
    }

    @Override
    public IRubyObject fastGetInstanceVariable(String string) {
        assert (IdUtil.isInstanceVariable(string));
        return this.variableTableFastFetch(string);
    }

    @Override
    public IRubyObject setInstanceVariable(String string, IRubyObject iRubyObject) {
        assert (IdUtil.isInstanceVariable(string) && iRubyObject != null);
        this.ensureInstanceVariablesSettable();
        return this.variableTableStore(string, iRubyObject);
    }

    @Override
    public IRubyObject fastSetInstanceVariable(String string, IRubyObject iRubyObject) {
        assert (IdUtil.isInstanceVariable(string) && iRubyObject != null);
        this.ensureInstanceVariablesSettable();
        return this.variableTableFastStore(string, iRubyObject);
    }

    @Override
    public IRubyObject removeInstanceVariable(String string) {
        assert (IdUtil.isInstanceVariable(string));
        this.ensureInstanceVariablesSettable();
        return this.variableTableRemove(string);
    }

    @Override
    public List<Variable<IRubyObject>> getInstanceVariableList() {
        VariableTableEntry[] variableTableEntryArray = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> arrayList = new ArrayList<Variable<IRubyObject>>();
        int n = variableTableEntryArray.length;
        while (--n >= 0) {
            VariableTableEntry variableTableEntry = variableTableEntryArray[n];
            while (variableTableEntry != null) {
                if (IdUtil.isInstanceVariable(variableTableEntry.name)) {
                    IRubyObject iRubyObject = variableTableEntry.value;
                    if (iRubyObject == null) {
                        iRubyObject = this.variableTableReadLocked(variableTableEntry);
                    }
                    arrayList.add(new VariableEntry<IRubyObject>(variableTableEntry.name, iRubyObject));
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return arrayList;
    }

    @Override
    public List<String> getInstanceVariableNameList() {
        VariableTableEntry[] variableTableEntryArray = this.variableTableGetTable();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = variableTableEntryArray.length;
        while (--n >= 0) {
            VariableTableEntry variableTableEntry = variableTableEntryArray[n];
            while (variableTableEntry != null) {
                if (IdUtil.isInstanceVariable(variableTableEntry.name)) {
                    arrayList.add(variableTableEntry.name);
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return arrayList;
    }

    protected String validateInstanceVariable(String string) {
        if (IdUtil.isValidInstanceVariableName(string)) {
            return string;
        }
        throw this.getRuntime().newNameError("`" + string + "' is not allowable as an instance variable name", string);
    }

    protected void ensureInstanceVariablesSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_INST_VAR);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    @Override
    public InternalVariables getInternalVariables() {
        return this;
    }

    @Override
    public boolean hasInternalVariable(String string) {
        assert (!RubyObject.isRubyVariable(string));
        return this.variableTableContains(string);
    }

    @Override
    public boolean fastHasInternalVariable(String string) {
        assert (!RubyObject.isRubyVariable(string));
        return this.variableTableFastContains(string);
    }

    @Override
    public IRubyObject getInternalVariable(String string) {
        assert (!RubyObject.isRubyVariable(string));
        return this.variableTableFetch(string);
    }

    @Override
    public IRubyObject fastGetInternalVariable(String string) {
        assert (!RubyObject.isRubyVariable(string));
        return this.variableTableFastFetch(string);
    }

    @Override
    public void setInternalVariable(String string, IRubyObject iRubyObject) {
        assert (!RubyObject.isRubyVariable(string));
        this.variableTableStore(string, iRubyObject);
    }

    @Override
    public void fastSetInternalVariable(String string, IRubyObject iRubyObject) {
        assert (!RubyObject.isRubyVariable(string));
        this.variableTableFastStore(string, iRubyObject);
    }

    @Override
    public IRubyObject removeInternalVariable(String string) {
        assert (!RubyObject.isRubyVariable(string));
        return this.variableTableRemove(string);
    }

    @Override
    public void syncVariables(List<Variable<IRubyObject>> list) {
        this.variableTableSync(list);
    }

    @Override
    public List<Variable<IRubyObject>> getInternalVariableList() {
        VariableTableEntry[] variableTableEntryArray = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> arrayList = new ArrayList<Variable<IRubyObject>>();
        int n = variableTableEntryArray.length;
        while (--n >= 0) {
            VariableTableEntry variableTableEntry = variableTableEntryArray[n];
            while (variableTableEntry != null) {
                if (!RubyObject.isRubyVariable(variableTableEntry.name)) {
                    IRubyObject iRubyObject = variableTableEntry.value;
                    if (iRubyObject == null) {
                        iRubyObject = this.variableTableReadLocked(variableTableEntry);
                    }
                    arrayList.add(new VariableEntry<IRubyObject>(variableTableEntry.name, iRubyObject));
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return arrayList;
    }

    @Override
    public boolean hasVariables() {
        return this.variableTableGetSize() > 0;
    }

    @Override
    public int getVariableCount() {
        return this.variableTableGetSize();
    }

    @Override
    public List<Variable<IRubyObject>> getVariableList() {
        VariableTableEntry[] variableTableEntryArray = this.variableTableGetTable();
        ArrayList<Variable<IRubyObject>> arrayList = new ArrayList<Variable<IRubyObject>>();
        int n = variableTableEntryArray.length;
        while (--n >= 0) {
            VariableTableEntry variableTableEntry = variableTableEntryArray[n];
            while (variableTableEntry != null) {
                IRubyObject iRubyObject = variableTableEntry.value;
                if (iRubyObject == null) {
                    iRubyObject = this.variableTableReadLocked(variableTableEntry);
                }
                arrayList.add(new VariableEntry<IRubyObject>(variableTableEntry.name, iRubyObject));
                variableTableEntry = variableTableEntry.next;
            }
        }
        return arrayList;
    }

    @Override
    public List<String> getVariableNameList() {
        VariableTableEntry[] variableTableEntryArray = this.variableTableGetTable();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = variableTableEntryArray.length;
        while (--n >= 0) {
            VariableTableEntry variableTableEntry = variableTableEntryArray[n];
            while (variableTableEntry != null) {
                arrayList.add(variableTableEntry.name);
                variableTableEntry = variableTableEntry.next;
            }
        }
        return arrayList;
    }

    @Deprecated
    public Map getVariableMap() {
        return this.variableTableGetMap();
    }

    protected static final boolean isRubyVariable(String string) {
        char c;
        return string.length() > 0 && ((c = string.charAt(0)) == '@' || c <= 'Z' && c >= 'A');
    }

    protected synchronized IRubyObject variableTableReadLocked(VariableTableEntry variableTableEntry) {
        return variableTableEntry.value;
    }

    protected boolean variableTableContains(String string) {
        VariableTableEntry[] variableTableEntryArray = this.variableTable;
        if (this.variableTable != null) {
            int n = string.hashCode();
            VariableTableEntry variableTableEntry = variableTableEntryArray[n & variableTableEntryArray.length - 1];
            while (variableTableEntry != null) {
                if (n == variableTableEntry.hash && string.equals(variableTableEntry.name)) {
                    return true;
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return false;
    }

    protected boolean variableTableFastContains(String string) {
        assert (string == string.intern()) : string + " not interned";
        VariableTableEntry[] variableTableEntryArray = this.variableTable;
        if (this.variableTable != null) {
            VariableTableEntry variableTableEntry = variableTableEntryArray[string.hashCode() & variableTableEntryArray.length - 1];
            while (variableTableEntry != null) {
                if (string == variableTableEntry.name) {
                    return true;
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return false;
    }

    protected IRubyObject variableTableFetch(String string) {
        VariableTableEntry[] variableTableEntryArray = this.variableTable;
        if (this.variableTable != null) {
            int n = string.hashCode();
            VariableTableEntry variableTableEntry = variableTableEntryArray[n & variableTableEntryArray.length - 1];
            while (variableTableEntry != null) {
                if (n == variableTableEntry.hash && string.equals(variableTableEntry.name)) {
                    IRubyObject iRubyObject = variableTableEntry.value;
                    if (iRubyObject != null) {
                        return iRubyObject;
                    }
                    return this.variableTableReadLocked(variableTableEntry);
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return null;
    }

    protected IRubyObject variableTableFastFetch(String string) {
        assert (string == string.intern()) : string + " not interned";
        VariableTableEntry[] variableTableEntryArray = this.variableTable;
        if (this.variableTable != null) {
            VariableTableEntry variableTableEntry = variableTableEntryArray[string.hashCode() & variableTableEntryArray.length - 1];
            while (variableTableEntry != null) {
                if (string == variableTableEntry.name) {
                    IRubyObject iRubyObject = variableTableEntry.value;
                    if (iRubyObject != null) {
                        return iRubyObject;
                    }
                    return this.variableTableReadLocked(variableTableEntry);
                }
                variableTableEntry = variableTableEntry.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableStore(String string, IRubyObject iRubyObject) {
        int n = string.hashCode();
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            VariableTableEntry[] variableTableEntryArray = this.variableTable;
            if (this.variableTable == null) {
                VariableTableEntry variableTableEntry;
                variableTableEntryArray = new VariableTableEntry[8];
                variableTableEntryArray[n & 7] = variableTableEntry = new VariableTableEntry(n, string.intern(), iRubyObject, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = variableTableEntryArray;
                return iRubyObject;
            }
            int n2 = this.variableTableSize + 1;
            if (n2 > this.variableTableThreshold) {
                variableTableEntryArray = this.variableTableRehash();
            }
            int n3 = n & variableTableEntryArray.length - 1;
            VariableTableEntry variableTableEntry = variableTableEntryArray[n3];
            while (variableTableEntry != null) {
                if (n == variableTableEntry.hash && string.equals(variableTableEntry.name)) {
                    variableTableEntry.value = iRubyObject;
                    return iRubyObject;
                }
                variableTableEntry = variableTableEntry.next;
            }
            variableTableEntryArray[n3] = variableTableEntry = new VariableTableEntry(n, string.intern(), iRubyObject, variableTableEntryArray[n3]);
            this.variableTableSize = n2;
            this.variableTable = variableTableEntryArray;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableFastStore(String string, IRubyObject iRubyObject) {
        assert (string == string.intern()) : string + " not interned";
        int n = string.hashCode();
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            VariableTableEntry[] variableTableEntryArray = this.variableTable;
            if (this.variableTable == null) {
                VariableTableEntry variableTableEntry;
                variableTableEntryArray = new VariableTableEntry[8];
                variableTableEntryArray[n & 7] = variableTableEntry = new VariableTableEntry(n, string, iRubyObject, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = variableTableEntryArray;
                return iRubyObject;
            }
            int n2 = this.variableTableSize + 1;
            if (n2 > this.variableTableThreshold) {
                variableTableEntryArray = this.variableTableRehash();
            }
            int n3 = n & variableTableEntryArray.length - 1;
            VariableTableEntry variableTableEntry = variableTableEntryArray[n3];
            while (variableTableEntry != null) {
                if (string == variableTableEntry.name) {
                    variableTableEntry.value = iRubyObject;
                    return iRubyObject;
                }
                variableTableEntry = variableTableEntry.next;
            }
            variableTableEntryArray[n3] = variableTableEntry = new VariableTableEntry(n, string, iRubyObject, variableTableEntryArray[n3]);
            this.variableTableSize = n2;
            this.variableTable = variableTableEntryArray;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject variableTableRemove(String string) {
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            VariableTableEntry[] variableTableEntryArray = this.variableTable;
            if (this.variableTable != null) {
                VariableTableEntry variableTableEntry;
                int n = string.hashCode();
                int n2 = n & variableTableEntryArray.length - 1;
                VariableTableEntry variableTableEntry2 = variableTableEntry = variableTableEntryArray[n2];
                while (variableTableEntry2 != null) {
                    if (n == variableTableEntry2.hash && string.equals(variableTableEntry2.name)) {
                        IRubyObject iRubyObject = variableTableEntry2.value;
                        VariableTableEntry variableTableEntry3 = variableTableEntry2.next;
                        VariableTableEntry variableTableEntry4 = variableTableEntry;
                        while (variableTableEntry4 != variableTableEntry2) {
                            variableTableEntry3 = new VariableTableEntry(variableTableEntry4.hash, variableTableEntry4.name, variableTableEntry4.value, variableTableEntry3);
                            variableTableEntry4 = variableTableEntry4.next;
                        }
                        variableTableEntryArray[n2] = variableTableEntry3;
                        --this.variableTableSize;
                        this.variableTable = variableTableEntryArray;
                        return iRubyObject;
                    }
                    variableTableEntry2 = variableTableEntry2.next;
                }
            }
        }
        return null;
    }

    protected VariableTableEntry[] variableTableGetTable() {
        VariableTableEntry[] variableTableEntryArray = this.variableTable;
        if (this.variableTable != null) {
            return variableTableEntryArray;
        }
        return VARIABLE_TABLE_EMPTY_TABLE;
    }

    protected int variableTableGetSize() {
        if (this.variableTable != null) {
            return this.variableTableSize;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void variableTableSync(List<Variable<IRubyObject>> list) {
        RubyObject rubyObject = this;
        synchronized (rubyObject) {
            this.variableTableSize = 0;
            this.variableTableThreshold = 6;
            this.variableTable = new VariableTableEntry[8];
            for (Variable<IRubyObject> variable : list) {
                this.variableTableStore(variable.getName(), variable.getValue());
            }
        }
    }

    protected final VariableTableEntry[] variableTableRehash() {
        VariableTableEntry[] variableTableEntryArray = this.variableTable;
        int n = variableTableEntryArray.length;
        if (n >= 0x40000000) {
            return variableTableEntryArray;
        }
        int n2 = n << 1;
        VariableTableEntry[] variableTableEntryArray2 = new VariableTableEntry[n2];
        this.variableTableThreshold = (int)((float)n2 * 0.75f);
        int n3 = n2 - 1;
        int n4 = n;
        while (--n4 >= 0) {
            int n5;
            VariableTableEntry variableTableEntry = variableTableEntryArray[n4];
            if (variableTableEntry == null) continue;
            VariableTableEntry variableTableEntry2 = variableTableEntry.next;
            int n6 = variableTableEntry.hash & n3;
            if (variableTableEntry2 == null) {
                variableTableEntryArray2[n6] = variableTableEntry;
                continue;
            }
            VariableTableEntry variableTableEntry3 = variableTableEntry;
            int n7 = n6;
            VariableTableEntry variableTableEntry4 = variableTableEntry2;
            while (variableTableEntry4 != null) {
                n5 = variableTableEntry4.hash & n3;
                if (n5 != n7) {
                    n7 = n5;
                    variableTableEntry3 = variableTableEntry4;
                }
                variableTableEntry4 = variableTableEntry4.next;
            }
            variableTableEntryArray2[n7] = variableTableEntry3;
            variableTableEntry4 = variableTableEntry;
            while (variableTableEntry4 != variableTableEntry3) {
                VariableTableEntry variableTableEntry5;
                n5 = variableTableEntry4.hash & n3;
                variableTableEntryArray2[n5] = variableTableEntry5 = new VariableTableEntry(variableTableEntry4.hash, variableTableEntry4.name, variableTableEntry4.value, variableTableEntryArray2[n5]);
                variableTableEntry4 = variableTableEntry4.next;
            }
        }
        this.variableTable = variableTableEntryArray2;
        return variableTableEntryArray2;
    }

    protected Map variableTableGetMap() {
        HashMap<String, IRubyObject> hashMap = new HashMap<String, IRubyObject>();
        VariableTableEntry[] variableTableEntryArray = this.variableTable;
        if (this.variableTable != null) {
            int n = variableTableEntryArray.length;
            while (--n >= 0) {
                VariableTableEntry variableTableEntry = variableTableEntryArray[n];
                while (variableTableEntry != null) {
                    IRubyObject iRubyObject = variableTableEntry.value;
                    if (iRubyObject == null) {
                        iRubyObject = this.variableTableReadLocked(variableTableEntry);
                    }
                    hashMap.put(variableTableEntry.name, iRubyObject);
                    variableTableEntry = variableTableEntry.next;
                }
            }
        }
        return hashMap;
    }

    protected Map variableTableGetMap(Map map) {
        VariableTableEntry[] variableTableEntryArray = this.variableTable;
        if (this.variableTable != null) {
            int n = variableTableEntryArray.length;
            while (--n >= 0) {
                VariableTableEntry variableTableEntry = variableTableEntryArray[n];
                while (variableTableEntry != null) {
                    IRubyObject iRubyObject = variableTableEntry.value;
                    if (iRubyObject == null) {
                        iRubyObject = this.variableTableReadLocked(variableTableEntry);
                    }
                    map.put(variableTableEntry.name, iRubyObject);
                    variableTableEntry = variableTableEntry.next;
                }
            }
        }
        return map;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        List<String> list = this.getInstanceVariableNameList();
        objectOutputStream.writeInt(list.size());
        for (String string : list) {
            objectOutputStream.writeObject(string);
            objectOutputStream.writeObject(this.getInstanceVariables().getInstanceVariable(string));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.setInstanceVariable((String)objectInputStream.readObject(), (IRubyObject)objectInputStream.readObject());
        }
    }

    protected static final class VariableTableEntry {
        final int hash;
        final String name;
        volatile IRubyObject value;
        final VariableTableEntry next;

        VariableTableEntry(int n, String string, IRubyObject iRubyObject, VariableTableEntry variableTableEntry) {
            assert (string == string.intern()) : string + " is not interned";
            this.hash = n;
            this.name = string;
            this.value = iRubyObject;
            this.next = variableTableEntry;
        }
    }

    public static class ObjectMethods {
        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
        public static IRubyObject intialize(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().getNil();
        }
    }

    public class Finalizer
    implements Finalizable {
        private long id;
        private List<IRubyObject> finalizers;
        private AtomicBoolean finalized;

        public Finalizer(long l) {
            this.id = l;
            this.finalized = new AtomicBoolean(false);
        }

        public void addFinalizer(IRubyObject iRubyObject) {
            if (this.finalizers == null) {
                this.finalizers = new ArrayList<IRubyObject>();
            }
            this.finalizers.add(iRubyObject);
        }

        public void removeFinalizers() {
            this.finalizers = null;
        }

        public void finalize() {
            if (this.finalized.compareAndSet(false, true) && this.finalizers != null) {
                for (int i = 0; i < this.finalizers.size(); ++i) {
                    IRubyObject iRubyObject = this.finalizers.get(i);
                    RuntimeHelpers.invoke(iRubyObject.getRuntime().getCurrentContext(), iRubyObject, "call", RubyObject.this.id());
                }
            }
        }
    }
}

