/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import org.jruby.nb.nb.nb.CompatVersion;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyComplex;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyFloat;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyRational;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"NilClass"})
public class RubyNil
extends RubyObject {
    public static final ObjectAllocator NIL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return ruby.getNil();
        }
    };

    public RubyNil(Ruby ruby) {
        super(ruby, ruby.getNilClass(), false);
        this.flags |= 3;
    }

    public static RubyClass createNilClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("NilClass", ruby.getObject(), NIL_ALLOCATOR);
        ruby.setNilClass(rubyClass);
        rubyClass.index = 5;
        rubyClass.defineAnnotatedMethods(RubyNil.class);
        rubyClass.getMetaClass().undefineMethod("new");
        return rubyClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 5;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Void.TYPE;
    }

    @JRubyMethod(name={"to_i"})
    public static RubyFixnum to_i(IRubyObject iRubyObject) {
        return RubyFixnum.zero(iRubyObject.getRuntime());
    }

    @JRubyMethod(name={"to_f"})
    public static RubyFloat to_f(IRubyObject iRubyObject) {
        return RubyFloat.newFloat(iRubyObject.getRuntime(), 0.0);
    }

    @JRubyMethod(name={"to_s"})
    public static RubyString to_s(IRubyObject iRubyObject) {
        return RubyString.newEmptyString(iRubyObject.getRuntime());
    }

    @JRubyMethod(name={"to_a"})
    public static RubyArray to_a(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newEmptyArray();
    }

    @JRubyMethod(name={"inspect"})
    public static RubyString inspect(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newString("nil");
    }

    @JRubyMethod(name={"type"})
    public static RubyClass type(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getNilClass();
    }

    @JRubyMethod(name={"&"}, required=1)
    public static RubyBoolean op_and(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().getFalse();
    }

    @JRubyMethod(name={"|"}, required=1)
    public static RubyBoolean op_or(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().newBoolean(iRubyObject2.isTrue());
    }

    @JRubyMethod(name={"^"}, required=1)
    public static RubyBoolean op_xor(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().newBoolean(iRubyObject2.isTrue());
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    @Override
    public RubyFixnum id() {
        return this.getRuntime().newFixnum(4);
    }

    @Override
    public IRubyObject taint(ThreadContext threadContext) {
        return this;
    }

    @Override
    public IRubyObject freeze(ThreadContext threadContext) {
        return this;
    }

    @JRubyMethod(name={"to_c"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_c(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyComplex.newComplexCanonicalize(threadContext, RubyFixnum.zero(threadContext.getRuntime()));
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_r(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyRational.newRationalCanonicalize(threadContext, RubyFixnum.zero(threadContext.getRuntime()));
    }
}

