/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyIO;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.nb.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.nb.nb.util.IOInputStream;
import org.jruby.nb.nb.nb.util.IOOutputStream;
import org.jruby.util.ByteList;

@JRubyModule(name={"Marshal"})
public class RubyMarshal {
    public static RubyModule createMarshalModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Marshal");
        ruby.setMarshal(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyMarshal.class);
        rubyModule.defineConstant("MAJOR_VERSION", ruby.newFixnum(4));
        rubyModule.defineConstant("MINOR_VERSION", ruby.newFixnum(8));
        return rubyModule;
    }

    @JRubyMethod(name={"dump"}, required=1, optional=2, frame=true, module=true)
    public static IRubyObject dump(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (iRubyObjectArray.length < 1) {
            throw iRubyObject.getRuntime().newArgumentError("wrong # of arguments(at least 1)");
        }
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = null;
        int n = -1;
        if (iRubyObjectArray.length >= 2) {
            if (iRubyObjectArray[1].respondsTo("write")) {
                iRubyObject3 = iRubyObjectArray[1];
            } else if (iRubyObjectArray[1] instanceof RubyFixnum) {
                n = (int)((RubyFixnum)iRubyObjectArray[1]).getLongValue();
            } else {
                throw iRubyObject.getRuntime().newTypeError("Instance of IO needed");
            }
            if (iRubyObjectArray.length == 3) {
                n = (int)((RubyFixnum)iRubyObjectArray[2]).getLongValue();
            }
        }
        try {
            if (iRubyObject3 != null) {
                RubyMarshal.dumpToStream(iRubyObject2, RubyMarshal.outputStream(iRubyObject3), n);
                return iRubyObject3;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            RubyMarshal.dumpToStream(iRubyObject2, byteArrayOutputStream, n);
            return RubyString.newString(iRubyObject.getRuntime(), new ByteList(byteArrayOutputStream.toByteArray(), false));
        }
        catch (IOException iOException) {
            throw iRubyObject.getRuntime().newIOErrorFromException(iOException);
        }
    }

    private static OutputStream outputStream(IRubyObject iRubyObject) {
        RubyMarshal.setBinmodeIfPossible(iRubyObject);
        if (iRubyObject instanceof RubyIO) {
            return ((RubyIO)iRubyObject).getOutStream();
        }
        return new IOOutputStream(iRubyObject);
    }

    private static void setBinmodeIfPossible(IRubyObject iRubyObject) {
        if (iRubyObject.respondsTo("binmode")) {
            iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "binmode");
        }
    }

    @JRubyMethod(name={"load", "restore"}, required=1, optional=1, frame=true, module=true)
    public static IRubyObject load(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        try {
            Object object;
            InputStream inputStream;
            if (iRubyObjectArray.length < 1) {
                throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments (0 for 1)");
            }
            if (iRubyObjectArray.length > 2) {
                throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments (" + iRubyObjectArray.length + " for 2)");
            }
            IRubyObject iRubyObject2 = null;
            IRubyObject iRubyObject3 = null;
            switch (iRubyObjectArray.length) {
                case 2: {
                    iRubyObject3 = iRubyObjectArray[1];
                }
                case 1: {
                    iRubyObject2 = iRubyObjectArray[0];
                }
            }
            if (iRubyObject2 != null && iRubyObject2.respondsTo("read")) {
                inputStream = RubyMarshal.inputStream(iRubyObject2);
            } else if (iRubyObject2 != null && iRubyObject2.respondsTo("to_str")) {
                object = (RubyString)RuntimeHelpers.invoke(threadContext, iRubyObject2, "to_str");
                ByteList byteList = ((RubyString)object).getByteList();
                inputStream = new ByteArrayInputStream(byteList.unsafeBytes(), byteList.begin(), byteList.length());
            } else {
                throw iRubyObject.getRuntime().newTypeError("instance of IO needed");
            }
            object = new UnmarshalStream(iRubyObject.getRuntime(), inputStream, iRubyObject3);
            return ((UnmarshalStream)object).unmarshalObject();
        }
        catch (EOFException eOFException) {
            throw iRubyObject.getRuntime().newEOFError();
        }
        catch (IOException iOException) {
            throw iRubyObject.getRuntime().newIOErrorFromException(iOException);
        }
    }

    private static InputStream inputStream(IRubyObject iRubyObject) {
        RubyMarshal.setBinmodeIfPossible(iRubyObject);
        if (iRubyObject instanceof RubyIO) {
            return ((RubyIO)iRubyObject).getInStream();
        }
        return new IOInputStream(iRubyObject);
    }

    private static void dumpToStream(IRubyObject iRubyObject, OutputStream outputStream, int n) throws IOException {
        MarshalStream marshalStream = new MarshalStream(iRubyObject.getRuntime(), outputStream, n);
        marshalStream.dumpObject(iRubyObject);
    }
}

