/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyMethod;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.RubySymbol;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.nb.ast.ArgsNode;
import org.jruby.nb.nb.nb.ast.ArgumentNode;
import org.jruby.nb.nb.nb.ast.ListNode;
import org.jruby.nb.nb.nb.ast.LocalAsgnNode;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.RootNode;
import org.jruby.nb.nb.nb.compiler.ASTCompiler;
import org.jruby.nb.nb.nb.compiler.ASTInspector;
import org.jruby.nb.nb.nb.compiler.impl.StandardASMCompiler;
import org.jruby.nb.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.nb.internal.runtime.methods.MethodArgs;
import org.jruby.nb.nb.nb.javasupport.Java;
import org.jruby.nb.nb.nb.javasupport.JavaObject;
import org.jruby.nb.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.CompiledBlock;
import org.jruby.nb.nb.nb.runtime.InterpretedBlock;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.load.Library;
import org.jruby.nb.nb.nb.util.TypeConverter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.TraceClassVisitor;

@JRubyModule(name={"JRuby"})
public class RubyJRuby {
    public static RubyModule createJRuby(Ruby ruby) {
        ThreadContext threadContext = ruby.getCurrentContext();
        ruby.getKernel().callMethod(threadContext, "require", ruby.newString("java"));
        RubyModule rubyModule = ruby.defineModule("JRuby");
        rubyModule.defineAnnotatedMethods(RubyJRuby.class);
        RubyClass rubyClass = rubyModule.defineClassUnder("CompiledScript", ruby.getObject(), ruby.getObject().getAllocator());
        rubyClass.attr_accessor(threadContext, new IRubyObject[]{ruby.newSymbol("name"), ruby.newSymbol("class_name"), ruby.newSymbol("original_script"), ruby.newSymbol("code")});
        rubyClass.defineAnnotatedMethods(JRubyCompiledScript.class);
        return rubyModule;
    }

    public static RubyModule createJRubyExt(Ruby ruby) {
        ruby.getKernel().callMethod(ruby.getCurrentContext(), "require", ruby.newString("java"));
        RubyModule rubyModule = ruby.getOrCreateModule("JRuby").defineModuleUnder("Extensions");
        rubyModule.defineAnnotatedMethods(JRubyExtensions.class);
        ruby.getObject().includeModule(rubyModule);
        return rubyModule;
    }

    @JRubyMethod(name={"runtime"}, frame=true, module=true)
    public static IRubyObject runtime(IRubyObject iRubyObject, Block block) {
        return Java.java_to_ruby(iRubyObject, JavaObject.wrap(iRubyObject.getRuntime(), iRubyObject.getRuntime()), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"objectspace"}, frame=true, module=true)
    public static IRubyObject getObjectSpaceEnabled(IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        return RubyBoolean.newBoolean(ruby, ruby.isObjectSpaceEnabled());
    }

    @JRubyMethod(name={"objectspace="}, required=1, frame=true, module=true)
    public static IRubyObject setObjectSpaceEnabled(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        ruby.setObjectSpaceEnabled(iRubyObject2.isTrue());
        return ruby.getNil();
    }

    @JRubyMethod(name={"parse", "ast_for"}, optional=3, frame=true, module=true)
    public static IRubyObject parse(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (block.isGiven()) {
            if (block.getBody() instanceof CompiledBlock) {
                throw new RuntimeException("Cannot compile an already compiled block. Use -J-Djruby.jit.enabled=false to avoid this problem.");
            }
            Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 0, 0);
            return Java.java_to_ruby(iRubyObject, JavaObject.wrap(iRubyObject.getRuntime(), ((InterpretedBlock)block.getBody()).getIterNode().getBodyNode()), Block.NULL_BLOCK);
        }
        Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 1, 3);
        String string = "-";
        boolean bl = false;
        RubyString rubyString = iRubyObjectArray[0].convertToString();
        if (iRubyObjectArray.length > 1) {
            string = iRubyObjectArray[1].convertToString().toString();
            if (iRubyObjectArray.length > 2) {
                bl = iRubyObjectArray[2].isTrue();
            }
        }
        return Java.java_to_ruby(iRubyObject, JavaObject.wrap(iRubyObject.getRuntime(), iRubyObject.getRuntime().parse(rubyString.getByteList(), string, null, 0, bl)), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"compile"}, optional=3, frame=true, module=true)
    public static IRubyObject compile(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        String string;
        Node node;
        Object object;
        RubyString rubyString;
        if (block.isGiven()) {
            Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 0, 0);
            if (block.getBody() instanceof CompiledBlock) {
                throw new RuntimeException("Cannot compile an already compiled block. Use -J-Djruby.jit.enabled=false to avoid this problem.");
            }
            rubyString = RubyString.newEmptyString(iRubyObject.getRuntime());
            object = ((InterpretedBlock)block.getBody()).getIterNode().getBodyNode();
            node = new RootNode(((Node)object).getPosition(), block.getBinding().getDynamicScope(), (Node)object);
            string = "__block_" + node.getPosition().getFile();
        } else {
            Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 1, 3);
            string = "-";
            boolean bl = false;
            rubyString = iRubyObjectArray[0].convertToString();
            if (iRubyObjectArray.length > 1) {
                string = iRubyObjectArray[1].convertToString().toString();
                if (iRubyObjectArray.length > 2) {
                    bl = iRubyObjectArray[2].isTrue();
                }
            }
            node = iRubyObject.getRuntime().parse(rubyString.getByteList(), string, null, 0, bl);
        }
        object = string.equals("-e") ? "__dash_e__" : string.replace('\\', '/').replaceAll(".rb", "").replaceAll("-", "_dash_");
        ASTInspector aSTInspector = new ASTInspector();
        aSTInspector.inspect(node);
        StandardASMCompiler standardASMCompiler = new StandardASMCompiler((String)object, string);
        ASTCompiler aSTCompiler = new ASTCompiler();
        aSTCompiler.compileRoot(node, standardASMCompiler, aSTInspector);
        byte[] byArray = standardASMCompiler.getClassByteArray();
        IRubyObject iRubyObject2 = ((RubyModule)iRubyObject).fastGetConstant("CompiledScript").callMethod(iRubyObject.getRuntime().getCurrentContext(), "new");
        iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "name=", iRubyObject.getRuntime().newString(string));
        iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "class_name=", iRubyObject.getRuntime().newString((String)object));
        iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "original_script=", rubyString);
        iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "code=", Java.java_to_ruby(iRubyObject, JavaObject.wrap(iRubyObject.getRuntime(), byArray), Block.NULL_BLOCK));
        return iRubyObject2;
    }

    @JRubyMethod(name={"reference"}, required=1, module=true)
    public static IRubyObject reference(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Java.wrap(iRubyObject.getRuntime().getJavaSupport().getJavaUtilitiesModule(), (IRubyObject)JavaObject.wrap(iRubyObject.getRuntime(), iRubyObject2));
    }

    @JRubyMethod(name={"dereference"}, required=1, module=true)
    public static IRubyObject dereference(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (!(iRubyObject2.dataGetStruct() instanceof JavaObject)) {
            throw threadContext.getRuntime().newTypeError("got " + iRubyObject2 + ", expected wrapped Java object");
        }
        Object object = JavaUtil.unwrapJavaObject(iRubyObject2);
        if (!(object instanceof IRubyObject)) {
            throw threadContext.getRuntime().newTypeError("got " + iRubyObject2 + ", expected Java-wrapped Ruby object");
        }
        return (IRubyObject)object;
    }

    public static class MethodExtensions {
        @JRubyMethod(name={"args"})
        public static IRubyObject methodArgs(IRubyObject iRubyObject) {
            Ruby ruby = iRubyObject.getRuntime();
            RubyMethod rubyMethod = (RubyMethod)iRubyObject;
            DynamicMethod dynamicMethod = rubyMethod.method;
            if (dynamicMethod instanceof MethodArgs) {
                Node node;
                MethodArgs methodArgs = (MethodArgs)((Object)dynamicMethod);
                ArgsNode argsNode = methodArgs.getArgsNode();
                RubyArray rubyArray = RubyArray.newArray(ruby);
                RubyArray rubyArray2 = RubyArray.newArray(ruby);
                ListNode listNode = argsNode.getArgs();
                for (int i = 0; listNode != null && i < listNode.size(); ++i) {
                    node = (ArgumentNode)listNode.get(i);
                    rubyArray2.append(RubySymbol.newSymbol(ruby, ((ArgumentNode)node).getName()));
                }
                rubyArray.append(rubyArray2);
                RubyArray rubyArray3 = RubyArray.newArray(ruby);
                node = argsNode.getOptArgs();
                for (int i = 0; node != null && i < ((ListNode)node).size(); ++i) {
                    LocalAsgnNode localAsgnNode = (LocalAsgnNode)((ListNode)node).get(i);
                    rubyArray3.append(RubySymbol.newSymbol(ruby, localAsgnNode.getName()));
                }
                rubyArray.append(rubyArray3);
                if (argsNode.getRestArgNode() != null) {
                    rubyArray.append(RubySymbol.newSymbol(ruby, argsNode.getRestArgNode().getName()));
                } else {
                    rubyArray.append(ruby.getNil());
                }
                if (argsNode.getBlockArgNode() != null) {
                    rubyArray.append(RubySymbol.newSymbol(ruby, argsNode.getBlockArgNode().getName()));
                } else {
                    rubyArray.append(ruby.getNil());
                }
                return rubyArray;
            }
            throw ruby.newTypeError("Method args are only available for standard interpreted or jitted methods");
        }
    }

    @JRubyModule(name={"JRubyExtensions"})
    public static class JRubyExtensions {
        @JRubyMethod(name={"steal_method"}, required=2, module=true)
        public static IRubyObject steal_method(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            RubyModule rubyModule = null;
            rubyModule = iRubyObject instanceof RubyModule ? (RubyModule)iRubyObject : iRubyObject.getSingletonClass();
            String string = iRubyObject3.toString();
            if (!(iRubyObject2 instanceof RubyModule)) {
                throw iRubyObject.getRuntime().newArgumentError("First argument must be a module/class");
            }
            DynamicMethod dynamicMethod = ((RubyModule)iRubyObject2).searchMethod(string);
            if (dynamicMethod == null || dynamicMethod.isUndefined()) {
                throw iRubyObject.getRuntime().newArgumentError("No such method " + string + " on " + iRubyObject2);
            }
            rubyModule.addMethod(string, dynamicMethod);
            return iRubyObject.getRuntime().getNil();
        }

        @JRubyMethod(name={"steal_methods"}, required=1, rest=true, module=true)
        public static IRubyObject steal_methods(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject2 = iRubyObjectArray[0];
            for (int i = 1; i < iRubyObjectArray.length; ++i) {
                JRubyExtensions.steal_method(iRubyObject, iRubyObject2, iRubyObjectArray[i]);
            }
            return iRubyObject.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"JRuby::CompiledScript"})
    public static class JRubyCompiledScript {
        @JRubyMethod(name={"to_s"})
        public static IRubyObject compiled_script_to_s(IRubyObject iRubyObject) {
            return iRubyObject.getInstanceVariables().fastGetInstanceVariable("@original_script");
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject compiled_script_inspect(IRubyObject iRubyObject) {
            return iRubyObject.getRuntime().newString("#<JRuby::CompiledScript " + iRubyObject.getInstanceVariables().fastGetInstanceVariable("@name") + ">");
        }

        @JRubyMethod(name={"inspect_bytecode"})
        public static IRubyObject compiled_script_inspect_bytecode(IRubyObject iRubyObject) {
            StringWriter stringWriter = new StringWriter();
            ClassReader classReader = new ClassReader((byte[])JavaUtil.convertRubyToJava(iRubyObject.getInstanceVariables().fastGetInstanceVariable("@code"), byte[].class));
            TraceClassVisitor traceClassVisitor = new TraceClassVisitor(new PrintWriter(stringWriter));
            classReader.accept((ClassVisitor)traceClassVisitor, 2);
            return iRubyObject.getRuntime().newString(stringWriter.toString());
        }
    }

    public static class TypeLibrary
    implements Library {
        public void load(Ruby ruby, boolean bl) throws IOException {
            RubyModule rubyModule = ruby.defineModule("Type");
            rubyModule.defineAnnotatedMethods(TypeLibrary.class);
        }

        @JRubyMethod(module=true)
        public static IRubyObject coerce_to(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            Ruby ruby = iRubyObject2.getRuntime();
            if (!(iRubyObject3 instanceof RubyClass)) {
                throw ruby.newTypeError(iRubyObject3, ruby.getClassClass());
            }
            if (!(iRubyObject4 instanceof RubySymbol)) {
                throw ruby.newTypeError(iRubyObject4, ruby.getSymbol());
            }
            RubyClass rubyClass = (RubyClass)iRubyObject3;
            RubySymbol rubySymbol = (RubySymbol)iRubyObject4;
            return TypeConverter.convertToTypeOrRaise(iRubyObject2, rubyClass, rubySymbol.asJavaString());
        }
    }

    public static class ExtLibrary
    implements Library {
        public void load(Ruby ruby, boolean bl) throws IOException {
            RubyJRuby.createJRubyExt(ruby);
            ruby.getMethod().defineAnnotatedMethods(MethodExtensions.class);
        }
    }
}

