/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.nb.nb.nb.CompatVersion;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyFloat;
import org.jruby.nb.nb.nb.RubyInteger;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyRational;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.nb.nb.runtime.marshal.UnmarshalStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Bignum"}, parent="Integer")
public class RubyBignum
extends RubyInteger {
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private final BigInteger value;

    public static RubyClass createBignumClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Bignum", ruby.getInteger(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setBignum(rubyClass);
        rubyClass.index = 2;
        rubyClass.defineAnnotatedMethods(RubyBignum.class);
        return rubyClass;
    }

    public RubyBignum(Ruby ruby, BigInteger bigInteger) {
        super(ruby, ruby.getBignum());
        this.value = bigInteger;
    }

    @Override
    public int getNativeTypeIndex() {
        return 2;
    }

    @Override
    public Class<?> getJavaClass() {
        return BigInteger.class;
    }

    public static RubyBignum newBignum(Ruby ruby, long l) {
        return RubyBignum.newBignum(ruby, BigInteger.valueOf(l));
    }

    public static RubyBignum newBignum(Ruby ruby, double d) {
        return RubyBignum.newBignum(ruby, new BigDecimal(d).toBigInteger());
    }

    public static RubyBignum newBignum(Ruby ruby, BigInteger bigInteger) {
        return new RubyBignum(ruby, bigInteger);
    }

    public static RubyBignum newBignum(Ruby ruby, String string) {
        return new RubyBignum(ruby, new BigInteger(string));
    }

    @Override
    public double getDoubleValue() {
        return RubyBignum.big2dbl(this);
    }

    @Override
    public long getLongValue() {
        return RubyBignum.big2long(this);
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static RubyInteger bignorm(Ruby ruby, BigInteger bigInteger) {
        if (bigInteger.compareTo(LONG_MIN) < 0 || bigInteger.compareTo(LONG_MAX) > 0) {
            return RubyBignum.newBignum(ruby, bigInteger);
        }
        return ruby.newFixnum(bigInteger.longValue());
    }

    public static long big2long(RubyBignum rubyBignum) {
        BigInteger bigInteger = rubyBignum.getValue();
        if (bigInteger.compareTo(LONG_MIN) < 0 || bigInteger.compareTo(LONG_MAX) > 0) {
            throw rubyBignum.getRuntime().newRangeError("bignum too big to convert into `long'");
        }
        return bigInteger.longValue();
    }

    public static double big2dbl(RubyBignum rubyBignum) {
        BigInteger bigInteger = rubyBignum.getValue();
        double d = RubyBignum.convertToDouble(bigInteger);
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            rubyBignum.getRuntime().getWarnings().warn(IRubyWarnings.ID.BIGNUM_FROM_FLOAT_RANGE, "Bignum out of Float range", new Object[0]);
        }
        return d;
    }

    private IRubyObject checkShiftDown(RubyBignum rubyBignum) {
        if (rubyBignum.value.signum() == 0) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (this.value.compareTo(LONG_MIN) < 0 || this.value.compareTo(LONG_MAX) > 0) {
            return rubyBignum.value.signum() >= 0 ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.minus_one(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    static double convertToDouble(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        double d = 0.0;
        double d2 = 1.0;
        for (int i = byArray.length - 1; i > 0; --i) {
            d += (double)(byArray[i] & 0xFF) * d2;
            d2 *= 256.0;
        }
        return d += (double)byArray[0] * d2;
    }

    public static BigInteger fix2big(RubyFixnum rubyFixnum) {
        return BigInteger.valueOf(rubyFixnum.getLongValue());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(IRubyObject[] iRubyObjectArray) {
        int n;
        int n2 = n = iRubyObjectArray.length == 0 ? 10 : RubyBignum.num2int(iRubyObjectArray[0]);
        if (n < 2 || n > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + n);
        }
        return this.getRuntime().newString(this.getValue().toString(n));
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.getRuntime().newArray(RubyBignum.newBignum(this.getRuntime(), ((RubyFixnum)iRubyObject).getLongValue()), this);
        }
        if (iRubyObject instanceof RubyBignum) {
            return this.getRuntime().newArray(RubyBignum.newBignum(this.getRuntime(), ((RubyBignum)iRubyObject).getValue()), this);
        }
        throw this.getRuntime().newTypeError("Can't coerce " + iRubyObject.getMetaClass().getName() + " to Bignum");
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return RubyBignum.bignorm(this.getRuntime(), this.value.negate());
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.addFixnum((RubyFixnum)iRubyObject);
        }
        if (iRubyObject instanceof RubyBignum) {
            return this.addBignum((RubyBignum)iRubyObject);
        }
        if (iRubyObject instanceof RubyFloat) {
            return this.addFloat((RubyFloat)iRubyObject);
        }
        return this.addOther(threadContext, iRubyObject);
    }

    private IRubyObject addFixnum(RubyFixnum rubyFixnum) {
        return RubyBignum.bignorm(this.getRuntime(), this.value.add(RubyBignum.fix2big(rubyFixnum)));
    }

    private IRubyObject addBignum(RubyBignum rubyBignum) {
        return RubyBignum.bignorm(this.getRuntime(), this.value.add(rubyBignum.value));
    }

    private IRubyObject addFloat(RubyFloat rubyFloat) {
        return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) + rubyFloat.getDoubleValue());
    }

    private IRubyObject addOther(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.coerceBin(threadContext, "+", iRubyObject);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.subtractFixnum((RubyFixnum)iRubyObject);
        }
        if (iRubyObject instanceof RubyBignum) {
            return this.subtractBignum((RubyBignum)iRubyObject);
        }
        if (iRubyObject instanceof RubyFloat) {
            return this.subtractFloat((RubyFloat)iRubyObject);
        }
        return this.subtractOther(threadContext, iRubyObject);
    }

    private IRubyObject subtractFixnum(RubyFixnum rubyFixnum) {
        return RubyBignum.bignorm(this.getRuntime(), this.value.subtract(RubyBignum.fix2big(rubyFixnum)));
    }

    private IRubyObject subtractBignum(RubyBignum rubyBignum) {
        return RubyBignum.bignorm(this.getRuntime(), this.value.subtract(rubyBignum.value));
    }

    private IRubyObject subtractFloat(RubyFloat rubyFloat) {
        return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) - rubyFloat.getDoubleValue());
    }

    private IRubyObject subtractOther(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.coerceBin(threadContext, "-", iRubyObject);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.multiply(RubyBignum.fix2big((RubyFixnum)iRubyObject)));
        }
        if (iRubyObject instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.multiply(((RubyBignum)iRubyObject).value));
        }
        if (iRubyObject instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) * ((RubyFloat)iRubyObject).getDoubleValue());
        }
        return this.coerceBin(threadContext, "*", iRubyObject);
    }

    private IRubyObject op_divide(ThreadContext threadContext, IRubyObject iRubyObject, String string) {
        BigInteger bigInteger;
        assert ("/".equals(string) || "div".equals(string));
        if (iRubyObject instanceof RubyFixnum) {
            bigInteger = RubyBignum.fix2big((RubyFixnum)iRubyObject);
        } else if (iRubyObject instanceof RubyBignum) {
            bigInteger = ((RubyBignum)iRubyObject).value;
        } else {
            if (iRubyObject instanceof RubyFloat) {
                double d = RubyBignum.big2dbl(this) / ((RubyFloat)iRubyObject).getDoubleValue();
                if ("/".equals(string)) {
                    return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) / ((RubyFloat)iRubyObject).getDoubleValue());
                }
                return RubyNumeric.dbl2num(this.getRuntime(), d);
            }
            return this.coerceBin(threadContext, string, iRubyObject);
        }
        if (bigInteger.equals(BigInteger.ZERO)) {
            throw this.getRuntime().newZeroDivisionError();
        }
        BigInteger[] bigIntegerArray = this.value.divideAndRemainder(bigInteger);
        if (this.value.signum() * bigInteger.signum() == -1 && bigIntegerArray[1].signum() != 0) {
            return RubyBignum.bignorm(this.getRuntime(), bigIntegerArray[0].subtract(BigInteger.ONE));
        }
        return RubyBignum.bignorm(this.getRuntime(), bigIntegerArray[0]);
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_div(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.op_divide(threadContext, iRubyObject, "/");
    }

    @JRubyMethod(name={"div"}, required=1)
    public IRubyObject op_idiv(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.op_divide(threadContext, iRubyObject, "div");
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext threadContext, IRubyObject iRubyObject) {
        BigInteger bigInteger;
        if (iRubyObject instanceof RubyFixnum) {
            bigInteger = RubyBignum.fix2big((RubyFixnum)iRubyObject);
        } else if (iRubyObject instanceof RubyBignum) {
            bigInteger = ((RubyBignum)iRubyObject).value;
        } else {
            return this.coerceBin(threadContext, "divmod", iRubyObject);
        }
        if (bigInteger.equals(BigInteger.ZERO)) {
            throw this.getRuntime().newZeroDivisionError();
        }
        BigInteger[] bigIntegerArray = this.value.divideAndRemainder(bigInteger);
        if (this.value.signum() * bigInteger.signum() == -1 && bigIntegerArray[1].signum() != 0) {
            bigIntegerArray[0] = bigIntegerArray[0].subtract(BigInteger.ONE);
            bigIntegerArray[1] = bigInteger.add(bigIntegerArray[1]);
        }
        Ruby ruby = this.getRuntime();
        return RubyArray.newArray(this.getRuntime(), RubyBignum.bignorm(ruby, bigIntegerArray[0]), RubyBignum.bignorm(ruby, bigIntegerArray[1]));
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(ThreadContext threadContext, IRubyObject iRubyObject) {
        BigInteger bigInteger;
        if (iRubyObject instanceof RubyFixnum) {
            bigInteger = RubyBignum.fix2big((RubyFixnum)iRubyObject);
        } else if (iRubyObject instanceof RubyBignum) {
            bigInteger = ((RubyBignum)iRubyObject).value;
        } else {
            return this.coerceBin(threadContext, "%", iRubyObject);
        }
        if (bigInteger.equals(BigInteger.ZERO)) {
            throw this.getRuntime().newZeroDivisionError();
        }
        BigInteger bigInteger2 = this.value.mod(bigInteger.abs());
        if (bigInteger.signum() == -1 && bigInteger2.signum() != 0) {
            bigInteger2 = bigInteger.add(bigInteger2);
        }
        return RubyBignum.bignorm(this.getRuntime(), bigInteger2);
    }

    @Override
    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder(ThreadContext threadContext, IRubyObject iRubyObject) {
        BigInteger bigInteger;
        if (iRubyObject instanceof RubyFixnum) {
            bigInteger = RubyBignum.fix2big((RubyFixnum)iRubyObject);
        } else if (iRubyObject instanceof RubyBignum) {
            bigInteger = ((RubyBignum)iRubyObject).value;
        } else {
            return this.coerceBin(threadContext, "remainder", iRubyObject);
        }
        if (bigInteger.equals(BigInteger.ZERO)) {
            throw this.getRuntime().newZeroDivisionError();
        }
        return RubyBignum.bignorm(this.getRuntime(), this.value.remainder(bigInteger));
    }

    @Override
    @JRubyMethod(name={"quo"}, required=1)
    public IRubyObject quo(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) / ((RubyNumeric)iRubyObject).getDoubleValue());
        }
        return this.coerceBin(threadContext, "quo", iRubyObject);
    }

    @JRubyMethod(name={"**", "power"}, required=1)
    public IRubyObject op_pow(ThreadContext threadContext, IRubyObject iRubyObject) {
        double d;
        if (iRubyObject instanceof RubyFixnum) {
            RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
            long l = rubyFixnum.getLongValue();
            if ((long)((this.value.bitLength() + 7) / 8 * 4) * Math.abs(l) > 0x100000L) {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big", l);
            }
            if (l >= 0L) {
                return RubyBignum.bignorm(this.getRuntime(), this.value.pow((int)l));
            }
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(RubyBignum.big2dbl(this), l));
        }
        if (iRubyObject instanceof RubyBignum) {
            d = ((RubyBignum)iRubyObject).getDoubleValue();
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big", d);
        } else if (iRubyObject instanceof RubyFloat) {
            d = ((RubyFloat)iRubyObject).getDoubleValue();
        } else {
            return this.coerceBin(threadContext, "**", iRubyObject);
        }
        return RubyFloat.newFloat(this.getRuntime(), Math.pow(RubyBignum.big2dbl(this), d));
    }

    @JRubyMethod(name={"**", "power"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_pow_19(ThreadContext threadContext, IRubyObject iRubyObject) {
        double d;
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject == RubyFixnum.zero(ruby)) {
            return RubyFixnum.one(ruby);
        }
        if (iRubyObject instanceof RubyFixnum) {
            RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
            long l = rubyFixnum.getLongValue();
            if (l < 0L) {
                return RubyRational.newRationalRaw(ruby, this).callMethod(threadContext, "**", iRubyObject);
            }
            if ((long)((this.value.bitLength() + 7) / 8 * 4) * Math.abs(l) > 0x100000L) {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big", l);
            }
            if (l >= 0L) {
                return RubyBignum.bignorm(ruby, this.value.pow((int)l));
            }
            return RubyFloat.newFloat(ruby, Math.pow(RubyBignum.big2dbl(this), l));
        }
        if (iRubyObject instanceof RubyBignum) {
            if (iRubyObject.callMethod(threadContext, "<", RubyFixnum.zero(ruby)).isTrue()) {
                return RubyRational.newRationalRaw(ruby, this).callMethod(threadContext, "**", iRubyObject);
            }
            d = ((RubyBignum)iRubyObject).getDoubleValue();
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big", d);
        } else if (iRubyObject instanceof RubyFloat) {
            d = ((RubyFloat)iRubyObject).getDoubleValue();
        } else {
            return this.coerceBin(threadContext, "**", iRubyObject);
        }
        return RubyNumeric.dbl2num(ruby, Math.pow(RubyBignum.big2dbl(this), d));
    }

    @JRubyMethod(name={"&"}, required=1)
    public IRubyObject op_and(ThreadContext threadContext, IRubyObject iRubyObject) {
        if ((iRubyObject = iRubyObject.convertToInteger()) instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.and(((RubyBignum)iRubyObject).value));
        }
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.and(RubyBignum.fix2big((RubyFixnum)iRubyObject)));
        }
        return this.coerceBin(threadContext, "&", iRubyObject);
    }

    @JRubyMethod(name={"|"}, required=1)
    public IRubyObject op_or(ThreadContext threadContext, IRubyObject iRubyObject) {
        if ((iRubyObject = iRubyObject.convertToInteger()) instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.or(((RubyBignum)iRubyObject).value));
        }
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.or(RubyBignum.fix2big((RubyFixnum)iRubyObject)));
        }
        return this.coerceBin(threadContext, "|", iRubyObject);
    }

    @JRubyMethod(name={"^"}, required=1)
    public IRubyObject op_xor(ThreadContext threadContext, IRubyObject iRubyObject) {
        if ((iRubyObject = iRubyObject.convertToInteger()) instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.xor(((RubyBignum)iRubyObject).value));
        }
        if (iRubyObject instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.xor(BigInteger.valueOf(((RubyFixnum)iRubyObject).getLongValue())));
        }
        return this.coerceBin(threadContext, "^", iRubyObject);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_neg() {
        return RubyBignum.newBignum(this.getRuntime(), this.value.not());
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_lshift(IRubyObject iRubyObject) {
        long l;
        boolean bl = false;
        while (true) {
            if (iRubyObject instanceof RubyFixnum) {
                l = ((RubyFixnum)iRubyObject).getLongValue();
                if (l >= 0L) break;
                bl = true;
                l = -l;
                break;
            }
            if (iRubyObject instanceof RubyBignum) {
                RubyBignum rubyBignum = (RubyBignum)iRubyObject;
                if (rubyBignum.value.signum() < 0) {
                    IRubyObject iRubyObject2 = rubyBignum.checkShiftDown(this);
                    if (!iRubyObject2.isNil()) {
                        return iRubyObject2;
                    }
                    bl = true;
                }
                l = RubyBignum.big2long(rubyBignum);
                break;
            }
            iRubyObject = iRubyObject.convertToInteger();
        }
        return RubyBignum.bignorm(this.getRuntime(), bl ? this.value.shiftRight((int)l) : this.value.shiftLeft((int)l));
    }

    @JRubyMethod(name={">>"}, required=1)
    public IRubyObject op_rshift(IRubyObject iRubyObject) {
        long l;
        boolean bl = false;
        while (true) {
            if (iRubyObject instanceof RubyFixnum) {
                l = ((RubyFixnum)iRubyObject).getLongValue();
                if (l >= 0L) break;
                bl = true;
                l = -l;
                break;
            }
            if (iRubyObject instanceof RubyBignum) {
                RubyBignum rubyBignum = (RubyBignum)iRubyObject;
                if (rubyBignum.value.signum() >= 0) {
                    IRubyObject iRubyObject2 = rubyBignum.checkShiftDown(this);
                    if (!iRubyObject2.isNil()) {
                        return iRubyObject2;
                    }
                } else {
                    bl = true;
                }
                l = RubyBignum.big2long(rubyBignum);
                break;
            }
            iRubyObject = iRubyObject.convertToInteger();
        }
        return RubyBignum.bignorm(this.getRuntime(), bl ? this.value.shiftLeft((int)l) : this.value.shiftRight((int)l));
    }

    @JRubyMethod(name={"[]"}, required=1)
    public RubyFixnum op_aref(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyBignum) {
            if (((RubyBignum)iRubyObject).value.signum() >= 0 || this.value.signum() == -1) {
                return RubyFixnum.zero(this.getRuntime());
            }
            return RubyFixnum.one(this.getRuntime());
        }
        long l = RubyBignum.num2long(iRubyObject);
        if (l < 0L || l > Integer.MAX_VALUE) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.value.testBit((int)l) ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        BigInteger bigInteger;
        if (iRubyObject instanceof RubyFixnum) {
            bigInteger = RubyBignum.fix2big((RubyFixnum)iRubyObject);
        } else if (iRubyObject instanceof RubyBignum) {
            bigInteger = ((RubyBignum)iRubyObject).value;
        } else {
            if (iRubyObject instanceof RubyFloat) {
                return RubyBignum.dbl_cmp(this.getRuntime(), RubyBignum.big2dbl(this), ((RubyFloat)iRubyObject).getDoubleValue());
            }
            return this.coerceCmp(threadContext, "<=>", iRubyObject);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value.compareTo(bigInteger));
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject iRubyObject) {
        BigInteger bigInteger;
        if (iRubyObject instanceof RubyFixnum) {
            bigInteger = RubyBignum.fix2big((RubyFixnum)iRubyObject);
        } else if (iRubyObject instanceof RubyBignum) {
            bigInteger = ((RubyBignum)iRubyObject).value;
        } else {
            if (iRubyObject instanceof RubyFloat) {
                double d = ((RubyFloat)iRubyObject).getDoubleValue();
                if (Double.isNaN(d)) {
                    return this.getRuntime().getFalse();
                }
                return RubyBoolean.newBoolean(this.getRuntime(), d == RubyBignum.big2dbl(this));
            }
            return iRubyObject.op_eqq(this.getRuntime().getCurrentContext(), this);
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this.value.compareTo(bigInteger) == 0);
    }

    @Override
    @JRubyMethod(name={"eql?", "==="}, required=1)
    public IRubyObject eql_p(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyBignum) {
            return this.value.compareTo(((RubyBignum)iRubyObject).value) == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        return RubyBignum.newBignum(this.getRuntime(), this.value.abs());
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum((this.value.bitLength() + 7) / 8);
    }

    public static void marshalTo(RubyBignum rubyBignum, MarshalStream marshalStream) throws IOException {
        marshalStream.registerLinkTarget(rubyBignum);
        marshalStream.write(rubyBignum.value.signum() >= 0 ? 43 : 45);
        BigInteger bigInteger = rubyBignum.value.abs();
        byte[] byArray = bigInteger.toByteArray();
        boolean bl = byArray.length % 2 != 0 && byArray[0] != 0;
        int n = byArray.length / 2;
        if (bl) {
            ++n;
        }
        marshalStream.writeInt(n);
        for (int i = 1; i <= n * 2 && i <= byArray.length; ++i) {
            marshalStream.write(byArray[byArray.length - i]);
        }
        if (bl) {
            marshalStream.write(0);
        }
    }

    public static RubyNumeric unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        boolean bl = unmarshalStream.readUnsignedByte() == 43;
        int n = unmarshalStream.unmarshalInt();
        byte[] byArray = new byte[n * 2 + 1];
        for (int i = byArray.length - 1; i >= 1; --i) {
            byArray[i] = unmarshalStream.readSignedByte();
        }
        BigInteger bigInteger = new BigInteger(byArray);
        if (!bl) {
            bigInteger = bigInteger.negate();
        }
        RubyInteger rubyInteger = RubyBignum.bignorm(unmarshalStream.getRuntime(), bigInteger);
        unmarshalStream.registerLinkTarget(rubyInteger);
        return rubyInteger;
    }
}

