/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBignum;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyFloat;
import org.jruby.nb.nb.nb.RubyInteger;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyConstant;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.CallbackFactory;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"BigDecimal"}, parent="Numeric")
public class RubyBigDecimal
extends RubyNumeric {
    private static final ObjectAllocator BIGDECIMAL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyBigDecimal(ruby, rubyClass);
        }
    };
    @JRubyConstant
    public static final int ROUND_DOWN = 1;
    @JRubyConstant
    public static final int ROUND_CEILING = 2;
    @JRubyConstant
    public static final int ROUND_UP = 0;
    @JRubyConstant
    public static final int ROUND_HALF_DOWN = 5;
    @JRubyConstant
    public static final int ROUND_HALF_EVEN = 6;
    @JRubyConstant
    public static final int ROUND_HALF_UP = 4;
    @JRubyConstant
    public static final int ROUND_FLOOR = 3;
    @JRubyConstant
    public static final int SIGN_POSITIVE_INFINITE = 3;
    @JRubyConstant
    public static final int EXCEPTION_OVERFLOW = 1;
    @JRubyConstant
    public static final int SIGN_POSITIVE_ZERO = 1;
    @JRubyConstant
    public static final int EXCEPTION_ALL = 255;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_FINITE = -2;
    @JRubyConstant
    public static final int EXCEPTION_UNDERFLOW = 4;
    @JRubyConstant
    public static final int SIGN_NaN = 0;
    @JRubyConstant
    public static final int BASE = 10000;
    @JRubyConstant
    public static final int ROUND_MODE = 256;
    @JRubyConstant
    public static final int SIGN_POSITIVE_FINITE = 2;
    @JRubyConstant
    public static final int EXCEPTION_INFINITY = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_INFINITE = -3;
    @JRubyConstant
    public static final int EXCEPTION_ZERODIVIDE = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_ZERO = -1;
    @JRubyConstant
    public static final int EXCEPTION_NaN = 2;
    private static final BigDecimal TWO = new BigDecimal(2);
    private static final double SQRT_10 = 3.1622776601683795;
    private boolean isNaN = false;
    private int infinitySign = 0;
    private int zeroSign = 0;
    private BigDecimal value;
    private static final Pattern INFINITY_PATTERN = Pattern.compile("^([+-])?Infinity$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([+-]?\\d*\\.?\\d*([eE][+-]?)?\\d*).*");

    public static RubyClass createBigDecimal(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("BigDecimal", ruby.getNumeric(), BIGDECIMAL_ALLOCATOR);
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyBigDecimal.class);
        ruby.getKernel().defineAnnotatedMethods(BigDecimalKernelMethods.class);
        rubyClass.setInternalModuleVariable("vpPrecLimit", RubyFixnum.zero(ruby));
        rubyClass.setInternalModuleVariable("vpExceptionMode", RubyFixnum.zero(ruby));
        rubyClass.setInternalModuleVariable("vpRoundingMode", ruby.newFixnum(4));
        rubyClass.defineAnnotatedMethods(RubyBigDecimal.class);
        rubyClass.defineAnnotatedConstants(RubyBigDecimal.class);
        return rubyClass;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public RubyBigDecimal(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public RubyBigDecimal(Ruby ruby, BigDecimal bigDecimal) {
        super(ruby, ruby.fastGetClass("BigDecimal"));
        this.value = bigDecimal;
    }

    public static RubyBigDecimal newBigDecimal(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyBigDecimal.newInstance(iRubyObject.getRuntime().fastGetClass("BigDecimal"), iRubyObjectArray);
    }

    @JRubyMethod(name={"ver"}, meta=true)
    public static IRubyObject ver(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newString("1.0.1");
    }

    @JRubyMethod(name={"_dump"}, optional=1, frame=true)
    public IRubyObject dump(IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = RubyString.newUnicodeString(iRubyObjectArray[0].getRuntime(), "0:");
        RubyString rubyString2 = this.asString();
        return rubyString.append(rubyString2);
    }

    @JRubyMethod(name={"_load"}, required=1, frame=true, meta=true)
    public static RubyBigDecimal load(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyBigDecimal rubyBigDecimal = (RubyBigDecimal)((RubyClass)iRubyObject).allocate();
        String string = iRubyObject2.convertToString().asJavaString();
        String string2 = string.substring(string.indexOf(":") + 1);
        rubyBigDecimal.value = new BigDecimal(string2);
        return rubyBigDecimal;
    }

    @JRubyMethod(name={"double_fig"}, meta=true)
    public static IRubyObject double_fig(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newFixnum(20);
    }

    @JRubyMethod(name={"limit"}, optional=1, meta=true)
    public static IRubyObject limit(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2;
        Ruby ruby = iRubyObject.getRuntime();
        RubyModule rubyModule = (RubyModule)iRubyObject;
        IRubyObject iRubyObject3 = rubyModule.searchInternalModuleVariable("vpPrecLimit");
        if (iRubyObjectArray.length > 0 && !(iRubyObject2 = iRubyObjectArray[0]).isNil()) {
            if (!(iRubyObject2 instanceof RubyFixnum)) {
                throw ruby.newTypeError(iRubyObject2, ruby.getFixnum());
            }
            if (0L > ((RubyFixnum)iRubyObject2).getLongValue()) {
                throw ruby.newArgumentError("argument must be positive");
            }
            rubyModule.setInternalModuleVariable("vpPrecLimit", iRubyObject2);
        }
        return iRubyObject3;
    }

    @JRubyMethod(name={"mode"}, required=1, optional=1, meta=true)
    public static IRubyObject mode(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        long l;
        Ruby ruby = iRubyObject.getRuntime();
        RubyClass rubyClass = ruby.fastGetClass("BigDecimal");
        RubyModule rubyModule = (RubyModule)iRubyObject;
        iRubyObjectArray = Arity.scanArgs(ruby, iRubyObjectArray, 1, 1);
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = iRubyObjectArray[1];
        if (!(iRubyObject2 instanceof RubyFixnum)) {
            throw ruby.newTypeError("wrong argument type " + iRubyObject2.getMetaClass() + " (expected Fixnum)");
        }
        long l2 = ((RubyFixnum)iRubyObject2).getLongValue();
        if ((l2 & (l = ((RubyFixnum)rubyClass.fastGetConstant("EXCEPTION_ALL")).getLongValue())) != 0L) {
            RubyFixnum rubyFixnum;
            if (iRubyObject3.isNil()) {
                return rubyModule.searchInternalModuleVariable("vpExceptionMode");
            }
            if (!iRubyObject3.isNil() && !(iRubyObject3 instanceof RubyBoolean)) {
                throw ruby.newTypeError("second argument must be true or false");
            }
            RubyFixnum rubyFixnum2 = (RubyFixnum)rubyModule.searchInternalModuleVariable("vpExceptionMode");
            RubyFixnum rubyFixnum3 = new RubyFixnum(ruby, rubyFixnum2.getLongValue());
            RubyFixnum rubyFixnum4 = (RubyFixnum)rubyClass.fastGetConstant("EXCEPTION_INFINITY");
            if ((l2 & rubyFixnum4.getLongValue()) != 0L) {
                RubyFixnum rubyFixnum5 = rubyFixnum3 = iRubyObject3.isTrue() ? (RubyFixnum)rubyFixnum2.callCoerced(threadContext, "|", rubyFixnum4) : (RubyFixnum)rubyFixnum2.callCoerced(threadContext, "&", new RubyFixnum(ruby, rubyFixnum4.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((l2 & (rubyFixnum = (RubyFixnum)rubyClass.fastGetConstant("EXCEPTION_NaN")).getLongValue()) != 0L) {
                rubyFixnum3 = iRubyObject3.isTrue() ? (RubyFixnum)rubyFixnum2.callCoerced(threadContext, "|", rubyFixnum) : (RubyFixnum)rubyFixnum2.callCoerced(threadContext, "&", new RubyFixnum(ruby, rubyFixnum.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            rubyModule.setInternalModuleVariable("vpExceptionMode", rubyFixnum3);
            return rubyFixnum3;
        }
        long l3 = ((RubyFixnum)rubyClass.fastGetConstant("ROUND_MODE")).getLongValue();
        if (l2 == l3) {
            if (iRubyObject3.isNil()) {
                return rubyModule.searchInternalModuleVariable("vpRoundingMode");
            }
            if (!(iRubyObject3 instanceof RubyFixnum)) {
                throw ruby.newTypeError("wrong argument type " + iRubyObject2.getMetaClass() + " (expected Fixnum)");
            }
            RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject3;
            if (rubyFixnum != rubyClass.fastGetConstant("ROUND_UP") && rubyFixnum != rubyClass.fastGetConstant("ROUND_DOWN") && rubyFixnum != rubyClass.fastGetConstant("ROUND_FLOOR") && rubyFixnum != rubyClass.fastGetConstant("ROUND_CEILING") && rubyFixnum != rubyClass.fastGetConstant("ROUND_HALF_UP") && rubyFixnum != rubyClass.fastGetConstant("ROUND_HALF_DOWN") && rubyFixnum != rubyClass.fastGetConstant("ROUND_HALF_EVEN")) {
                throw ruby.newTypeError("invalid rounding mode");
            }
            rubyModule.setInternalModuleVariable("vpRoundingMode", rubyFixnum);
            return rubyModule.searchInternalModuleVariable("vpRoundingMode");
        }
        throw ruby.newTypeError("first argument for BigDecimal#mode invalid");
    }

    private RoundingMode getRoundingMode(Ruby ruby) {
        RubyFixnum rubyFixnum = (RubyFixnum)ruby.fastGetClass("BigDecimal").searchInternalModuleVariable("vpRoundingMode");
        return RoundingMode.valueOf((int)rubyFixnum.getLongValue());
    }

    private RubyBigDecimal getVpValue(IRubyObject iRubyObject, boolean bl) {
        if (iRubyObject instanceof RubyBigDecimal) {
            return (RubyBigDecimal)iRubyObject;
        }
        if (iRubyObject instanceof RubyFixnum || iRubyObject instanceof RubyBignum) {
            String string = iRubyObject.toString();
            return RubyBigDecimal.newInstance(this.getRuntime().fastGetClass("BigDecimal"), new IRubyObject[]{this.getRuntime().newString(string)});
        }
        if (bl) {
            String string;
            if (this.isImmediate()) {
                ThreadContext threadContext = this.getRuntime().getCurrentContext();
                string = RubyBigDecimal.inspect(threadContext, this).toString();
            } else {
                string = this.getMetaClass().getBaseName();
            }
            throw this.getRuntime().newTypeError(string + " can't be coerced into BigDecimal");
        }
        return null;
    }

    @JRubyMethod(name={"new"}, required=1, optional=1, meta=true)
    public static RubyBigDecimal newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        BigDecimal bigDecimal;
        if (iRubyObjectArray.length == 0) {
            bigDecimal = new BigDecimal(0);
        } else {
            String string = iRubyObjectArray[0].convertToString().toString();
            if ("NaN".equals(string = string.trim())) {
                return RubyBigDecimal.newNaN(iRubyObject.getRuntime());
            }
            Matcher matcher = INFINITY_PATTERN.matcher(string);
            if (matcher.matches()) {
                int n = 1;
                String string2 = matcher.group(1);
                if ("-".equals(string2)) {
                    n = -1;
                }
                return RubyBigDecimal.newInfinity(iRubyObject.getRuntime(), n);
            }
            string = string.replaceFirst("[dD]", "E");
            string = string.replaceAll("_", "");
            string = NUMBER_PATTERN.matcher(string).replaceFirst("$1");
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                bigDecimal = new BigDecimal(0);
            }
            if (bigDecimal.signum() == 0) {
                if (string.matches("^\\s*-.*")) {
                    return RubyBigDecimal.newZero(iRubyObject.getRuntime(), -1);
                }
                return RubyBigDecimal.newZero(iRubyObject.getRuntime(), 1);
            }
        }
        return new RubyBigDecimal(iRubyObject.getRuntime(), bigDecimal);
    }

    private static RubyBigDecimal newZero(Ruby ruby, int n) {
        RubyBigDecimal rubyBigDecimal = new RubyBigDecimal(ruby, BigDecimal.ZERO);
        rubyBigDecimal.zeroSign = n < 0 ? -1 : 1;
        return rubyBigDecimal;
    }

    private static RubyBigDecimal newNaN(Ruby ruby) {
        RubyBigDecimal rubyBigDecimal = new RubyBigDecimal(ruby, BigDecimal.ZERO);
        rubyBigDecimal.isNaN = true;
        return rubyBigDecimal;
    }

    private static RubyBigDecimal newInfinity(Ruby ruby, int n) {
        RubyBigDecimal rubyBigDecimal = new RubyBigDecimal(ruby, BigDecimal.ZERO);
        rubyBigDecimal.infinitySign = n < 0 ? -1 : 1;
        return rubyBigDecimal;
    }

    private RubyBigDecimal setResult() {
        return this.setResult(0);
    }

    private RubyBigDecimal setResult(int n) {
        int n2 = RubyFixnum.fix2int(this.getRuntime().fastGetClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
        int n3 = Math.max(n, n2);
        if (n3 > 0 && this.value.scale() > n3 - this.getExponent()) {
            this.value = this.value.setScale(n3 - this.getExponent(), 4);
        }
        return this;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.newNaN(ruby);
        }
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "%", iRubyObject, true);
        }
        if (rubyBigDecimal.isInfinity() || rubyBigDecimal.isNaN() || rubyBigDecimal.isZero()) {
            return RubyBigDecimal.newNaN(ruby);
        }
        BigDecimal bigDecimal = this.value.remainder(rubyBigDecimal.value);
        if (bigDecimal.signum() * rubyBigDecimal.value.signum() < 0) {
            bigDecimal = bigDecimal.add(rubyBigDecimal.value);
        }
        return new RubyBigDecimal(ruby, bigDecimal).setResult();
    }

    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.newNaN(ruby);
        }
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "remainder", iRubyObject, true);
        }
        if (rubyBigDecimal.isInfinity() || rubyBigDecimal.isNaN() || rubyBigDecimal.isZero()) {
            return RubyBigDecimal.newNaN(ruby);
        }
        return new RubyBigDecimal(ruby, this.value.remainder(rubyBigDecimal.value)).setResult();
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.mult2(threadContext, iRubyObject, RubyFixnum.zero(threadContext.getRuntime()));
    }

    @JRubyMethod(name={"mult"}, required=2)
    public IRubyObject mult2(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "*", iRubyObject);
        }
        int n = RubyNumeric.fix2int(iRubyObject2);
        if (this.isNaN() || rubyBigDecimal.isNaN()) {
            return RubyBigDecimal.newNaN(ruby);
        }
        if (this.isInfinity() && rubyBigDecimal.isZero() || this.isZero() && rubyBigDecimal.isInfinity()) {
            return RubyBigDecimal.newNaN(ruby);
        }
        if (this.isZero() || rubyBigDecimal.isZero()) {
            int n2 = this.isZero() ? this.zeroSign : this.value.signum();
            int n3 = rubyBigDecimal.isZero() ? rubyBigDecimal.zeroSign : rubyBigDecimal.value.signum();
            return RubyBigDecimal.newZero(ruby, n2 * n3);
        }
        if (this.isInfinity() || rubyBigDecimal.isInfinity()) {
            int n4 = this.isInfinity() ? this.infinitySign : this.value.signum();
            int n5 = rubyBigDecimal.isInfinity() ? rubyBigDecimal.infinitySign : rubyBigDecimal.value.signum();
            return RubyBigDecimal.newInfinity(ruby, n4 * n5);
        }
        BigDecimal bigDecimal = this.value.multiply(rubyBigDecimal.value);
        if (bigDecimal.precision() > n) {
            bigDecimal = bigDecimal.round(new MathContext(n, RoundingMode.HALF_UP));
        }
        return new RubyBigDecimal(ruby, bigDecimal).setResult();
    }

    @JRubyMethod(name={"**", "power"}, required=1)
    public IRubyObject op_pow(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyFixnum)) {
            throw this.getRuntime().newTypeError("wrong argument type " + iRubyObject.getMetaClass() + " (expected Fixnum)");
        }
        if (this.isNaN() || this.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        int n = RubyNumeric.fix2int(iRubyObject.convertToInteger());
        if (n < 0) {
            if (this.isZero()) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), this.value.signum());
            }
            int n2 = (-n + 4) * (this.getAllDigits().length() + 4);
            return new RubyBigDecimal(this.getRuntime(), this.value.pow(n, new MathContext(n2, RoundingMode.HALF_UP)));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.pow(n));
    }

    @JRubyMethod(name={"+"}, required=1, frame=true)
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.addInternal(threadContext, iRubyObject, "add", RubyFixnum.zero(threadContext.getRuntime()));
    }

    @JRubyMethod(name={"add"}, required=2, frame=true)
    public IRubyObject add2(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.addInternal(threadContext, iRubyObject, "add", iRubyObject2);
    }

    private IRubyObject addInternal(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        int n = this.getPositiveInt(threadContext, iRubyObject2);
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "+", iRubyObject, true);
        }
        IRubyObject iRubyObject3 = this.handleAddSpecialValues(rubyBigDecimal);
        if (iRubyObject3 != null) {
            return iRubyObject3;
        }
        RoundingMode roundingMode = this.getRoundingMode(ruby);
        return new RubyBigDecimal(ruby, this.value.add(rubyBigDecimal.value, new MathContext(n, roundingMode)));
    }

    private int getPositiveInt(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject instanceof RubyFixnum) {
            int n = RubyNumeric.fix2int(iRubyObject);
            if (n < 0) {
                throw ruby.newArgumentError("argument must be positive");
            }
            return n;
        }
        throw ruby.newTypeError(iRubyObject, ruby.getFixnum());
    }

    private IRubyObject handleAddSpecialValues(RubyBigDecimal rubyBigDecimal) {
        int n;
        if (this.isNaN() || rubyBigDecimal.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * rubyBigDecimal.infinitySign > 0) {
            return this.isInfinity() ? this : rubyBigDecimal;
        }
        if (this.infinitySign * rubyBigDecimal.infinitySign < 0) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * rubyBigDecimal.infinitySign == 0 && (n = this.infinitySign + rubyBigDecimal.infinitySign) != 0) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), n);
        }
        return null;
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "-", iRubyObject);
        }
        RubyBigDecimal rubyBigDecimal2 = this.handleMinusSpecialValues(rubyBigDecimal);
        if (rubyBigDecimal2 != null) {
            return rubyBigDecimal2;
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(rubyBigDecimal.value)).setResult();
    }

    @JRubyMethod(name={"sub"}, required=2)
    public IRubyObject sub2(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "-", iRubyObject);
        }
        RubyBigDecimal rubyBigDecimal2 = this.handleMinusSpecialValues(rubyBigDecimal);
        if (rubyBigDecimal2 != null) {
            return rubyBigDecimal2;
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(rubyBigDecimal.value)).setResult();
    }

    private RubyBigDecimal handleMinusSpecialValues(RubyBigDecimal rubyBigDecimal) {
        if (this.isNaN() || rubyBigDecimal.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * rubyBigDecimal.infinitySign > 0) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * rubyBigDecimal.infinitySign < 0) {
            return this;
        }
        if (this.infinitySign * rubyBigDecimal.infinitySign == 0) {
            if (this.isInfinity()) {
                return this;
            }
            if (rubyBigDecimal.isInfinity()) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), rubyBigDecimal.infinitySign * -1);
            }
            int n = this.infinitySign + rubyBigDecimal.infinitySign;
            if (n != 0) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), n);
            }
        }
        return null;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        Ruby ruby = this.getRuntime();
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(ruby);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(ruby, -this.infinitySign);
        }
        if (this.isZero()) {
            return RubyBigDecimal.newZero(ruby, -this.zeroSign);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.negate());
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_quo(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.op_div(threadContext, iRubyObject, this.getRuntime().newFixnum(200));
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "div", iRubyObject);
        }
        if (this.isNaN() || rubyBigDecimal.isZero() || rubyBigDecimal.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity() || rubyBigDecimal.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.divideToIntegralValue(rubyBigDecimal.value)).setResult();
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = RubyNumeric.fix2int(iRubyObject2);
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "/", iRubyObject);
        }
        if (this.isNaN() || this.isZero() && rubyBigDecimal.isZero() || rubyBigDecimal.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (rubyBigDecimal.isZero()) {
            int n2 = this.isInfinity() ? this.infinitySign : this.value.signum();
            return RubyBigDecimal.newInfinity(this.getRuntime(), n2 * rubyBigDecimal.zeroSign);
        }
        if (this.isInfinity() && !rubyBigDecimal.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign * rubyBigDecimal.value.signum());
        }
        if (!this.isInfinity() && rubyBigDecimal.isInfinity()) {
            return RubyBigDecimal.newZero(this.getRuntime(), this.value.signum() * rubyBigDecimal.infinitySign);
        }
        if (this.isInfinity() && rubyBigDecimal.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (n == 0) {
            return this.op_quo(threadContext, iRubyObject);
        }
        int n3 = Math.max(200, n);
        return new RubyBigDecimal(this.getRuntime(), this.value.divide(rubyBigDecimal.value, new MathContext(n3, RoundingMode.HALF_UP))).setResult(n);
    }

    private IRubyObject cmp(ThreadContext threadContext, IRubyObject iRubyObject, char c) {
        int n = 0;
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            IRubyObject iRubyObject2 = this.callCoerced(threadContext, "<=>", iRubyObject);
            if (iRubyObject2.isNil()) {
                return this.getRuntime().getNil();
            }
            n = RubyNumeric.fix2int(iRubyObject2);
        } else {
            if (this.isNaN() | rubyBigDecimal.isNaN()) {
                return this.getRuntime().getNil();
            }
            n = this.infinitySign != 0 || rubyBigDecimal.infinitySign != 0 ? this.infinitySign - rubyBigDecimal.infinitySign : this.value.compareTo(rubyBigDecimal.value);
        }
        switch (c) {
            case '*': {
                return this.getRuntime().newFixnum(n);
            }
            case '=': {
                return n == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '!': {
                return n != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'G': {
                return n >= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '>': {
                return n > 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'L': {
                return n <= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '<': {
                return n < 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, '*');
    }

    @JRubyMethod(name={"eql?", "==", "==="}, required=1)
    public IRubyObject eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, '=');
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, '<');
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, 'L');
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, '>');
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.cmp(threadContext, iRubyObject, 'G');
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        Ruby ruby = this.getRuntime();
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(ruby);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(ruby, 1);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.abs()).setResult();
    }

    @JRubyMethod(name={"ceil"}, optional=1)
    public IRubyObject ceil(IRubyObject[] iRubyObjectArray) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = 0;
        if (iRubyObjectArray.length > 0) {
            n = RubyNumeric.fix2int(iRubyObjectArray[0]);
        }
        if (this.value.scale() > n) {
            return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n, RoundingMode.CEILING));
        }
        return this;
    }

    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject instanceof RubyFloat ? this.getRuntime().newArray(iRubyObject, this.to_f()) : this.getRuntime().newArray(this.getVpValue(iRubyObject, true), this);
        return rubyArray;
    }

    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public RubyNumeric multiplyWith(ThreadContext threadContext, RubyInteger rubyInteger) {
        return (RubyNumeric)this.op_mul(threadContext, rubyInteger);
    }

    public RubyNumeric multiplyWith(ThreadContext threadContext, RubyFloat rubyFloat) {
        return (RubyNumeric)this.op_mul(threadContext, rubyFloat);
    }

    public RubyNumeric multiplyWith(ThreadContext threadContext, RubyBignum rubyBignum) {
        return (RubyNumeric)this.op_mul(threadContext, rubyBignum);
    }

    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        if (this.isInfinity() || this.isNaN()) {
            return RubyArray.newArray(ruby, RubyBigDecimal.newNaN(ruby), RubyBigDecimal.newNaN(ruby));
        }
        RubyBigDecimal rubyBigDecimal = this.getVpValue(iRubyObject, false);
        if (rubyBigDecimal == null) {
            return this.callCoerced(threadContext, "divmod", iRubyObject, true);
        }
        if (rubyBigDecimal.isInfinity() || rubyBigDecimal.isNaN() || rubyBigDecimal.isZero()) {
            return RubyArray.newArray(ruby, RubyBigDecimal.newNaN(ruby), RubyBigDecimal.newNaN(ruby));
        }
        BigDecimal[] bigDecimalArray = this.value.divideAndRemainder(rubyBigDecimal.value);
        BigDecimal bigDecimal = bigDecimalArray[0];
        BigDecimal bigDecimal2 = bigDecimalArray[1];
        if (bigDecimal2.signum() * rubyBigDecimal.value.signum() < 0) {
            bigDecimal = bigDecimal.subtract(BigDecimal.ONE);
            bigDecimal2 = bigDecimal2.add(rubyBigDecimal.value);
        }
        return RubyArray.newArray(ruby, new RubyBigDecimal(ruby, bigDecimal), new RubyBigDecimal(ruby, bigDecimal2));
    }

    @JRubyMethod(name={"exponent"})
    public IRubyObject exponent() {
        return this.getRuntime().newFixnum(this.getExponent());
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (this.isNaN()) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(!this.isInfinity());
    }

    @JRubyMethod(name={"floor"}, optional=1)
    public IRubyObject floor(IRubyObject[] iRubyObjectArray) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = 0;
        if (iRubyObjectArray.length > 0) {
            n = RubyNumeric.fix2int(iRubyObjectArray[0]);
        }
        if (this.value.scale() > n) {
            return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n, RoundingMode.FLOOR));
        }
        return this;
    }

    @JRubyMethod(name={"frac"})
    public IRubyObject frac() {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        if (this.value.scale() > 0 && this.value.precision() < this.value.scale()) {
            return new RubyBigDecimal(this.getRuntime(), this.value);
        }
        BigDecimal bigDecimal = this.value.subtract(((RubyBigDecimal)this.fix()).value);
        return new RubyBigDecimal(this.getRuntime(), bigDecimal);
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (this.infinitySign == 0) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.infinitySign);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext threadContext) {
        StringBuilder stringBuilder = new StringBuilder("#<BigDecimal:").append(Integer.toHexString(System.identityHashCode(this))).append(",");
        stringBuilder.append("'").append(this.callMethod(threadContext, MethodIndex.TO_S, "to_s")).append("'").append(",");
        stringBuilder.append(this.getSignificantDigits().length()).append("(");
        int n = this.getAllDigits().length();
        int n2 = n / 4;
        stringBuilder.append((n2 + 1) * 4).append(")").append(">");
        return this.getRuntime().newString(stringBuilder.toString());
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return this.getRuntime().newBoolean(this.isNaN);
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p() {
        return this.isZero() ? this.getRuntime().getNil() : this;
    }

    @JRubyMethod(name={"precs"})
    public IRubyObject precs() {
        Ruby ruby = this.getRuntime();
        IRubyObject[] iRubyObjectArray = new IRubyObject[2];
        iRubyObjectArray[0] = ruby.newFixnum(this.getSignificantDigits().length());
        int n = this.getAllDigits().length();
        int n2 = n / 4;
        iRubyObjectArray[1] = ruby.newFixnum((n2 + 1) * 4);
        return RubyArray.newArray(ruby, iRubyObjectArray);
    }

    @JRubyMethod(name={"round"}, optional=2)
    public IRubyObject round(IRubyObject[] iRubyObjectArray) {
        int n;
        int n2 = iRubyObjectArray.length > 0 ? RubyBigDecimal.num2int(iRubyObjectArray[0]) : 0;
        int n3 = n = iRubyObjectArray.length > 1 ? this.javaRoundingModeFromRubyRoundingMode(iRubyObjectArray[1]) : 4;
        if (n2 < 0) {
            BigDecimal bigDecimal = this.value.movePointRight(n2);
            BigDecimal bigDecimal2 = bigDecimal.setScale(0, n);
            return new RubyBigDecimal(this.getRuntime(), bigDecimal2.movePointLeft(n2));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n2, n));
    }

    private int javaRoundingModeFromRubyRoundingMode(IRubyObject iRubyObject) {
        return RubyBigDecimal.num2int(iRubyObject);
    }

    @JRubyMethod(name={"sign"})
    public IRubyObject sign() {
        if (this.isNaN()) {
            return this.getMetaClass().fastGetConstant("SIGN_NaN");
        }
        if (this.isInfinity()) {
            if (this.infinitySign < 0) {
                return this.getMetaClass().fastGetConstant("SIGN_NEGATIVE_INFINITE");
            }
            return this.getMetaClass().fastGetConstant("SIGN_POSITIVE_INFINITE");
        }
        if (this.isZero()) {
            if (this.zeroSign < 0) {
                return this.getMetaClass().fastGetConstant("SIGN_NEGATIVE_ZERO");
            }
            return this.getMetaClass().fastGetConstant("SIGN_POSITIVE_ZERO");
        }
        if (this.value.signum() < 0) {
            return this.getMetaClass().fastGetConstant("SIGN_NEGATIVE_FINITE");
        }
        return this.getMetaClass().fastGetConstant("SIGN_POSITIVE_FINITE");
    }

    @JRubyMethod(name={"split"})
    public RubyArray split() {
        RubyFixnum rubyFixnum;
        RubyString rubyString;
        Ruby ruby = this.getRuntime();
        IRubyObject[] iRubyObjectArray = new IRubyObject[4];
        RubyFixnum rubyFixnum2 = this.isNaN ? RubyFixnum.zero(ruby) : (this.isInfinity() ? ruby.newFixnum(this.infinitySign) : (this.isZero() ? ruby.newFixnum(this.zeroSign) : ruby.newFixnum(this.value.signum())));
        iRubyObjectArray[0] = rubyFixnum2;
        if (this.isNaN()) {
            rubyString = ruby.newString("NaN");
            rubyFixnum = RubyFixnum.zero(ruby);
        } else if (this.isInfinity()) {
            rubyString = ruby.newString("Infinity");
            rubyFixnum = RubyFixnum.zero(ruby);
        } else if (this.isZero()) {
            rubyString = ruby.newString("0");
            rubyFixnum = RubyFixnum.zero(ruby);
        } else {
            rubyString = ruby.newString(this.getSignificantDigits());
            rubyFixnum = ruby.newFixnum(this.getExponent());
        }
        iRubyObjectArray[1] = rubyString;
        iRubyObjectArray[3] = rubyFixnum;
        iRubyObjectArray[2] = ruby.newFixnum(10);
        return RubyArray.newArray(ruby, iRubyObjectArray);
    }

    private String getSignificantDigits() {
        BigDecimal bigDecimal = this.value.abs().stripTrailingZeros();
        return bigDecimal.unscaledValue().toString();
    }

    private String getAllDigits() {
        BigDecimal bigDecimal = this.value.abs();
        return bigDecimal.unscaledValue().toString();
    }

    private int getExponent() {
        if (this.isZero()) {
            return 0;
        }
        BigDecimal bigDecimal = this.value.abs().stripTrailingZeros();
        return bigDecimal.precision() - bigDecimal.scale();
    }

    @JRubyMethod(name={"sqrt"}, required=1)
    public IRubyObject sqrt(IRubyObject iRubyObject) {
        Ruby ruby = this.getRuntime();
        if (this.isNaN()) {
            throw ruby.newFloatDomainError("(VpSqrt) SQRT(NaN value)");
        }
        if (this.isInfinity() && this.infinitySign < 0 || this.value.signum() < 0) {
            throw ruby.newFloatDomainError("(VpSqrt) SQRT(negative value)");
        }
        if (this.isInfinity() && this.infinitySign > 0) {
            return RubyBigDecimal.newInfinity(ruby, 1);
        }
        int n = RubyNumeric.fix2int(iRubyObject);
        if (n < 0) {
            throw ruby.newArgumentError("argument must be positive");
        }
        return new RubyBigDecimal(this.getRuntime(), RubyBigDecimal.bigSqrt(this.value, new MathContext(n += 4, RoundingMode.HALF_UP))).setResult();
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        if (this.isNaN()) {
            return RubyFloat.newFloat(this.getRuntime(), Double.NaN);
        }
        if (this.isInfinity()) {
            return RubyFloat.newFloat(this.getRuntime(), this.infinitySign < 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        if (this.isZero()) {
            return RubyFloat.newFloat(this.getRuntime(), this.zeroSign < 0 ? -0.0 : 0.0);
        }
        return RubyFloat.newFloat(this.getRuntime(), this.value.doubleValue());
    }

    @JRubyMethod(name={"to_i", "to_int"})
    public IRubyObject to_int() {
        if (this.isNaN() || this.infinitySign != 0) {
            return this.getRuntime().getNil();
        }
        try {
            return RubyNumeric.int2fix(this.getRuntime(), this.value.longValueExact());
        }
        catch (ArithmeticException arithmeticException) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.toBigInteger());
        }
    }

    private String removeTrailingZeroes(String string) {
        while (string.length() > 0 && string.charAt(string.length() - 1) == '0') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean formatHasLeadingPlus(String string) {
        return string.startsWith("+");
    }

    public static boolean formatHasLeadingSpace(String string) {
        return string.startsWith(" ");
    }

    public static boolean formatHasFloatingPointNotation(String string) {
        return string.endsWith("F");
    }

    public static int formatFractionalDigitGroups(String string) {
        int n = 0;
        Pattern pattern = Pattern.compile("(\\+| )?(\\d+)(E|F)?");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            n = Integer.parseInt(matcher.group(2));
        }
        return n;
    }

    private boolean hasArg(IRubyObject[] iRubyObjectArray) {
        return iRubyObjectArray.length != 0 && !iRubyObjectArray[0].isNil();
    }

    private String format(IRubyObject[] iRubyObjectArray) {
        return iRubyObjectArray[0].toString();
    }

    private String firstArgument(IRubyObject[] iRubyObjectArray) {
        if (this.hasArg(iRubyObjectArray)) {
            return this.format(iRubyObjectArray);
        }
        return null;
    }

    private boolean posSpace(String string) {
        if (null != string) {
            return RubyBigDecimal.formatHasLeadingSpace(string);
        }
        return false;
    }

    private boolean posSign(String string) {
        if (null != string) {
            return RubyBigDecimal.formatHasLeadingPlus(string) || this.posSpace(string);
        }
        return false;
    }

    private boolean asEngineering(String string) {
        if (null != string) {
            return !RubyBigDecimal.formatHasFloatingPointNotation(string);
        }
        return true;
    }

    private int groups(String string) {
        if (null != string) {
            return RubyBigDecimal.formatFractionalDigitGroups(string);
        }
        return 0;
    }

    private boolean isZero() {
        return !this.isNaN() && !this.isInfinity() && this.value.signum() == 0;
    }

    private boolean isNaN() {
        return this.isNaN;
    }

    private boolean isInfinity() {
        return this.infinitySign != 0;
    }

    private String unscaledValue() {
        return this.value.abs().unscaledValue().toString();
    }

    private IRubyObject engineeringValue(String string) {
        int n = this.getExponent();
        int n2 = this.value.signum();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2 == -1 ? "-" : (n2 == 1 ? (this.posSign(string) ? (this.posSpace(string) ? " " : "+") : "") : ""));
        stringBuilder.append("0.");
        if (0 == this.groups(string)) {
            String string2 = this.removeTrailingZeroes(this.unscaledValue());
            if ("".equals(string2)) {
                stringBuilder.append("0");
            } else {
                stringBuilder.append(string2);
            }
        } else {
            String string3 = "";
            for (int i = 0; i < this.unscaledValue().length(); i += this.groups(string)) {
                int n3 = i + this.groups(string);
                if (n3 > this.unscaledValue().length()) {
                    n3 = this.unscaledValue().length();
                }
                stringBuilder.append(string3).append(this.unscaledValue().substring(i, n3));
                string3 = " ";
            }
        }
        stringBuilder.append("E").append(n);
        return this.getRuntime().newString(stringBuilder.toString());
    }

    private IRubyObject floatingPointValue(String string) {
        String[] stringArray = this.value.abs().stripTrailingZeros().toPlainString().split("\\.");
        String string2 = "0";
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        String string3 = "0";
        if (stringArray.length > 1) {
            string3 = stringArray[1];
        }
        int n = this.value.signum();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n == -1 ? "-" : (n == 1 ? (this.posSign(string) ? (this.posSpace(string) ? " " : "+") : "") : ""));
        if (this.groups(string) == 0) {
            stringBuilder.append(string2);
            if (null != string3) {
                stringBuilder.append(".").append(string3);
            }
        } else {
            int n2;
            int n3;
            String string4 = "";
            for (n3 = 0; n3 < string2.length(); n3 += this.groups(string)) {
                n2 = n3 + this.groups(string);
                if (n2 > string2.length()) {
                    n2 = string2.length();
                }
                stringBuilder.append(string4).append(string2.substring(n3, n2));
                string4 = " ";
            }
            if (null != string3) {
                stringBuilder.append(".");
                string4 = "";
                for (n3 = 0; n3 < string3.length(); n3 += this.groups(string)) {
                    n2 = n3 + this.groups(string);
                    if (n2 > string3.length()) {
                        n2 = string3.length();
                    }
                    stringBuilder.append(string4).append(string3.substring(n3, n2));
                    string4 = " ";
                }
            }
        }
        return this.getRuntime().newString(stringBuilder.toString());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(IRubyObject[] iRubyObjectArray) {
        String string = this.firstArgument(iRubyObjectArray);
        if (this.isNaN()) {
            return this.getRuntime().newString("NaN");
        }
        if (this.infinitySign != 0) {
            if (this.infinitySign == -1) {
                return this.getRuntime().newString("-Infinity");
            }
            return this.getRuntime().newString("Infinity");
        }
        if (this.isZero()) {
            String string2 = "0.0";
            if (this.zeroSign < 0) {
                string2 = "-" + string2;
            }
            return this.getRuntime().newString(string2);
        }
        if (this.asEngineering(string)) {
            return this.engineeringValue(string);
        }
        return this.floatingPointValue(string);
    }

    @JRubyMethod
    public IRubyObject fix() {
        return this.truncate(RubyFixnum.zero(this.getRuntime()));
    }

    @JRubyMethod
    public IRubyObject truncate() {
        return this.truncate(RubyFixnum.zero(this.getRuntime()));
    }

    @JRubyMethod
    public IRubyObject truncate(IRubyObject iRubyObject) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = RubyNumeric.fix2int(iRubyObject);
        int n2 = this.value.precision() - this.value.scale() + n;
        if (n2 > 0) {
            return new RubyBigDecimal(this.getRuntime(), this.value.round(new MathContext(n2, RoundingMode.DOWN)));
        }
        return new RubyBigDecimal(this.getRuntime(), BigDecimal.ZERO);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.getRuntime().newBoolean(this.isZero());
    }

    public static BigDecimal bigSqrt(BigDecimal bigDecimal, MathContext mathContext) {
        int n;
        int n2 = bigDecimal.signum();
        if (n2 == -1) {
            throw new ArithmeticException("Square root of a negative number: " + bigDecimal);
        }
        if (n2 == 0) {
            return bigDecimal.round(mathContext);
        }
        int n3 = mathContext.getPrecision();
        if (n3 == 0) {
            throw new IllegalArgumentException("Most roots won't have infinite precision = 0");
        }
        int n4 = 62;
        int n5 = 16;
        MathContext mathContext2 = new MathContext(18, RoundingMode.HALF_DOWN);
        BigDecimal bigDecimal2 = null;
        BigDecimal bigDecimal3 = null;
        BigDecimal bigDecimal4 = null;
        BigDecimal bigDecimal5 = null;
        BigInteger bigInteger = bigDecimal.unscaledValue();
        int n6 = Math.max(0, n - n4 + ((n = bigInteger.bitLength()) % 2 == 0 ? 0 : 1));
        bigInteger = bigInteger.shiftRight(n6);
        double d = Math.sqrt(bigInteger.doubleValue());
        BigDecimal bigDecimal6 = new BigDecimal(BigInteger.ONE.shiftLeft(n6 / 2));
        int n7 = bigDecimal.scale();
        if (n7 % 2 == 1) {
            d *= 3.1622776601683795;
        }
        n7 = (int)Math.floor((double)n7 / 2.0);
        bigDecimal2 = new BigDecimal(d, mathContext2);
        bigDecimal2 = bigDecimal2.multiply(bigDecimal6, mathContext2);
        if (n7 != 0) {
            bigDecimal2 = bigDecimal2.movePointLeft(n7);
        }
        if (n3 < n5) {
            return bigDecimal2.round(mathContext);
        }
        bigDecimal4 = BigDecimal.ONE.divide(TWO.multiply(bigDecimal2), mathContext2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        assert (n5 > 3) : "Never ending loop!";
        int n8 = n3 + 1;
        while (n8 > n5) {
            arrayList.add(n8);
            n8 = n8 / 2 + (n8 > 100 ? 1 : 2);
        }
        for (n8 = arrayList.size() - 1; n8 > -1; --n8) {
            mathContext2 = new MathContext((Integer)arrayList.get(n8), n8 % 2 == 1 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN);
            bigDecimal3 = bigDecimal.subtract(bigDecimal2.multiply(bigDecimal2, mathContext2), mathContext2);
            if (n8 == 0) {
                bigDecimal2 = bigDecimal2.add(bigDecimal3.multiply(bigDecimal4, mathContext), mathContext);
                break;
            }
            bigDecimal2 = bigDecimal2.add(bigDecimal3.multiply(bigDecimal4, mathContext2));
            bigDecimal5 = BigDecimal.ONE.subtract(TWO.multiply(bigDecimal2).multiply(bigDecimal4, mathContext2));
            bigDecimal4 = bigDecimal4.add(bigDecimal5.multiply(bigDecimal4, mathContext2));
        }
        return bigDecimal2;
    }

    public static class BigDecimalKernelMethods {
        @JRubyMethod(name={"BigDecimal"}, rest=true, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return RubyBigDecimal.newBigDecimal(iRubyObject, iRubyObjectArray, Block.NULL_BLOCK);
        }
    }
}

