/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.libraries;

import java.io.IOException;
import org.jruby.nb.nb.CompatVersion;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.load.Library;

public class FiberLibrary
implements Library {
    public void load(Ruby ruby, boolean bl) throws IOException {
        Fiber.setup(ruby);
    }

    @JRubyClass(name={"Fiber"})
    public static class Fiber
    extends RubyObject {
        private final Object yieldLock = new Object();
        private Block block;
        private IRubyObject result;
        private Thread thread;
        private boolean alive = false;

        @JRubyMethod(name={"new"}, rest=true, meta=true, frame=true, compat=CompatVersion.RUBY1_9)
        public static Fiber newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Fiber fiber = new Fiber(threadContext.getRuntime(), (RubyClass)iRubyObject);
            fiber.initialize(threadContext, iRubyObjectArray, block);
            return fiber;
        }

        public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
            this.block = block;
            final Ruby ruby = threadContext.getRuntime();
            this.result = ruby.getNil();
            this.thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = Fiber.this.yieldLock;
                    synchronized (object) {
                        Fiber.this.alive = true;
                        ThreadContext threadContext = ruby.getCurrentContext();
                        threadContext.setFiber(Fiber.this);
                        try {
                            Fiber.this.result = Fiber.this.block.yield(ruby.getCurrentContext(), Fiber.this.result, null, null, true);
                            Object var4_3 = null;
                            Fiber.this.yieldLock.notify();
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            Fiber.this.yieldLock.notify();
                            throw throwable;
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            return this;
        }

        public Fiber(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("Fiber", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            rubyClass.defineAnnotatedMethods(Fiber.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject resume(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.result = threadContext.getRuntime().newArrayNoCopyLight(iRubyObjectArray);
                if (!this.alive) {
                    this.thread.start();
                    this.yieldLock.wait();
                } else {
                    this.yieldLock.notify();
                    this.yieldLock.wait();
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject transfer(IRubyObject[] iRubyObjectArray) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.yieldLock.notify();
                this.yieldLock.wait();
            }
            return this.result;
        }

        @JRubyMethod(name={"alive?"}, compat=CompatVersion.RUBY1_9)
        public IRubyObject alive_p(ThreadContext threadContext) {
            return threadContext.getRuntime().newBoolean(this.alive);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws InterruptedException {
            Fiber fiber = threadContext.getFiber();
            fiber.result = iRubyObject2;
            Object object = fiber.yieldLock;
            synchronized (object) {
                fiber.yieldLock.notify();
                fiber.yieldLock.wait();
            }
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject current(ThreadContext threadContext, IRubyObject iRubyObject) {
            return threadContext.getRuntime().getCurrentContext().getFiber();
        }
    }
}

