/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.lexer.yacc;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jruby.nb.nb.lexer.yacc.LexerSource;
import org.jruby.nb.nb.parser.ParserConfiguration;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamLexerSource
extends LexerSource {
    private static final int INITIAL_PUSHBACK_SIZE = 100;
    private final InputStream in;
    private char[] buf = new char[100];
    private int bufLength = -1;
    private int oneAgo = 10;
    private int twoAgo = 0;

    public InputStreamLexerSource(String string, InputStream inputStream, List<String> list, int n, boolean bl) {
        super(string, list, n, bl);
        this.in = inputStream;
    }

    @Override
    public int read() throws IOException {
        int n;
        if (this.bufLength >= 0) {
            n = this.buf[this.bufLength--];
        } else {
            n = this.wrappedRead();
            if (n == -1) {
                return -1;
            }
        }
        this.advance(n);
        if (n == 10) {
            ++this.line;
        }
        return n;
    }

    @Override
    public void unread(int n) {
        if (n == -1) {
            return;
        }
        this.retreat();
        if (n == 10) {
            --this.line;
        }
        this.buf[++this.bufLength] = (char)n;
        this.growBuf();
    }

    @Override
    public boolean peek(int n) throws IOException {
        int n2 = this.twoAgo;
        int n3 = this.read();
        this.unread(n3);
        this.twoAgo = n2;
        return n3 == n;
    }

    private void advance(int n) {
        this.twoAgo = this.oneAgo;
        this.oneAgo = n;
        ++this.offset;
    }

    private int carriageReturn(int n) throws IOException {
        n = this.in.read();
        if (n != 10) {
            this.unread((char)n);
            n = 10;
        } else {
            ++this.offset;
        }
        return n;
    }

    private void growBuf() {
        if (this.bufLength + 1 == this.buf.length) {
            char[] cArray = new char[this.buf.length + 100];
            System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
            this.buf = cArray;
        }
    }

    private void retreat() {
        --this.offset;
        this.oneAgo = this.twoAgo;
        this.twoAgo = 0;
    }

    private int wrappedRead() throws IOException {
        int n = this.in.read();
        if (n == 13) {
            n = this.carriageReturn(n);
        }
        this.captureFeature(n);
        return n;
    }

    public static LexerSource getSource(String string, InputStream inputStream, List<String> list, ParserConfiguration parserConfiguration) {
        return new InputStreamLexerSource(string, inputStream, list, parserConfiguration.getLineNumber(), parserConfiguration.hasExtraPositionInformation());
    }

    @Override
    public ByteList readLineBytes() throws IOException {
        ByteList byteList = new ByteList(80);
        int n = this.read();
        while (n != 10 && n != -1) {
            byteList.append(n);
            n = this.read();
        }
        return byteList;
    }

    @Override
    public int skipUntil(int n) throws IOException {
        n = this.read();
        while (n != 10 && n != -1) {
            n = this.read();
        }
        return n;
    }

    @Override
    public void unreadMany(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = n - 1; i >= 0; --i) {
            this.unread(charSequence.charAt(i));
        }
    }

    @Override
    public boolean matchMarker(ByteList byteList, boolean bl, boolean bl2) throws IOException {
        int n = byteList.length();
        ByteList byteList2 = new ByteList(n + 1);
        if (bl) {
            this.indentLoop(byteList2);
        }
        if (!this.matches(byteList, byteList2, n)) {
            return false;
        }
        return this.finishMarker(bl2, byteList2);
    }

    private void indentLoop(ByteList byteList) throws IOException {
        int n;
        while ((n = this.read()) != -1) {
            if (!Character.isWhitespace(n) || n == 10) {
                this.unread(n);
                break;
            }
            byteList.append(n);
        }
    }

    private boolean matches(ByteList byteList, ByteList byteList2, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            int n2 = this.read();
            byteList2.append(n2);
            if (byteList.charAt(i) == n2) continue;
            this.unreadMany((CharSequence)byteList2);
            return false;
        }
        return true;
    }

    private boolean finishMarker(boolean bl, ByteList byteList) throws IOException {
        if (!bl) {
            return true;
        }
        int n = this.read();
        if (n == -1 || n == 10) {
            return true;
        }
        byteList.append(n);
        this.unreadMany((CharSequence)byteList);
        return false;
    }

    @Override
    public boolean wasBeginOfLine() {
        return this.twoAgo == 10;
    }

    @Override
    public boolean lastWasBeginOfLine() {
        return this.oneAgo == 10;
    }

    public String toString() {
        try {
            int n;
            ByteList byteList = new ByteList(20);
            byteList.append(this.twoAgo);
            byteList.append(this.oneAgo);
            byteList.append(new byte[]{45, 62});
            for (n = 0; n < 20; ++n) {
                int n2 = this.read();
                if (n2 == 0) {
                    --n;
                    break;
                }
                byteList.append(n2);
            }
            while (n >= 0) {
                this.unread(byteList.charAt(n));
                ++n;
            }
            byteList.append(new byte[]{32, 46, 46, 46});
            return byteList.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ByteList readUntil(char c) throws IOException {
        ByteList byteList = new ByteList(20);
        int n = this.read();
        while (n != c && n != -1) {
            byteList.append(n);
            n = this.read();
        }
        if (n == -1) {
            return null;
        }
        this.unread(n);
        return byteList;
    }

    @Override
    public int chompReadAhead() {
        int n = this.bufLength + 1;
        this.bufLength = -1;
        return n;
    }

    @Override
    public boolean isANewLine() {
        return this.oneAgo == 10;
    }

    @Override
    public void setIsANewLine(boolean bl) {
        this.oneAgo = bl ? 10 : this.oneAgo;
    }

    @Override
    public void setOffset(int n) {
        this.offset = n;
    }
}

