/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.javasupport.proxy;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyNil;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.javasupport.JavaClass;
import org.jruby.nb.nb.javasupport.JavaObject;
import org.jruby.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.javasupport.proxy.InternalJavaProxy;
import org.jruby.nb.nb.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.nb.nb.javasupport.proxy.JavaProxyConstructor;
import org.jruby.nb.nb.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.nb.nb.javasupport.proxy.JavaProxyMethod;
import org.jruby.nb.nb.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.JRubyClassLoader;

public class JavaProxyClass
extends JavaProxyReflectionObject {
    static ThreadLocal<Ruby> runtimeTLS = new ThreadLocal();
    private final Class proxyClass;
    private final ArrayList<JavaProxyMethod> methods = new ArrayList();
    private final HashMap<String, List<JavaProxyMethod>> methodMap = new HashMap();
    private final RubyArray constructors;
    private static final HashSet<String> EXCLUDE_MODULES = new HashSet();
    private static final HashSet<String> EXCLUDE_METHODS;

    JavaProxyClass(Class clazz) {
        super(JavaProxyClass.getThreadLocalRuntime(), JavaProxyClass.getThreadLocalRuntime().fastGetModule("Java").fastGetClass("JavaProxyClass"));
        this.proxyClass = clazz;
        this.constructors = this.buildRubyArray(this.getConstructors());
    }

    public boolean equals(Object object) {
        return object instanceof JavaProxyClass && this.proxyClass == ((JavaProxyClass)object).proxyClass;
    }

    public int hashCode() {
        return this.proxyClass.hashCode();
    }

    public Object getValue() {
        return this;
    }

    private static Ruby getThreadLocalRuntime() {
        return runtimeTLS.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaProxyClass getProxyClass(Ruby ruby, Class clazz, Class[] classArray, Set set) throws InvocationTargetException {
        Ruby ruby2 = runtimeTLS.get();
        runtimeTLS.set(ruby);
        try {
            JRubyClassLoader jRubyClassLoader = ruby.getJRubyClassLoader();
            JavaProxyClass javaProxyClass = JavaProxyClassFactory.newProxyClass(ruby, jRubyClassLoader, null, clazz, classArray, set);
            Object var8_7 = null;
            runtimeTLS.set(ruby2);
            return javaProxyClass;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            runtimeTLS.set(ruby2);
            throw throwable;
        }
    }

    public static JavaProxyClass getProxyClass(Ruby ruby, Class clazz, Class[] classArray) throws InvocationTargetException {
        return JavaProxyClass.getProxyClass(ruby, clazz, classArray, null);
    }

    public static Object newProxyInstance(Ruby ruby, Class clazz, Class[] classArray, Class[] classArray2, Object[] objectArray, JavaProxyInvocationHandler javaProxyInvocationHandler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        JavaProxyClass javaProxyClass = JavaProxyClass.getProxyClass(ruby, clazz, classArray);
        JavaProxyConstructor javaProxyConstructor = javaProxyClass.getConstructor(classArray2 == null ? new Class[]{} : classArray2);
        return javaProxyConstructor.newInstance(objectArray, javaProxyInvocationHandler);
    }

    public Class getSuperclass() {
        return this.proxyClass.getSuperclass();
    }

    public Class[] getInterfaces() {
        Class<?>[] classArray = this.proxyClass.getInterfaces();
        Class[] classArray2 = new Class[classArray.length - 1];
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == InternalJavaProxy.class) continue;
            classArray2[n++] = classArray[i];
        }
        return classArray2;
    }

    public JavaProxyConstructor[] getConstructors() {
        Constructor<?>[] constructorArray = this.proxyClass.getConstructors();
        JavaProxyConstructor[] javaProxyConstructorArray = new JavaProxyConstructor[constructorArray.length];
        for (int i = 0; i < constructorArray.length; ++i) {
            javaProxyConstructorArray[i] = new JavaProxyConstructor(this.getRuntime(), this, constructorArray[i]);
        }
        return javaProxyConstructorArray;
    }

    public JavaProxyConstructor getConstructor(Class[] classArray) throws SecurityException, NoSuchMethodException {
        Class[] classArray2 = new Class[classArray.length + 1];
        System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
        classArray2[classArray.length] = JavaProxyInvocationHandler.class;
        Constructor constructor = this.proxyClass.getConstructor(classArray2);
        return new JavaProxyConstructor(this.getRuntime(), this, constructor);
    }

    public JavaProxyMethod[] getMethods() {
        return this.methods.toArray(new JavaProxyMethod[this.methods.size()]);
    }

    public JavaProxyMethod getMethod(String string, Class[] classArray) {
        List<JavaProxyMethod> list = this.methodMap.get(string);
        if (list != null) {
            int n = list.size();
            while (--n >= 0) {
                ProxyMethodImpl proxyMethodImpl = (ProxyMethodImpl)list.get(n);
                if (!proxyMethodImpl.matches(string, classArray)) continue;
                return proxyMethodImpl;
            }
        }
        return null;
    }

    Class getProxyClass() {
        return this.proxyClass;
    }

    public Class getJavaClass() {
        return this.proxyClass;
    }

    JavaProxyMethod initMethod(String string, String string2, boolean bl) {
        Class clazz = this.proxyClass;
        try {
            Class[] classArray = JavaProxyClass.parse(clazz.getClassLoader(), string2);
            Method method = clazz.getDeclaredMethod(string, classArray);
            Method method2 = null;
            if (bl) {
                method2 = clazz.getDeclaredMethod("__super$" + string, classArray);
            }
            ProxyMethodImpl proxyMethodImpl = new ProxyMethodImpl(this.getRuntime(), this, method, method2);
            this.methods.add(proxyMethodImpl);
            List<JavaProxyMethod> list = this.methodMap.get(string);
            if (list == null) {
                list = new ArrayList<JavaProxyMethod>(2);
                this.methodMap.put(string, list);
            }
            list.add(proxyMethodImpl);
            return proxyMethodImpl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError(classNotFoundException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new InternalError(securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.getMessage());
        }
    }

    private static Class[] parse(final ClassLoader classLoader, String string) throws ClassNotFoundException {
        ArrayList<Class<Byte>> arrayList = new ArrayList<Class<Byte>>();
        int n = 1;
        while (string.charAt(n) != ')') {
            Class clazz;
            int n2 = 0;
            while (string.charAt(n) == '[') {
                ++n;
                ++n2;
            }
            switch (string.charAt(n)) {
                case 'L': {
                    int n3 = string.indexOf(59, n);
                    final String string2 = string.substring(n + 1, n3);
                    n = n3;
                    try {
                        clazz = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                            @Override
                            public Class run() throws ClassNotFoundException {
                                return Class.forName(string2.replace('/', '.'), false, classLoader);
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (ClassNotFoundException)privilegedActionException.getException();
                    }
                }
                case 'B': {
                    clazz = Byte.TYPE;
                    break;
                }
                case 'C': {
                    clazz = Character.TYPE;
                    break;
                }
                case 'Z': {
                    clazz = Boolean.TYPE;
                    break;
                }
                case 'S': {
                    clazz = Short.TYPE;
                    break;
                }
                case 'I': {
                    clazz = Integer.TYPE;
                    break;
                }
                case 'J': {
                    clazz = Long.TYPE;
                    break;
                }
                case 'F': {
                    clazz = Float.TYPE;
                    break;
                }
                case 'D': {
                    clazz = Double.TYPE;
                    break;
                }
                default: {
                    throw new InternalError("cannot parse " + string + "[" + n + "]");
                }
            }
            ++n;
            if (n2 != 0) {
                clazz = Array.newInstance(clazz, new int[n2]).getClass();
            }
            arrayList.add(clazz);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public static RubyClass createJavaProxyClassClass(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaProxyClass", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaProxyReflectionObject.registerRubyMethods(ruby, rubyClass);
        rubyClass.defineAnnotatedMethods(JavaProxyClass.class);
        return rubyClass;
    }

    @JRubyMethod(meta=true)
    public static RubyObject get(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (!(iRubyObject2 instanceof JavaClass)) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject2, iRubyObject.getRuntime().getJavaSupport().getJavaClassClass());
        }
        JavaClass javaClass = (JavaClass)iRubyObject2;
        try {
            return JavaProxyClass.getProxyClass(iRubyObject.getRuntime(), (Class)javaClass.getValue(), new Class[0]);
        }
        catch (Error error) {
            RaiseException raiseException = iRubyObject.getRuntime().newArgumentError("unable to create proxy class for " + javaClass.getValue());
            raiseException.initCause(error);
            throw raiseException;
        }
        catch (InvocationTargetException invocationTargetException) {
            RaiseException raiseException = iRubyObject.getRuntime().newArgumentError("unable to create proxy class for " + javaClass.getValue());
            raiseException.initCause(invocationTargetException);
            throw raiseException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @JRubyMethod(meta=true)
    public static RubyObject get_with_class(IRubyObject var0, IRubyObject var1_1) {
        var2_2 = var0.getRuntime();
        if (!(var1_1 instanceof RubyClass)) {
            throw var2_2.newTypeError(var1_1, var2_2.getClassClass());
        }
        var3_3 = (RubyClass)var1_1;
        var4_4 = null;
        var5_5 = new HashSet<Object>();
        var6_6 = new ArrayList<Object>();
        var7_7 = var3_3.getAncestorList();
        var8_8 = false;
        var9_9 = var7_7.iterator();
        block7: while (true) {
            block29: {
                block30: {
                    block27: {
                        block28: {
                            if (!var9_9.hasNext()) break block27;
                            var10_11 = var9_9.next();
                            var11_13 = (RubyModule)var10_11;
                            if (!(var11_13 instanceof RubyClass)) break block28;
                            if (var8_8) continue;
                            if (!var11_13.getInstanceVariables().fastHasInstanceVariable("@java_proxy_class")) {
                                var8_8 = true;
                                continue;
                            }
                            var12_17 = var11_13.getInstanceVariables().fastGetInstanceVariable("@java_class");
                            if (var12_17 == null) {
                                throw var2_2.newTypeError("no java_class defined for proxy (or ancestor): " + var11_13);
                            }
                            if (!(var12_17 instanceof JavaClass)) {
                                throw var2_2.newTypeError("invalid java_class defined for proxy (or ancestor): " + var11_13 + ": " + var12_17);
                            }
                            if (var4_4 == null) {
                                var4_4 = (JavaClass)var12_17;
                            } else if (var4_4 != var12_17) {
                                throw var2_2.newTypeError("java_class defined for " + var3_3 + " (" + var4_4 + ") does not match java_class for ancestor " + var11_13 + " (" + var12_17 + ")");
                            }
                            var12_17 = var11_13.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                            if (var12_17 == null || var12_17 instanceof RubyNil) break block29;
                            if (!(var12_17 instanceof RubyArray)) {
                                throw var2_2.newTypeError("invalid java_interfaces defined for proxy (or ancestor): " + var11_13 + ": " + var12_17);
                            }
                            var13_18 = (RubyArray)var12_17;
                            var15_22 = var14_19 = var13_18.size();
                            break block30;
                        }
                        if (JavaProxyClass.EXCLUDE_MODULES.contains(var11_13.getName())) continue;
                        var13_18 = var12_17 = var11_13.getMethods();
                        // MONITORENTER : var12_17
                        for (String var15_24 : var12_17.keySet()) {
                            if (JavaProxyClass.EXCLUDE_METHODS.contains(var15_24)) continue;
                            var5_5.add(var15_24);
                        }
                        // MONITOREXIT : var13_18
                        continue;
                    }
                    if (var4_4 == null) {
                        throw var2_2.newArgumentError("unable to create proxy class: no java_class defined for " + var3_3);
                    }
                    var9_10 = var6_6.size();
                    var10_12 = new Class[var9_10];
                    var11_14 = var9_10;
                    while (--var11_14 >= 0) {
                        var10_12[var11_14] = (Class)var6_6.get(var11_14);
                    }
                    try {
                        return JavaProxyClass.getProxyClass(var0.getRuntime(), var4_4.javaClass(), var10_12, var5_5);
                    }
                    catch (Error var11_15) {
                        var12_17 = var0.getRuntime().newArgumentError("unable to create proxy class for " + var4_4.getValue() + " : " + var11_15.getMessage());
                        var12_17.initCause(var11_15);
                        throw var12_17;
                    }
                    catch (InvocationTargetException var11_16) {
                        var12_17 = var0.getRuntime().newArgumentError("unable to create proxy class for " + var4_4.getValue() + " : " + var11_16.getMessage());
                        var12_17.initCause(var11_16);
                        throw var12_17;
                    }
                }
                while (--var15_22 >= 0) {
                    var16_25 = var13_18.eltInternal(var15_22);
                    if (!(var16_25 instanceof JavaClass)) {
                        throw var2_2.newTypeError("invalid java interface defined for proxy (or ancestor): " + var11_13 + ": " + var16_25);
                    }
                    var17_26 = ((JavaClass)var16_25).javaClass();
                    if (!var17_26.isInterface()) {
                        throw var2_2.newTypeError("invalid java interface defined for proxy (or ancestor): " + var11_13 + ": " + var16_25 + " (not an interface)");
                    }
                    if (var6_6.contains(var17_26)) continue;
                    var6_6.add(var17_26);
                }
            }
            if ((var12_17 = var11_13.getInstanceVariables().fastGetInstanceVariable("@__java_ovrd_methods")) == null) {
                var13_18 = var11_13.getMethods();
                var15_23 = var13_18;
                // MONITORENTER : var13_18
                var14_20 = RubyArray.newArrayLight(var2_2, var13_18.size());
                for (Object var17_26 : var13_18.keySet()) {
                    if (JavaProxyClass.EXCLUDE_METHODS.contains(var17_26)) continue;
                    var5_5.add(var17_26);
                    var14_20.append(var2_2.newString((String)var17_26));
                }
                // MONITOREXIT : var15_23
                var11_13.fastSetInstanceVariable("@__java_ovrd_methods", var14_20);
                continue;
            }
            if (!(var12_17 instanceof RubyArray)) {
                throw var2_2.newTypeError("invalid @__java_ovrd_methods defined for proxy: " + var11_13 + ": " + var12_17);
            }
            var13_18 = (RubyArray)var12_17;
            var15_22 = var14_19 = var13_18.size();
            while (true) {
                if (--var15_22 >= 0) ** break;
                continue block7;
                var16_25 = var13_18.eltInternal(var15_22);
                if (!(var16_25 instanceof RubyString)) {
                    throw var2_2.newTypeError("invalid method name defined for proxy (or ancestor): " + var11_13 + ": " + var16_25);
                }
                var5_5.add(var16_25.asJavaString());
            }
            break;
        }
    }

    @JRubyMethod
    public RubyObject superclass() {
        return JavaClass.get(this.getRuntime(), this.getSuperclass());
    }

    @JRubyMethod
    public RubyArray methods() {
        return this.buildRubyArray(this.getMethods());
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return this.buildRubyArray(this.getInterfaces());
    }

    @JRubyMethod
    public RubyArray constructors() {
        return this.constructors;
    }

    public static void createJavaProxyModule(Ruby ruby) {
        RubyModule rubyModule = ruby.getJavaSupport().getJavaModule();
        JavaProxyClass.createJavaProxyClassClass(ruby, rubyModule);
        ProxyMethodImpl.createJavaProxyMethodClass(ruby, rubyModule);
        JavaProxyConstructor.createJavaProxyConstructorClass(ruby, rubyModule);
    }

    public String nameOnInspection() {
        return "[Proxy:" + this.getSuperclass().getName() + "]";
    }

    static {
        EXCLUDE_MODULES.add("Kernel");
        EXCLUDE_MODULES.add("Java");
        EXCLUDE_MODULES.add("JavaProxyMethods");
        EXCLUDE_MODULES.add("Enumerable");
        EXCLUDE_METHODS = new HashSet();
        EXCLUDE_METHODS.add("class");
        EXCLUDE_METHODS.add("finalize");
        EXCLUDE_METHODS.add("initialize");
        EXCLUDE_METHODS.add("java_class");
        EXCLUDE_METHODS.add("java_object");
        EXCLUDE_METHODS.add("__jcreate!");
        EXCLUDE_METHODS.add("__jsend!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JRubyClass(name={"JavaProxy::JavaProxyMethod"})
    public static class ProxyMethodImpl
    extends JavaProxyReflectionObject
    implements JavaProxyMethod {
        private final Method m;
        private Object state;
        private final Method sm;
        private final Class[] parameterTypes;
        private final JavaProxyClass clazz;

        public ProxyMethodImpl(Ruby ruby, JavaProxyClass javaProxyClass, Method method, Method method2) {
            super(ruby, ruby.getJavaSupport().getJavaModule().fastGetClass("JavaProxyMethod"));
            this.m = method;
            this.parameterTypes = method.getParameterTypes();
            this.sm = method2;
            this.clazz = javaProxyClass;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ProxyMethodImpl && this.m == ((ProxyMethodImpl)object).m;
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public Method getMethod() {
            return this.m;
        }

        @Override
        public Method getSuperMethod() {
            return this.sm;
        }

        @Override
        public int getModifiers() {
            return this.m.getModifiers();
        }

        @Override
        public String getName() {
            return this.m.getName();
        }

        @Override
        public Class<?>[] getExceptionTypes() {
            return this.m.getExceptionTypes();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }

        @Override
        public Object getState() {
            return this.state;
        }

        @Override
        public boolean hasSuperImplementation() {
            return this.sm != null;
        }

        @Override
        public Object invoke(Object object, Object[] objectArray) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (!this.hasSuperImplementation()) {
                throw new NoSuchMethodException();
            }
            return this.sm.invoke(object, objectArray);
        }

        @Override
        public void setState(Object object) {
            this.state = object;
        }

        @Override
        public String toString() {
            return this.m.toString();
        }

        @Override
        public Object defaultResult() {
            Class<?> clazz = this.m.getReturnType();
            if (clazz == Void.TYPE) {
                return null;
            }
            if (clazz == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (clazz == Byte.TYPE) {
                return new Byte(0);
            }
            if (clazz == Short.TYPE) {
                return new Short(0);
            }
            if (clazz == Integer.TYPE) {
                return new Integer(0);
            }
            if (clazz == Long.TYPE) {
                return new Long(0L);
            }
            if (clazz == Float.TYPE) {
                return new Float(0.0f);
            }
            if (clazz == Double.TYPE) {
                return new Double(0.0);
            }
            return null;
        }

        public boolean matches(String string, Class[] classArray) {
            return this.m.getName().equals(string) && Arrays.equals(this.parameterTypes, classArray);
        }

        public Class getReturnType() {
            return this.m.getReturnType();
        }

        public static RubyClass createJavaProxyMethodClass(Ruby ruby, RubyModule rubyModule) {
            RubyClass rubyClass = rubyModule.defineClassUnder("JavaProxyMethod", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            JavaProxyReflectionObject.registerRubyMethods(ruby, rubyClass);
            rubyClass.defineAnnotatedMethods(ProxyMethodImpl.class);
            return rubyClass;
        }

        public RubyObject name() {
            return this.getRuntime().newString(this.getName());
        }

        @Override
        @JRubyMethod(name={"declaring_class"})
        public JavaProxyClass getDeclaringClass() {
            return this.clazz;
        }

        @JRubyMethod
        public RubyArray argument_types() {
            return this.buildRubyArray(this.getParameterTypes());
        }

        @JRubyMethod(name={"super?"})
        public IRubyObject super_p() {
            return this.hasSuperImplementation() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod
        public RubyFixnum arity() {
            return this.getRuntime().newFixnum(this.getArity());
        }

        protected String nameOnInspection() {
            return this.getDeclaringClass().nameOnInspection() + "/" + this.getName();
        }

        @Override
        @JRubyMethod
        public IRubyObject inspect() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.nameOnInspection());
            stringBuilder.append("(");
            Class<?>[] classArray = this.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                stringBuilder.append(classArray[i].getName());
                if (i >= classArray.length - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(")>");
            return this.getRuntime().newString(stringBuilder.toString());
        }

        @JRubyMethod(name={"invoke"}, rest=true)
        public IRubyObject do_invoke(IRubyObject[] iRubyObjectArray) {
            if (iRubyObjectArray.length != 1 + this.getArity()) {
                throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 1 + this.getArity());
            }
            IRubyObject iRubyObject = iRubyObjectArray[0];
            if (!(iRubyObject instanceof JavaObject)) {
                throw this.getRuntime().newTypeError("invokee not a java object");
            }
            Object object = ((JavaObject)iRubyObject).getValue();
            Object[] objectArray = new Object[iRubyObjectArray.length - 1];
            System.arraycopy(iRubyObjectArray, 1, objectArray, 0, objectArray.length);
            Class<?>[] classArray = this.getParameterTypes();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = JavaUtil.convertRubyToJava((IRubyObject)objectArray[i], classArray[i]);
            }
            try {
                Object object2 = this.sm.invoke(object, objectArray);
                return JavaUtil.convertJavaToRuby(this.getRuntime(), object2, this.getReturnType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.getRuntime().newTypeError("illegal access on '" + this.sm.getName() + "': " + illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                if (this.getRuntime().getDebug().isTrue()) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                this.getRuntime().getJavaSupport().handleNativeException(invocationTargetException.getTargetException());
                return this.getRuntime().getNil();
            }
        }

        private int getArity() {
            return this.getParameterTypes().length;
        }
    }
}

