/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.java.proxies;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyInteger;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyRange;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.nb.java.proxies.JavaProxy;
import org.jruby.nb.nb.javasupport.JavaArray;
import org.jruby.nb.nb.javasupport.JavaClass;
import org.jruby.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

public class ArrayJavaProxy
extends JavaProxy {
    public ArrayJavaProxy(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createArrayJavaProxy(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        RubyClass rubyClass = ruby.defineClass("ArrayJavaProxy", ruby.getJavaSupport().getJavaProxyClass(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new ArrayJavaProxy(ruby, rubyClass);
            }
        });
        RubyClass rubyClass2 = rubyClass.getSingletonClass();
        DynamicMethod dynamicMethod = rubyClass2.searchMethod("new");
        rubyClass2.addMethod("new", new ArrayNewMethod((RubyModule)rubyClass2, Visibility.PUBLIC, dynamicMethod));
        rubyClass.defineAnnotatedMethods(ArrayJavaProxy.class);
        rubyClass.includeModule(ruby.getEnumerable());
        return rubyClass;
    }

    public JavaArray getJavaArray() {
        return (JavaArray)this.dataGetStruct();
    }

    @JRubyMethod(name={"length", "size"}, backtrace=true)
    public IRubyObject length() {
        return this.getJavaArray().length();
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true, backtrace=true)
    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 1 && iRubyObjectArray[0] instanceof RubyInteger) {
            return JavaUtil.java_to_ruby(threadContext.getRuntime(), this.getJavaArray().aref(iRubyObjectArray[0]));
        }
        return this.getRange(threadContext, iRubyObjectArray);
    }

    @JRubyMethod(name={"[]="}, backtrace=true)
    public IRubyObject op_aset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Object object = this.getJavaArray().getRubyConverter().convert(threadContext, iRubyObject2);
        this.getJavaArray().setWithExceptionHandling((int)iRubyObject.convertToInteger().getLongValue(), object);
        return iRubyObject2;
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject at(ThreadContext threadContext, IRubyObject iRubyObject) {
        long l;
        RubyFixnum rubyFixnum = this.getJavaArray().length();
        RubyInteger rubyInteger = iRubyObject.convertToInteger();
        if (rubyInteger.getLongValue() < 0L) {
            rubyInteger = RubyFixnum.newFixnum(threadContext.getRuntime(), rubyInteger.getLongValue() + rubyFixnum.getLongValue());
        }
        if ((l = rubyInteger.getLongValue()) >= 0L && l < rubyFixnum.getLongValue()) {
            return JavaUtil.java_to_ruby(threadContext.getRuntime(), this.getJavaArray().aref(rubyInteger));
        }
        return threadContext.getRuntime().getNil();
    }

    public IRubyObject at(int n) {
        return this.getJavaArray().at(n);
    }

    @JRubyMethod(name={"+"}, backtrace=true)
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        JavaClass javaClass = JavaClass.get(threadContext.getRuntime(), this.getJavaArray().getComponentType());
        if (iRubyObject instanceof ArrayJavaProxy) {
            JavaArray javaArray = ((ArrayJavaProxy)iRubyObject).getJavaArray();
            if (this.getJavaArray().getComponentType().isAssignableFrom(javaArray.getComponentType())) {
                return javaClass.concatArrays(threadContext, this.getJavaArray(), javaArray);
            }
        }
        return javaClass.concatArrays(threadContext, this.getJavaArray(), iRubyObject);
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject each(ThreadContext threadContext, Block block) {
        int n = (int)this.getJavaArray().length().getLongValue();
        for (int i = 0; i < n; ++i) {
            block.yield(threadContext, JavaUtil.java_to_ruby(threadContext.getRuntime(), this.at(i)));
        }
        return this;
    }

    @JRubyMethod(name={"to_a", "to_ary"}, backtrace=true)
    public IRubyObject to_a(ThreadContext threadContext) {
        RubyModule rubyModule = threadContext.getRuntime().getJavaSupport().getJavaArrayUtilitiesModule();
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)rubyModule, "java_to_ruby", this);
    }

    public IRubyObject getRange(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 1) {
            return this.getRange(threadContext, iRubyObjectArray[0]);
        }
        if (iRubyObjectArray.length == 2) {
            return this.getRange(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        }
        throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
    }

    public IRubyObject getRange(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = (int)this.getJavaArray().length().getLongValue();
        JavaClass javaClass = JavaClass.get(threadContext.getRuntime(), this.getJavaArray().getComponentType());
        if (iRubyObject instanceof RubyRange) {
            RubyRange rubyRange = (RubyRange)iRubyObject;
            if (rubyRange.first() instanceof RubyFixnum && rubyRange.last() instanceof RubyFixnum) {
                int n2 = (int)((RubyFixnum)rubyRange.first()).getLongValue();
                int n3 = (int)((RubyFixnum)rubyRange.last()).getLongValue();
                n2 = n2 >= 0 ? n2 : n + n2;
                n3 = n3 >= 0 ? n3 : n + n3;
                int n4 = n3 - n2;
                if (rubyRange.exclude_end_p().isFalse()) {
                    ++n4;
                }
                if (n4 <= 0) {
                    return javaClass.emptyJavaArray(threadContext);
                }
                return javaClass.javaArraySubarray(threadContext, this.getJavaArray(), n2, n4);
            }
            throw threadContext.getRuntime().newTypeError("only Fixnum ranges supported");
        }
        throw threadContext.getRuntime().newTypeError(iRubyObject, threadContext.getRuntime().getRange());
    }

    public IRubyObject getRange(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JavaClass javaClass = JavaClass.get(threadContext.getRuntime(), this.getJavaArray().getComponentType());
        if (iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            int n = (int)((RubyFixnum)iRubyObject).getLongValue();
            int n2 = (int)((RubyFixnum)iRubyObject2).getLongValue();
            if ((long)n2 > this.getJavaArray().length().getLongValue()) {
                throw threadContext.getRuntime().newIndexError("length specifed is longer than array");
            }
            int n3 = n = n >= 0 ? n : (int)this.getJavaArray().length().getLongValue() + n;
            if (n2 <= 0) {
                return javaClass.emptyJavaArray(threadContext);
            }
            return javaClass.javaArraySubarray(threadContext, this.getJavaArray(), n, n2);
        }
        throw threadContext.getRuntime().newTypeError("only Fixnum ranges supported");
    }

    public static class ArrayNewMethod
    extends JavaMethod.JavaMethodOne {
        private DynamicMethod oldNew;

        public ArrayNewMethod(RubyModule rubyModule, Visibility visibility, DynamicMethod dynamicMethod) {
            super(rubyModule, visibility);
            this.oldNew = dynamicMethod;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
            Ruby ruby = threadContext.getRuntime();
            IRubyObject iRubyObject3 = this.oldNew.call(threadContext, iRubyObject, rubyModule, "new_proxy");
            if (iRubyObject2 instanceof JavaArray) {
                iRubyObject3.dataWrapStruct(iRubyObject2);
                return iRubyObject3;
            }
            throw ruby.newTypeError(iRubyObject2, ruby.getJavaSupport().getJavaArrayClass());
        }
    }
}

