/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.java.invokers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.java.invokers.RubyToJavaInvoker;
import org.jruby.nb.nb.javasupport.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodInvoker
extends RubyToJavaInvoker {
    private Method[] methods;

    MethodInvoker(RubyModule rubyModule, List<Method> list) {
        super(rubyModule);
        this.methods = list.toArray(new Method[list.size()]);
        if (!Ruby.isSecurityRestricted()) {
            Method.setAccessible(this.methods, true);
        }
    }

    synchronized void createJavaMethods(Ruby ruby) {
        if (!this.initialized) {
            if (this.methods != null) {
                if (this.methods.length == 1) {
                    this.javaCallable = JavaMethod.create(ruby, this.methods[0]);
                } else {
                    HashMap<Integer, ArrayList<JavaMethod>> hashMap = new HashMap<Integer, ArrayList<JavaMethod>>();
                    int n = 0;
                    for (Method javaMethodArray : this.methods) {
                        int n2 = javaMethodArray.getParameterTypes().length;
                        n = Math.max(n2, n);
                        ArrayList<JavaMethod> arrayList = (ArrayList<JavaMethod>)hashMap.get(n2);
                        if (arrayList == null) {
                            arrayList = new ArrayList<JavaMethod>();
                            hashMap.put(n2, arrayList);
                        }
                        arrayList.add(JavaMethod.create(ruby, javaMethodArray));
                    }
                    this.javaCallables = new JavaMethod[n + 1][];
                    for (Map.Entry entry : hashMap.entrySet()) {
                        List list = (List)entry.getValue();
                        JavaMethod[] javaMethodArray = list.toArray(new JavaMethod[list.size()]);
                        this.javaCallables[((Integer)entry.getKey()).intValue()] = javaMethodArray;
                    }
                }
                this.methods = null;
                this.cache = new ConcurrentHashMap();
            }
            this.initialized = true;
        }
    }
}

