/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.internal.runtime.methods;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.ast.executable.RubiniusCMethod;
import org.jruby.nb.nb.ast.executable.RubiniusMachine;
import org.jruby.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.internal.runtime.JumpTarget;
import org.jruby.nb.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.Frame;
import org.jruby.nb.nb.runtime.RubyEvent;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

public class RubiniusMethod
extends DynamicMethod
implements JumpTarget {
    private RubiniusCMethod cmethod;
    private StaticScope staticScope;
    private Arity arity;

    public RubiniusMethod(RubyModule rubyModule, RubiniusCMethod rubiniusCMethod, StaticScope staticScope, Visibility visibility) {
        super(rubyModule, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.staticScope = staticScope;
        this.cmethod = rubiniusCMethod;
        this.arity = Arity.optional();
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        assert (iRubyObjectArray != null);
        Ruby ruby = threadContext.getRuntime();
        this.callConfig.pre(threadContext, iRubyObject, rubyModule, string, block, this.staticScope, this);
        try {
            if (ruby.hasEventHooks()) {
                this.traceCall(threadContext, ruby, string);
            }
            iRubyObject2 = RubiniusMachine.INSTANCE.exec(threadContext, iRubyObject, this.cmethod.code, this.cmethod.literals, iRubyObjectArray);
            Object var11_10 = null;
        }
        catch (JumpException.ReturnJump returnJump) {
            block10: {
                try {
                    if (returnJump.getTarget() != this) break block10;
                    IRubyObject iRubyObject3 = (IRubyObject)returnJump.getValue();
                    Object var11_11 = null;
                    if (ruby.hasEventHooks()) {
                        this.traceReturn(threadContext, ruby, string);
                    }
                    this.callConfig.post(threadContext);
                    return iRubyObject3;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (ruby.hasEventHooks()) {
                        this.traceReturn(threadContext, ruby, string);
                    }
                    this.callConfig.post(threadContext);
                    throw throwable;
                }
            }
            throw returnJump;
        }
        if (ruby.hasEventHooks()) {
            this.traceReturn(threadContext, ruby, string);
        }
        this.callConfig.post(threadContext);
        return iRubyObject2;
    }

    private void traceReturn(ThreadContext threadContext, Ruby ruby, String string) {
        if (!ruby.hasEventHooks()) {
            return;
        }
        Frame frame = threadContext.getPreviousFrame();
        ruby.callEventHooks(threadContext, RubyEvent.RETURN, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
    }

    private void traceCall(ThreadContext threadContext, Ruby ruby, String string) {
        if (!ruby.hasEventHooks()) {
            return;
        }
        ruby.callEventHooks(threadContext, RubyEvent.CALL, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.arity;
    }

    public DynamicMethod dup() {
        return new RubiniusMethod(this.getImplementationClass(), this.cmethod, this.staticScope, this.getVisibility());
    }
}

