/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.internal.runtime.methods;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.internal.runtime.JumpTarget;
import org.jruby.nb.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.RubyEvent;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.callback.Callback;

public class FullFunctionCallbackMethod
extends DynamicMethod
implements JumpTarget {
    private Callback callback;

    public FullFunctionCallbackMethod(RubyModule rubyModule, Callback callback, Visibility visibility) {
        super(rubyModule, visibility, CallConfiguration.FRAME_ONLY);
        this.callback = callback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        try {
            IRubyObject iRubyObject2;
            block9: {
                this.callConfig.pre(threadContext, iRubyObject, rubyModule, string, block, null, this);
                assert (iRubyObjectArray != null);
                Ruby ruby = threadContext.getRuntime();
                boolean bl = ruby.hasEventHooks();
                if (bl) {
                    ruby.callEventHooks(threadContext, RubyEvent.C_CALL, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                }
                try {
                    iRubyObject2 = this.callback.execute(iRubyObject, iRubyObjectArray, block);
                    Object var12_11 = null;
                    if (!bl) break block9;
                }
                catch (JumpException.ReturnJump returnJump) {
                    block10: {
                        IRubyObject iRubyObject3;
                        block11: {
                            try {
                                if (returnJump.getTarget() != this) break block10;
                                iRubyObject3 = (IRubyObject)returnJump.getValue();
                                Object var12_12 = null;
                                if (!bl) break block11;
                                ruby.callEventHooks(threadContext, RubyEvent.C_RETURN, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                            }
                            catch (Throwable throwable) {
                                Object var12_13 = null;
                                if (!bl) throw throwable;
                                ruby.callEventHooks(threadContext, RubyEvent.C_RETURN, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                                throw throwable;
                            }
                        }
                        Object var14_15 = null;
                        this.callConfig.post(threadContext);
                        return iRubyObject3;
                    }
                    throw returnJump;
                }
                ruby.callEventHooks(threadContext, RubyEvent.C_RETURN, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
            }
            Object var14_14 = null;
            this.callConfig.post(threadContext);
            return iRubyObject2;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.callConfig.post(threadContext);
            throw throwable;
        }
    }

    public Callback getCallback() {
        return this.callback;
    }

    public Arity getArity() {
        return this.getCallback().getArity();
    }

    public DynamicMethod dup() {
        return new FullFunctionCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

