/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.internal.runtime.methods;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.ast.ArgsNode;
import org.jruby.nb.nb.ast.ListNode;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.executable.Script;
import org.jruby.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.internal.runtime.JumpTarget;
import org.jruby.nb.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.internal.runtime.methods.MethodArgs;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.RubyEvent;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

public final class DefaultMethod
extends DynamicMethod
implements JumpTarget,
MethodArgs {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private int callCount = 0;
    private Script jitCompiledScript;
    private int requiredArgsCount;
    private int maxArgsCount;
    private int restArg;
    private boolean hasOptArgs;
    private CallConfiguration jitCallConfig;
    private ISourcePosition position;

    public DefaultMethod(RubyModule rubyModule, StaticScope staticScope, Node node, ArgsNode argsNode, Visibility visibility, ISourcePosition iSourcePosition) {
        super(rubyModule, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.body = node;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.requiredArgsCount = argsNode.getRequiredArgsCount();
        this.maxArgsCount = argsNode.getRestArg() >= 0 ? -1 : argsNode.getRequiredArgsCount() + argsNode.getOptionalArgsCount();
        this.restArg = argsNode.getRestArg();
        this.hasOptArgs = argsNode.getOptArgs() != null;
        this.position = iSourcePosition;
        assert (argsNode != null);
    }

    public int getCallCount() {
        return this.callCount;
    }

    public int incrementCallCount() {
        return ++this.callCount;
    }

    public void setCallCount(int n) {
        this.callCount = n;
    }

    public Script getJITCompilerScript() {
        return this.jitCompiledScript;
    }

    public void setJITCompiledScript(Script script) {
        this.jitCompiledScript = script;
    }

    public CallConfiguration getJITCallConfig() {
        return this.jitCallConfig;
    }

    public void setJITCallConfig(CallConfiguration callConfiguration) {
        this.jitCallConfig = callConfiguration;
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        assert (iRubyObjectArray != null);
        Ruby ruby = threadContext.getRuntime();
        if (this.callCount >= 0) {
            ruby.getJITCompiler().tryJIT(this, threadContext, string);
        }
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            return this.retryJITCall(threadContext, ruby, iRubyObject, string, iRubyObjectArray, block);
        }
        return this.interpretedCall(threadContext, ruby, iRubyObject, rubyModule, string, iRubyObjectArray, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRubyObject retryJITCall(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, Block block) {
        try {
            IRubyObject iRubyObject2;
            try {
                this.jitPre(threadContext, iRubyObject, string, block, iRubyObjectArray.length);
                iRubyObject2 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObjectArray, block);
                Object var10_10 = null;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
                Object var10_11 = null;
                this.jitPost(ruby, threadContext, string);
                return iRubyObject3;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject4 = this.handleRedo(ruby);
                Object var10_12 = null;
                this.jitPost(ruby, threadContext, string);
                return iRubyObject4;
            }
            this.jitPost(ruby, threadContext, string);
            return iRubyObject2;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.jitPost(ruby, threadContext, string);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject interpretedCall(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        try {
            IRubyObject iRubyObject2;
            try {
                this.preInterpret(threadContext, string, iRubyObject, block, ruby, iRubyObjectArray);
                iRubyObject2 = this.body.interpret(ruby, threadContext, iRubyObject, block);
                Object var11_11 = null;
            }
            catch (JumpException.ReturnJump returnJump) {
                IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
                Object var11_12 = null;
                this.postInterpret(ruby, threadContext, string);
                return iRubyObject3;
            }
            catch (JumpException.RedoJump redoJump) {
                IRubyObject iRubyObject4 = this.handleRedo(ruby);
                Object var11_13 = null;
                this.postInterpret(ruby, threadContext, string);
                return iRubyObject4;
            }
            this.postInterpret(ruby, threadContext, string);
            return iRubyObject2;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.postInterpret(ruby, threadContext, string);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject2;
                try {
                    this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK, iRubyObjectArray.length);
                    iRubyObject2 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObjectArray, Block.NULL_BLOCK);
                    Object var10_10 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
                    Object var10_11 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject3;
                }
                catch (JumpException.RedoJump redoJump) {
                    IRubyObject iRubyObject4 = this.handleRedo(ruby);
                    Object var10_12 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject4;
                }
                this.jitPost(ruby, threadContext, string);
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.jitPost(ruby, threadContext, string);
                throw throwable;
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject2;
                try {
                    this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK, 0);
                    iRubyObject2 = this.jitCompiledScript.__file__(threadContext, iRubyObject, Block.NULL_BLOCK);
                    Object var9_9 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
                    Object var9_10 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject3;
                }
                catch (JumpException.RedoJump redoJump) {
                    IRubyObject iRubyObject4 = this.handleRedo(ruby);
                    Object var9_11 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject4;
                }
                this.jitPost(ruby, threadContext, string);
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.jitPost(ruby, threadContext, string);
                throw throwable;
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject2;
                try {
                    this.jitPre(threadContext, iRubyObject, string, block, 0);
                    iRubyObject2 = this.jitCompiledScript.__file__(threadContext, iRubyObject, block);
                    Object var10_10 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    IRubyObject iRubyObject3 = this.handleReturn(threadContext, returnJump);
                    Object var10_11 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject3;
                }
                catch (JumpException.RedoJump redoJump) {
                    IRubyObject iRubyObject4 = this.handleRedo(ruby);
                    Object var10_12 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject4;
                }
                this.jitPost(ruby, threadContext, string);
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.jitPost(ruby, threadContext, string);
                throw throwable;
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, IRubyObject.NULL_ARRAY, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject3;
                try {
                    this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK, 1);
                    iRubyObject3 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, Block.NULL_BLOCK);
                    Object var10_10 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    IRubyObject iRubyObject4 = this.handleReturn(threadContext, returnJump);
                    Object var10_11 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject4;
                }
                catch (JumpException.RedoJump redoJump) {
                    IRubyObject iRubyObject5 = this.handleRedo(ruby);
                    Object var10_12 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject5;
                }
                this.jitPost(ruby, threadContext, string);
                return iRubyObject3;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.jitPost(ruby, threadContext, string);
                throw throwable;
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject3;
                try {
                    this.jitPre(threadContext, iRubyObject, string, block, 1);
                    iRubyObject3 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, block);
                    Object var11_11 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    IRubyObject iRubyObject4 = this.handleReturn(threadContext, returnJump);
                    Object var11_12 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject4;
                }
                catch (JumpException.RedoJump redoJump) {
                    IRubyObject iRubyObject5 = this.handleRedo(ruby);
                    Object var11_13 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject5;
                }
                this.jitPost(ruby, threadContext, string);
                return iRubyObject3;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                this.jitPost(ruby, threadContext, string);
                throw throwable;
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject4;
                try {
                    this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK, 2);
                    iRubyObject4 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, iRubyObject3, Block.NULL_BLOCK);
                    Object var11_11 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    IRubyObject iRubyObject5 = this.handleReturn(threadContext, returnJump);
                    Object var11_12 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject5;
                }
                catch (JumpException.RedoJump redoJump) {
                    IRubyObject iRubyObject6 = this.handleRedo(ruby);
                    Object var11_13 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject6;
                }
                this.jitPost(ruby, threadContext, string);
                return iRubyObject4;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                this.jitPost(ruby, threadContext, string);
                throw throwable;
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject4;
                try {
                    this.jitPre(threadContext, iRubyObject, string, block, 2);
                    iRubyObject4 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, iRubyObject3, block);
                    Object var12_12 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    IRubyObject iRubyObject5 = this.handleReturn(threadContext, returnJump);
                    Object var12_13 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject5;
                }
                catch (JumpException.RedoJump redoJump) {
                    IRubyObject iRubyObject6 = this.handleRedo(ruby);
                    Object var12_14 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject6;
                }
                this.jitPost(ruby, threadContext, string);
                return iRubyObject4;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                this.jitPost(ruby, threadContext, string);
                throw throwable;
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject5;
                try {
                    this.jitPre(threadContext, iRubyObject, string, Block.NULL_BLOCK, 3);
                    iRubyObject5 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4, Block.NULL_BLOCK);
                    Object var12_12 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    IRubyObject iRubyObject6 = this.handleReturn(threadContext, returnJump);
                    Object var12_13 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject6;
                }
                catch (JumpException.RedoJump redoJump) {
                    IRubyObject iRubyObject7 = this.handleRedo(ruby);
                    Object var12_14 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject7;
                }
                this.jitPost(ruby, threadContext, string);
                return iRubyObject5;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                this.jitPost(ruby, threadContext, string);
                throw throwable;
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this.jitCompiledScript != null && !ruby.hasEventHooks()) {
            try {
                IRubyObject iRubyObject5;
                try {
                    this.jitPre(threadContext, iRubyObject, string, block, 3);
                    iRubyObject5 = this.jitCompiledScript.__file__(threadContext, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4, block);
                    Object var13_13 = null;
                }
                catch (JumpException.ReturnJump returnJump) {
                    IRubyObject iRubyObject6 = this.handleReturn(threadContext, returnJump);
                    Object var13_14 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject6;
                }
                catch (JumpException.RedoJump redoJump) {
                    IRubyObject iRubyObject7 = this.handleRedo(ruby);
                    Object var13_15 = null;
                    this.jitPost(ruby, threadContext, string);
                    return iRubyObject7;
                }
                this.jitPost(ruby, threadContext, string);
                return iRubyObject5;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                this.jitPost(ruby, threadContext, string);
                throw throwable;
            }
        }
        return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4}, block);
    }

    private int assignOptArgs(IRubyObject[] iRubyObjectArray, Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, int n) {
        int n2;
        ListNode listNode = this.argsNode.getOptArgs();
        int n3 = 0;
        for (n2 = this.requiredArgsCount; n2 < iRubyObjectArray.length && n3 < listNode.size(); ++n2, ++n3) {
            listNode.get(n3).assign(ruby, threadContext, iRubyObject, iRubyObjectArray[n2], Block.NULL_BLOCK, true);
            ++n;
        }
        n2 = 0;
        while (n3 < listNode.size()) {
            listNode.get(n3).interpret(ruby, threadContext, iRubyObject, Block.NULL_BLOCK);
            ++n2;
            ++n3;
        }
        return n;
    }

    private void interpretArgs(Ruby ruby, IRubyObject[] iRubyObjectArray, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        this.checkArgCount(ruby, iRubyObjectArray.length);
        this.prepareArguments(threadContext, ruby, iRubyObject, iRubyObjectArray);
        if (this.argsNode.getBlockArgNode() != null) {
            this.processBlockArg(threadContext, block);
        }
    }

    private void jitPre(ThreadContext threadContext, IRubyObject iRubyObject, String string, Block block, int n) {
        this.jitCallConfig.pre(threadContext, iRubyObject, this.getImplementationClass(), string, block, this.staticScope, this);
        this.getArity().checkArity(threadContext.getRuntime(), n);
    }

    private void jitPost(Ruby ruby, ThreadContext threadContext, String string) {
        if (ruby.hasEventHooks()) {
            this.traceReturn(threadContext, ruby, string);
        }
        this.jitCallConfig.post(threadContext);
    }

    private void postInterpret(Ruby ruby, ThreadContext threadContext, String string) {
        if (ruby.hasEventHooks()) {
            this.traceReturn(threadContext, ruby, string);
        }
        threadContext.postMethodFrameAndScope();
    }

    private void preInterpret(ThreadContext threadContext, String string, IRubyObject iRubyObject, Block block, Ruby ruby, IRubyObject[] iRubyObjectArray) {
        threadContext.preMethodFrameAndScope(this.getImplementationClass(), string, iRubyObject, block, this.staticScope);
        if (ruby.hasEventHooks()) {
            this.traceCall(threadContext, ruby, string);
        }
        this.interpretArgs(ruby, iRubyObjectArray, threadContext, iRubyObject, block);
    }

    private void processBlockArg(ThreadContext threadContext, Block block) {
        threadContext.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), RuntimeHelpers.processBlockArgument(threadContext.getRuntime(), block), 0);
    }

    private void checkArgCount(Ruby ruby, int n) {
        Arity.checkArgumentCount(ruby, n, this.requiredArgsCount, this.maxArgsCount);
    }

    private void prepareArguments(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (this.requiredArgsCount > 0) {
            threadContext.getCurrentScope().setArgValues(iRubyObjectArray, this.requiredArgsCount);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(threadContext, ruby, iRubyObject, iRubyObjectArray);
        }
    }

    private void prepareOptOrRestArgs(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        int n = this.interpretOptArgs(threadContext, ruby, iRubyObject, iRubyObjectArray);
        this.interpretRestArg(threadContext, ruby, iRubyObjectArray, n);
    }

    private int interpretOptArgs(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (this.hasOptArgs) {
            return this.assignOptArgs(iRubyObjectArray, ruby, threadContext, iRubyObject, this.requiredArgsCount);
        }
        return this.requiredArgsCount;
    }

    private void interpretRestArg(ThreadContext threadContext, Ruby ruby, IRubyObject[] iRubyObjectArray, int n) {
        if (this.restArg >= 0) {
            RubyArray rubyArray = RubyArray.newArrayNoCopy(ruby, iRubyObjectArray, n);
            threadContext.getCurrentScope().setValue(this.restArg, rubyArray, 0);
        }
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    private void traceReturn(ThreadContext threadContext, Ruby ruby, String string) {
        ruby.callEventHooks(threadContext, RubyEvent.RETURN, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
    }

    private void traceCall(ThreadContext threadContext, Ruby ruby, String string) {
        ruby.callEventHooks(threadContext, RubyEvent.CALL, this.position.getFile(), this.position.getStartLine(), string, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

