/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ext.socket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.ext.socket.RubyBasicSocket;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"IPSocket"}, parent="BasicSocket")
public class RubyIPSocket
extends RubyBasicSocket {
    private static ObjectAllocator IPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyIPSocket(ruby, rubyClass);
        }
    };

    static void createIPSocket(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("IPSocket", ruby.fastGetClass("BasicSocket"), IPSOCKET_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyIPSocket.class);
        ruby.getObject().fastSetConstant("IPsocket", rubyClass);
    }

    public RubyIPSocket(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    protected static RuntimeException sockerr(IRubyObject iRubyObject, String string) {
        return new RaiseException(iRubyObject.getRuntime(), iRubyObject.getRuntime().fastGetClass("SocketError"), string, true);
    }

    private IRubyObject addrFor(InetSocketAddress inetSocketAddress) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[4];
        Ruby ruby = this.getRuntime();
        iRubyObjectArray[0] = ruby.newString("AF_INET");
        iRubyObjectArray[1] = ruby.newFixnum(inetSocketAddress.getPort());
        iRubyObjectArray[2] = ruby.isDoNotReverseLookupEnabled() ? ruby.newString(inetSocketAddress.getAddress().getHostAddress()) : ruby.newString(inetSocketAddress.getHostName());
        iRubyObjectArray[3] = ruby.newString(inetSocketAddress.getAddress().getHostAddress());
        return ruby.newArrayNoCopy(iRubyObjectArray);
    }

    @JRubyMethod
    public IRubyObject addr() {
        InetSocketAddress inetSocketAddress = this.getLocalSocket();
        if (inetSocketAddress == null) {
            throw this.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
        }
        return this.addrFor(inetSocketAddress);
    }

    @JRubyMethod
    public IRubyObject peeraddr() {
        InetSocketAddress inetSocketAddress = this.getRemoteSocket();
        if (inetSocketAddress == null) {
            throw this.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
        }
        return this.addrFor(inetSocketAddress);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getaddress(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            return iRubyObject.getRuntime().newString(InetAddress.getByName(iRubyObject2.convertToString().toString()).getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyIPSocket.sockerr(iRubyObject, "getaddress: name or service not known");
        }
    }
}

